/*
 * Decompiled with CFR 0.152.
 */
package internal.com.getkeepsafe.relinker.elf;

import internal.com.getkeepsafe.relinker.elf.Dynamic64Structure;
import internal.com.getkeepsafe.relinker.elf.Elf;
import internal.com.getkeepsafe.relinker.elf.ElfParser;
import internal.com.getkeepsafe.relinker.elf.Program64Header;
import internal.com.getkeepsafe.relinker.elf.Section64Header;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class Elf64Header
extends Elf.Header {
    private final ElfParser parser;

    public Elf64Header(boolean bigEndian, ElfParser parser) throws IOException {
        this.bigEndian = bigEndian;
        this.parser = parser;
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        byteBuffer.order(bigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
        this.type = parser.readHalf(byteBuffer, 16L);
        this.phoff = parser.readLong(byteBuffer, 32L);
        this.shoff = parser.readLong(byteBuffer, 40L);
        this.phentsize = parser.readHalf(byteBuffer, 54L);
        this.phnum = parser.readHalf(byteBuffer, 56L);
        this.shentsize = parser.readHalf(byteBuffer, 58L);
        this.shnum = parser.readHalf(byteBuffer, 60L);
        this.shstrndx = parser.readHalf(byteBuffer, 62L);
    }

    @Override
    public Elf.SectionHeader getSectionHeader(int index) throws IOException {
        return new Section64Header(this.parser, this, index);
    }

    @Override
    public Elf.ProgramHeader getProgramHeader(long index) throws IOException {
        return new Program64Header(this.parser, this, index);
    }

    @Override
    public Elf.DynamicStructure getDynamicStructure(long baseOffset, int index) throws IOException {
        return new Dynamic64Structure(this.parser, this, baseOffset, index);
    }
}

