/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import com.hyphenate.chat.EMBase;
import com.hyphenate.chat.adapter.EMACallSession;

public class EMCallSession
extends EMBase<EMACallSession> {
    EMCallSession() {
    }

    EMCallSession(EMACallSession eMACallSession) {
        this.emaObject = eMACallSession;
    }

    public String getCallId() {
        return ((EMACallSession)this.emaObject).getCallId();
    }

    static EndReason getEndReason(int n) {
        if (n == EndReason.HANGUP.getValue()) {
            return EndReason.HANGUP;
        }
        if (n == EndReason.NORESPONSE.getValue()) {
            return EndReason.NORESPONSE;
        }
        if (n == EndReason.REJECT.getValue()) {
            return EndReason.REJECT;
        }
        if (n == EndReason.BUSY.getValue()) {
            return EndReason.BUSY;
        }
        if (n == EndReason.FAIL.getValue()) {
            return EndReason.FAIL;
        }
        if (n == EndReason.SERVICE_NOT_ENABLE.getValue()) {
            return EndReason.SERVICE_NOT_ENABLE;
        }
        if (n == EndReason.SERVICE_ARREARAGES.getValue()) {
            return EndReason.SERVICE_ARREARAGES;
        }
        if (n == EndReason.SERVICE_FORBIDDEN.getValue()) {
            return EndReason.SERVICE_FORBIDDEN;
        }
        return EndReason.OFFLINE;
    }

    static SessionInfoType getSessionInfoType(int n) {
        SessionInfoType sessionInfoType = SessionInfoType.RESUME_VOICE;
        switch (n) {
            case 0: {
                sessionInfoType = SessionInfoType.PAUSE_VOICE;
                break;
            }
            case 1: {
                sessionInfoType = SessionInfoType.RESUME_VOICE;
                break;
            }
            case 2: {
                sessionInfoType = SessionInfoType.PAUSE_VIDEO;
                break;
            }
            case 3: {
                sessionInfoType = SessionInfoType.RESUME_VIDEO;
                break;
            }
        }
        return sessionInfoType;
    }

    public Type getType() {
        EMACallSession.Type type = ((EMACallSession)this.emaObject).getType();
        switch (type) {
            case VOICE: {
                return Type.VOICE;
            }
        }
        return Type.VIDEO;
    }

    public ConnectType getConnectType() {
        EMACallSession.ConnectType connectType = ((EMACallSession)this.emaObject).getConnectType();
        switch (connectType) {
            case DIRECT: {
                return ConnectType.DIRECT;
            }
            case RELAY: {
                return ConnectType.RELAY;
            }
        }
        return ConnectType.NONE;
    }

    String password() {
        return "12345678";
    }

    public String getRemoteName() {
        return ((EMACallSession)this.emaObject).getRemoteName();
    }

    public String getExt() {
        return ((EMACallSession)this.emaObject).getExt();
    }

    public String getLocalName() {
        return ((EMACallSession)this.emaObject).getLocalName();
    }

    public String getServerRecordId() {
        return ((EMACallSession)this.emaObject).getServerRecordId();
    }

    public boolean isRecordOnServer() {
        return ((EMACallSession)this.emaObject).isRecordOnServer();
    }

    static enum SessionInfoType {
        PAUSE_VOICE,
        RESUME_VOICE,
        PAUSE_VIDEO,
        RESUME_VIDEO;

    }

    public static enum EndReason {
        HANGUP(0),
        NORESPONSE(1),
        REJECT(2),
        BUSY(3),
        FAIL(4),
        OFFLINE(5),
        SERVICE_NOT_ENABLE(101),
        SERVICE_ARREARAGES(102),
        SERVICE_FORBIDDEN(103);

        private int value;

        private EndReason(int n2) {
            this.value = n2;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum Status {
        DISCONNECTED,
        RINGING,
        CONNECTING,
        CONNECTED,
        ACCEPTED;

    }

    public static enum ConnectType {
        NONE,
        DIRECT,
        RELAY;

    }

    public static enum Type {
        VOICE,
        VIDEO;

    }
}

