/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import android.content.res.AssetFileDescriptor;
import android.graphics.Bitmap;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.hyphenate.EMCallBack;
import com.hyphenate.EMConferenceListener;
import com.hyphenate.EMValueCallBack;
import com.hyphenate.chat.EMCDNCanvas;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMConference;
import com.hyphenate.chat.EMConferenceAttribute;
import com.hyphenate.chat.EMConferenceMember;
import com.hyphenate.chat.EMConferenceStream;
import com.hyphenate.chat.EMLiveConfig;
import com.hyphenate.chat.EMLiveLayoutStyle;
import com.hyphenate.chat.EMLiveRegion;
import com.hyphenate.chat.EMMirror;
import com.hyphenate.chat.EMRoomConfig;
import com.hyphenate.chat.EMStreamParam;
import com.hyphenate.chat.EMStreamStatistics;
import com.hyphenate.chat.EMWaterMarkOption;
import com.hyphenate.chat.EMWhiteboard;
import com.hyphenate.chat.adapter.EMACallConferenceListener;
import com.hyphenate.chat.adapter.EMACallManager;
import com.hyphenate.chat.adapter.EMAError;
import com.hyphenate.chat.adapter.EMARTCConfigManager;
import com.hyphenate.media.EMCallSurfaceView;
import com.hyphenate.util.EMLog;
import com.hyphenate.util.EasyUtils;
import com.superrtc.audio.WebRtcAudioRecord;
import com.superrtc.audio.WebRtcAudioTrack;
import com.superrtc.mediamanager.EMediaAttribute;
import com.superrtc.mediamanager.EMediaDefines;
import com.superrtc.mediamanager.EMediaEntities;
import com.superrtc.mediamanager.EMediaManager;
import com.superrtc.mediamanager.EMediaPublishConfiguration;
import com.superrtc.mediamanager.EMediaSession;
import com.superrtc.mediamanager.EMediaStream;
import com.superrtc.sdk.RtcConnection;
import com.superrtc.watermark.Watermark;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EMConferenceManager {
    private final String TAG = this.getClass().getSimpleName();
    private EMACallManager emaCallManager;
    private EMediaManager mediaManager = null;
    private EMediaSession mediaSession = null;
    private Role role = new Role();
    private ExecutorService executorService;
    private List<EMConferenceListener> conferenceListeners = Collections.synchronizedList(new ArrayList());
    private List<EMConferenceMember> memberList = Collections.synchronizedList(new ArrayList());
    private Map<String, EMConferenceStream> availableStreamMap = new ConcurrentHashMap<String, EMConferenceStream>();
    private Map<String, EMConferenceStream> subscribedStreamMap = new ConcurrentHashMap<String, EMConferenceStream>();
    private String accessToken;
    private String appKey;
    private String username;
    private EMConferenceType conferenceType;
    private EMConference currentConference;
    private Watermark watermark;
    private EMConferenceRole userRoleType;
    private String Conferenceticket;
    private String liveId;
    private boolean isCreator = false;
    private ILocalAudioDataListener mLocalAudioDataListener = null;
    private IRemoteAudioDataListener mRemoteAudioDataListener = null;
    EMediaSession.EMediaSessionDelegate sessionDelegate = new EMediaSession.EMediaSessionDelegate(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void joinMember(EMediaSession eMediaSession, EMediaEntities.EMediaMember eMediaMember) {
            EMLog.d(EMConferenceManager.this.TAG, "onMemberJoined() memberName: " + eMediaMember.memberName + ", extension: " + eMediaMember.extension);
            EMConferenceMember eMConferenceMember = EMConferenceManager.this.memberContains(eMediaMember.memberName);
            if (null != eMConferenceMember) {
                EMConferenceManager.this.memberList.remove(eMConferenceMember);
            }
            EMConferenceMember eMConferenceMember2 = EMConferenceMember.from(eMediaMember);
            EMConferenceManager.this.memberList.add(eMConferenceMember2);
            List list = EMConferenceManager.this.conferenceListeners;
            synchronized (list) {
                for (EMConferenceListener eMConferenceListener : EMConferenceManager.this.conferenceListeners.subList(0, EMConferenceManager.this.conferenceListeners.size())) {
                    eMConferenceListener.onMemberJoined(eMConferenceMember2);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void exitMember(EMediaSession eMediaSession, EMediaEntities.EMediaMember eMediaMember) {
            EMLog.d(EMConferenceManager.this.TAG, "onMemberExited() memberName: " + eMediaMember.memberName + ", extension: " + eMediaMember.extension);
            EMConferenceMember eMConferenceMember = EMConferenceManager.this.memberContains(eMediaMember.memberName);
            if (null != eMConferenceMember) {
                EMConferenceManager.this.memberList.remove(eMConferenceMember);
            }
            List list = EMConferenceManager.this.conferenceListeners;
            synchronized (list) {
                for (EMConferenceListener eMConferenceListener : EMConferenceManager.this.conferenceListeners.subList(0, EMConferenceManager.this.conferenceListeners.size())) {
                    eMConferenceListener.onMemberExited(EMConferenceMember.from(eMediaMember));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addStream(EMediaSession eMediaSession, EMediaStream eMediaStream) {
            EMLog.d(EMConferenceManager.this.TAG, "onStreamAdded() memberName: " + eMediaStream.memberName + ", extension: " + eMediaStream.extension + ", streamId: " + eMediaStream.streamId + ", streamName: " + eMediaStream.streamName + ", streamType: " + (Object)((Object)eMediaStream.streamType) + ", audioOff: " + eMediaStream.audioOff + ", videoOff: " + eMediaStream.videoOff);
            EMConferenceStream eMConferenceStream = new EMConferenceStream();
            eMConferenceStream.init(eMediaStream);
            EMConferenceManager.this.availableStreamMap.put(eMConferenceStream.getStreamId(), eMConferenceStream);
            List list = EMConferenceManager.this.conferenceListeners;
            synchronized (list) {
                for (EMConferenceListener eMConferenceListener : EMConferenceManager.this.conferenceListeners.subList(0, EMConferenceManager.this.conferenceListeners.size())) {
                    eMConferenceListener.onStreamAdded(eMConferenceStream);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeStream(EMediaSession eMediaSession, EMediaStream eMediaStream) {
            EMLog.d(EMConferenceManager.this.TAG, "onStreamRemoved() memberName: " + eMediaStream.memberName + ", extension: " + eMediaStream.extension + ", streamId: " + eMediaStream.streamId + ", streamName: " + eMediaStream.streamName + ", streamType: " + (Object)((Object)eMediaStream.streamType) + ", audioOff: " + eMediaStream.audioOff + ", videoOff: " + eMediaStream.videoOff);
            EMConferenceStream eMConferenceStream = null;
            if (EMConferenceManager.this.availableStreamMap.containsKey(eMediaStream.streamId)) {
                eMConferenceStream = (EMConferenceStream)EMConferenceManager.this.availableStreamMap.get(eMediaStream.streamId);
                EMConferenceManager.this.availableStreamMap.remove(eMediaStream.streamId);
            } else if (EMConferenceManager.this.subscribedStreamMap.containsKey(eMediaStream.streamId)) {
                eMConferenceStream = (EMConferenceStream)EMConferenceManager.this.subscribedStreamMap.get(eMediaStream.streamId);
                EMConferenceManager.this.subscribedStreamMap.remove(eMediaStream.streamId);
            } else {
                eMConferenceStream = new EMConferenceStream();
            }
            eMConferenceStream.init(eMediaStream);
            EMConferenceManager.this.mediaManager.unsubscribe(eMediaSession, eMediaStream.streamId, null);
            List list = EMConferenceManager.this.conferenceListeners;
            synchronized (list) {
                for (EMConferenceListener eMConferenceListener : EMConferenceManager.this.conferenceListeners.subList(0, EMConferenceManager.this.conferenceListeners.size())) {
                    eMConferenceListener.onStreamRemoved(eMConferenceStream);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void updateStream(EMediaSession eMediaSession, EMediaStream eMediaStream) {
            EMLog.d(EMConferenceManager.this.TAG, "onStreamUpdate() memberName: " + eMediaStream.memberName + ", extension: " + eMediaStream.extension + ", streamId: " + eMediaStream.streamId + ", streamName: " + eMediaStream.streamName + ", streamType: " + (Object)((Object)eMediaStream.streamType) + ", audioOff: " + eMediaStream.audioOff + ", videoOff: " + eMediaStream.videoOff);
            EMConferenceStream eMConferenceStream = null;
            eMConferenceStream = EMConferenceManager.this.availableStreamMap.containsKey(eMediaStream.streamId) ? (EMConferenceStream)EMConferenceManager.this.availableStreamMap.get(eMediaStream.streamId) : (EMConferenceManager.this.subscribedStreamMap.containsKey(eMediaStream.streamId) ? (EMConferenceStream)EMConferenceManager.this.subscribedStreamMap.get(eMediaStream.streamId) : new EMConferenceStream());
            eMConferenceStream.init(eMediaStream);
            List list = EMConferenceManager.this.conferenceListeners;
            synchronized (list) {
                for (EMConferenceListener eMConferenceListener : EMConferenceManager.this.conferenceListeners.subList(0, EMConferenceManager.this.conferenceListeners.size())) {
                    eMConferenceListener.onStreamUpdate(eMConferenceStream);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void passiveCloseReason(EMediaSession eMediaSession, int n, String string) {
            EMLog.d(EMConferenceManager.this.TAG, "onPassiveLeave() code: " + n + ", reason: " + string);
            EMConferenceManager.this.memberList.clear();
            EMConferenceManager.this.subscribedStreamMap.clear();
            EMConferenceManager.this.availableStreamMap.clear();
            List list = EMConferenceManager.this.conferenceListeners;
            synchronized (list) {
                for (EMConferenceListener eMConferenceListener : EMConferenceManager.this.conferenceListeners.subList(0, EMConferenceManager.this.conferenceListeners.size())) {
                    eMConferenceListener.onPassiveLeave(n, string);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notice(EMediaSession eMediaSession, EMediaDefines.EMediaNoticeCode eMediaNoticeCode, String string, String string2, Object object) {
            List list = EMConferenceManager.this.conferenceListeners;
            synchronized (list) {
                for (EMConferenceListener eMConferenceListener : EMConferenceManager.this.conferenceListeners.subList(0, EMConferenceManager.this.conferenceListeners.size())) {
                    EMConferenceListener.ConferenceState conferenceState = EMConferenceManager.this.stateMap(eMediaNoticeCode.noticeCode);
                    if (conferenceState == EMConferenceListener.ConferenceState.STATE_PUBLISH_SETUP) {
                        eMConferenceListener.onStreamSetup(string);
                        continue;
                    }
                    if (conferenceState == EMConferenceListener.ConferenceState.STATE_SUBSCRIBE_SETUP) {
                        eMConferenceListener.onStreamSetup(string);
                        continue;
                    }
                    if (conferenceState == EMConferenceListener.ConferenceState.STATE_STATISTICS) {
                        eMConferenceListener.onStreamStatistics(new EMStreamStatistics(string2, (RtcConnection.RtcStatistics)object));
                        continue;
                    }
                    if (conferenceState == EMConferenceListener.ConferenceState.STATE_CUSTOM_MSG || conferenceState == EMConferenceListener.ConferenceState.STATE_P2P_PEER_EXIT || conferenceState == EMConferenceListener.ConferenceState.STATE_TAKE_CAMERA_PICTURE) continue;
                    if (conferenceState == EMConferenceListener.ConferenceState.STATE_AUDIO_TALKERS) {
                        Map map = (Map)object;
                        ArrayList<String> arrayList = new ArrayList<String>(map.keySet());
                        eMConferenceListener.onSpeakers(arrayList);
                        continue;
                    }
                    if (conferenceState == EMConferenceListener.ConferenceState.STATE_UPDATE_PUB) {
                        eMConferenceListener.onGetLocalStreamId(string, string2);
                        continue;
                    }
                    EMLog.d(EMConferenceManager.this.TAG, "Notice code: " + eMediaNoticeCode.noticeCode);
                    eMConferenceListener.onConferenceState(conferenceState);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void changeRole(EMediaSession eMediaSession) {
            int n = eMediaSession.role;
            EMLog.i(EMConferenceManager.this.TAG, "updateRole: " + n);
            if (EMConferenceManager.this.role != null) {
                EMConferenceManager.this.role.updateRole(EMConferenceRole.from(n));
            }
            List list = EMConferenceManager.this.conferenceListeners;
            synchronized (list) {
                for (EMConferenceListener eMConferenceListener : EMConferenceManager.this.conferenceListeners.subList(0, EMConferenceManager.this.conferenceListeners.size())) {
                    eMConferenceListener.onRoleChanged(EMConferenceRole.from(n));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void adminAdd(EMediaSession eMediaSession, String string) {
            EMLog.i(EMConferenceManager.this.TAG, "adminAdd  adminMemId: " + string);
            List list = EMConferenceManager.this.conferenceListeners;
            synchronized (list) {
                for (EMConferenceListener eMConferenceListener : EMConferenceManager.this.conferenceListeners.subList(0, EMConferenceManager.this.conferenceListeners.size())) {
                    eMConferenceListener.onAdminAdded(string);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void adminRemove(EMediaSession eMediaSession, String string) {
            EMLog.i(EMConferenceManager.this.TAG, "adminRemove  adminMemId: " + string);
            List list = EMConferenceManager.this.conferenceListeners;
            synchronized (list) {
                for (EMConferenceListener eMConferenceListener : EMConferenceManager.this.conferenceListeners.subList(0, EMConferenceManager.this.conferenceListeners.size())) {
                    eMConferenceListener.onAdminRemoved(string);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void pubStreamFailed(EMediaSession eMediaSession, EMediaEntities.EMediaError eMediaError) {
            EMLog.i(EMConferenceManager.this.TAG, "pubStreamFailed: " + eMediaSession.myName);
            List list = EMConferenceManager.this.conferenceListeners;
            synchronized (list) {
                for (EMConferenceListener eMConferenceListener : EMConferenceManager.this.conferenceListeners.subList(0, EMConferenceManager.this.conferenceListeners.size())) {
                    eMConferenceListener.onPubStreamFailed(eMediaError.code.errorcode, eMediaError.errorDescription);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void updateStreamFailed(EMediaSession eMediaSession, EMediaEntities.EMediaError eMediaError) {
            EMLog.i(EMConferenceManager.this.TAG, "updateStreamFailed: " + eMediaSession.myName);
            List list = EMConferenceManager.this.conferenceListeners;
            synchronized (list) {
                for (EMConferenceListener eMConferenceListener : EMConferenceManager.this.conferenceListeners.subList(0, EMConferenceManager.this.conferenceListeners.size())) {
                    eMConferenceListener.onUpdateStreamFailed(eMediaError.code.errorcode, eMediaError.errorDescription);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void updateAttrs(EMediaSession eMediaSession, EMediaAttribute[] eMediaAttributeArray) {
            EMLog.i(EMConferenceManager.this.TAG, "updateAttrs: " + Arrays.toString(eMediaAttributeArray));
            EMConferenceAttribute[] eMConferenceAttributeArray = new EMConferenceAttribute[eMediaAttributeArray.length];
            for (int k = 0; k < eMediaAttributeArray.length; ++k) {
                Object object = EMConferenceAttribute.Action.ADD;
                switch (eMediaAttributeArray[k].action) {
                    case ADD: {
                        object = EMConferenceAttribute.Action.ADD;
                        break;
                    }
                    case DELETE: {
                        object = EMConferenceAttribute.Action.DELETE;
                        break;
                    }
                    case UPDATE: {
                        object = EMConferenceAttribute.Action.UPDATE;
                    }
                }
                eMConferenceAttributeArray[k] = new EMConferenceAttribute((EMConferenceAttribute.Action)((Object)object), eMediaAttributeArray[k].key, eMediaAttributeArray[k].value);
            }
            List list = EMConferenceManager.this.conferenceListeners;
            synchronized (list) {
                for (EMConferenceListener eMConferenceListener : EMConferenceManager.this.conferenceListeners.subList(0, EMConferenceManager.this.conferenceListeners.size())) {
                    eMConferenceListener.onAttributesUpdated(eMConferenceAttributeArray);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reqSpeaker(EMediaSession eMediaSession, String string, String string2, String string3) {
            EMLog.i(EMConferenceManager.this.TAG, "reqSpeaker  reqMemId: " + string);
            List list = EMConferenceManager.this.conferenceListeners;
            synchronized (list) {
                for (EMConferenceListener eMConferenceListener : EMConferenceManager.this.conferenceListeners.subList(0, EMConferenceManager.this.conferenceListeners.size())) {
                    eMConferenceListener.onReqSpeaker(string, string2, string3);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reqAdmin(EMediaSession eMediaSession, String string, String string2, String string3) {
            EMLog.i(EMConferenceManager.this.TAG, "reqAdmin  reqMemId: " + string);
            List list = EMConferenceManager.this.conferenceListeners;
            synchronized (list) {
                for (EMConferenceListener eMConferenceListener : EMConferenceManager.this.conferenceListeners.subList(0, EMConferenceManager.this.conferenceListeners.size())) {
                    eMConferenceListener.onReqAdmin(string, string2, string3);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setMute(EMediaSession eMediaSession, String string, String string2) {
            EMLog.i(EMConferenceManager.this.TAG, "setMute  reqMemId: " + string2);
            List list = EMConferenceManager.this.conferenceListeners;
            synchronized (list) {
                for (EMConferenceListener eMConferenceListener : EMConferenceManager.this.conferenceListeners.subList(0, EMConferenceManager.this.conferenceListeners.size())) {
                    eMConferenceListener.onMute(string, string2);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setUnMute(EMediaSession eMediaSession, String string, String string2) {
            EMLog.i(EMConferenceManager.this.TAG, "setUnMute  reqMemId: " + string2);
            List list = EMConferenceManager.this.conferenceListeners;
            synchronized (list) {
                for (EMConferenceListener eMConferenceListener : EMConferenceManager.this.conferenceListeners.subList(0, EMConferenceManager.this.conferenceListeners.size())) {
                    eMConferenceListener.onUnMute(string, string2);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setMuteAll(EMediaSession eMediaSession, boolean bl) {
            EMLog.i(EMConferenceManager.this.TAG, "setMuteAll  mute: " + bl);
            List list = EMConferenceManager.this.conferenceListeners;
            synchronized (list) {
                for (EMConferenceListener eMConferenceListener : EMConferenceManager.this.conferenceListeners.subList(0, EMConferenceManager.this.conferenceListeners.size())) {
                    eMConferenceListener.onMuteAll(bl);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reqSpeakFailed(EMediaSession eMediaSession, String string, String string2) {
            EMLog.i(EMConferenceManager.this.TAG, "refuseSpeaker  reqMemId: " + string);
            List list = EMConferenceManager.this.conferenceListeners;
            synchronized (list) {
                for (EMConferenceListener eMConferenceListener : EMConferenceManager.this.conferenceListeners.subList(0, EMConferenceManager.this.conferenceListeners.size())) {
                    eMConferenceListener.onApplySpeakerRefused(string, string2);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reqAdminFailed(EMediaSession eMediaSession, String string, String string2) {
            EMLog.i(EMConferenceManager.this.TAG, "refuseAdmin  reqMemId: " + string);
            List list = EMConferenceManager.this.conferenceListeners;
            synchronized (list) {
                for (EMConferenceListener eMConferenceListener : EMConferenceManager.this.conferenceListeners.subList(0, EMConferenceManager.this.conferenceListeners.size())) {
                    eMConferenceListener.onApplyAdminRefused(string, string2);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void setLivecfg(EMediaSession eMediaSession, String string) {
            Object object;
            Object object2;
            EMLog.i(EMConferenceManager.this.TAG, "setLivecfg  livecfg: " + string);
            EMLiveConfig eMLiveConfig = new EMLiveConfig();
            if (string == null) {
                EMLog.i(EMConferenceManager.this.TAG, "setLivecfg livcfg is null");
                return;
            }
            if (string.length() <= 0) {
                EMLog.i(EMConferenceManager.this.TAG, "setLivecfg  livcfg is empty");
                return;
            }
            try {
                JSONObject jSONObject = new JSONObject(string);
                eMLiveConfig.setCdnurl(jSONObject.getString("cdn"));
                eMLiveConfig.setLiveLayoutStyle(EMLiveLayoutStyle.valueOf(jSONObject.getString("layoutStyle")));
                object2 = jSONObject.optJSONObject("canvas");
                object = new EMCDNCanvas();
                ((EMCDNCanvas)object).setBgclr(object2.optInt("bgclr"));
                ((EMCDNCanvas)object).setHeight(object2.optInt("w"));
                ((EMCDNCanvas)object).setWidth(object2.optInt("h"));
                ((EMCDNCanvas)object).setVideoKbps(object2.optInt("bps") / 1000);
                ((EMCDNCanvas)object).setFps(object2.optInt("fps"));
                ((EMCDNCanvas)object).setCodec(object2.optString("codec"));
            }
            catch (Exception exception) {
                exception.getStackTrace();
            }
            List list = EMConferenceManager.this.conferenceListeners;
            synchronized (list) {
                object2 = EMConferenceManager.this.conferenceListeners.subList(0, EMConferenceManager.this.conferenceListeners.size()).iterator();
                while (object2.hasNext()) {
                    object = (EMConferenceListener)object2.next();
                    object.onGetLivecfg(eMLiveConfig);
                }
                return;
            }
        }
    };

    public void setLocalAudioDataListener(final ILocalAudioDataListener iLocalAudioDataListener) {
        this.mLocalAudioDataListener = iLocalAudioDataListener;
        if (iLocalAudioDataListener != null) {
            WebRtcAudioRecord.getInstance().setListener(new WebRtcAudioRecord.IAudioRecordListener(){

                @Override
                public void onAudioData(byte[] byArray, int n, int n2, int n3) {
                    iLocalAudioDataListener.onLocalAudioData(byArray, n, n2, n3);
                }
            });
        } else {
            WebRtcAudioRecord.getInstance().setListener(null);
        }
    }

    public void setRemoteAudioDataListener(final IRemoteAudioDataListener iRemoteAudioDataListener) {
        this.mRemoteAudioDataListener = iRemoteAudioDataListener;
        if (iRemoteAudioDataListener != null) {
            WebRtcAudioTrack.getInstance().setAudioTrackListener(new WebRtcAudioTrack.IAudioTrackListener(){

                @Override
                public void onAudioData(byte[] byArray, int n, int n2, int n3) {
                    iRemoteAudioDataListener.onRemoteAudioData(byArray, n, n2, n3);
                }
            });
        } else {
            WebRtcAudioTrack.getInstance().setAudioTrackListener(null);
        }
    }

    public void set(String string, String string2, String string3) {
        this.accessToken = string;
        this.appKey = string2;
        this.username = string3;
    }

    protected EMConferenceManager(EMACallManager eMACallManager) {
        this.emaCallManager = eMACallManager;
        if (!EMediaManager.isInit()) {
            if (EMClient.getInstance().getOptions().isUseStereoInput()) {
                EMediaManager.setUseStereoInput(true);
            }
            EMediaManager.initGlobal(EMClient.getInstance().getContext());
        }
        this.mediaManager = EMediaManager.getInstance();
        this.executorService = Executors.newCachedThreadPool();
        this.emaCallManager.setCallConferenceListener(new EMACallConferenceListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onReceiveInvite(String string, String string2, String string3) {
                List list = EMConferenceManager.this.conferenceListeners;
                synchronized (list) {
                    try {
                        for (EMConferenceListener eMConferenceListener : EMConferenceManager.this.conferenceListeners) {
                            eMConferenceListener.onReceiveInvite(string, string2, string3);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        });
        this.setSubscribeAudioMixEnable();
    }

    EMediaManager mediaManager() {
        if (this.mediaManager == null) {
            this.mediaManager = EMediaManager.getInstance();
        }
        return this.mediaManager;
    }

    public boolean isCreator() {
        return this.isCreator;
    }

    public void addConferenceListener(EMConferenceListener eMConferenceListener) {
        if (eMConferenceListener != null && !this.conferenceListeners.contains(eMConferenceListener)) {
            this.conferenceListeners.add(eMConferenceListener);
        }
    }

    public void removeConferenceListener(EMConferenceListener eMConferenceListener) {
        if (eMConferenceListener != null) {
            this.conferenceListeners.remove(eMConferenceListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int startAudioMixing(String string, int n, boolean bl) {
        if (this.currentConference == null) {
            EMLog.e(this.TAG, "call startAudioMixing, not in a conference currently.");
            return 816;
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            EMLog.e(this.TAG, "call startAudioMixing, but filePath is null.");
            return 818;
        }
        if (string.startsWith("/assets/")) {
            String string2 = string.substring("/assets/".length());
            AssetFileDescriptor assetFileDescriptor = null;
            try {
                assetFileDescriptor = EMClient.getInstance().getContext().getAssets().openFd(string2);
            }
            catch (IOException iOException) {
                EMLog.e(this.TAG, "call startAudioMixing, assets file: " + string2 + " does not exists.");
                int n2 = 818;
                return n2;
            }
            finally {
                if (assetFileDescriptor != null) {
                    try {
                        assetFileDescriptor.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        }
        if (!new File(string).exists()) {
            EMLog.e(this.TAG, "call startAudioMixing, file: " + string + " does not exists.");
            return 818;
        }
        this.mediaManager.startAudioMixing(string, n, bl);
        return 0;
    }

    public int stopAudioMixing() {
        if (this.currentConference == null) {
            EMLog.e(this.TAG, "call stopAudioMixing, not in a conference currently.");
            return 816;
        }
        this.mediaManager.stopAudioMixing();
        return 0;
    }

    public int adjustAudioMixingVolume(int n) {
        if (this.currentConference == null) {
            EMLog.e(this.TAG, "call adjustAudioMixingVolume, not in a conference currently.");
            return 816;
        }
        if (n < 0) {
            n = 0;
        }
        if (n > 100) {
            n = 100;
        }
        this.mediaManager.adjustAudioMixingVolume(n);
        return 0;
    }

    public void getConferenceInfo(final String string, final String string2, final EMValueCallBack<EMConference> eMValueCallBack) {
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                block9: {
                    EMAError eMAError = new EMAError();
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("confrId", string);
                    hashMap.put("password", string2);
                    String string3 = EMConferenceManager.convertMapToJSONObject(hashMap).toString();
                    String string22 = EMConferenceManager.this.emaCallManager.requestMediaFromServer(4, string3, eMAError);
                    if (eMAError.errCode() != 0) {
                        if (eMValueCallBack != null) {
                            eMValueCallBack.onError(eMAError.errCode(), eMAError.errMsg());
                        }
                        return;
                    }
                    try {
                        JSONObject jSONObject = new JSONObject(string22);
                        JSONObject jSONObject2 = jSONObject.optJSONObject("confr");
                        EMConference eMConference = new EMConference();
                        eMConference.setPassword(string2);
                        eMConference.setConferenceId(jSONObject2.optString("id"));
                        eMConference.setConferenceType(EMConferenceType.from(jSONObject2.optInt("type")));
                        eMConference.setMemberNum(jSONObject2.optInt("memTotal"));
                        eMConference.setAudienceTotal(jSONObject2.optInt("audienceTotal"));
                        JSONArray jSONArray = jSONObject2.optJSONArray("admins");
                        String[] stringArray = new String[jSONArray.length()];
                        for (int k = 0; k < jSONArray.length(); ++k) {
                            stringArray[k] = jSONArray.getString(k);
                        }
                        eMConference.setAdmins(stringArray);
                        jSONArray = jSONObject2.optJSONArray("talkers");
                        if (jSONArray != null) {
                            String[] stringArray2 = new String[jSONArray.length()];
                            for (int k = 0; k < jSONArray.length(); ++k) {
                                stringArray2[k] = jSONArray.getString(k);
                            }
                            eMConference.setTalkers(stringArray2);
                        } else {
                            eMConference.setTalkers(null);
                        }
                        if (eMValueCallBack != null) {
                            eMValueCallBack.onSuccess(eMConference);
                        }
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                        if (eMValueCallBack == null) break block9;
                        eMValueCallBack.onError(1, jSONException.getMessage());
                    }
                }
            }
        });
    }

    public void joinRoom(String string, String string2, EMConferenceRole eMConferenceRole, EMValueCallBack<EMConference> eMValueCallBack) {
        this.joinRoom(string, string2, eMConferenceRole, null, eMValueCallBack);
    }

    public void joinRoom(final String string, final String string2, final EMConferenceRole eMConferenceRole, final EMRoomConfig eMRoomConfig, final EMValueCallBack<EMConference> eMValueCallBack) {
        EMLog.d(this.TAG, "joinRoom: " + string);
        if (TextUtils.isEmpty((CharSequence)this.accessToken) || TextUtils.isEmpty((CharSequence)this.appKey) || TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2)) {
            EMLog.e(this.TAG, "AccessToken AppKey or Username or Room or Password is not set");
            if (eMValueCallBack != null) {
                eMValueCallBack.onError(804, "If you want to use this feature without im account login, please setting the necessary parameters through the EMClient.getInstance().conferenceManager.set(String accessToken, String appKey, String username) method.");
            }
            return;
        }
        this.conferenceType = eMRoomConfig != null ? eMRoomConfig.getConfrTyp() : EMConferenceType.SmallCommunication;
        this.userRoleType = eMConferenceRole;
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                block18: {
                    Object object;
                    Object object2;
                    EMAError eMAError = new EMAError();
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("memName", EMConferenceManager.this.username);
                    hashMap.put("token", EMConferenceManager.this.accessToken);
                    hashMap.put("roomName", string);
                    hashMap.put("password", string2);
                    if (eMRoomConfig != null) {
                        hashMap.put("supportWechatMiniProgram", eMRoomConfig.isSupportMiniProgram());
                        hashMap.put("rec", eMRoomConfig.isRecord());
                        hashMap.put("recMerge", eMRoomConfig.isMergeRecord());
                        hashMap.put("confrType", eMRoomConfig.getConfrTyp().code);
                        if (eMRoomConfig.getMaxTalkerCount() != -1) {
                            hashMap.put("maxTalkerCount", eMRoomConfig.getMaxTalkerCount());
                        }
                        if (eMRoomConfig.getMaxVideoCount() != -1) {
                            hashMap.put("maxVideoCount", eMRoomConfig.getMaxVideoCount());
                        }
                        if (eMRoomConfig.getMaxAudienceCount() != -1) {
                            hashMap.put("maxAudienceCount", eMRoomConfig.getMaxAudienceCount());
                        }
                        if (eMRoomConfig.getLiveConfig() != null) {
                            object2 = new HashMap();
                            object2.put("cdn", eMRoomConfig.getLiveConfig().getCdnurl());
                            object2.put("layoutStyle", eMRoomConfig.getLiveConfig().getLiveLayoutStyle().getValue());
                            object = null;
                            if (eMRoomConfig.getLiveConfig().getCdnCanvas() != null) {
                                object = new HashMap();
                                if (eMRoomConfig.getLiveConfig().getCdnCanvas().getWidth() > 0) {
                                    object.put("w", eMRoomConfig.getLiveConfig().getCdnCanvas().getWidth());
                                }
                                if (eMRoomConfig.getLiveConfig().getCdnCanvas().getHeight() > 0) {
                                    object.put("h", eMRoomConfig.getLiveConfig().getCdnCanvas().getHeight());
                                }
                                if (eMRoomConfig.getLiveConfig().getCdnCanvas().getFps() > 0) {
                                    object.put("fps", eMRoomConfig.getLiveConfig().getCdnCanvas().getFps());
                                }
                                if (eMRoomConfig.getLiveConfig().getCdnCanvas().getVideoKbps() > 0) {
                                    object.put("bps", eMRoomConfig.getLiveConfig().getCdnCanvas().getVideoKbps() * 1000);
                                }
                                if (eMRoomConfig.getLiveConfig().getCdnCanvas().getCodec() != null) {
                                    object.put("codec", eMRoomConfig.getLiveConfig().getCdnCanvas().getCodec());
                                }
                                object.put("bgclr", eMRoomConfig.getLiveConfig().getCdnCanvas().getBgclr());
                            }
                            object2.put("canvas", object);
                            hashMap.put("liveCfg", object2);
                        }
                    } else {
                        hashMap.put("confrType", EMConferenceType.SmallCommunication.code);
                        hashMap.put("liveCfg", null);
                    }
                    object2 = EMConferenceManager.convertMapToJSONObject(hashMap).toString();
                    object = EMConferenceManager.this.emaCallManager.requestMediaFromServer(7, (String)object2, eMAError);
                    if (eMAError.errCode() != 0) {
                        EMLog.d(EMConferenceManager.this.TAG, "requestMultiMediaFromServer failed " + eMAError.errCode() + ", " + eMAError.errMsg());
                        if (eMValueCallBack != null) {
                            eMValueCallBack.onError(eMAError.errCode(), eMAError.errMsg());
                        }
                        return;
                    }
                    EMConference eMConference = new EMConference();
                    try {
                        JSONObject jSONObject = new JSONObject((String)object);
                        EMConferenceManager.this.Conferenceticket = jSONObject.optString("ticket");
                        String string3 = jSONObject.optString("confrId");
                        EMConferenceManager.this.liveId = jSONObject.optString("liveId");
                        EMConferenceManager.this.isCreator = jSONObject.optBoolean("isCreator");
                        eMConference.setConferenceId(jSONObject.optString("confrId"));
                        eMConference.setPassword(string2);
                        if (eMRoomConfig != null) {
                            eMConference.setConferenceType(eMRoomConfig.getConfrTyp());
                        } else {
                            eMConference.setConferenceType(EMConferenceType.SmallCommunication);
                        }
                        EMConferenceManager.this.joinConferenceMultiple(string3, string2, eMConferenceRole, eMRoomConfig, null, new EMValueCallBack<EMConference>(){

                            @Override
                            public void onSuccess(EMConference eMConference) {
                                EMLog.d(EMConferenceManager.this.TAG, "Join conference success");
                                eMValueCallBack.onSuccess(eMConference);
                            }

                            @Override
                            public void onError(int n, String string) {
                                EMLog.e(EMConferenceManager.this.TAG, "join conference failed error " + n + ", msg " + string);
                                eMValueCallBack.onError(n, string);
                            }
                        });
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                        if (eMValueCallBack == null) break block18;
                        eMValueCallBack.onError(804, jSONException.getMessage());
                    }
                }
            }
        });
    }

    public void createAndJoinConference(EMConferenceType eMConferenceType, String string, EMValueCallBack<EMConference> eMValueCallBack) {
        this.createAndJoinConference(eMConferenceType, string, null, false, false, eMValueCallBack);
    }

    public void createAndJoinConference(EMConferenceType eMConferenceType, String string, boolean bl, boolean bl2, EMValueCallBack<EMConference> eMValueCallBack) {
        this.createAndJoinConference(eMConferenceType, string, null, bl, bl2, eMValueCallBack);
    }

    public void createAndJoinConference(EMConferenceType eMConferenceType, String string, boolean bl, boolean bl2, boolean bl3, EMValueCallBack<EMConference> eMValueCallBack) {
        this.createAndJoinConference(eMConferenceType, string, bl, null, bl2, bl3, eMValueCallBack);
    }

    @Deprecated
    public void createAndJoinConference(@NonNull EMConferenceType eMConferenceType, String string, EMStreamParam eMStreamParam, boolean bl, boolean bl2, EMValueCallBack<EMConference> eMValueCallBack) {
        this.createAndJoinConference(eMConferenceType, string, false, eMStreamParam, bl, bl2, eMValueCallBack);
    }

    @Deprecated
    public void createAndJoinConference(final @NonNull EMConferenceType eMConferenceType, final String string, final boolean bl, final EMStreamParam eMStreamParam, final boolean bl2, final boolean bl3, final EMValueCallBack<EMConference> eMValueCallBack) {
        EMLog.d(this.TAG, "createAndJoinConference: " + (Object)((Object)eMConferenceType));
        if (TextUtils.isEmpty((CharSequence)this.accessToken) || TextUtils.isEmpty((CharSequence)this.appKey) || TextUtils.isEmpty((CharSequence)this.username)) {
            EMLog.e(this.TAG, "AccessToken AppKey or Username is not set");
            if (eMValueCallBack != null) {
                eMValueCallBack.onError(804, "If you want to use this feature without im account login, please setting the necessary parameters through the EMClient.getInstance().conferenceManager.set(String accessToken, String appKey, String username) method.");
            }
            return;
        }
        this.conferenceType = eMConferenceType;
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                block4: {
                    EMAError eMAError = new EMAError();
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("uid", EasyUtils.getMediaRequestUid(EMConferenceManager.this.appKey, EMConferenceManager.this.username));
                    hashMap.put("token", EMConferenceManager.this.accessToken);
                    hashMap.put("confrType", eMConferenceType.code);
                    hashMap.put("password", string);
                    hashMap.put("rec", bl2);
                    hashMap.put("recMerge", bl3);
                    hashMap.put("supportWechatMiniProgram", bl);
                    EMConferenceManager.this.addCommonParams(hashMap);
                    String string4 = EMConferenceManager.convertMapToJSONObject(hashMap).toString();
                    String string2 = EMConferenceManager.this.emaCallManager.requestMediaFromServer(0, string4, eMAError);
                    if (eMAError.errCode() != 0) {
                        EMLog.d(EMConferenceManager.this.TAG, "requestMediaFromServer failed " + eMAError.errCode() + ", " + eMAError.errMsg());
                        if (eMValueCallBack != null) {
                            eMValueCallBack.onError(eMAError.errCode(), eMAError.errMsg());
                        }
                        return;
                    }
                    final EMConference eMConference = new EMConference();
                    try {
                        JSONObject jSONObject = new JSONObject(string2);
                        String string3 = jSONObject.optString("ticket");
                        eMConference.setConferenceId(jSONObject.optString("confrId"));
                        eMConference.setPassword(string);
                        eMConference.setConferenceType(eMConferenceType);
                        EMLog.d(EMConferenceManager.this.TAG, "Join conference");
                        EMConferenceRole eMConferenceRole = EMConferenceRole.from(new JSONObject(string3).optInt("rights"));
                        EMConferenceManager.this.role.update(eMConferenceRole, jSONObject.optString("roleToken"));
                        EMConferenceManager.this.setSubscribeAudioMixEnable();
                        EMConferenceManager.this.mediaSession = EMConferenceManager.this.mediaManager.newSessionWithTicket(string3, "{'extension':'creator'}", EMConferenceManager.this.sessionDelegate);
                        EMConferenceManager.this.mediaManager.setSession(EMConferenceManager.this.mediaSession, EMClient.getInstance().getCurrentUser());
                        EMConferenceManager.this.mediaManager.join(EMConferenceManager.this.mediaSession, EMConferenceManager.this.configWrap(eMStreamParam), new EMediaEntities.EMediaIdBlockType(){

                            @Override
                            public void onDone(Object object, EMediaEntities.EMediaError eMediaError) {
                                if (eMediaError != null) {
                                    EMLog.d(EMConferenceManager.this.TAG, "Join conference failed code=" + (Object)((Object)eMediaError.code) + ", desc=" + eMediaError.errorDescription);
                                    if (eMValueCallBack != null) {
                                        eMValueCallBack.onError(EMConferenceManager.this.errorMap(eMediaError.code.errorcode), eMediaError.errorDescription);
                                    }
                                } else {
                                    EMLog.d(EMConferenceManager.this.TAG, "Join conference success!");
                                    eMConference.setConferenceRole(EMConferenceRole.from(((EMConferenceManager)EMConferenceManager.this).mediaSession.role));
                                    eMConference.setPubStreamId((String)object, EMConferenceStream.StreamType.NORMAL);
                                    eMConference.setRecordOnServer(((EMConferenceManager)EMConferenceManager.this).mediaSession.isRecordOnServer);
                                    EMLog.d(EMConferenceManager.this.TAG, "record? " + eMConference.isRecordOnServer());
                                    EMConferenceManager.this.currentConference = eMConference;
                                    if (eMValueCallBack != null) {
                                        eMValueCallBack.onSuccess(eMConference);
                                    }
                                }
                            }
                        });
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                        if (eMValueCallBack == null) break block4;
                        eMValueCallBack.onError(804, jSONException.getMessage());
                    }
                }
            }
        });
    }

    public void joinConference(String string, String string2, EMValueCallBack<EMConference> eMValueCallBack) {
        this.joinConference(string, string2, null, eMValueCallBack);
    }

    @Deprecated
    public void joinConference(String string, String string2, EMStreamParam eMStreamParam, EMValueCallBack<EMConference> eMValueCallBack) {
        EMLog.d(this.TAG, "joinConference");
        this.joinConferenceMultiple(string, string2, EMConferenceRole.NoType, null, eMStreamParam, eMValueCallBack);
    }

    public void joinConferenceMultiple(final String string, final String string2, final EMConferenceRole eMConferenceRole, final EMRoomConfig eMRoomConfig, final EMStreamParam eMStreamParam, final EMValueCallBack<EMConference> eMValueCallBack) {
        EMLog.d(this.TAG, "joinConferenceMultiple");
        if (TextUtils.isEmpty((CharSequence)this.accessToken) || TextUtils.isEmpty((CharSequence)this.appKey) || TextUtils.isEmpty((CharSequence)this.username)) {
            EMLog.e(this.TAG, "AccessToken AppKey or Username is not set");
            if (eMValueCallBack != null) {
                eMValueCallBack.onError(804, "If you want to use this feature without im account login, please setting the necessary parameters through the EMClient.getInstance().conferenceManager.set(String accessToken, String appKey, String username) method.");
            }
            return;
        }
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                block11: {
                    EMAError eMAError = new EMAError();
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("uid", EasyUtils.getMediaRequestUid(EMConferenceManager.this.appKey, EMConferenceManager.this.username));
                    hashMap.put("token", EMConferenceManager.this.accessToken);
                    hashMap.put("confrId", string);
                    hashMap.put("password", string2);
                    if (eMConferenceRole != EMConferenceRole.NoType) {
                        hashMap.put("role", eMConferenceRole.code);
                    }
                    EMConferenceManager.this.addCommonParams(hashMap);
                    String string7 = EMConferenceManager.convertMapToJSONObject(hashMap).toString();
                    String string22 = EMConferenceManager.this.emaCallManager.requestMediaFromServer(0, string7, eMAError);
                    if (eMAError.errCode() != 0) {
                        EMLog.d(EMConferenceManager.this.TAG, "requestMediaFromServer failed " + eMAError.errCode() + ", " + eMAError.errMsg());
                        if (eMValueCallBack != null) {
                            eMValueCallBack.onError(eMAError.errCode(), eMAError.errMsg());
                        }
                        return;
                    }
                    final EMConference eMConference = new EMConference();
                    eMConference.setConferenceId(string);
                    eMConference.setPassword(string2);
                    try {
                        EMARTCConfigManager eMARTCConfigManager;
                        JSONObject jSONObject = new JSONObject(string22);
                        String string3 = jSONObject.optString("ticket");
                        EMConferenceRole eMConferenceRole2 = EMConferenceRole.from(new JSONObject(string3).optInt("rights"));
                        EMConferenceManager.this.role.update(eMConferenceRole2, jSONObject.optString("roleToken"));
                        EMConferenceManager.this.conferenceType = EMConferenceType.from(jSONObject.optInt("type"));
                        EMLog.i(EMConferenceManager.this.TAG, "joinConference, conferenceType: " + (Object)((Object)EMConferenceManager.this.conferenceType));
                        eMConference.setConferenceType(EMConferenceManager.this.conferenceType);
                        EMConferenceManager.this.setSubscribeAudioMixEnable();
                        if (eMRoomConfig != null) {
                            EMConferenceManager.this.mediaSession = EMConferenceManager.this.mediaManager.newSessionWithTicket(string3, eMRoomConfig.getExt(), EMConferenceManager.this.sessionDelegate);
                            EMConferenceManager.this.mediaManager.setSession(EMConferenceManager.this.mediaSession, eMRoomConfig.getNickName());
                        } else {
                            EMConferenceManager.this.mediaSession = EMConferenceManager.this.mediaManager.newSessionWithTicket(string3, "{'extension':'member'}", EMConferenceManager.this.sessionDelegate);
                            EMConferenceManager.this.mediaManager.setSession(EMConferenceManager.this.mediaSession, EMClient.getInstance().getCurrentUser());
                        }
                        if (EMClient.getInstance().getOptions().getUseRtcConfig() && (eMARTCConfigManager = EMClient.getInstance().rtcConfigManager()) != null) {
                            String[] stringArray;
                            String[] stringArray2;
                            String string4;
                            String string5;
                            if (eMARTCConfigManager.getWSUrl() != null && (string5 = eMARTCConfigManager.getWSUrl()).length() > 0 && (string4 = new JSONObject(string3).optString("url")).length() > 0 && (stringArray2 = string4.split("//")).length > 1 && (stringArray = stringArray2[1].split("/")).length > 0) {
                                stringArray[0] = string5;
                                String string6 = stringArray2[0] + "//";
                                for (int k = 0; k < stringArray.length; ++k) {
                                    string6 = string6 + stringArray[k];
                                    if (k >= stringArray.length - 1) continue;
                                    string6 = string6 + "/";
                                }
                                EMConferenceManager.this.mediaManager.setSpecificServerUrl(string6, null);
                            }
                            if (eMARTCConfigManager.getCandidateMap() != null && eMARTCConfigManager.getCandidateMap().length() > 0) {
                                EMConferenceManager.this.mediaManager.setCandidate(eMARTCConfigManager.getCandidateMap());
                            }
                        }
                        EMConferenceManager.this.mediaManager.join(EMConferenceManager.this.mediaSession, EMConferenceManager.this.configWrap(eMStreamParam), new EMediaEntities.EMediaIdBlockType(){

                            @Override
                            public void onDone(Object object, EMediaEntities.EMediaError eMediaError) {
                                if (eMediaError != null) {
                                    EMLog.d(EMConferenceManager.this.TAG, "Join conference failed code=" + (Object)((Object)eMediaError.code) + ", desc=" + eMediaError.errorDescription);
                                    if (eMValueCallBack != null) {
                                        eMValueCallBack.onError(EMConferenceManager.this.errorMap(eMediaError.code.errorcode), eMediaError.errorDescription);
                                    }
                                } else {
                                    EMLog.d(EMConferenceManager.this.TAG, "Join conference success!");
                                    eMConference.setConferenceRole(EMConferenceRole.from(((EMConferenceManager)EMConferenceManager.this).mediaSession.role));
                                    EMConferenceManager.this.role.updateRole(EMConferenceRole.from(((EMConferenceManager)EMConferenceManager.this).mediaSession.role));
                                    eMConference.setPubStreamId((String)object, EMConferenceStream.StreamType.NORMAL);
                                    eMConference.setRecordOnServer(((EMConferenceManager)EMConferenceManager.this).mediaSession.isRecordOnServer);
                                    EMLog.d(EMConferenceManager.this.TAG, "Join conference: is record? " + eMConference.isRecordOnServer());
                                    EMConferenceManager.this.currentConference = eMConference;
                                    if (eMValueCallBack != null) {
                                        eMValueCallBack.onSuccess(eMConference);
                                    }
                                }
                            }
                        });
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                        if (eMValueCallBack == null) break block11;
                        eMValueCallBack.onError(804, jSONException.getMessage());
                    }
                }
            }
        });
    }

    public void updateLiveLayout(final List<EMLiveRegion> list, final EMValueCallBack<String> eMValueCallBack) {
        if (this.currentConference != null) {
            if (this.currentConference.getConferenceRole() != EMConferenceRole.Admin) {
                EMLog.d(this.TAG, "updateLiveLayout failed  Current role is not Admin");
                return;
            }
        } else {
            EMLog.e(this.TAG, "updateLiveLayout failed, not in a conference currently.");
            return;
        }
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                EMLog.d(EMConferenceManager.this.TAG, "updateLiveLayout , confrId: " + EMConferenceManager.this.currentConference.getConferenceId());
                EMAError eMAError = new EMAError();
                HashMap<String, String> hashMap = new HashMap<String, String>();
                try {
                    Object object;
                    JSONArray jSONArray = new JSONArray();
                    if (list != null && list.size() > 0) {
                        for (int k = 0; k < list.size(); ++k) {
                            object = new JSONObject();
                            object.put("sid", (Object)((EMLiveRegion)list.get(k)).getStreamId());
                            object.put("x", ((EMLiveRegion)list.get(k)).getX());
                            object.put("y", ((EMLiveRegion)list.get(k)).getY());
                            object.put("w", ((EMLiveRegion)list.get(k)).getWidth());
                            object.put("h", ((EMLiveRegion)list.get(k)).getHeight());
                            object.put("z", ((EMLiveRegion)list.get(k)).getZorder());
                            String string = ((EMLiveRegion)list.get(k)).getStyle() == EMLiveRegion.EMRegionStyle.FILL ? "fill" : "AspectFit";
                            object.put("style", (Object)string);
                            jSONArray.put(k, object);
                        }
                    }
                    hashMap.put("confrId", EMConferenceManager.this.currentConference.getConferenceId());
                    hashMap.put("liveId", EMConferenceManager.this.liveId);
                    hashMap.put("roleToken", EMConferenceManager.this.role.getRoleToken());
                    hashMap.put("regions", (String)jSONArray);
                    String string = EMConferenceManager.convertMapToJSONObject(hashMap).toString();
                    object = EMConferenceManager.this.emaCallManager.requestMediaFromServer(8, string, eMAError);
                    if (eMAError.errCode() != 0) {
                        EMLog.d(EMConferenceManager.this.TAG, "updateLiveLayout failed " + eMAError.errCode() + ", " + eMAError.errMsg());
                        if (eMValueCallBack != null) {
                            eMValueCallBack.onError(eMAError.errCode(), eMAError.errMsg());
                        }
                    } else {
                        EMLog.d(EMConferenceManager.this.TAG, "updateLiveLayout success!");
                        if (eMValueCallBack != null) {
                            eMValueCallBack.onSuccess(object);
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
    }

    private void stopLiveStream(final EMValueCallBack<String> eMValueCallBack) {
        if (this.currentConference != null) {
            this.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    EMLog.d(EMConferenceManager.this.TAG, "stopLiveStream confrId: " + EMConferenceManager.this.currentConference.getConferenceId());
                    EMAError eMAError = new EMAError();
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("confrId", EMConferenceManager.this.currentConference.getConferenceId());
                    hashMap.put("liveId", EMConferenceManager.this.liveId);
                    hashMap.put("roleToken", EMConferenceManager.this.role.getRoleToken());
                    String string = EMConferenceManager.convertMapToJSONObject(hashMap).toString();
                    String string2 = EMConferenceManager.this.emaCallManager.requestMediaFromServer(9, string, eMAError);
                    if (eMAError.errCode() != 0) {
                        EMLog.d(EMConferenceManager.this.TAG, "stopLiveStream failed " + eMAError.errCode() + ", " + eMAError.errMsg());
                        if (eMValueCallBack != null) {
                            eMValueCallBack.onError(eMAError.errCode(), eMAError.errMsg());
                        }
                    } else {
                        EMLog.d(EMConferenceManager.this.TAG, "stopLiveStream success!");
                        if (eMValueCallBack != null) {
                            eMValueCallBack.onSuccess(string2);
                        }
                    }
                }
            });
        } else {
            EMLog.d(this.TAG, "stopLiveStream:  currentConference is null");
        }
    }

    public void joinConferenceWithTicket(final String string, final EMStreamParam eMStreamParam, final EMValueCallBack<EMConference> eMValueCallBack) {
        EMLog.d(this.TAG, "joinConferenceWithTicket");
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                block6: {
                    try {
                        EMLog.d(EMConferenceManager.this.TAG, "Join conference");
                        final EMConference eMConference = new EMConference();
                        JSONObject jSONObject = new JSONObject(string);
                        String string4 = jSONObject.optString("confrId");
                        String string2 = jSONObject.optString("password");
                        eMConference.setConferenceId(string4);
                        eMConference.setPassword(string2);
                        String string3 = jSONObject.optString("type");
                        if (string3 != null && string3.equals("live")) {
                            EMConferenceManager.this.conferenceType = EMConferenceType.LiveStream;
                        } else if (string3 != null && string3.equals("communication_mix")) {
                            EMConferenceManager.this.conferenceType = EMConferenceType.LargeCommunication;
                        } else {
                            EMConferenceManager.this.conferenceType = EMConferenceType.SmallCommunication;
                        }
                        EMConferenceManager.this.setSubscribeAudioMixEnable();
                        EMConferenceManager.this.mediaSession = EMConferenceManager.this.mediaManager.newSessionWithTicket(string, "{'extension':'member'}", EMConferenceManager.this.sessionDelegate);
                        EMConferenceManager.this.mediaManager.setSession(EMConferenceManager.this.mediaSession, EMClient.getInstance().getCurrentUser());
                        EMConferenceManager.this.mediaManager.join(EMConferenceManager.this.mediaSession, EMConferenceManager.this.configWrap(eMStreamParam), new EMediaEntities.EMediaIdBlockType(){

                            @Override
                            public void onDone(Object object, EMediaEntities.EMediaError eMediaError) {
                                if (eMediaError != null) {
                                    EMLog.d(EMConferenceManager.this.TAG, "Join conference with ticket failed code=" + (Object)((Object)eMediaError.code) + ", desc=" + eMediaError.errorDescription);
                                    if (eMValueCallBack != null) {
                                        eMValueCallBack.onError(EMConferenceManager.this.errorMap(eMediaError.code.errorcode), eMediaError.errorDescription);
                                    }
                                } else {
                                    EMLog.d(EMConferenceManager.this.TAG, "Join conference with ticket success!");
                                    eMConference.setConferenceRole(EMConferenceRole.from(((EMConferenceManager)EMConferenceManager.this).mediaSession.role));
                                    eMConference.setPubStreamId((String)object, EMConferenceStream.StreamType.NORMAL);
                                    eMConference.setRecordOnServer(((EMConferenceManager)EMConferenceManager.this).mediaSession.isRecordOnServer);
                                    EMLog.d(EMConferenceManager.this.TAG, "Join conference: is record? " + eMConference.isRecordOnServer());
                                    EMConferenceManager.this.currentConference = eMConference;
                                    EMConferenceManager.this.currentConference = new EMConference();
                                    if (eMValueCallBack != null) {
                                        eMValueCallBack.onSuccess(eMConference);
                                    }
                                }
                            }
                        });
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                        if (eMValueCallBack == null) break block6;
                        eMValueCallBack.onError(804, jSONException.getMessage());
                    }
                }
            }
        });
    }

    public void inviteUserToJoinConference(final String string, final String string2, final String string3, final String string4, final EMValueCallBack eMValueCallBack) {
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                EMLog.d(EMConferenceManager.this.TAG, "inviteUserToJoinConference");
                EMAError eMAError = new EMAError();
                EMConferenceManager.this.emaCallManager.inviteUserToJoinConference(string, string2, string3, string4, eMAError);
                if (eMAError.errCode() != 0) {
                    EMLog.d(EMConferenceManager.this.TAG, "inviteUserToJoinConference failed " + eMAError.errCode() + ", " + eMAError.errMsg());
                    eMValueCallBack.onError(eMAError.errCode(), eMAError.errMsg());
                    return;
                }
                eMValueCallBack.onSuccess(null);
            }
        });
    }

    public void grantRole(String string, final EMConferenceMember eMConferenceMember, final EMConferenceRole eMConferenceRole, final EMValueCallBack<String> eMValueCallBack) {
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                EMLog.d(EMConferenceManager.this.TAG, "grantRole, mem: " + eMConferenceMember.memberName + ", target role: " + (Object)((Object)eMConferenceRole));
                EMAError eMAError = new EMAError();
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("uids", new Object[]{eMConferenceMember.memberName});
                hashMap.put("roleToken", EMConferenceManager.this.role.getRoleToken());
                hashMap.put("role", eMConferenceRole.code);
                EMConferenceManager.this.addCommonParams(hashMap);
                String string = EMConferenceManager.convertMapToJSONObject(hashMap).toString();
                boolean bl = EMConferenceManager.this.username.equals(EasyUtils.useridFromJid(eMConferenceMember.memberName)) && eMConferenceRole.code < ((EMConferenceManager)EMConferenceManager.this).role.getRole().code;
                String string2 = bl ? EMConferenceManager.this.emaCallManager.requestMediaFromServer(6, string, eMAError) : EMConferenceManager.this.emaCallManager.requestMediaFromServer(1, string, eMAError);
                if (eMAError.errCode() != 0) {
                    EMLog.d(EMConferenceManager.this.TAG, "grantRole failed " + eMAError.errCode() + ", " + eMAError.errMsg());
                    if (eMValueCallBack != null) {
                        eMValueCallBack.onError(eMAError.errCode(), eMAError.errMsg());
                    }
                } else {
                    EMLog.d(EMConferenceManager.this.TAG, "grantRole success!");
                    if (eMValueCallBack != null) {
                        eMValueCallBack.onSuccess(string2);
                    }
                }
            }
        });
    }

    public void kickMember(String string, final List<String> list, final EMValueCallBack<String> eMValueCallBack) {
        if (this.currentConference != null) {
            if (this.currentConference.getConferenceRole() != EMConferenceRole.Admin) {
                EMLog.d(this.TAG, "kickMember failed  Current role is not Admin");
                return;
            }
        } else {
            EMLog.e(this.TAG, "kickMember, not in a conference currently.");
            return;
        }
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                EMLog.d(EMConferenceManager.this.TAG, "kickMember, mem: " + list.toString());
                EMAError eMAError = new EMAError();
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                Object[] objectArray = new Object[list.size()];
                for (int k = 0; k < list.size(); ++k) {
                    objectArray[k] = list.get(k);
                }
                hashMap.put("uids", objectArray);
                hashMap.put("roleToken", EMConferenceManager.this.role.getRoleToken());
                EMConferenceManager.this.addCommonParams(hashMap);
                String string = EMConferenceManager.convertMapToJSONObject(hashMap).toString();
                String string2 = EMConferenceManager.this.emaCallManager.requestMediaFromServer(2, string, eMAError);
                if (eMAError.errCode() != 0) {
                    EMLog.d(EMConferenceManager.this.TAG, "kickMember failed " + eMAError.errCode() + ", " + eMAError.errMsg());
                    if (eMValueCallBack != null) {
                        eMValueCallBack.onError(eMAError.errCode(), eMAError.errMsg());
                    }
                } else {
                    EMLog.d(EMConferenceManager.this.TAG, "kickMember success!");
                    if (eMValueCallBack != null) {
                        eMValueCallBack.onSuccess(string2);
                    }
                }
            }
        });
    }

    public void muteAll(String string, final boolean bl, final EMValueCallBack<String> eMValueCallBack) {
        if (this.currentConference != null) {
            if (this.currentConference.getConferenceRole() != EMConferenceRole.Admin) {
                EMLog.d(this.TAG, "muteAll failed  Current role is not Admin");
                return;
            }
        } else {
            EMLog.e(this.TAG, "muteAll, not in a conference currently.");
            return;
        }
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                EMLog.d(EMConferenceManager.this.TAG, "muteAll , mute: " + bl);
                EMAError eMAError = new EMAError();
                HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
                hashMap.put("muteAll", bl);
                HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
                hashMap2.put("roleToken", EMConferenceManager.this.role.getRoleToken());
                hashMap2.put("cstate", hashMap);
                EMConferenceManager.this.addCommonParams(hashMap2);
                String string = EMConferenceManager.convertMapToJSONObject(hashMap2).toString();
                String string2 = EMConferenceManager.this.emaCallManager.requestMediaFromServer(5, string, eMAError);
                if (eMAError.errCode() != 0) {
                    EMLog.d(EMConferenceManager.this.TAG, "muteAll failed " + eMAError.errCode() + ", " + eMAError.errMsg());
                    if (eMValueCallBack != null) {
                        eMValueCallBack.onError(eMAError.errCode(), eMAError.errMsg());
                    }
                } else {
                    EMLog.d(EMConferenceManager.this.TAG, "muteAll success!");
                    if (eMValueCallBack != null) {
                        eMValueCallBack.onSuccess(string2);
                    }
                }
            }
        });
    }

    public void setConferenceAttribute(@NonNull String string, @NonNull String string2, EMValueCallBack<Void> eMValueCallBack) {
        this.handleConferenceAttribute(EMConferenceAttribute.Action.UPDATE, string, string2, eMValueCallBack);
    }

    public void deleteConferenceAttribute(@NonNull String string, EMValueCallBack<Void> eMValueCallBack) {
        this.handleConferenceAttribute(EMConferenceAttribute.Action.DELETE, string, null, eMValueCallBack);
    }

    private void handleConferenceAttribute(final EMConferenceAttribute.Action action, final String string, final String string2, final EMValueCallBack<Void> eMValueCallBack) {
        EMLog.i(this.TAG, "handleConferenceAttribute, action: " + (Object)((Object)action) + ", key: " + string + ", value: " + string2);
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                EMAError eMAError = new EMAError();
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("key", string);
                if (string2 != null) {
                    hashMap.put("val", string2);
                }
                switch (action) {
                    case UPDATE: {
                        hashMap.put("op", "UPDATE");
                        break;
                    }
                    case DELETE: {
                        hashMap.put("op", "DEL");
                    }
                }
                JSONObject[] jSONObjectArray = new JSONObject[]{EMConferenceManager.convertMapToJSONObject(hashMap)};
                HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
                hashMap2.put("roleToken", EMConferenceManager.this.role.getRoleToken());
                hashMap2.put("cattrs", jSONObjectArray);
                EMConferenceManager.this.addCommonParams(hashMap2);
                String string3 = EMConferenceManager.convertMapToJSONObject(hashMap2).toString();
                EMConferenceManager.this.emaCallManager.requestMediaFromServer(5, string3, eMAError);
                if (eMAError.errCode() != 0) {
                    EMLog.d(EMConferenceManager.this.TAG, "handleConferenceAttribute failed " + eMAError.errCode() + ", " + eMAError.errMsg());
                    if (eMValueCallBack != null) {
                        eMValueCallBack.onError(eMAError.errCode(), eMAError.errMsg());
                    }
                } else {
                    EMLog.d(EMConferenceManager.this.TAG, "handleConferenceAttribute success!");
                    if (eMValueCallBack != null) {
                        eMValueCallBack.onSuccess(null);
                    }
                }
            }
        });
    }

    protected void addCommonParams(Map<String, Object> map) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("os", "Android");
        hashMap.put("version", "3.6.8");
        map.put("terminal", hashMap);
    }

    public void destroyConference(final EMValueCallBack eMValueCallBack) {
        EMLog.d(this.TAG, "destroyConference");
        if (this.role.getRole() != EMConferenceRole.Admin) {
            return;
        }
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                EMAError eMAError = new EMAError();
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("roleToken", EMConferenceManager.this.role.getRoleToken());
                String string = EMConferenceManager.convertMapToJSONObject(hashMap).toString();
                String string2 = EMConferenceManager.this.emaCallManager.requestMediaFromServer(3, string, eMAError);
                if (eMAError.errCode() != 0) {
                    EMLog.d(EMConferenceManager.this.TAG, "destroyConference failed " + eMAError.errCode() + ", " + eMAError.errMsg());
                    if (eMValueCallBack != null) {
                        eMValueCallBack.onError(eMAError.errCode(), eMAError.errMsg());
                    }
                } else {
                    EMLog.d(EMConferenceManager.this.TAG, "destroyConference success!");
                    if (eMValueCallBack != null) {
                        eMValueCallBack.onSuccess(null);
                    }
                }
                EMConferenceManager.this.memberList.clear();
                EMConferenceManager.this.subscribedStreamMap.clear();
                EMConferenceManager.this.availableStreamMap.clear();
                EMConferenceManager.this.currentConference = null;
                EMConferenceManager.this.watermark = null;
            }
        });
    }

    public void exitConference(final EMValueCallBack eMValueCallBack) {
        EMLog.d(this.TAG, "Exit conference - async");
        this.mediaManager.exit(this.mediaSession, new EMediaEntities.EMediaIdBlockType(){

            @Override
            public void onDone(Object object, EMediaEntities.EMediaError eMediaError) {
                if (eMediaError != null) {
                    EMLog.d(EMConferenceManager.this.TAG, "Exit conference failed code=" + (Object)((Object)eMediaError.code) + ", desc=" + eMediaError.errorDescription);
                    if (eMValueCallBack != null) {
                        eMValueCallBack.onError(EMConferenceManager.this.errorMap(eMediaError.code.errorcode), eMediaError.errorDescription);
                    }
                } else {
                    EMLog.d(EMConferenceManager.this.TAG, "Exit conference success");
                    if (eMValueCallBack != null) {
                        eMValueCallBack.onSuccess(null);
                    }
                }
                EMConferenceManager.this.memberList.clear();
                EMConferenceManager.this.subscribedStreamMap.clear();
                EMConferenceManager.this.availableStreamMap.clear();
                EMConferenceManager.this.currentConference = null;
                EMConferenceManager.this.watermark = null;
            }
        });
    }

    public void publish(EMStreamParam eMStreamParam, final EMValueCallBack<String> eMValueCallBack) {
        EMLog.d(this.TAG, "Publish local stream");
        EMediaPublishConfiguration eMediaPublishConfiguration = this.configWrap(eMStreamParam);
        if (eMediaPublishConfiguration != null) {
            EMLog.i(this.TAG, "Publish local stream, video off: " + eMediaPublishConfiguration.isVideoOff() + ", audio off: " + eMediaPublishConfiguration.isMute() + ", stream type: " + (Object)((Object)eMediaPublishConfiguration.getPubType()));
        }
        this.mediaManager.publish(this.mediaSession, eMediaPublishConfiguration, new EMediaEntities.EMediaIdBlockType(){

            @Override
            public void onDone(Object object, EMediaEntities.EMediaError eMediaError) {
                if (eMediaError != null) {
                    EMLog.d(EMConferenceManager.this.TAG, "Publish failed code=" + (Object)((Object)eMediaError.code) + ", desc=" + eMediaError.errorDescription);
                    if (eMValueCallBack != null) {
                        eMValueCallBack.onError(EMConferenceManager.this.errorMap(eMediaError.code.errorcode), eMediaError.errorDescription);
                    }
                } else {
                    EMLog.d(EMConferenceManager.this.TAG, "Publish success Stream id - " + object);
                    if (eMValueCallBack != null) {
                        eMValueCallBack.onSuccess((String)object);
                    }
                }
            }
        });
    }

    public void unpublish(String string, final EMValueCallBack<String> eMValueCallBack) {
        EMLog.d(this.TAG, "UNPublish local stream - async");
        this.mediaManager.unpublish(this.mediaSession, string, new EMediaEntities.EMediaIdBlockType(){

            @Override
            public void onDone(Object object, EMediaEntities.EMediaError eMediaError) {
                if (eMediaError != null) {
                    EMLog.d(EMConferenceManager.this.TAG, "Unpublish failed code=" + (Object)((Object)eMediaError.code) + ", desc=" + eMediaError.errorDescription);
                    if (eMValueCallBack != null) {
                        eMValueCallBack.onError(EMConferenceManager.this.errorMap(eMediaError.code.errorcode), eMediaError.errorDescription);
                    }
                } else {
                    EMLog.d(EMConferenceManager.this.TAG, "Unpublish success Stream id - " + object);
                    if (eMValueCallBack != null) {
                        eMValueCallBack.onSuccess((String)object);
                    }
                }
            }
        });
    }

    public void subscribe(final EMConferenceStream eMConferenceStream, EMCallSurfaceView eMCallSurfaceView, final EMValueCallBack<String> eMValueCallBack) {
        EMLog.d(this.TAG, "Subscribe stream - async " + eMConferenceStream.toString());
        this.mediaManager.subscribe(this.mediaSession, eMConferenceStream.getStreamId(), eMCallSurfaceView, new EMediaEntities.EMediaIdBlockType(){

            @Override
            public void onDone(Object object, EMediaEntities.EMediaError eMediaError) {
                if (eMediaError != null) {
                    EMLog.d(EMConferenceManager.this.TAG, "Subscribe failed code=" + (Object)((Object)eMediaError.code) + ", desc=" + eMediaError.errorDescription);
                    if (eMValueCallBack != null) {
                        eMValueCallBack.onError(EMConferenceManager.this.errorMap(eMediaError.code.errorcode), eMediaError.errorDescription);
                    }
                } else {
                    EMLog.d(EMConferenceManager.this.TAG, "Subscribe success Stream id - " + object);
                    EMConferenceManager.this.subscribedStreamMap.put(eMConferenceStream.getStreamId(), eMConferenceStream);
                    EMConferenceManager.this.availableStreamMap.remove(eMConferenceStream.getStreamId());
                    if (eMValueCallBack != null) {
                        eMValueCallBack.onSuccess((String)object);
                    }
                }
            }
        });
    }

    public void updateSubscribe(final EMConferenceStream eMConferenceStream, EMCallSurfaceView eMCallSurfaceView, final EMValueCallBack<String> eMValueCallBack) {
        EMLog.d(this.TAG, "Update subscribe stream - async " + eMConferenceStream.toString());
        this.mediaManager.updateSubscribe(this.mediaSession, eMConferenceStream.getStreamId(), eMCallSurfaceView, new EMediaEntities.EMediaIdBlockType(){

            @Override
            public void onDone(Object object, EMediaEntities.EMediaError eMediaError) {
                if (eMediaError != null) {
                    EMLog.d(EMConferenceManager.this.TAG, "Update subscribe failed code=" + (Object)((Object)eMediaError.code) + ", desc=" + eMediaError.errorDescription);
                    if (eMValueCallBack != null) {
                        eMValueCallBack.onError(EMConferenceManager.this.errorMap(eMediaError.code.errorcode), eMediaError.errorDescription);
                    }
                } else {
                    EMLog.d(EMConferenceManager.this.TAG, "Update subscribe success Stream id - " + object);
                    EMConferenceManager.this.subscribedStreamMap.put(eMConferenceStream.getStreamId(), eMConferenceStream);
                    EMConferenceManager.this.availableStreamMap.remove(eMConferenceStream.getStreamId());
                    if (eMValueCallBack != null) {
                        eMValueCallBack.onSuccess((String)object);
                    }
                }
            }
        });
    }

    public void unsubscribe(final EMConferenceStream eMConferenceStream, final EMValueCallBack<String> eMValueCallBack) {
        EMLog.d(this.TAG, "UNSubscribe stream - async " + eMConferenceStream.toString());
        this.mediaManager.unsubscribe(this.mediaSession, eMConferenceStream.getStreamId(), new EMediaEntities.EMediaIdBlockType(){

            @Override
            public void onDone(Object object, EMediaEntities.EMediaError eMediaError) {
                if (eMediaError != null) {
                    EMLog.d(EMConferenceManager.this.TAG, "Unsubscribe failed code=" + (Object)((Object)eMediaError.code) + ", desc=" + eMediaError.errorDescription);
                    if (eMValueCallBack != null) {
                        eMValueCallBack.onError(EMConferenceManager.this.errorMap(eMediaError.code.errorcode), eMediaError.errorDescription);
                    }
                } else {
                    EMLog.d(EMConferenceManager.this.TAG, "Unsubscribe success Stream id - " + object);
                    EMConferenceManager.this.availableStreamMap.put(eMConferenceStream.getStreamId(), eMConferenceStream);
                    EMConferenceManager.this.subscribedStreamMap.remove(eMConferenceStream.getStreamId());
                    if (eMValueCallBack != null) {
                        eMValueCallBack.onSuccess((String)object);
                    }
                }
            }
        });
    }

    public void inputExternalVideoData(EMConferenceStream.StreamType streamType, byte[] byArray, RtcConnection.FORMAT fORMAT, int n, int n2, int n3, int n4, int n5) {
        EMediaDefines.EMediaStreamType eMediaStreamType;
        if (streamType == EMConferenceStream.StreamType.NORMAL) {
            eMediaStreamType = EMediaDefines.EMediaStreamType.EMSTREAM_TYPE_NORMAL;
        } else if (streamType == EMConferenceStream.StreamType.DESKTOP) {
            eMediaStreamType = EMediaDefines.EMediaStreamType.EMSTREAM_TYPE_DESKTOP;
        } else {
            throw new IllegalArgumentException("Unsupported stream type: " + (Object)((Object)streamType));
        }
        this.mediaManager.inputExternalVideoData(eMediaStreamType, byArray, fORMAT, n, n2, n3, n4, n5);
    }

    public void setWaterMark(EMWaterMarkOption eMWaterMarkOption) {
        if (eMWaterMarkOption != null) {
            this.watermark = new Watermark(eMWaterMarkOption.getMarkImg(), eMWaterMarkOption.getWidth(), eMWaterMarkOption.getHeight(), eMWaterMarkOption.getOrientation().getDesc(), eMWaterMarkOption.getwMargin(), eMWaterMarkOption.gethMargin());
            this.mediaManager.setWaterMark(this.watermark);
        } else {
            this.mediaManager.setWaterMark(null);
        }
    }

    public void clearWaterMark() {
        this.mediaManager.setWaterMark(null);
    }

    public int inputExternalAudioData(byte[] byArray, int n) {
        return this.mediaManager.inputExternalAudioData(byArray, n);
    }

    @Deprecated
    public void inputExternalVideoData(Bitmap bitmap) {
        int n = bitmap.getWidth();
        int n2 = bitmap.getHeight();
        n = n % 2 == 0 ? n : n - 1;
        n2 = n2 % 2 == 0 ? n2 : n2 - 1;
        int[] nArray = new int[n * n2];
        bitmap.getPixels(nArray, 0, n, 0, 0, n, n2);
        byte[] byArray = new byte[n * n2 * 3 / 2];
        EMConferenceManager.encodeYUV420SP(byArray, nArray, n, n2);
        bitmap.recycle();
        this.mediaManager.inputExternalVideoData(EMediaDefines.EMediaStreamType.EMSTREAM_TYPE_DESKTOP, byArray, RtcConnection.FORMAT.NV21, n, n2, n, n2, 0);
    }

    @Deprecated
    public void inputExternalVideoData(EMConferenceStream.StreamType streamType, byte[] byArray, int n, int n2, int n3) {
        EMediaDefines.EMediaStreamType eMediaStreamType;
        if (streamType == EMConferenceStream.StreamType.NORMAL) {
            eMediaStreamType = EMediaDefines.EMediaStreamType.EMSTREAM_TYPE_NORMAL;
        } else if (streamType == EMConferenceStream.StreamType.DESKTOP) {
            eMediaStreamType = EMediaDefines.EMediaStreamType.EMSTREAM_TYPE_DESKTOP;
        } else {
            throw new IllegalArgumentException("Unsupported stream type: " + (Object)((Object)streamType));
        }
        this.mediaManager.inputExternalVideoData(eMediaStreamType, byArray, RtcConnection.FORMAT.NV21, n, n2, n, n2, n3);
    }

    @Deprecated
    public void inputExternalVideoData(byte[] byArray, int n, int n2, int n3) {
        this.inputExternalVideoData(EMConferenceStream.StreamType.NORMAL, byArray, n, n2, n3);
    }

    public void startMonitorSpeaker(int n) {
        this.mediaManager.setAudioTalkerInterval(n, new EMediaEntities.EMediaIdBlockType(){

            @Override
            public void onDone(Object object, EMediaEntities.EMediaError eMediaError) {
                EMLog.d(EMConferenceManager.this.TAG, "error: " + (Object)((Object)eMediaError.code) + " desc:" + eMediaError.errorDescription);
            }
        });
    }

    public void stopMonitorSpeaker() {
        this.mediaManager.stopAudioTalker();
    }

    private void setSubscribeAudioMixEnable() {
        if (this.conferenceType == EMConferenceType.LargeCommunication) {
            this.mediaManager.setSubscribeAudioMixEnabled(false);
        } else {
            this.mediaManager.setSubscribeAudioMixEnabled(true);
        }
    }

    public void setLocalSurfaceView(EMCallSurfaceView eMCallSurfaceView) {
        this.mediaManager.setLocalPreviewView(eMCallSurfaceView);
    }

    public void updateLocalSurfaceView(EMCallSurfaceView eMCallSurfaceView) {
        this.mediaManager.setVideoViews(null, eMCallSurfaceView, null, true);
    }

    public void updateRemoteSurfaceView(String string, EMCallSurfaceView eMCallSurfaceView) {
        this.mediaManager.setVideoViews(string, null, eMCallSurfaceView, false);
    }

    public void updateVideoMaxKbps(int n) {
        this.mediaManager.updateVideoMaxKbps(n);
    }

    public int getCameraId() {
        return this.mediaManager.getCameraFacing();
    }

    public void switchCamera() {
        this.mediaManager.switchCamera();
    }

    public void closeVideoTransfer() {
        this.mediaManager.setVideoEnabled(false);
    }

    public void openVideoTransfer() {
        this.mediaManager.setVideoEnabled(true);
    }

    public void closeVoiceTransfer() {
        this.mediaManager.setMuteEnabled(true);
    }

    public void openVoiceTransfer() {
        this.mediaManager.setMuteEnabled(false);
    }

    public void muteRemoteAudio(String string, boolean bl) {
        this.mediaManager.muteRemoteAudio(string, bl);
    }

    public void muteRemoteVideo(String string, boolean bl) {
        this.mediaManager.muteRemoteVideo(string, bl);
    }

    public void enableStatistics(boolean bl) {
        if (this.mediaSession != null) {
            this.mediaManager.enableStatistics(this.mediaSession, bl);
        } else {
            EMLog.e(this.TAG, "Conference no start");
        }
    }

    public List<EMConferenceMember> getConferenceMemberList() {
        return this.memberList;
    }

    public Map<String, EMConferenceStream> getAvailableStreamMap() {
        return this.availableStreamMap;
    }

    public Map<String, EMConferenceStream> getSubscribedStreamMap() {
        return this.subscribedStreamMap;
    }

    public void setLocalVideoViewMirror(@EMMirror.MIRROR int n) {
        RtcConnection.MIRROR mIRROR = EMMirror.convert(n);
        this.mediaManager.setLocalVideoViewMirror(mIRROR);
    }

    public void setRotation(int n) {
        this.mediaManager.setRotation(n);
    }

    public void createWhiteboardRoom(final String string, final String string2, final String string3, final String string4, final EMValueCallBack<EMWhiteboard> eMValueCallBack) {
        EMLog.d(this.TAG, "createWhiteboardRoom: " + string + " room: " + string3);
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                EMAError eMAError = new EMAError();
                String string5 = EMConferenceManager.this.emaCallManager.requestWBFromServer(0, string, string2, string3, string4, eMAError);
                if (eMAError.errCode() != 0) {
                    if (eMValueCallBack != null) {
                        eMValueCallBack.onError(eMAError.errCode(), eMAError.errMsg());
                    }
                    return;
                }
                try {
                    JSONObject jSONObject = new JSONObject(string5);
                    String string22 = jSONObject.getString("roomId");
                    String string32 = jSONObject.getString("whiteBoardUrl");
                    EMWhiteboard eMWhiteboard = new EMWhiteboard();
                    eMWhiteboard.setRoomId(string22);
                    eMWhiteboard.setRoomUrl(string32);
                    eMValueCallBack.onSuccess(eMWhiteboard);
                }
                catch (Exception exception) {
                    eMValueCallBack.onError(1, "parse response failed");
                }
            }
        });
    }

    public void destroyWhiteboardRoom(final String string, final String string2, final String string3, final EMCallBack eMCallBack) {
        EMLog.d(this.TAG, "destroyWhiteboardRoom: " + string + " room: " + string3);
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                EMAError eMAError = new EMAError();
                String string4 = EMConferenceManager.this.emaCallManager.requestWBFromServer(1, string, string2, string3, "", eMAError);
                if (eMAError.errCode() != 0) {
                    if (eMCallBack != null) {
                        eMCallBack.onError(eMAError.errCode(), eMAError.errMsg());
                    }
                    return;
                }
                eMCallBack.onSuccess();
            }
        });
    }

    public void joinWhiteboardRoomWithId(final String string, final String string2, final String string3, final String string4, final EMValueCallBack<EMWhiteboard> eMValueCallBack) {
        EMLog.d(this.TAG, "joinWhiteboardRoomWithId: " + string + " room: " + string3);
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                EMAError eMAError = new EMAError();
                String string5 = EMConferenceManager.this.emaCallManager.requestWBFromServer(2, string, string2, string3, string4, eMAError);
                if (eMAError.errCode() != 0) {
                    if (eMValueCallBack != null) {
                        eMValueCallBack.onError(eMAError.errCode(), eMAError.errMsg());
                    }
                    return;
                }
                try {
                    JSONObject jSONObject = new JSONObject(string5);
                    String string22 = jSONObject.getString("whiteBoardUrl");
                    EMWhiteboard eMWhiteboard = new EMWhiteboard();
                    eMWhiteboard.setRoomUrl(string22);
                    eMValueCallBack.onSuccess(eMWhiteboard);
                }
                catch (Exception exception) {
                    eMValueCallBack.onError(1, "parse response failed");
                }
            }
        });
    }

    public void joinWhiteboardRoomWithName(final String string, final String string2, final String string3, final String string4, final EMValueCallBack<EMWhiteboard> eMValueCallBack) {
        EMLog.d(this.TAG, "joinWhiteboardRoomWithName: " + string + " room: " + string3);
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                EMAError eMAError = new EMAError();
                String string5 = EMConferenceManager.this.emaCallManager.requestWBFromServer(3, string, string2, string3, string4, eMAError);
                if (eMAError.errCode() != 0) {
                    if (eMValueCallBack != null) {
                        eMValueCallBack.onError(eMAError.errCode(), eMAError.errMsg());
                    }
                    return;
                }
                try {
                    JSONObject jSONObject = new JSONObject(string5);
                    String string22 = jSONObject.getString("whiteBoardUrl");
                    EMWhiteboard eMWhiteboard = new EMWhiteboard();
                    eMWhiteboard.setRoomUrl(string22);
                    eMValueCallBack.onSuccess(eMWhiteboard);
                }
                catch (Exception exception) {
                    eMValueCallBack.onError(1, "parse response failed");
                }
            }
        });
    }

    public void applyTobeSpeaker(String string) {
        this.mediaManager.reqActionByMemberId(this.mediaSession, string, "", 21, new EMediaEntities.EMediaIdBlockType(){

            @Override
            public void onDone(Object object, EMediaEntities.EMediaError eMediaError) {
            }
        });
    }

    public void handleSpeakerApplication(String string, boolean bl) {
        int n = bl ? 0 : 1;
        this.mediaManager.handleActionByMemberId(this.mediaSession, string, n, 21, new EMediaEntities.EMediaIdBlockType(){

            @Override
            public void onDone(Object object, EMediaEntities.EMediaError eMediaError) {
            }
        });
    }

    public void applyTobeAdmin(String string) {
        this.mediaManager.reqActionByMemberId(this.mediaSession, string, "", 22, new EMediaEntities.EMediaIdBlockType(){

            @Override
            public void onDone(Object object, EMediaEntities.EMediaError eMediaError) {
            }
        });
    }

    public void handleAdminApplication(String string, boolean bl) {
        int n = bl ? 0 : 1;
        this.mediaManager.handleActionByMemberId(this.mediaSession, string, n, 22, new EMediaEntities.EMediaIdBlockType(){

            @Override
            public void onDone(Object object, EMediaEntities.EMediaError eMediaError) {
            }
        });
    }

    public void muteMember(String string) {
        this.mediaManager.reqActionByMemberId(this.mediaSession, "", string, 23, new EMediaEntities.EMediaIdBlockType(){

            @Override
            public void onDone(Object object, EMediaEntities.EMediaError eMediaError) {
            }
        });
    }

    public void unmuteMember(String string) {
        this.mediaManager.reqActionByMemberId(this.mediaSession, "", string, 24, new EMediaEntities.EMediaIdBlockType(){

            @Override
            public void onDone(Object object, EMediaEntities.EMediaError eMediaError) {
            }
        });
    }

    private EMediaPublishConfiguration configWrap(EMStreamParam eMStreamParam) {
        EMediaPublishConfiguration eMediaPublishConfiguration = null;
        if (eMStreamParam == null) {
            return null;
        }
        eMediaPublishConfiguration = eMStreamParam.streamType == EMConferenceStream.StreamType.NORMAL ? (this.conferenceType == EMConferenceType.LargeCommunication ? EMediaPublishConfiguration.initAudioMixConfig() : EMediaPublishConfiguration.initNormalConfig()) : EMediaPublishConfiguration.initDesktopConfig();
        eMediaPublishConfiguration.setExtension(eMStreamParam.extension);
        eMediaPublishConfiguration.setMute(eMStreamParam.audioOff);
        eMediaPublishConfiguration.setVideoOff(eMStreamParam.videoOff);
        if (eMStreamParam.videoWidth > 0) {
            eMediaPublishConfiguration.setVwidth(eMStreamParam.videoWidth);
        }
        if (eMStreamParam.videoHeight > 0) {
            eMediaPublishConfiguration.setVheight(eMStreamParam.videoHeight);
        }
        eMediaPublishConfiguration.setPubView(eMStreamParam.shareView);
        eMediaPublishConfiguration.setUseBackCamera(eMStreamParam.useBackCamera);
        eMediaPublishConfiguration.setMaxVideoKbps(eMStreamParam.maxVideoKbps);
        eMediaPublishConfiguration.setMaxAudioKbps(eMStreamParam.maxAudioKbps);
        eMediaPublishConfiguration.setExternalVideoSource(eMStreamParam.usingExternalSource);
        RtcConnection.enableFixedVideoResolution(eMStreamParam.enableFixedVideoResolution);
        if (eMStreamParam.minVideoKbps > 0) {
            RtcConnection.setMinVideoKbps(eMStreamParam.minVideoKbps);
        }
        RtcConnection.setAudioSampleRate(eMStreamParam.audioSampleRate);
        return eMediaPublishConfiguration;
    }

    private static JSONObject convertMapToJSONObject(Map<String, Object> map) {
        JSONObject jSONObject = new JSONObject();
        Set<Map.Entry<String, Object>> set = map.entrySet();
        for (Map.Entry<String, Object> entry : set) {
            Object object;
            Object object2 = entry.getValue();
            if (object2 instanceof Map) {
                object = EMConferenceManager.convertMapToJSONObject((Map)object2);
            } else if (object2 instanceof List) {
                object = new JSONArray();
                for (Object e2 : (List)object2) {
                    ((JSONArray)object).put(e2);
                }
            } else if (object2 instanceof Object[]) {
                object = new JSONArray();
                for (Object object3 : (Object[])object2) {
                    ((JSONArray)object).put(object3);
                }
            } else {
                object = object2;
            }
            try {
                jSONObject.put(entry.getKey(), object);
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
        return jSONObject;
    }

    private EMConferenceMember memberContains(String string) {
        for (EMConferenceMember eMConferenceMember : this.memberList) {
            if (!eMConferenceMember.memberName.equals(string)) continue;
            return eMConferenceMember;
        }
        return null;
    }

    private int errorMap(int n) {
        int n2 = 0;
        switch (n) {
            case 0: {
                n2 = 0;
                break;
            }
            case -1: {
                n2 = 1;
                break;
            }
            case -102: {
                n2 = 818;
                break;
            }
            case -106: {
                n2 = 805;
                break;
            }
            case -108: {
                n2 = 2;
                break;
            }
            case -109: {
                n2 = 803;
                break;
            }
            case -112: {
                n2 = 819;
                break;
            }
            case -113: {
                n2 = 820;
                break;
            }
            case -122: {
                n2 = 806;
                break;
            }
            case -123: {
                n2 = 807;
                break;
            }
            case -124: {
                n2 = 808;
                break;
            }
            case -142: {
                n2 = 809;
                break;
            }
            case -143: {
                n2 = 810;
                break;
            }
            case -144: {
                n2 = 811;
                break;
            }
            case -145: {
                n2 = 812;
                break;
            }
            case -404: {
                n2 = 803;
                break;
            }
            case -410: {
                n2 = 821;
                break;
            }
            case -411: {
                n2 = 822;
                break;
            }
            case -500: {
                n2 = 813;
                break;
            }
            case -502: {
                n2 = 814;
                break;
            }
            case -504: {
                n2 = 815;
                break;
            }
            case -506: 
            case -301: {
                n2 = 816;
                break;
            }
            case -522: {
                n2 = 4;
                break;
            }
            case -523: {
                n2 = 823;
                break;
            }
            default: {
                n2 = 1;
            }
        }
        return n2;
    }

    private EMConferenceListener.ConferenceState stateMap(int n) {
        EMConferenceListener.ConferenceState conferenceState;
        switch (n) {
            case 0: {
                conferenceState = EMConferenceListener.ConferenceState.STATE_NORMAL;
                break;
            }
            case 100: {
                conferenceState = EMConferenceListener.ConferenceState.STATE_STATISTICS;
                break;
            }
            case 120: {
                conferenceState = EMConferenceListener.ConferenceState.STATE_DISCONNECTION;
                break;
            }
            case 121: {
                conferenceState = EMConferenceListener.ConferenceState.STATE_RECONNECTION;
                break;
            }
            case 122: {
                conferenceState = EMConferenceListener.ConferenceState.STATE_POOR_QUALITY;
                break;
            }
            case 123: {
                conferenceState = EMConferenceListener.ConferenceState.STATE_PUBLISH_SETUP;
                break;
            }
            case 124: {
                conferenceState = EMConferenceListener.ConferenceState.STATE_SUBSCRIBE_SETUP;
                break;
            }
            case 125: {
                conferenceState = EMConferenceListener.ConferenceState.STATE_TAKE_CAMERA_PICTURE;
                break;
            }
            case 126: {
                conferenceState = EMConferenceListener.ConferenceState.STATE_CUSTOM_MSG;
                break;
            }
            case 129: {
                conferenceState = EMConferenceListener.ConferenceState.STATE_UPDATE_PUB;
                break;
            }
            case 131: {
                conferenceState = EMConferenceListener.ConferenceState.STATE_AUDIO_TALKERS;
                break;
            }
            case 181: {
                conferenceState = EMConferenceListener.ConferenceState.STATE_P2P_PEER_EXIT;
                break;
            }
            case 201: {
                conferenceState = EMConferenceListener.ConferenceState.STATE_OPEN_CAMERA_FAIL;
                break;
            }
            case 202: {
                conferenceState = EMConferenceListener.ConferenceState.STATE_OPEN_MIC_FAIL;
                break;
            }
            case 204: {
                conferenceState = EMConferenceListener.ConferenceState.STATE_NO_REMOTE_AUDIO;
                break;
            }
            case 205: {
                conferenceState = EMConferenceListener.ConferenceState.STATE_NO_REMOTE_VIDEO;
                break;
            }
            default: {
                conferenceState = EMConferenceListener.ConferenceState.STATE_NORMAL;
            }
        }
        return conferenceState;
    }

    private static void encodeYUV420SP(byte[] byArray, int[] nArray, int n, int n2) {
        int n3 = n * n2;
        int n4 = 0;
        int n5 = n3;
        int n6 = 0;
        for (int k = 0; k < n2; ++k) {
            for (int i2 = 0; i2 < n; ++i2) {
                int n7 = (nArray[n6] & 0xFF000000) >> 24;
                int n8 = (nArray[n6] & 0xFF0000) >> 16;
                int n9 = (nArray[n6] & 0xFF00) >> 8;
                int n10 = (nArray[n6] & 0xFF) >> 0;
                int n11 = (66 * n8 + 129 * n9 + 25 * n10 + 128 >> 8) + 16;
                int n12 = (-38 * n8 - 74 * n9 + 112 * n10 + 128 >> 8) + 128;
                int n13 = (112 * n8 - 94 * n9 - 18 * n10 + 128 >> 8) + 128;
                byArray[n4++] = (byte)(n11 < 0 ? 0 : (n11 > 255 ? 255 : n11));
                if (k % 2 == 0 && n6 % 2 == 0) {
                    byArray[n5++] = (byte)(n13 < 0 ? 0 : (n13 > 255 ? 255 : n13));
                    byArray[n5++] = (byte)(n12 < 0 ? 0 : (n12 > 255 ? 255 : n12));
                }
                ++n6;
            }
        }
    }

    public static interface IRemoteAudioDataListener {
        public void onRemoteAudioData(byte[] var1, int var2, int var3, int var4);
    }

    public static interface ILocalAudioDataListener {
        public void onLocalAudioData(byte[] var1, int var2, int var3, int var4);
    }

    public static enum EMConferenceType {
        SmallCommunication(10),
        LargeCommunication(11),
        LiveStream(12);

        public int code;

        private EMConferenceType(int n2) {
            this.code = n2;
        }

        static EMConferenceType from(int n) {
            switch (n) {
                case 10: {
                    return SmallCommunication;
                }
                case 11: {
                    return LargeCommunication;
                }
                case 12: {
                    return LiveStream;
                }
            }
            return SmallCommunication;
        }
    }

    public static enum EMConferenceRole {
        Admin(7),
        Talker(3),
        Audience(1),
        NoType(0);

        public int code;

        private EMConferenceRole(int n2) {
            this.code = n2;
        }

        static EMConferenceRole from(int n) {
            switch (n) {
                case 0: {
                    return NoType;
                }
                case 1: {
                    return Audience;
                }
                case 3: {
                    return Talker;
                }
                case 7: {
                    return Admin;
                }
            }
            return Admin;
        }
    }

    static class Role {
        private EMConferenceRole role = EMConferenceRole.Audience;
        private String roleToken;

        Role() {
        }

        public Role updateRole(EMConferenceRole eMConferenceRole) {
            this.role = eMConferenceRole;
            return this;
        }

        public Role updateToken(String string) {
            this.roleToken = string;
            return this;
        }

        public void update(EMConferenceRole eMConferenceRole, String string) {
            this.role = eMConferenceRole;
            this.roleToken = string;
        }

        public EMConferenceRole getRole() {
            return this.role;
        }

        public String getRoleToken() {
            return this.roleToken;
        }
    }
}

