/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.cloud;

import android.content.Context;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Pair;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.adapter.EMARHttpCallback;
import com.hyphenate.cloud.EMHttpClient;
import com.hyphenate.cloud.HttpCallback;
import com.hyphenate.cloud.HttpClientConfig;
import com.hyphenate.cloud.HttpClientController;
import com.hyphenate.cloud.HttpResponse;
import com.hyphenate.exceptions.HyphenateException;
import com.hyphenate.util.EMLog;
import com.hyphenate.util.NetUtils;
import com.hyphenate.util.UriUtils;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.util.HashMap;
import java.util.Map;

public class HttpClientManager {
    private static final String TAG = "HttpClientManager";
    public static String Method_GET = "GET";
    public static String Method_POST = "POST";
    public static String Method_PUT = "PUT";
    public static String Method_DELETE = "DELETE";
    public static final int max_retries_times_on_connection_refused = 3;
    private static final int max_retry_times_on_connection_refused = 20;
    private static volatile long retrivedTokenTime = 0L;
    private static final int retriveInterval = 120000;
    private static int HIGH_SPEED_DOWNLOAD_BUF_SIZE = 30720;
    private static final int REQUEST_FAILED_CODE = 408;
    private static volatile boolean isRetring = false;

    public static Pair<Integer, String> sendGetRequest(String string, Map<String, String> map) throws HyphenateException {
        return HttpClientManager.sendRequestWithToken(string, null, map, Method_GET);
    }

    public static Pair<Integer, String> sendPostRequest(String string, String string2, Map<String, String> map) throws HyphenateException {
        return HttpClientManager.sendRequestWithToken(string, string2, map, Method_POST);
    }

    public static Pair<Integer, String> sendPutRequest(String string, String string2, Map<String, String> map) throws HyphenateException {
        return HttpClientManager.sendRequestWithToken(string, string2, map, Method_PUT);
    }

    public static int uploadFile(String string, String string2, String string3, Map<String, String> map, StringBuilder stringBuilder, EMARHttpCallback eMARHttpCallback) {
        int n = new Builder(EMClient.getInstance().getContext()).uploadFile(string).setUrl(string2).setFilename(string3).setConnectTimeout(30000).setHeaders(map).setHeader("app", EMClient.getInstance().getOptions().getAppKey()).setHeader("id", EMClient.getInstance().getCurrentUser()).execute(stringBuilder, eMARHttpCallback);
        EMLog.d(TAG, "upload code = " + n);
        return n;
    }

    public static int downloadFile(String string, String string2, Map<String, String> map, EMARHttpCallback eMARHttpCallback) {
        return new Builder(EMClient.getInstance().getContext()).downloadFile(string2).setConnectTimeout(30000).setUrl(string).setHeaders(map).execute(null, eMARHttpCallback);
    }

    public static Pair<Integer, String> sendDeleteRequest(String string, Map<String, String> map) throws HyphenateException {
        return HttpClientManager.sendRequestWithToken(string, null, map, Method_DELETE);
    }

    public static Pair<Integer, String> sendRequestWithToken(String string, String string2, String string3) throws HyphenateException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Authorization", "Bearer " + EMClient.getInstance().getOptions().getAccessToken());
        try {
            return HttpClientManager.sendHttpRequestWithRetryToken(string, hashMap, string2, string3);
        }
        catch (IOException iOException) {
            String string4 = " send request : " + string + " failed!";
            if (iOException != null && iOException.toString() != null) {
                string4 = iOException.toString();
            }
            EMLog.d(TAG, string4);
            throw new HyphenateException(1, string4);
        }
    }

    static Pair<Integer, String> sendRequestWithToken(String string, String string2, Map<String, String> map, String string3) throws HyphenateException {
        if (map == null) {
            map = new HashMap<String, String>();
        }
        if (TextUtils.isEmpty((CharSequence)map.get("Authorization"))) {
            map.put("Authorization", "Bearer " + EMClient.getInstance().getOptions().getAccessToken());
        }
        try {
            return HttpClientManager.sendHttpRequestWithRetryToken(string, map, string2, string3);
        }
        catch (IOException iOException) {
            String string4 = " send request : " + string + " failed!";
            if (iOException != null && iOException.toString() != null) {
                string4 = iOException.toString();
            }
            EMLog.d(TAG, string4);
            throw new HyphenateException(1, string4);
        }
    }

    static Pair<Integer, String> sendHttpRequestWithRetryToken(String string, Map<String, String> map, String string2, String string3) throws HyphenateException, IOException {
        return HttpClientManager.sendRequest(string, map, string2, string3);
    }

    public static Pair<Integer, String> sendRequest(String string, Map<String, String> map, String string2, String string3) throws IOException, HyphenateException {
        Pair pair = null;
        String string4 = string;
        for (int k = 0; k < 3; ++k) {
            EMLog.d(TAG, "try send request, request url: " + string4 + " with number: " + k);
            HttpResponse httpResponse = new Builder(EMClient.getInstance().getContext()).setRequestMethod(string3).setUrl(string4).setHeaders(map).setParams(string2).execute();
            if (httpResponse == null) continue;
            pair = new Pair((Object)httpResponse.code, (Object)httpResponse.content);
        }
        return pair;
    }

    public static HttpResponse httpExecute(String string, Map<String, String> map, String string2, String string3, int n) throws IOException {
        return new Builder(EMClient.getInstance().getContext()).setRequestMethod(string3).setUrl(string).setConnectTimeout(n).setHeaders(map).withToken(false).setParams(string2).execute();
    }

    public static HttpResponse httpExecute(String string, Map<String, String> map, String string2, String string3) throws IOException {
        int n = HttpClientConfig.getTimeout(map);
        return HttpClientManager.httpExecute(string, map, string2, string3, n);
    }

    static String getNewHost(String string, String string2) {
        return HttpClientConfig.getNewHost(string, string2);
    }

    private static long onDownloadCompleted(HttpResponse httpResponse, String string, HttpCallback httpCallback) throws IOException, IllegalStateException {
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        int n = 0;
        int n2 = 0;
        long l = httpResponse.contentLength;
        inputStream = httpResponse.inputStream;
        int n3 = inputStream.available();
        EMLog.d(TAG, "inputStream length = " + n3);
        File file = new File(string);
        try {
            fileOutputStream = new FileOutputStream(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            inputStream.close();
            throw iOException;
        }
        int n4 = HIGH_SPEED_DOWNLOAD_BUF_SIZE;
        byte[] byArray = new byte[n4];
        long l2 = 0L;
        try {
            while ((n = inputStream.read(byArray)) != -1) {
                int n5 = (int)((l2 += (long)n) * 100L / l);
                EMLog.d(TAG, n5 + "");
                if (n5 == 100 || n5 > n2 + 5) {
                    n2 = n5;
                    if (httpCallback != null) {
                        httpCallback.onProgress(l, l2);
                    }
                }
                fileOutputStream.write(byArray, 0, n);
            }
            long l3 = file.length();
            return l3;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw iOException;
        }
        finally {
            fileOutputStream.close();
            inputStream.close();
        }
    }

    private static long onDownloadCompleted(HttpResponse httpResponse, Uri uri, HttpCallback httpCallback) throws IOException, IllegalStateException {
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        int n = 0;
        int n2 = 0;
        long l = httpResponse.contentLength;
        inputStream = httpResponse.inputStream;
        ParcelFileDescriptor parcelFileDescriptor = null;
        try {
            parcelFileDescriptor = EMClient.getInstance().getContext().getContentResolver().openFileDescriptor(uri, "w");
            fileOutputStream = new FileOutputStream(parcelFileDescriptor.getFileDescriptor());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            inputStream.close();
            throw exception;
        }
        int n3 = HIGH_SPEED_DOWNLOAD_BUF_SIZE;
        byte[] byArray = new byte[n3];
        long l2 = 0L;
        try {
            int n4;
            while ((n = inputStream.read(byArray)) != -1) {
                n4 = (int)((l2 += (long)n) * 100L / l);
                EMLog.d(TAG, n4 + "");
                if (n4 == 100 || n4 > n2 + 5) {
                    n2 = n4;
                    if (httpCallback != null) {
                        httpCallback.onProgress(l, l2);
                    }
                }
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
                EMLog.d(TAG, "\u6267\u884c\u5199\u5165\u64cd\u4f5c count = " + n);
            }
            n4 = UriUtils.isFileExistByUri(EMClient.getInstance().getContext(), uri);
            EMLog.d(TAG, "download by uri fileExistByUri = " + (n4 != 0));
            long l3 = inputStream.available();
            return l3;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw iOException;
        }
        finally {
            if (fileOutputStream != null) {
                ((OutputStream)fileOutputStream).close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public static class Builder {
        private final HttpClientController.HttpParams p;

        public Builder() {
            this(EMClient.getInstance().getContext());
        }

        public Builder(Context context) {
            this.p = new HttpClientController.HttpParams(context);
        }

        public Builder get() {
            this.p.mRequestMethod = "GET";
            return this;
        }

        public Builder post() {
            this.p.mRequestMethod = "POST";
            return this;
        }

        public Builder put() {
            this.p.mRequestMethod = "PUT";
            return this;
        }

        public Builder delete() {
            this.p.mRequestMethod = "DELETE";
            return this;
        }

        public Builder uploadFile(String string) {
            this.p.mRequestMethod = "POST";
            this.p.mLocalFileUri = string;
            this.p.isUploadFile = true;
            return this;
        }

        public Builder uploadFile(String string, String string2, String string3) {
            this.p.mRequestMethod = "POST";
            this.p.mLocalFileUri = string;
            this.p.mFilename = string2;
            this.p.mFileKey = string3;
            this.p.isUploadFile = true;
            return this;
        }

        public Builder downloadFile(String string) {
            this.p.mRequestMethod = "GET";
            this.p.mDownloadPath = string;
            this.p.isDownloadFile = true;
            return this;
        }

        public Builder setRequestMethod(@NonNull String string) {
            this.p.mRequestMethod = string;
            return this;
        }

        public Builder setUrl(@NonNull String string) {
            this.p.mUrl = string;
            return this;
        }

        public Builder setUrl(@NonNull String string, int n) {
            this.p.mUrl = string;
            this.p.mPort = n;
            return this;
        }

        public Builder setConnectTimeout(int n) {
            this.p.mConnectTimeout = n;
            return this;
        }

        public Builder setReadTimeout(int n) {
            this.p.mReadTimeout = n;
            return this;
        }

        public Builder setHeader(String string, String string2) {
            this.p.mHeaders.put(string, string2);
            return this;
        }

        public Builder setHeaders(Map<String, String> map) {
            this.p.mHeaders.putAll(map);
            return this;
        }

        public Builder setParam(String string, String string2) {
            this.p.mParams.put(string, string2);
            return this;
        }

        public Builder setParams(Map<String, String> map) {
            this.p.mParams.putAll(map);
            return this;
        }

        public Builder setParams(String string) {
            this.p.mParamsString = string;
            return this;
        }

        public Builder isCanRetry(boolean bl) {
            this.p.canRetry = bl;
            return this;
        }

        public Builder setRetryTimes(int n) {
            this.p.canRetry = true;
            this.p.mRetryTimes = n;
            return this;
        }

        public Builder setLocalFilePath(String string) {
            this.p.mLocalFileUri = string;
            return this;
        }

        public Builder setFilename(String string) {
            this.p.mFilename = string;
            return this;
        }

        public Builder setFileKey(String string) {
            this.p.mFileKey = string;
            return this;
        }

        public Builder setDownloadPath(String string) {
            this.p.mDownloadPath = string;
            return this;
        }

        public Builder checkAndProcessSSL(boolean bl) {
            this.p.isCheckSSL = bl;
            return this;
        }

        public Builder withToken(boolean bl) {
            this.p.isNotUseToken = !bl;
            return this;
        }

        public Builder followRedirect(boolean bl) {
            this.p.followRedirect = bl;
            return this;
        }

        public HttpClientController build() throws IOException {
            HttpClientController httpClientController = new HttpClientController(this.p.mContext);
            this.p.apply(httpClientController);
            return httpClientController;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private HttpResponse executePrivate(HttpCallback httpCallback) throws IOException {
            HttpResponse httpResponse = null;
            HttpClientController httpClientController = null;
            try {
                Object object;
                boolean bl;
                block24: {
                    httpClientController = this.build();
                    HttpURLConnection httpURLConnection = httpClientController.h();
                    bl = false;
                    if (httpURLConnection.getDoOutput()) {
                        object = new DataOutputStream(httpURLConnection.getOutputStream());
                        httpClientController.a(this.p.mParamsString, (OutputStream)object);
                        httpClientController.a(this.p.mParams, (OutputStream)object);
                        try {
                            this.p.addFile(httpClientController, (OutputStream)object, httpCallback);
                        }
                        catch (IOException iOException) {
                            if (!TextUtils.isEmpty((CharSequence)iOException.getMessage()) && iOException.getMessage().contains("Connection reset")) {
                                bl = true;
                                break block24;
                            }
                            throw iOException;
                        }
                        finally {
                            if (object != null) {
                                ((FilterOutputStream)object).close();
                            }
                        }
                    }
                }
                httpResponse = this.p.getResponse(httpClientController);
                EMLog.d(HttpClientManager.TAG, httpResponse.toString());
                if (bl && httpResponse.code != 413) {
                    object = "Connection reset but not 413";
                    if (httpCallback != null) {
                        httpCallback.onError(httpResponse.code, (String)object);
                    }
                    httpResponse.content = object;
                }
                if (httpResponse.code == 200) {
                    if (httpCallback != null) {
                        httpCallback.onSuccess(httpResponse.content);
                    }
                    if (this.p.isDownloadFile) {
                        return this.download(httpResponse, httpCallback);
                    }
                } else if (httpResponse.code == 401) {
                    String string;
                    EMLog.e(HttpClientManager.TAG, "error: token \u5931\u6548");
                    long l = EMHttpClient.getInstance().chatConfig().o();
                    if (System.currentTimeMillis() - l <= 600000L) {
                        string = EMClient.getInstance().getAccessToken();
                        if (TextUtils.isEmpty((CharSequence)string)) {
                            string = EMClient.getInstance().getOptions().getAccessToken(true);
                        }
                    } else {
                        string = EMClient.getInstance().getOptions().getAccessToken(true);
                    }
                    if (!this.p.isNotUseToken && !this.p.isTokenExceeded) {
                        this.p.isTokenExceeded = true;
                        this.p.mHeaders.put("Authorization", "Bearer " + string);
                        EMLog.d(HttpClientManager.TAG, "\u91cd\u8bd5\u4e2d\u3002\u3002\u3002");
                        return this.executePrivate(httpCallback);
                    }
                } else if (httpCallback != null) {
                    httpCallback.onError(httpResponse.code, httpResponse.content);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                EMLog.e(HttpClientManager.TAG, "error message = " + iOException.getMessage());
                throw iOException;
            }
            catch (IllegalStateException illegalStateException) {
                illegalStateException.printStackTrace();
                EMLog.e(HttpClientManager.TAG, "error message = " + illegalStateException.getMessage());
                throw illegalStateException;
            }
            return httpResponse;
        }

        public int execute(StringBuilder stringBuilder, final EMARHttpCallback eMARHttpCallback) {
            int n = 408;
            HttpResponse httpResponse = null;
            try {
                httpResponse = this.executePrivate(new HttpCallback(){

                    @Override
                    public void onSuccess(String string) {
                    }

                    @Override
                    public void onError(int n, String string) {
                    }

                    @Override
                    public void onProgress(long l, long l2) {
                        if (eMARHttpCallback != null) {
                            eMARHttpCallback.onProgress(l, l2);
                        }
                    }
                });
                n = httpResponse.code;
                try {
                    if (stringBuilder != null) {
                        stringBuilder.append(httpResponse.content);
                    }
                }
                catch (Exception exception) {
                    EMLog.e(HttpClientManager.TAG, "json parse exception remotefilepath:" + this.p.mUrl);
                }
                return n;
            }
            catch (IOException iOException) {
                String string = iOException != null && iOException.getMessage() != null ? iOException.getMessage() : "failed to upload the files";
                EMLog.e(HttpClientManager.TAG, "error asyncExecute:" + string);
                if (string.toLowerCase().contains("refused") && NetUtils.hasNetwork(this.p.mContext) && this.p.canRetry && this.p.mRetryTimes > 0) {
                    String string2 = EMHttpClient.getInstance().chatConfig().m();
                    this.p.mUrl = HttpClientManager.getNewHost(this.p.mUrl, string2);
                    --this.p.mRetryTimes;
                    EMLog.d(HttpClientManager.TAG, "\u91cd\u8bd5\u4e2d\u3002\u3002\u3002");
                    return this.execute(stringBuilder, eMARHttpCallback);
                }
                try {
                    if (stringBuilder != null) {
                        stringBuilder.append(string);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (httpResponse != null) {
                    return httpResponse.code;
                }
                EMLog.e(HttpClientManager.TAG, iOException.getMessage());
                return n;
            }
        }

        public HttpResponse execute() {
            return this.execute(null);
        }

        public HttpResponse execute(HttpCallback httpCallback) {
            if (this.p.isUploadFile || this.p.isDownloadFile) {
                return this.executeFile(httpCallback);
            }
            return this.executeNormal(httpCallback);
        }

        public void asyncExecute(HttpCallback httpCallback) {
            if (this.p.isUploadFile || this.p.isDownloadFile) {
                this.asyncExecuteFile(httpCallback);
            } else {
                this.asyncExecuteNormal(httpCallback);
            }
        }

        private void asyncExecuteNormal(final HttpCallback httpCallback) {
            new Thread(){

                @Override
                public void run() {
                    this.executeNormal(httpCallback);
                }
            }.start();
        }

        private HttpResponse executeNormal(HttpCallback httpCallback) {
            HttpResponse httpResponse = null;
            try {
                httpResponse = this.executePrivate(httpCallback);
                if (httpResponse.code != 200 && this.p.canRetry && this.p.mRetryTimes > 0) {
                    --this.p.mRetryTimes;
                    return this.executeNormal(httpCallback);
                }
                return httpResponse;
            }
            catch (IOException iOException) {
                String string = iOException != null && iOException.getMessage() != null ? iOException.getMessage() : "failed to request";
                EMLog.e(HttpClientManager.TAG, "error execute:" + string);
                if (this.p.canRetry && this.p.mRetryTimes > 0) {
                    --this.p.mRetryTimes;
                    return this.executeNormal(httpCallback);
                }
                if (httpResponse == null) {
                    httpResponse = new HttpResponse();
                }
                if (httpResponse.code == 0) {
                    httpResponse.code = 408;
                }
                httpResponse.content = string;
                if (httpCallback != null) {
                    httpCallback.onError(httpResponse.code, string);
                }
                return httpResponse;
            }
        }

        private HttpResponse executeFile(HttpCallback httpCallback) {
            HttpResponse httpResponse = null;
            try {
                httpResponse = this.executePrivate(httpCallback);
                int n = httpResponse.code;
                String string = "";
                switch (n) {
                    case 401: {
                        long l = EMHttpClient.getInstance().chatConfig().o();
                        if (System.currentTimeMillis() - l <= 600000L) {
                            string = "unauthorized file";
                            if (httpCallback != null) {
                                httpCallback.onError(n, string);
                            }
                            httpResponse.content = string;
                            return httpResponse;
                        }
                        if (this.p.canRetry && this.p.mRetryTimes > 0) {
                            String string2 = EMHttpClient.getInstance().chatConfig().m();
                            this.p.mUrl = HttpClientManager.getNewHost(this.p.mUrl, string2);
                            --this.p.mRetryTimes;
                            return this.executeFile(httpCallback);
                        }
                        return httpResponse;
                    }
                }
                return httpResponse;
            }
            catch (IOException iOException) {
                String string = iOException != null && iOException.getMessage() != null ? iOException.getMessage() : (this.p.isUploadFile ? "failed to upload the file" : "failed to download file");
                EMLog.e(HttpClientManager.TAG, "error execute:" + string);
                if (string.toLowerCase().contains("refused") && NetUtils.hasNetwork(this.p.mContext)) {
                    if (!this.p.isDefaultRetry) {
                        this.p.isDefaultRetry = true;
                        this.p.mRetryTimes = 20;
                        this.p.canRetry = true;
                        String string3 = EMHttpClient.getInstance().chatConfig().m();
                        this.p.mUrl = HttpClientManager.getNewHost(this.p.mUrl, string3);
                        return this.executeFile(httpCallback);
                    }
                    if (this.p.canRetry && this.p.mRetryTimes > 0) {
                        String string4 = EMHttpClient.getInstance().chatConfig().m();
                        this.p.mUrl = HttpClientManager.getNewHost(this.p.mUrl, string4);
                        --this.p.mRetryTimes;
                        return this.executeFile(httpCallback);
                    }
                }
                if (httpResponse == null) {
                    httpResponse = new HttpResponse();
                }
                if (httpResponse.code == 0) {
                    httpResponse.code = 408;
                }
                httpResponse.content = string;
                if (httpCallback != null) {
                    httpCallback.onError(httpResponse.code, httpResponse.content);
                }
                return httpResponse;
            }
        }

        private void asyncExecuteFile(final HttpCallback httpCallback) {
            new Thread(){

                @Override
                public void run() {
                    this.executeFile(httpCallback);
                }
            }.start();
        }

        private HttpResponse download(HttpResponse httpResponse, HttpCallback httpCallback) throws IOException, IllegalStateException {
            File file;
            String string = UriUtils.getFilePath(this.p.mDownloadPath);
            if (!TextUtils.isEmpty((CharSequence)string) && !(file = new File(string)).getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            long l = 0L;
            String string2 = "";
            l = this.p.mDownloadPath.startsWith("content") ? HttpClientManager.onDownloadCompleted(httpResponse, UriUtils.getLocalUriFromString(this.p.mLocalFileUri), httpCallback) : HttpClientManager.onDownloadCompleted(httpResponse, string, httpCallback);
            if (l <= 0L) {
                string2 = "downloaded content size is zero!";
                if (httpCallback != null) {
                    httpCallback.onError(408, string2);
                }
                httpResponse.code = 408;
                httpResponse.content = string2;
                return httpResponse;
            }
            string2 = "download successfully";
            if (httpCallback != null) {
                EMLog.e(HttpClientManager.TAG, "download successfully");
                httpCallback.onSuccess(string2);
            }
            return httpResponse;
        }
    }
}

