/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc;

import com.superrtc.AudioTrack;
import com.superrtc.CalledByNative;
import com.superrtc.JniCommon;
import com.superrtc.VideoTrack;
import javax.annotation.Nullable;

public class MediaStreamTrack {
    public static final String AUDIO_TRACK_KIND = "audio";
    public static final String VIDEO_TRACK_KIND = "video";
    private long nativeTrack;

    @Nullable
    static MediaStreamTrack createMediaStreamTrack(long l) {
        if (l == 0L) {
            return null;
        }
        String string = MediaStreamTrack.nativeGetKind(l);
        if (string.equals(AUDIO_TRACK_KIND)) {
            return new AudioTrack(l);
        }
        if (string.equals(VIDEO_TRACK_KIND)) {
            return new VideoTrack(l);
        }
        return null;
    }

    public MediaStreamTrack(long l) {
        if (l == 0L) {
            throw new IllegalArgumentException("nativeTrack may not be null");
        }
        this.nativeTrack = l;
    }

    public String id() {
        this.checkMediaStreamTrackExists();
        return MediaStreamTrack.nativeGetId(this.nativeTrack);
    }

    public String kind() {
        this.checkMediaStreamTrackExists();
        return MediaStreamTrack.nativeGetKind(this.nativeTrack);
    }

    public boolean enabled() {
        this.checkMediaStreamTrackExists();
        return MediaStreamTrack.nativeGetEnabled(this.nativeTrack);
    }

    public boolean setEnabled(boolean bl) {
        this.checkMediaStreamTrackExists();
        return MediaStreamTrack.nativeSetEnabled(this.nativeTrack, bl);
    }

    public State state() {
        this.checkMediaStreamTrackExists();
        return MediaStreamTrack.nativeGetState(this.nativeTrack);
    }

    public void dispose() {
        this.checkMediaStreamTrackExists();
        JniCommon.nativeReleaseRef(this.nativeTrack);
        this.nativeTrack = 0L;
    }

    long getNativeMediaStreamTrack() {
        this.checkMediaStreamTrackExists();
        return this.nativeTrack;
    }

    private void checkMediaStreamTrackExists() {
        if (this.nativeTrack == 0L) {
            throw new IllegalStateException("MediaStreamTrack has been disposed.");
        }
    }

    private static native String nativeGetId(long var0);

    private static native String nativeGetKind(long var0);

    private static native boolean nativeGetEnabled(long var0);

    private static native boolean nativeSetEnabled(long var0, boolean var2);

    private static native State nativeGetState(long var0);

    public static enum MediaType {
        MEDIA_TYPE_AUDIO(0),
        MEDIA_TYPE_VIDEO(1);

        private final int nativeIndex;

        private MediaType(int n2) {
            this.nativeIndex = n2;
        }

        @CalledByNative(value="MediaType")
        int getNative() {
            return this.nativeIndex;
        }

        @CalledByNative(value="MediaType")
        static MediaType fromNativeIndex(int n) {
            for (MediaType mediaType : MediaType.values()) {
                if (mediaType.getNative() != n) continue;
                return mediaType;
            }
            throw new IllegalArgumentException("Unknown native media type: " + n);
        }
    }

    public static enum State {
        LIVE,
        ENDED;


        @CalledByNative(value="State")
        static State fromNativeIndex(int n) {
            return State.values()[n];
        }
    }
}

