/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc;

import android.content.Context;
import android.os.Build;
import com.superrtc.CalledByNative;
import com.superrtc.ContextUtils;
import com.superrtc.Logging;
import com.superrtc.NetworkMonitorAutoDetect;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;

public class NetworkMonitor {
    private static final String TAG = "NetworkMonitor";
    private final ArrayList<Long> nativeNetworkObservers;
    private final ArrayList<NetworkObserver> networkObservers;
    private final Object autoDetectLock = new Object();
    @Nullable
    private NetworkMonitorAutoDetect autoDetect;
    private int numObservers = 0;
    private volatile NetworkMonitorAutoDetect.ConnectionType currentConnectionType;

    private NetworkMonitor() {
        this.nativeNetworkObservers = new ArrayList();
        this.networkObservers = new ArrayList();
        this.currentConnectionType = NetworkMonitorAutoDetect.ConnectionType.CONNECTION_UNKNOWN;
    }

    @Deprecated
    public static void init(Context context) {
    }

    @CalledByNative
    public static NetworkMonitor getInstance() {
        return InstanceHolder.instance;
    }

    private static void assertIsTrue(boolean bl) {
        if (!bl) {
            throw new AssertionError((Object)"Expected to be true");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startMonitoring(Context context) {
        Object object = this.autoDetectLock;
        synchronized (object) {
            ++this.numObservers;
            if (this.autoDetect == null) {
                this.autoDetect = this.createAutoDetect(context);
            }
            this.currentConnectionType = NetworkMonitorAutoDetect.getConnectionType(this.autoDetect.getCurrentNetworkState());
        }
    }

    @Deprecated
    public void startMonitoring() {
        this.startMonitoring(ContextUtils.getApplicationContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    private void startMonitoring(@Nullable Context context, long l) {
        Logging.d(TAG, "Start monitoring with native observer " + l);
        this.startMonitoring(context != null ? context : ContextUtils.getApplicationContext());
        ArrayList<Long> arrayList = this.nativeNetworkObservers;
        synchronized (arrayList) {
            this.nativeNetworkObservers.add(l);
        }
        this.updateObserverActiveNetworkList(l);
        this.notifyObserversOfConnectionTypeChange(this.currentConnectionType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopMonitoring() {
        Object object = this.autoDetectLock;
        synchronized (object) {
            if (--this.numObservers == 0) {
                this.autoDetect.destroy();
                this.autoDetect = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    private void stopMonitoring(long l) {
        Logging.d(TAG, "Stop monitoring with native observer " + l);
        this.stopMonitoring();
        ArrayList<Long> arrayList = this.nativeNetworkObservers;
        synchronized (arrayList) {
            this.nativeNetworkObservers.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    private boolean networkBindingSupported() {
        Object object = this.autoDetectLock;
        synchronized (object) {
            return this.autoDetect != null && this.autoDetect.supportNetworkCallback();
        }
    }

    @CalledByNative
    private static int androidSdkInt() {
        return Build.VERSION.SDK_INT;
    }

    private NetworkMonitorAutoDetect.ConnectionType getCurrentConnectionType() {
        return this.currentConnectionType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getCurrentDefaultNetId() {
        Object object = this.autoDetectLock;
        synchronized (object) {
            return this.autoDetect == null ? -1L : this.autoDetect.getDefaultNetId();
        }
    }

    private NetworkMonitorAutoDetect createAutoDetect(Context context) {
        return new NetworkMonitorAutoDetect(new NetworkMonitorAutoDetect.Observer(){

            @Override
            public void onConnectionTypeChanged(NetworkMonitorAutoDetect.ConnectionType connectionType) {
                NetworkMonitor.this.updateCurrentConnectionType(connectionType);
            }

            @Override
            public void onNetworkConnect(NetworkMonitorAutoDetect.NetworkInformation networkInformation) {
                NetworkMonitor.this.notifyObserversOfNetworkConnect(networkInformation);
            }

            @Override
            public void onNetworkDisconnect(long l) {
                NetworkMonitor.this.notifyObserversOfNetworkDisconnect(l);
            }
        }, context);
    }

    private void updateCurrentConnectionType(NetworkMonitorAutoDetect.ConnectionType connectionType) {
        this.currentConnectionType = connectionType;
        this.notifyObserversOfConnectionTypeChange(connectionType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyObserversOfConnectionTypeChange(NetworkMonitorAutoDetect.ConnectionType connectionType) {
        ArrayList<NetworkObserver> arrayList;
        List<Long> list = this.getNativeNetworkObserversSync();
        for (Long object2 : list) {
            this.nativeNotifyConnectionTypeChanged(object2);
        }
        ArrayList<NetworkObserver> arrayList2 = this.networkObservers;
        synchronized (arrayList2) {
            arrayList = new ArrayList<NetworkObserver>(this.networkObservers);
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            NetworkObserver networkObserver = (NetworkObserver)iterator.next();
            networkObserver.onConnectionTypeChanged(connectionType);
        }
    }

    private void notifyObserversOfNetworkConnect(NetworkMonitorAutoDetect.NetworkInformation networkInformation) {
        List<Long> list = this.getNativeNetworkObserversSync();
        for (Long l : list) {
            this.nativeNotifyOfNetworkConnect(l, networkInformation);
        }
    }

    private void notifyObserversOfNetworkDisconnect(long l) {
        List<Long> list = this.getNativeNetworkObserversSync();
        for (Long l2 : list) {
            this.nativeNotifyOfNetworkDisconnect(l2, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateObserverActiveNetworkList(long l) {
        NetworkMonitorAutoDetect.NetworkInformation[] networkInformationArray = this.autoDetectLock;
        synchronized (this.autoDetectLock) {
            List<NetworkMonitorAutoDetect.NetworkInformation> list = this.autoDetect == null ? null : this.autoDetect.getActiveNetworkList();
            // ** MonitorExit[var4_2] (shouldn't be in output)
            if (list == null || list.size() == 0) {
                return;
            }
            networkInformationArray = new NetworkMonitorAutoDetect.NetworkInformation[list.size()];
            networkInformationArray = list.toArray(networkInformationArray);
            this.nativeNotifyOfActiveNetworkList(l, networkInformationArray);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Long> getNativeNetworkObserversSync() {
        ArrayList<Long> arrayList = this.nativeNetworkObservers;
        synchronized (arrayList) {
            return new ArrayList<Long>(this.nativeNetworkObservers);
        }
    }

    @Deprecated
    public static void addNetworkObserver(NetworkObserver networkObserver) {
        NetworkMonitor.getInstance().addObserver(networkObserver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObserver(NetworkObserver networkObserver) {
        ArrayList<NetworkObserver> arrayList = this.networkObservers;
        synchronized (arrayList) {
            this.networkObservers.add(networkObserver);
        }
    }

    @Deprecated
    public static void removeNetworkObserver(NetworkObserver networkObserver) {
        NetworkMonitor.getInstance().removeObserver(networkObserver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObserver(NetworkObserver networkObserver) {
        ArrayList<NetworkObserver> arrayList = this.networkObservers;
        synchronized (arrayList) {
            this.networkObservers.remove(networkObserver);
        }
    }

    public static boolean isOnline() {
        NetworkMonitorAutoDetect.ConnectionType connectionType = NetworkMonitor.getInstance().getCurrentConnectionType();
        return connectionType != NetworkMonitorAutoDetect.ConnectionType.CONNECTION_NONE;
    }

    private native void nativeNotifyConnectionTypeChanged(long var1);

    private native void nativeNotifyOfNetworkConnect(long var1, NetworkMonitorAutoDetect.NetworkInformation var3);

    private native void nativeNotifyOfNetworkDisconnect(long var1, long var3);

    private native void nativeNotifyOfActiveNetworkList(long var1, NetworkMonitorAutoDetect.NetworkInformation[] var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    NetworkMonitorAutoDetect getNetworkMonitorAutoDetect() {
        Object object = this.autoDetectLock;
        synchronized (object) {
            return this.autoDetect;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumObservers() {
        Object object = this.autoDetectLock;
        synchronized (object) {
            return this.numObservers;
        }
    }

    static NetworkMonitorAutoDetect createAndSetAutoDetectForTest(Context context) {
        NetworkMonitorAutoDetect networkMonitorAutoDetect;
        NetworkMonitor networkMonitor = NetworkMonitor.getInstance();
        networkMonitor.autoDetect = networkMonitorAutoDetect = networkMonitor.createAutoDetect(context);
        return networkMonitor.autoDetect;
    }

    private static class InstanceHolder {
        static final NetworkMonitor instance = new NetworkMonitor();

        private InstanceHolder() {
        }
    }

    public static interface NetworkObserver {
        public void onConnectionTypeChanged(NetworkMonitorAutoDetect.ConnectionType var1);
    }
}

