/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.voiceengine;

import android.content.Context;
import android.media.AudioDeviceInfo;
import android.media.AudioManager;
import android.os.Build;
import com.superrtc.ContextUtils;
import com.superrtc.Logging;
import com.superrtc.voiceengine.WebRtcAudioEffects;
import java.util.Arrays;
import java.util.List;

public final class WebRtcAudioUtils {
    private static final String TAG = "WebRtcAudioUtils";
    private static final String[] BLACKLISTED_OPEN_SL_ES_MODELS = new String[0];
    private static final String[] BLACKLISTED_AEC_MODELS = new String[0];
    private static final String[] BLACKLISTED_NS_MODELS = new String[0];
    private static final int DEFAULT_SAMPLE_RATE_HZ = 16000;
    private static int defaultSampleRateHz = 16000;
    private static boolean isDefaultSampleRateOverridden;
    private static boolean useWebRtcBasedAcousticEchoCanceler;
    private static boolean useWebRtcBasedNoiseSuppressor;

    public static synchronized void setWebRtcBasedAcousticEchoCanceler(boolean bl) {
        useWebRtcBasedAcousticEchoCanceler = bl;
    }

    public static synchronized void setWebRtcBasedNoiseSuppressor(boolean bl) {
        useWebRtcBasedNoiseSuppressor = bl;
    }

    public static synchronized void setWebRtcBasedAutomaticGainControl(boolean bl) {
        Logging.w(TAG, "setWebRtcBasedAutomaticGainControl() is deprecated");
    }

    public static synchronized boolean useWebRtcBasedAcousticEchoCanceler() {
        if (useWebRtcBasedAcousticEchoCanceler) {
            Logging.w(TAG, "Overriding default behavior; now using WebRTC AEC!");
        }
        return useWebRtcBasedAcousticEchoCanceler;
    }

    public static synchronized boolean useWebRtcBasedNoiseSuppressor() {
        if (useWebRtcBasedNoiseSuppressor) {
            Logging.w(TAG, "Overriding default behavior; now using WebRTC NS!");
        }
        return useWebRtcBasedNoiseSuppressor;
    }

    public static synchronized boolean useWebRtcBasedAutomaticGainControl() {
        return true;
    }

    public static boolean isAcousticEchoCancelerSupported() {
        return WebRtcAudioEffects.canUseAcousticEchoCanceler();
    }

    public static boolean isNoiseSuppressorSupported() {
        return WebRtcAudioEffects.canUseNoiseSuppressor();
    }

    public static boolean isAutomaticGainControlSupported() {
        return false;
    }

    public static synchronized void setDefaultSampleRateHz(int n) {
        isDefaultSampleRateOverridden = true;
        defaultSampleRateHz = n;
    }

    public static synchronized boolean isDefaultSampleRateOverridden() {
        return isDefaultSampleRateOverridden;
    }

    public static synchronized int getDefaultSampleRateHz() {
        return defaultSampleRateHz;
    }

    public static List<String> getBlackListedModelsForAecUsage() {
        return Arrays.asList(BLACKLISTED_AEC_MODELS);
    }

    public static List<String> getBlackListedModelsForNsUsage() {
        return Arrays.asList(BLACKLISTED_NS_MODELS);
    }

    public static String getThreadInfo() {
        return "@[name=" + Thread.currentThread().getName() + ", id=" + Thread.currentThread().getId() + "]";
    }

    public static boolean runningOnEmulator() {
        return Build.HARDWARE.equals("goldfish") && Build.BRAND.startsWith("generic_");
    }

    public static boolean deviceIsBlacklistedForOpenSLESUsage() {
        List<String> list = Arrays.asList(BLACKLISTED_OPEN_SL_ES_MODELS);
        return list.contains(Build.MODEL);
    }

    static void logDeviceInfo(String string) {
        Logging.d(string, "Android SDK: " + Build.VERSION.SDK_INT + ", Release: " + Build.VERSION.RELEASE + ", Brand: " + Build.BRAND + ", Device: " + Build.DEVICE + ", Id: " + Build.ID + ", Hardware: " + Build.HARDWARE + ", Manufacturer: " + Build.MANUFACTURER + ", Model: " + Build.MODEL + ", Product: " + Build.PRODUCT);
    }

    static void logAudioState(String string) {
        WebRtcAudioUtils.logDeviceInfo(string);
        Context context = ContextUtils.getApplicationContext();
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        WebRtcAudioUtils.logAudioStateBasic(string, audioManager);
        WebRtcAudioUtils.logAudioStateVolume(string, audioManager);
        WebRtcAudioUtils.logAudioDeviceInfo(string, audioManager);
    }

    private static void logAudioStateBasic(String string, AudioManager audioManager) {
        Logging.d(string, "Audio State: audio mode: " + WebRtcAudioUtils.modeToString(audioManager.getMode()) + ", has mic: " + WebRtcAudioUtils.hasMicrophone() + ", mic muted: " + audioManager.isMicrophoneMute() + ", music active: " + audioManager.isMusicActive() + ", speakerphone: " + audioManager.isSpeakerphoneOn() + ", BT SCO: " + audioManager.isBluetoothScoOn());
    }

    private static boolean isVolumeFixed(AudioManager audioManager) {
        if (Build.VERSION.SDK_INT < 21) {
            return false;
        }
        return audioManager.isVolumeFixed();
    }

    private static void logAudioStateVolume(String string, AudioManager audioManager) {
        int[] nArray = new int[]{0, 3, 2, 4, 5, 1};
        Logging.d(string, "Audio State: ");
        boolean bl = WebRtcAudioUtils.isVolumeFixed(audioManager);
        Logging.d(string, "  fixed volume=" + bl);
        if (!bl) {
            for (int n : nArray) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("  " + WebRtcAudioUtils.streamTypeToString(n) + ": ");
                stringBuilder.append("volume=").append(audioManager.getStreamVolume(n));
                stringBuilder.append(", max=").append(audioManager.getStreamMaxVolume(n));
                WebRtcAudioUtils.logIsStreamMute(string, audioManager, n, stringBuilder);
                Logging.d(string, stringBuilder.toString());
            }
        }
    }

    private static void logIsStreamMute(String string, AudioManager audioManager, int n, StringBuilder stringBuilder) {
        if (Build.VERSION.SDK_INT >= 23) {
            stringBuilder.append(", muted=").append(audioManager.isStreamMute(n));
        }
    }

    private static void logAudioDeviceInfo(String string, AudioManager audioManager) {
        if (Build.VERSION.SDK_INT < 23) {
            return;
        }
        AudioDeviceInfo[] audioDeviceInfoArray = audioManager.getDevices(3);
        if (audioDeviceInfoArray.length == 0) {
            return;
        }
        Logging.d(string, "Audio Devices: ");
        for (AudioDeviceInfo audioDeviceInfo : audioDeviceInfoArray) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("  ").append(WebRtcAudioUtils.deviceTypeToString(audioDeviceInfo.getType()));
            stringBuilder.append(audioDeviceInfo.isSource() ? "(in): " : "(out): ");
            if (audioDeviceInfo.getChannelCounts().length > 0) {
                stringBuilder.append("channels=").append(Arrays.toString(audioDeviceInfo.getChannelCounts()));
                stringBuilder.append(", ");
            }
            if (audioDeviceInfo.getEncodings().length > 0) {
                stringBuilder.append("encodings=").append(Arrays.toString(audioDeviceInfo.getEncodings()));
                stringBuilder.append(", ");
            }
            if (audioDeviceInfo.getSampleRates().length > 0) {
                stringBuilder.append("sample rates=").append(Arrays.toString(audioDeviceInfo.getSampleRates()));
                stringBuilder.append(", ");
            }
            stringBuilder.append("id=").append(audioDeviceInfo.getId());
            Logging.d(string, stringBuilder.toString());
        }
    }

    static String modeToString(int n) {
        switch (n) {
            case 2: {
                return "MODE_IN_CALL";
            }
            case 3: {
                return "MODE_IN_COMMUNICATION";
            }
            case 0: {
                return "MODE_NORMAL";
            }
            case 1: {
                return "MODE_RINGTONE";
            }
        }
        return "MODE_INVALID";
    }

    private static String streamTypeToString(int n) {
        switch (n) {
            case 0: {
                return "STREAM_VOICE_CALL";
            }
            case 3: {
                return "STREAM_MUSIC";
            }
            case 2: {
                return "STREAM_RING";
            }
            case 4: {
                return "STREAM_ALARM";
            }
            case 5: {
                return "STREAM_NOTIFICATION";
            }
            case 1: {
                return "STREAM_SYSTEM";
            }
        }
        return "STREAM_INVALID";
    }

    private static String deviceTypeToString(int n) {
        switch (n) {
            case 0: {
                return "TYPE_UNKNOWN";
            }
            case 1: {
                return "TYPE_BUILTIN_EARPIECE";
            }
            case 2: {
                return "TYPE_BUILTIN_SPEAKER";
            }
            case 3: {
                return "TYPE_WIRED_HEADSET";
            }
            case 4: {
                return "TYPE_WIRED_HEADPHONES";
            }
            case 5: {
                return "TYPE_LINE_ANALOG";
            }
            case 6: {
                return "TYPE_LINE_DIGITAL";
            }
            case 7: {
                return "TYPE_BLUETOOTH_SCO";
            }
            case 8: {
                return "TYPE_BLUETOOTH_A2DP";
            }
            case 9: {
                return "TYPE_HDMI";
            }
            case 10: {
                return "TYPE_HDMI_ARC";
            }
            case 11: {
                return "TYPE_USB_DEVICE";
            }
            case 12: {
                return "TYPE_USB_ACCESSORY";
            }
            case 13: {
                return "TYPE_DOCK";
            }
            case 14: {
                return "TYPE_FM";
            }
            case 15: {
                return "TYPE_BUILTIN_MIC";
            }
            case 16: {
                return "TYPE_FM_TUNER";
            }
            case 17: {
                return "TYPE_TV_TUNER";
            }
            case 18: {
                return "TYPE_TELEPHONY";
            }
            case 19: {
                return "TYPE_AUX_LINE";
            }
            case 20: {
                return "TYPE_IP";
            }
            case 21: {
                return "TYPE_BUS";
            }
            case 22: {
                return "TYPE_USB_HEADSET";
            }
        }
        return "TYPE_UNKNOWN";
    }

    private static boolean hasMicrophone() {
        return ContextUtils.getApplicationContext().getPackageManager().hasSystemFeature("android.hardware.microphone");
    }
}

