/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadb;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.activemq.ActiveMQMessageAuditNoSync;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.BrokerServiceAware;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.Queue;
import org.apache.activemq.broker.region.Topic;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.protobuf.Buffer;
import org.apache.activemq.store.MessageStore;
import org.apache.activemq.store.MessageStoreStatistics;
import org.apache.activemq.store.MessageStoreSubscriptionStatistics;
import org.apache.activemq.store.PersistenceAdapterStatistics;
import org.apache.activemq.store.TopicMessageStore;
import org.apache.activemq.store.kahadb.JournalCommand;
import org.apache.activemq.store.kahadb.TransactionIdConversion;
import org.apache.activemq.store.kahadb.Visitor;
import org.apache.activemq.store.kahadb.data.KahaAckMessageFileMapCommand;
import org.apache.activemq.store.kahadb.data.KahaAddMessageCommand;
import org.apache.activemq.store.kahadb.data.KahaCommitCommand;
import org.apache.activemq.store.kahadb.data.KahaDestination;
import org.apache.activemq.store.kahadb.data.KahaEntryType;
import org.apache.activemq.store.kahadb.data.KahaPrepareCommand;
import org.apache.activemq.store.kahadb.data.KahaProducerAuditCommand;
import org.apache.activemq.store.kahadb.data.KahaRemoveDestinationCommand;
import org.apache.activemq.store.kahadb.data.KahaRemoveMessageCommand;
import org.apache.activemq.store.kahadb.data.KahaRewrittenDataFileCommand;
import org.apache.activemq.store.kahadb.data.KahaRollbackCommand;
import org.apache.activemq.store.kahadb.data.KahaSubscriptionCommand;
import org.apache.activemq.store.kahadb.data.KahaTraceCommand;
import org.apache.activemq.store.kahadb.data.KahaTransactionInfo;
import org.apache.activemq.store.kahadb.data.KahaUpdateMessageCommand;
import org.apache.activemq.store.kahadb.disk.index.BTreeIndex;
import org.apache.activemq.store.kahadb.disk.index.BTreeVisitor;
import org.apache.activemq.store.kahadb.disk.index.ListIndex;
import org.apache.activemq.store.kahadb.disk.journal.DataFile;
import org.apache.activemq.store.kahadb.disk.journal.Journal;
import org.apache.activemq.store.kahadb.disk.journal.Location;
import org.apache.activemq.store.kahadb.disk.journal.TargetedDataFileAppender;
import org.apache.activemq.store.kahadb.disk.page.Page;
import org.apache.activemq.store.kahadb.disk.page.PageFile;
import org.apache.activemq.store.kahadb.disk.page.Transaction;
import org.apache.activemq.store.kahadb.disk.util.LocationMarshaller;
import org.apache.activemq.store.kahadb.disk.util.LongMarshaller;
import org.apache.activemq.store.kahadb.disk.util.Marshaller;
import org.apache.activemq.store.kahadb.disk.util.Sequence;
import org.apache.activemq.store.kahadb.disk.util.SequenceSet;
import org.apache.activemq.store.kahadb.disk.util.StringMarshaller;
import org.apache.activemq.store.kahadb.disk.util.VariableMarshaller;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.util.DataByteArrayInputStream;
import org.apache.activemq.util.DataByteArrayOutputStream;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.util.IOHelper;
import org.apache.activemq.util.ServiceStopper;
import org.apache.activemq.util.ServiceSupport;
import org.apache.activemq.util.ThreadPoolUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public abstract class MessageDatabase
extends ServiceSupport
implements BrokerServiceAware {
    protected BrokerService brokerService;
    public static final String PROPERTY_LOG_SLOW_ACCESS_TIME = "org.apache.activemq.store.kahadb.LOG_SLOW_ACCESS_TIME";
    public static final int LOG_SLOW_ACCESS_TIME = Integer.getInteger("org.apache.activemq.store.kahadb.LOG_SLOW_ACCESS_TIME", 0);
    public static final File DEFAULT_DIRECTORY = new File("KahaDB");
    protected static final Buffer UNMATCHED = new Buffer(new byte[0]);
    private static final Logger LOG = LoggerFactory.getLogger(MessageDatabase.class);
    static final int CLOSED_STATE = 1;
    static final int OPEN_STATE = 2;
    static final long NOT_ACKED = -1L;
    static final int VERSION = 6;
    static final byte COMPACTED_JOURNAL_FILE = 1;
    protected PageFile pageFile;
    protected Journal journal;
    protected Metadata metadata = new Metadata();
    protected final PersistenceAdapterStatistics persistenceAdapterStatistics = new PersistenceAdapterStatistics();
    protected MetadataMarshaller metadataMarshaller = new MetadataMarshaller();
    protected boolean failIfDatabaseIsLocked;
    protected boolean deleteAllMessages;
    protected File directory = DEFAULT_DIRECTORY;
    protected File indexDirectory = null;
    protected ScheduledExecutorService scheduler;
    private final Object schedulerLock = new Object();
    protected Journal.JournalDiskSyncStrategy journalDiskSyncStrategy = Journal.JournalDiskSyncStrategy.ALWAYS;
    protected boolean archiveDataLogs;
    protected File directoryArchive;
    protected AtomicLong journalSize = new AtomicLong(0L);
    long journalDiskSyncInterval = 1000L;
    long checkpointInterval = 5000L;
    long cleanupInterval = 30000L;
    int journalMaxFileLength = 0x2000000;
    int journalMaxWriteBatchSize = 0x400000;
    boolean enableIndexWriteAsync = false;
    int setIndexWriteBatchSize = PageFile.DEFAULT_WRITE_BATCH_SIZE;
    private String preallocationScope = Journal.PreallocationScope.ENTIRE_JOURNAL.name();
    private String preallocationStrategy = Journal.PreallocationStrategy.SPARSE_FILE.name();
    protected AtomicBoolean opened = new AtomicBoolean();
    private boolean ignoreMissingJournalfiles = false;
    private int indexCacheSize = 10000;
    private boolean checkForCorruptJournalFiles = false;
    protected PurgeRecoveredXATransactionStrategy purgeRecoveredXATransactionStrategy = PurgeRecoveredXATransactionStrategy.NEVER;
    private boolean checksumJournalFiles = true;
    protected boolean forceRecoverIndex = false;
    private boolean archiveCorruptedIndex = false;
    private boolean useIndexLFRUEviction = false;
    private float indexLFUEvictionFactor = 0.2f;
    private boolean enableIndexDiskSyncs = true;
    private boolean enableIndexRecoveryFile = true;
    private boolean enableIndexPageCaching = true;
    ReentrantReadWriteLock checkpointLock = new ReentrantReadWriteLock();
    private boolean enableAckCompaction = true;
    private int compactAcksAfterNoGC = 10;
    private boolean compactAcksIgnoresStoreGrowth = false;
    private int checkPointCyclesWithNoGC;
    private int journalLogOnLastCompactionCheck;
    private boolean enableSubscriptionStatistics = false;
    protected final AtomicReference<Location> lastAsyncJournalUpdate = new AtomicReference();
    private Location nextRecoveryPosition;
    private Location lastRecoveryPosition;
    protected final ReentrantReadWriteLock indexLock = new ReentrantReadWriteLock();
    private final HashSet<Integer> journalFilesBeingReplicated = new HashSet();
    final Runnable nullCompletionCallback = new Runnable(){

        @Override
        public void run() {
        }
    };
    protected final HashMap<String, StoredDestination> storedDestinations = new HashMap();
    protected final ConcurrentMap<String, MessageStore> storeCache = new ConcurrentHashMap<String, MessageStore>();
    private final LinkedHashMap<TransactionId, List<Operation>> inflightTransactions = new LinkedHashMap();
    protected final LinkedHashMap<TransactionId, List<Operation>> preparedTransactions = new LinkedHashMap();
    protected final Set<String> ackedAndPrepared = new HashSet<String>();
    protected final Set<String> rolledBackAcks = new HashSet<String>();

    @Override
    public void doStart() throws Exception {
        this.load();
    }

    @Override
    public void doStop(ServiceStopper stopper) throws Exception {
        this.unload();
    }

    public void allowIOResumption() {
        if (this.pageFile != null) {
            this.pageFile.allowIOResumption();
        }
        if (this.journal != null) {
            this.journal.allowIOResumption();
        }
    }

    private void loadPageFile() throws IOException {
        this.indexLock.writeLock().lock();
        try {
            final PageFile pageFile = this.getPageFile();
            pageFile.load();
            pageFile.tx().execute(new Transaction.Closure<IOException>(){

                @Override
                public void execute(Transaction tx) throws IOException {
                    if (pageFile.getPageCount() == 0L) {
                        Page<Metadata> page = tx.allocate();
                        assert (page.getPageId() == 0L);
                        page.set(MessageDatabase.this.metadata);
                        MessageDatabase.this.metadata.page = page;
                        MessageDatabase.this.metadata.state = 1;
                        MessageDatabase.this.metadata.destinations = new BTreeIndex(pageFile, tx.allocate().getPageId());
                        tx.store(MessageDatabase.this.metadata.page, MessageDatabase.this.metadataMarshaller, true);
                    } else {
                        Page<Metadata> page = tx.load(0L, MessageDatabase.this.metadataMarshaller);
                        MessageDatabase.this.metadata = page.get();
                        MessageDatabase.this.metadata.page = page;
                    }
                    MessageDatabase.this.metadata.destinations.setKeyMarshaller(StringMarshaller.INSTANCE);
                    MessageDatabase.this.metadata.destinations.setValueMarshaller(new StoredDestinationMarshaller());
                    MessageDatabase.this.metadata.destinations.load(tx);
                }
            });
            this.storedDestinations.clear();
            pageFile.tx().execute(new Transaction.Closure<IOException>(){

                @Override
                public void execute(Transaction tx) throws IOException {
                    Iterator<Map.Entry<String, StoredDestination>> iterator = MessageDatabase.this.metadata.destinations.iterator(tx);
                    while (iterator.hasNext()) {
                        Map.Entry<String, StoredDestination> entry = iterator.next();
                        StoredDestination sd = MessageDatabase.this.loadStoredDestination(tx, entry.getKey(), entry.getValue().subscriptions != null);
                        MessageDatabase.this.storedDestinations.put(entry.getKey(), sd);
                        if (!MessageDatabase.this.checkForCorruptJournalFiles || entry.getValue().locationIndex.isEmpty(tx) || entry.getValue().orderIndex.nextMessageId > 0L) continue;
                        throw new IOException("Detected uninitialized orderIndex nextMessageId with pending messages for " + entry.getKey());
                    }
                }
            });
            pageFile.flush();
        }
        finally {
            this.indexLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startCheckpoint() {
        if (this.checkpointInterval == 0L && this.cleanupInterval == 0L) {
            LOG.info("periodic checkpoint/cleanup disabled, will ocurr on clean shutdown/restart");
            return;
        }
        Object object = this.schedulerLock;
        synchronized (object) {
            if (this.scheduler == null || this.scheduler.isShutdown()) {
                this.scheduler = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

                    @Override
                    public Thread newThread(Runnable r) {
                        Thread schedulerThread = new Thread(r);
                        schedulerThread.setName("ActiveMQ Journal Checkpoint Worker");
                        schedulerThread.setDaemon(true);
                        return schedulerThread;
                    }
                });
                long delay = this.journal.isJournalDiskSyncPeriodic() ? Math.min(this.journalDiskSyncInterval > 0L ? this.journalDiskSyncInterval : this.checkpointInterval, 500L) : Math.min(this.checkpointInterval > 0L ? this.checkpointInterval : this.cleanupInterval, 500L);
                this.scheduler.scheduleWithFixedDelay(new CheckpointRunner(), 0L, delay, TimeUnit.MILLISECONDS);
            }
        }
    }

    public void open() throws IOException {
        if (this.opened.compareAndSet(false, true)) {
            this.getJournal().start();
            try {
                this.loadPageFile();
            }
            catch (Throwable t) {
                LOG.warn("Index corrupted. Recovering the index through journal replay. Cause:" + t);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Index load failure", t);
                }
                try {
                    this.pageFile.unload();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.archiveCorruptedIndex) {
                    this.pageFile.archive();
                } else {
                    this.pageFile.delete();
                }
                this.metadata = this.createMetadata();
                this.configureMetadata();
                this.pageFile = null;
                this.loadPageFile();
            }
            this.recover();
            this.startCheckpoint();
        }
    }

    public void load() throws IOException {
        this.indexLock.writeLock().lock();
        try {
            IOHelper.mkdirs(this.directory);
            if (this.deleteAllMessages) {
                this.getJournal().setCheckForCorruptionOnStartup(false);
                this.getJournal().start();
                this.getJournal().delete();
                this.getJournal().close();
                this.journal = null;
                this.getPageFile().delete();
                LOG.info("Persistence store purged.");
                this.deleteAllMessages = false;
            }
            this.open();
            this.store((JournalCommand)new KahaTraceCommand().setMessage("LOADED " + new Date()));
        }
        finally {
            this.indexLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException, InterruptedException {
        if (this.opened.compareAndSet(true, false)) {
            this.checkpointLock.writeLock().lock();
            try {
                if (this.metadata.page != null) {
                    this.checkpointUpdate(true);
                }
                this.pageFile.unload();
                this.metadata = this.createMetadata();
            }
            finally {
                this.checkpointLock.writeLock().unlock();
            }
            this.journal.close();
            Object object = this.schedulerLock;
            synchronized (object) {
                if (this.scheduler != null) {
                    ThreadPoolUtils.shutdownGraceful(this.scheduler, -1L);
                    this.scheduler = null;
                }
            }
            this.storeCache.clear();
            this.journalSize.set(0L);
        }
    }

    public void unload() throws IOException, InterruptedException {
        this.indexLock.writeLock().lock();
        try {
            if (this.pageFile != null && this.pageFile.isLoaded()) {
                this.metadata.state = 1;
                this.metadata.firstInProgressTransactionLocation = this.getInProgressTxLocationRange()[0];
                if (this.metadata.page != null) {
                    this.pageFile.tx().execute(new Transaction.Closure<IOException>(){

                        @Override
                        public void execute(Transaction tx) throws IOException {
                            tx.store(MessageDatabase.this.metadata.page, MessageDatabase.this.metadataMarshaller, true);
                        }
                    });
                }
            }
        }
        finally {
            this.indexLock.writeLock().unlock();
        }
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Location[] getInProgressTxLocationRange() {
        Location[] range = new Location[]{null, null};
        LinkedHashMap<TransactionId, List<Operation>> linkedHashMap = this.inflightTransactions;
        synchronized (linkedHashMap) {
            if (!this.inflightTransactions.isEmpty()) {
                for (List<Operation> ops : this.inflightTransactions.values()) {
                    if (ops.isEmpty()) continue;
                    this.trackMaxAndMin(range, ops);
                }
            }
            if (!this.preparedTransactions.isEmpty()) {
                for (List<Operation> ops : this.preparedTransactions.values()) {
                    if (ops.isEmpty()) continue;
                    this.trackMaxAndMin(range, ops);
                }
            }
        }
        return range;
    }

    private void trackMaxAndMin(Location[] range, List<Operation> ops) {
        Location t = ops.get(0).getLocation();
        if (range[0] == null || t.compareTo(range[0]) <= 0) {
            range[0] = t;
        }
        t = ops.get(ops.size() - 1).getLocation();
        if (range[1] == null || t.compareTo(range[1]) >= 0) {
            range[1] = t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTransactions() {
        TranInfo info;
        ArrayList<TranInfo> infos = new ArrayList<TranInfo>();
        LinkedHashMap<TransactionId, List<Operation>> linkedHashMap = this.inflightTransactions;
        synchronized (linkedHashMap) {
            if (!this.inflightTransactions.isEmpty()) {
                for (Map.Entry<TransactionId, List<Operation>> entry : this.inflightTransactions.entrySet()) {
                    info = new TranInfo();
                    info.id = entry.getKey();
                    for (Operation operation : entry.getValue()) {
                        info.track(operation);
                    }
                    infos.add(info);
                }
            }
        }
        linkedHashMap = this.preparedTransactions;
        synchronized (linkedHashMap) {
            if (!this.preparedTransactions.isEmpty()) {
                for (Map.Entry<TransactionId, List<Operation>> entry : this.preparedTransactions.entrySet()) {
                    info = new TranInfo();
                    info.id = entry.getKey();
                    for (Operation operation : entry.getValue()) {
                        info.track(operation);
                    }
                    infos.add(info);
                }
            }
        }
        return infos.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recover() throws IllegalStateException, IOException {
        this.indexLock.writeLock().lock();
        try {
            Location recoveryPosition;
            long start2 = System.currentTimeMillis();
            boolean requiresJournalReplay = this.recoverProducerAudit();
            Location lastIndoubtPosition = this.getRecoveryPosition();
            Location location = recoveryPosition = (requiresJournalReplay |= this.recoverAckMessageFileMap()) ? this.journal.getNextLocation(null) : lastIndoubtPosition;
            if (recoveryPosition != null) {
                int redoCounter = 0;
                int dataFileRotationTracker = recoveryPosition.getDataFileId();
                LOG.info("Recovering from the journal @" + recoveryPosition);
                while (recoveryPosition != null) {
                    try {
                        JournalCommand<?> message = this.load(recoveryPosition);
                        this.metadata.lastUpdate = recoveryPosition;
                        this.process(message, recoveryPosition, lastIndoubtPosition);
                        ++redoCounter;
                    }
                    catch (IOException failedRecovery) {
                        if (this.isIgnoreMissingJournalfiles()) {
                            LOG.debug("Failed to recover data at position:" + recoveryPosition, (Throwable)failedRecovery);
                            this.journal.corruptRecoveryLocation(recoveryPosition);
                        }
                        throw new IOException("Failed to recover data at position:" + recoveryPosition, failedRecovery);
                    }
                    recoveryPosition = this.journal.getNextLocation(recoveryPosition);
                    if (recoveryPosition != null && dataFileRotationTracker != recoveryPosition.getDataFileId()) {
                        dataFileRotationTracker = recoveryPosition.getDataFileId();
                        this.journal.cleanup();
                    }
                    if (!LOG.isInfoEnabled() || redoCounter % 100000 != 0) continue;
                    LOG.info("@" + recoveryPosition + ", " + redoCounter + " entries recovered ..");
                }
                if (LOG.isInfoEnabled()) {
                    long end = System.currentTimeMillis();
                    LOG.info("Recovery replayed " + redoCounter + " operations from the journal in " + (float)(end - start2) / 1000.0f + " seconds.");
                }
            }
            this.pageFile.tx().execute(new Transaction.Closure<IOException>(){

                @Override
                public void execute(Transaction tx) throws IOException {
                    MessageDatabase.this.recoverIndex(tx);
                }
            });
            HashSet<TransactionId> toRollback = new HashSet<TransactionId>();
            HashSet<TransactionId> toDiscard = new HashSet<TransactionId>();
            LinkedHashMap<TransactionId, List<Operation>> linkedHashMap = this.inflightTransactions;
            synchronized (linkedHashMap) {
                for (TransactionId id : this.inflightTransactions.keySet()) {
                    if (id.isLocalTransaction()) {
                        toRollback.add(id);
                        continue;
                    }
                    toDiscard.add(id);
                }
                for (TransactionId tx : toRollback) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("rolling back recovered indoubt local transaction " + tx);
                    }
                    this.store((JournalCommand)new KahaRollbackCommand().setTransactionInfo(TransactionIdConversion.convertToLocal(tx)), false, null, null);
                }
                for (TransactionId tx : toDiscard) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("discarding recovered in-flight XA transaction " + tx);
                    }
                    this.inflightTransactions.remove(tx);
                }
            }
            linkedHashMap = this.preparedTransactions;
            synchronized (linkedHashMap) {
                LinkedHashSet<TransactionId> txIds = new LinkedHashSet<TransactionId>(this.preparedTransactions.keySet());
                for (TransactionId txId : txIds) {
                    switch (this.purgeRecoveredXATransactionStrategy) {
                        case NEVER: {
                            LOG.warn("Recovered prepared XA TX: [{}]", (Object)txId);
                            break;
                        }
                        case COMMIT: {
                            this.store((JournalCommand)new KahaCommitCommand().setTransactionInfo(TransactionIdConversion.convert(txId)), false, null, null);
                            LOG.warn("Recovered and Committing prepared XA TX: [{}]", (Object)txId);
                            break;
                        }
                        case ROLLBACK: {
                            this.store((JournalCommand)new KahaRollbackCommand().setTransactionInfo(TransactionIdConversion.convert(txId)), false, null, null);
                            LOG.warn("Recovered and Rolling Back prepared XA TX: [{}]", (Object)txId);
                        }
                    }
                }
            }
        }
        finally {
            this.indexLock.writeLock().unlock();
        }
    }

    private KahaTransactionInfo createLocalTransactionInfo(TransactionId tx) {
        return TransactionIdConversion.convertToLocal(tx);
    }

    private Location minimum(Location x, Location y) {
        Location min = null;
        if (x != null) {
            int compare;
            min = x;
            if (y != null && (compare = y.compareTo(x)) < 0) {
                min = y;
            }
        } else {
            min = y;
        }
        return min;
    }

    private boolean recoverProducerAudit() throws IOException {
        boolean requiresReplay = true;
        if (this.metadata.producerSequenceIdTrackerLocation != null) {
            try {
                KahaProducerAuditCommand audit = (KahaProducerAuditCommand)this.load(this.metadata.producerSequenceIdTrackerLocation);
                ObjectInputStream objectIn = new ObjectInputStream(audit.getAudit().newInput());
                int maxNumProducers = this.getMaxFailoverProducersToTrack();
                int maxAuditDepth = this.getFailoverProducersAuditDepth();
                this.metadata.producerSequenceIdTracker = (ActiveMQMessageAuditNoSync)objectIn.readObject();
                this.metadata.producerSequenceIdTracker.setAuditDepth(maxAuditDepth);
                this.metadata.producerSequenceIdTracker.setMaximumNumberOfProducersToTrack(maxNumProducers);
                requiresReplay = false;
            }
            catch (Exception e) {
                LOG.warn("Cannot recover message audit", (Throwable)e);
            }
        }
        return requiresReplay;
    }

    private boolean recoverAckMessageFileMap() throws IOException {
        boolean requiresReplay = true;
        if (this.metadata.ackMessageFileMapLocation != null) {
            try {
                KahaAckMessageFileMapCommand audit = (KahaAckMessageFileMapCommand)this.load(this.metadata.ackMessageFileMapLocation);
                ObjectInputStream objectIn = new ObjectInputStream(audit.getAckMessageFileMap().newInput());
                this.metadata.ackMessageFileMap = (Map)objectIn.readObject();
                this.metadata.ackMessageFileMapDirtyFlag.lazySet(true);
                requiresReplay = false;
            }
            catch (Exception e) {
                LOG.warn("Cannot recover ackMessageFileMap", (Throwable)e);
            }
        }
        return requiresReplay;
    }

    protected void recoverIndex(Transaction tx) throws IOException {
        long start2 = System.currentTimeMillis();
        Location lastAppendLocation = this.journal.getLastAppendLocation();
        long undoCounter = 0L;
        for (String string : this.storedDestinations.keySet()) {
            StoredDestination storedDestination = this.storedDestinations.get(string);
            final ArrayList arrayList = new ArrayList();
            storedDestination.locationIndex.visit(tx, (BTreeVisitor<Location, Long>)new BTreeVisitor.GTEVisitor<Location, Long>(lastAppendLocation){

                @Override
                protected void matched(Location key, Long value) {
                    arrayList.add(value);
                }
            });
            for (Long l : arrayList) {
                MessageKeys keys = storedDestination.orderIndex.remove(tx, l);
                if (keys == null) continue;
                storedDestination.locationIndex.remove(tx, keys.location);
                storedDestination.messageIdIndex.remove(tx, keys.messageId);
                this.metadata.producerSequenceIdTracker.rollback(keys.messageId);
                ++undoCounter;
                this.decrementAndSubSizeToStoreStat(string, (long)keys.location.getSize());
            }
        }
        if (undoCounter > 0L && LOG.isInfoEnabled()) {
            long end = System.currentTimeMillis();
            LOG.info("Rolled back " + undoCounter + " messages from the index in " + (float)(end - start2) / 1000.0f + " seconds.");
        }
        undoCounter = 0L;
        start2 = System.currentTimeMillis();
        final SequenceSet ss = new SequenceSet();
        for (StoredDestination storedDestination : this.storedDestinations.values()) {
            storedDestination.locationIndex.visit(tx, new BTreeVisitor<Location, Long>(){
                int last = -1;

                @Override
                public boolean isInterestedInKeysBetween(Location first, Location second) {
                    if (first == null) {
                        return !ss.contains(0, second.getDataFileId());
                    }
                    if (second == null) {
                        return true;
                    }
                    return !ss.contains(first.getDataFileId(), second.getDataFileId());
                }

                @Override
                public void visit(List<Location> keys, List<Long> values) {
                    for (Location l : keys) {
                        int fileId = l.getDataFileId();
                        if (this.last == fileId) continue;
                        ss.add(fileId);
                        this.last = fileId;
                    }
                }
            });
        }
        HashSet<Integer> hashSet = new HashSet<Integer>();
        while (!ss.isEmpty()) {
            hashSet.add((int)ss.removeFirst());
        }
        for (Map.Entry<Integer, Set<Integer>> entry : this.metadata.ackMessageFileMap.entrySet()) {
            hashSet.add(entry.getKey());
            for (Integer n : entry.getValue()) {
                hashSet.add(n);
            }
        }
        hashSet.removeAll(this.journal.getFileMap().keySet());
        if (!hashSet.isEmpty()) {
            LOG.warn("Some journal files are missing: " + hashSet);
        }
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        for (Integer n : hashSet) {
            arrayList2.add(new BTreeVisitor.BetweenVisitor(new Location(n, 0), new Location(n + 1, 0)));
        }
        if (this.checkForCorruptJournalFiles) {
            Collection<DataFile> dataFiles = this.journal.getFileMap().values();
            Iterator<DataFile> iterator = dataFiles.iterator();
            while (iterator.hasNext()) {
                DataFile dataFile = iterator.next();
                int id = dataFile.getDataFileId();
                arrayList2.add(new BTreeVisitor.BetweenVisitor(new Location(id, dataFile.getLength()), new Location(id + 1, 0)));
                for (Sequence seq = (Sequence)dataFile.getCorruptedBlocks().getHead(); seq != null; seq = (Sequence)seq.getNext()) {
                    BTreeVisitor.BetweenVisitor visitor = new BTreeVisitor.BetweenVisitor(new Location(id, (int)seq.getFirst()), new Location(id, (int)seq.getLast() + 1));
                    arrayList2.add(visitor);
                    arrayList.add(visitor);
                }
            }
        }
        if (!arrayList2.isEmpty()) {
            for (Map.Entry entry : this.storedDestinations.entrySet()) {
                StoredDestination sd = (StoredDestination)entry.getValue();
                final LinkedHashMap matches = new LinkedHashMap();
                sd.locationIndex.visit(tx, (BTreeVisitor<Location, Long>)new BTreeVisitor.OrVisitor<Location, Long>(arrayList2){

                    @Override
                    protected void matched(Location key, Long value) {
                        matches.put(value, key);
                    }
                });
                if (matches.isEmpty()) continue;
                if (this.ignoreMissingJournalfiles) {
                    for (Long sequenceId : matches.keySet()) {
                        MessageKeys keys = sd.orderIndex.remove(tx, sequenceId);
                        sd.locationIndex.remove(tx, keys.location);
                        sd.messageIdIndex.remove(tx, keys.messageId);
                        LOG.info("[" + (String)entry.getKey() + "] dropped: " + keys.messageId + " at corrupt location: " + keys.location);
                        ++undoCounter;
                        this.decrementAndSubSizeToStoreStat((String)entry.getKey(), (long)keys.location.getSize());
                    }
                    continue;
                }
                LOG.error("[" + (String)entry.getKey() + "] references corrupt locations: " + matches);
                throw new IOException("Detected missing/corrupt journal files referenced by:[" + (String)entry.getKey() + "] " + matches.size() + " messages affected.");
            }
        }
        if (!this.ignoreMissingJournalfiles) {
            if (!arrayList.isEmpty()) {
                LOG.error("Detected corrupt journal files. " + arrayList);
                throw new IOException("Detected corrupt journal files. " + arrayList);
            }
            if (!hashSet.isEmpty()) {
                LOG.error("Detected missing journal files. " + hashSet);
                throw new IOException("Detected missing journal files. " + hashSet);
            }
        }
        if (undoCounter > 0L && LOG.isInfoEnabled()) {
            long end = System.currentTimeMillis();
            LOG.info("Detected missing/corrupt journal files.  Dropped " + undoCounter + " messages from the index in " + (float)(end - start2) / 1000.0f + " seconds.");
        }
    }

    public void incrementalRecover() throws IOException {
        this.indexLock.writeLock().lock();
        try {
            if (this.nextRecoveryPosition == null) {
                this.nextRecoveryPosition = this.lastRecoveryPosition == null ? this.getRecoveryPosition() : this.journal.getNextLocation(this.lastRecoveryPosition);
            }
            while (this.nextRecoveryPosition != null) {
                this.metadata.lastUpdate = this.lastRecoveryPosition = this.nextRecoveryPosition;
                JournalCommand<?> message = this.load(this.lastRecoveryPosition);
                this.process(message, this.lastRecoveryPosition, (IndexAware)null);
                this.nextRecoveryPosition = this.journal.getNextLocation(this.lastRecoveryPosition);
            }
        }
        finally {
            this.indexLock.writeLock().unlock();
        }
    }

    public Location getLastUpdatePosition() throws IOException {
        return this.metadata.lastUpdate;
    }

    private Location getRecoveryPosition() throws IOException {
        if (!this.forceRecoverIndex) {
            if (this.metadata.firstInProgressTransactionLocation != null) {
                return this.metadata.firstInProgressTransactionLocation;
            }
            if (this.metadata.lastUpdate != null) {
                return this.getNextInitializedLocation(this.metadata.lastUpdate);
            }
        }
        return this.journal.getNextLocation(null);
    }

    private Location getNextInitializedLocation(Location location) throws IOException {
        Location mayNotBeInitialized = this.journal.getNextLocation(location);
        if (location.getSize() == -1 && mayNotBeInitialized != null && mayNotBeInitialized.getSize() != -1) {
            return this.journal.getNextLocation(mayNotBeInitialized);
        }
        return mayNotBeInitialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkpointCleanup(boolean cleanup) throws IOException {
        long start2;
        this.indexLock.writeLock().lock();
        try {
            start2 = System.currentTimeMillis();
            if (!this.opened.get()) {
                return;
            }
        }
        finally {
            this.indexLock.writeLock().unlock();
        }
        this.checkpointUpdate(cleanup);
        long end = System.currentTimeMillis();
        if (LOG_SLOW_ACCESS_TIME > 0 && end - start2 > (long)LOG_SLOW_ACCESS_TIME && LOG.isInfoEnabled()) {
            LOG.info("Slow KahaDB access: cleanup took " + (end - start2));
        }
    }

    public ByteSequence toByteSequence(JournalCommand<?> data) throws IOException {
        int size2 = data.serializedSizeFramed();
        DataByteArrayOutputStream os = new DataByteArrayOutputStream(size2 + 1);
        os.writeByte(data.type().getNumber());
        data.writeFramed(os);
        return os.toByteSequence();
    }

    public Location store(JournalCommand<?> data) throws IOException {
        return this.store(data, false, null, null);
    }

    public Location store(JournalCommand<?> data, Runnable onJournalStoreComplete) throws IOException {
        return this.store(data, false, null, null, onJournalStoreComplete);
    }

    public Location store(JournalCommand<?> data, boolean sync, IndexAware before, Runnable after) throws IOException {
        return this.store(data, sync, before, after, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Location store(JournalCommand<?> data, boolean sync, IndexAware before, Runnable after, Runnable onJournalStoreComplete) throws IOException {
        try {
            Location location;
            ByteSequence sequence = this.toByteSequence(data);
            this.checkpointLock.readLock().lock();
            try {
                long start2 = System.currentTimeMillis();
                location = onJournalStoreComplete == null ? this.journal.write(sequence, sync) : this.journal.write(sequence, onJournalStoreComplete);
                long start22 = System.currentTimeMillis();
                if (!sync && this.journal.isJournalDiskSyncPeriodic()) {
                    this.lastAsyncJournalUpdate.set(location);
                }
                this.process(data, location, before);
                long end = System.currentTimeMillis();
                if (LOG_SLOW_ACCESS_TIME > 0 && end - start2 > (long)LOG_SLOW_ACCESS_TIME && LOG.isInfoEnabled()) {
                    LOG.info("Slow KahaDB access: Journal append took: " + (start22 - start2) + " ms, Index update took " + (end - start22) + " ms");
                }
                this.persistenceAdapterStatistics.addWriteTime(end - start2);
            }
            finally {
                this.checkpointLock.readLock().unlock();
            }
            if (after != null) {
                after.run();
            }
            if (this.scheduler == null && this.opened.get()) {
                this.startCheckpoint();
            }
            return location;
        }
        catch (IOException ioe) {
            LOG.error("KahaDB failed to store to Journal, command of type: " + (Object)((Object)data.type()), (Throwable)ioe);
            this.brokerService.handleIOException(ioe);
            throw ioe;
        }
    }

    public JournalCommand<?> load(Location location) throws IOException {
        long start2 = System.currentTimeMillis();
        ByteSequence data = this.journal.read(location);
        long end = System.currentTimeMillis();
        if (LOG_SLOW_ACCESS_TIME > 0 && end - start2 > (long)LOG_SLOW_ACCESS_TIME && LOG.isInfoEnabled()) {
            LOG.info("Slow KahaDB access: Journal read took: " + (end - start2) + " ms");
        }
        this.persistenceAdapterStatistics.addReadTime(end - start2);
        DataByteArrayInputStream is = new DataByteArrayInputStream(data);
        byte readByte = is.readByte();
        KahaEntryType type = KahaEntryType.valueOf(readByte);
        if (type == null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new IOException("Could not load journal record, null type information from: " + readByte + " at location: " + location);
        }
        JournalCommand message = (JournalCommand)type.createMessage();
        message.mergeFramed(is);
        return message;
    }

    void process(JournalCommand<?> data, Location location, Location inDoubtlocation) throws IOException {
        if (inDoubtlocation != null && location.compareTo(inDoubtlocation) >= 0) {
            this.process(data, location, (IndexAware)null);
        } else {
            data.visit(new Visitor(){

                @Override
                public void visit(KahaAddMessageCommand command) throws IOException {
                    MessageDatabase.this.metadata.producerSequenceIdTracker.isDuplicate(command.getMessageId());
                }
            });
        }
    }

    void process(JournalCommand<?> data, final Location location, final IndexAware onSequenceAssignedCallback) throws IOException {
        data.visit(new Visitor(){

            @Override
            public void visit(KahaAddMessageCommand command) throws IOException {
                MessageDatabase.this.process(command, location, onSequenceAssignedCallback);
            }

            @Override
            public void visit(KahaRemoveMessageCommand command) throws IOException {
                MessageDatabase.this.process(command, location);
            }

            @Override
            public void visit(KahaPrepareCommand command) throws IOException {
                MessageDatabase.this.process(command, location);
            }

            @Override
            public void visit(KahaCommitCommand command) throws IOException {
                MessageDatabase.this.process(command, location, onSequenceAssignedCallback);
            }

            @Override
            public void visit(KahaRollbackCommand command) throws IOException {
                MessageDatabase.this.process(command, location);
            }

            @Override
            public void visit(KahaRemoveDestinationCommand command) throws IOException {
                MessageDatabase.this.process(command, location);
            }

            @Override
            public void visit(KahaSubscriptionCommand command) throws IOException {
                MessageDatabase.this.process(command, location);
            }

            @Override
            public void visit(KahaProducerAuditCommand command) throws IOException {
                MessageDatabase.this.processLocation(location);
            }

            @Override
            public void visit(KahaAckMessageFileMapCommand command) throws IOException {
                MessageDatabase.this.processLocation(location);
            }

            @Override
            public void visit(KahaTraceCommand command) {
                MessageDatabase.this.processLocation(location);
            }

            @Override
            public void visit(KahaUpdateMessageCommand command) throws IOException {
                MessageDatabase.this.process(command, location);
            }

            @Override
            public void visit(KahaRewrittenDataFileCommand command) throws IOException {
                MessageDatabase.this.process(command, location);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(final KahaAddMessageCommand command, final Location location, final IndexAware runWithIndexLock) throws IOException {
        if (command.hasTransactionInfo()) {
            List<Operation> inflightTx = this.getInflightTx(command.getTransactionInfo());
            inflightTx.add(new AddOperation(command, location, runWithIndexLock));
        } else {
            this.indexLock.writeLock().lock();
            try {
                this.pageFile.tx().execute(new Transaction.Closure<IOException>(){

                    @Override
                    public void execute(Transaction tx) throws IOException {
                        long assignedIndex = MessageDatabase.this.updateIndex(tx, command, location);
                        if (runWithIndexLock != null) {
                            runWithIndexLock.sequenceAssignedWithIndexLocked(assignedIndex);
                        }
                    }
                });
            }
            finally {
                this.indexLock.writeLock().unlock();
            }
        }
    }

    protected void process(final KahaUpdateMessageCommand command, final Location location) throws IOException {
        this.indexLock.writeLock().lock();
        try {
            this.pageFile.tx().execute(new Transaction.Closure<IOException>(){

                @Override
                public void execute(Transaction tx) throws IOException {
                    MessageDatabase.this.updateIndex(tx, command, location);
                }
            });
        }
        finally {
            this.indexLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(final KahaRemoveMessageCommand command, final Location location) throws IOException {
        if (command.hasTransactionInfo()) {
            List<Operation> inflightTx = this.getInflightTx(command.getTransactionInfo());
            inflightTx.add(new RemoveOperation(command, location));
        } else {
            this.indexLock.writeLock().lock();
            try {
                this.pageFile.tx().execute(new Transaction.Closure<IOException>(){

                    @Override
                    public void execute(Transaction tx) throws IOException {
                        MessageDatabase.this.updateIndex(tx, command, location);
                    }
                });
            }
            finally {
                this.indexLock.writeLock().unlock();
            }
        }
    }

    protected void process(final KahaRemoveDestinationCommand command, final Location location) throws IOException {
        this.indexLock.writeLock().lock();
        try {
            this.pageFile.tx().execute(new Transaction.Closure<IOException>(){

                @Override
                public void execute(Transaction tx) throws IOException {
                    MessageDatabase.this.updateIndex(tx, command, location);
                }
            });
        }
        finally {
            this.indexLock.writeLock().unlock();
        }
    }

    protected void process(final KahaSubscriptionCommand command, final Location location) throws IOException {
        this.indexLock.writeLock().lock();
        try {
            this.pageFile.tx().execute(new Transaction.Closure<IOException>(){

                @Override
                public void execute(Transaction tx) throws IOException {
                    MessageDatabase.this.updateIndex(tx, command, location);
                }
            });
        }
        finally {
            this.indexLock.writeLock().unlock();
        }
    }

    protected void processLocation(Location location) {
        this.indexLock.writeLock().lock();
        try {
            this.metadata.lastUpdate = location;
        }
        finally {
            this.indexLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(KahaCommitCommand command, final Location location, IndexAware before) throws IOException {
        List inflightTx;
        TransactionId key = TransactionIdConversion.convert(command.getTransactionInfo());
        LinkedHashMap<TransactionId, List<Operation>> linkedHashMap = this.inflightTransactions;
        synchronized (linkedHashMap) {
            inflightTx = (List)this.inflightTransactions.remove(key);
            if (inflightTx == null) {
                inflightTx = (List)this.preparedTransactions.remove(key);
            }
        }
        if (inflightTx == null) {
            if (before != null) {
                before.sequenceAssignedWithIndexLocked(-1L);
            }
            return;
        }
        final List messagingTx = inflightTx;
        this.indexLock.writeLock().lock();
        try {
            this.pageFile.tx().execute(new Transaction.Closure<IOException>(){

                @Override
                public void execute(Transaction tx) throws IOException {
                    for (Operation op : messagingTx) {
                        op.execute(tx);
                        MessageDatabase.this.recordAckMessageReferenceLocation(location, op.getLocation());
                    }
                }
            });
            this.metadata.lastUpdate = location;
        }
        finally {
            this.indexLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(KahaPrepareCommand command, Location location) {
        TransactionId key = TransactionIdConversion.convert(command.getTransactionInfo());
        List tx = null;
        LinkedHashMap<TransactionId, List<Operation>> linkedHashMap = this.inflightTransactions;
        synchronized (linkedHashMap) {
            tx = (List)this.inflightTransactions.remove(key);
            if (tx != null) {
                this.preparedTransactions.put(key, tx);
            }
        }
        if (tx != null && !tx.isEmpty()) {
            this.indexLock.writeLock().lock();
            try {
                for (Operation op : tx) {
                    this.recordAckMessageReferenceLocation(location, op.getLocation());
                }
            }
            finally {
                this.indexLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(KahaRollbackCommand command, Location location) throws IOException {
        TransactionId key = TransactionIdConversion.convert(command.getTransactionInfo());
        List updates = null;
        LinkedHashMap<TransactionId, List<Operation>> linkedHashMap = this.inflightTransactions;
        synchronized (linkedHashMap) {
            updates = (List)this.inflightTransactions.remove(key);
            if (updates == null) {
                updates = (List)this.preparedTransactions.remove(key);
            }
        }
        if (key.isXATransaction() && updates != null && !updates.isEmpty()) {
            this.indexLock.writeLock().lock();
            try {
                for (Operation op : updates) {
                    this.recordAckMessageReferenceLocation(location, op.getLocation());
                }
            }
            finally {
                this.indexLock.writeLock().unlock();
            }
        }
    }

    protected void process(KahaRewrittenDataFileCommand command, Location location) throws IOException {
        TreeSet<Integer> completeFileSet = new TreeSet<Integer>(this.journal.getFileMap().keySet());
        DataFile current = this.journal.getDataFileById(location.getDataFileId());
        current.setTypeCode(command.getRewriteType());
        if (completeFileSet.contains(command.getSourceDataFileId()) && command.getSkipIfSourceExists()) {
            location.setOffset(this.journalMaxFileLength);
        }
    }

    long updateIndex(Transaction tx, KahaAddMessageCommand command, Location location) throws IOException {
        StoredDestination sd = this.getStoredDestination(command.getDestination(), tx);
        if (sd.subscriptions != null && sd.subscriptions.isEmpty(tx)) {
            return -1L;
        }
        int priority = command.getPrioritySupported() ? command.getPriority() : 4;
        long id = sd.orderIndex.getNextMessageId();
        Long previous = sd.locationIndex.put(tx, location, id);
        if (previous == null) {
            previous = sd.messageIdIndex.put(tx, command.getMessageId(), id);
            if (previous == null) {
                this.incrementAndAddSizeToStoreStat(command.getDestination(), (long)location.getSize());
                sd.orderIndex.put(tx, priority, id, new MessageKeys(command.getMessageId(), location));
                if (sd.subscriptions != null && !sd.subscriptions.isEmpty(tx)) {
                    this.addAckLocationForNewMessage(tx, command.getDestination(), sd, id);
                }
                this.metadata.lastUpdate = location;
            } else {
                MessageKeys messageKeys = sd.orderIndex.get(tx, previous);
                if (messageKeys != null && messageKeys.location.compareTo(location) < 0) {
                    LOG.warn("Duplicate message add attempt rejected. Destination: {}://{}, Message id: {}", new Object[]{command.getDestination().getType(), command.getDestination().getName(), command.getMessageId()});
                }
                sd.messageIdIndex.put(tx, command.getMessageId(), previous);
                sd.locationIndex.remove(tx, location);
                id = -1L;
            }
        } else {
            sd.locationIndex.put(tx, location, previous);
            sd.orderIndex.revertNextMessageId();
            this.metadata.lastUpdate = location;
        }
        this.metadata.producerSequenceIdTracker.isDuplicate(command.getMessageId());
        return id;
    }

    void trackPendingAdd(KahaDestination destination, Long seq) {
        StoredDestination sd = this.storedDestinations.get(this.key(destination));
        if (sd != null) {
            sd.trackPendingAdd(seq);
        }
    }

    void trackPendingAddComplete(KahaDestination destination, Long seq) {
        StoredDestination sd = this.storedDestinations.get(this.key(destination));
        if (sd != null) {
            sd.trackPendingAddComplete(seq);
        }
    }

    void updateIndex(Transaction tx, KahaUpdateMessageCommand updateMessageCommand, Location location) throws IOException {
        KahaAddMessageCommand command = updateMessageCommand.getMessage();
        StoredDestination sd = this.getStoredDestination(command.getDestination(), tx);
        Long id = sd.messageIdIndex.get(tx, command.getMessageId());
        if (id != null) {
            MessageKeys previousKeys = sd.orderIndex.put(tx, command.getPrioritySupported() ? command.getPriority() : 4, id, new MessageKeys(command.getMessageId(), location));
            sd.locationIndex.put(tx, location, id);
            this.incrementAndAddSizeToStoreStat(command.getDestination(), (long)location.getSize());
            if (previousKeys != null) {
                this.decrementAndSubSizeToStoreStat(command.getDestination(), (long)previousKeys.location.getSize());
                if (this.enableSubscriptionStatistics && sd.ackPositions != null && location.getSize() != previousKeys.location.getSize()) {
                    Iterator<Map.Entry<String, SequenceSet>> iter = sd.ackPositions.iterator(tx);
                    while (iter.hasNext()) {
                        Map.Entry<String, SequenceSet> e = iter.next();
                        if (!e.getValue().contains(id)) continue;
                        this.incrementAndAddSizeToStoreStat(this.key(command.getDestination()), e.getKey(), (long)location.getSize());
                        this.decrementAndSubSizeToStoreStat(this.key(command.getDestination()), e.getKey(), (long)previousKeys.location.getSize());
                    }
                }
                if (!previousKeys.location.equals(location)) {
                    sd.locationIndex.remove(tx, previousKeys.location);
                }
            }
            this.metadata.lastUpdate = location;
        } else {
            this.updateIndex(tx, command, location);
        }
    }

    void updateIndex(Transaction tx, KahaRemoveMessageCommand command, Location ackLocation) throws IOException {
        StoredDestination sd = this.getStoredDestination(command.getDestination(), tx);
        if (!command.hasSubscriptionKey()) {
            Long sequenceId = sd.messageIdIndex.remove(tx, command.getMessageId());
            if (sequenceId != null) {
                MessageKeys keys = sd.orderIndex.remove(tx, sequenceId);
                if (keys != null) {
                    sd.locationIndex.remove(tx, keys.location);
                    this.decrementAndSubSizeToStoreStat(command.getDestination(), (long)keys.location.getSize());
                    this.recordAckMessageReferenceLocation(ackLocation, keys.location);
                    this.metadata.lastUpdate = ackLocation;
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug("message not found in order index: " + sequenceId + " for: " + command.getMessageId());
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("message not found in sequence id index: " + command.getMessageId());
            }
        } else {
            Long sequence = sd.messageIdIndex.get(tx, command.getMessageId());
            if (sequence != null) {
                MessageKeys keys;
                String subscriptionKey = command.getSubscriptionKey();
                if (command.getAck() != UNMATCHED) {
                    sd.orderIndex.get(tx, sequence);
                    byte priority = sd.orderIndex.lastGetPriority();
                    sd.subscriptionAcks.put(tx, subscriptionKey, new LastAck(sequence, priority));
                }
                if ((keys = sd.orderIndex.get(tx, sequence)) != null) {
                    this.recordAckMessageReferenceLocation(ackLocation, keys.location);
                }
                this.removeAckLocation(command, tx, sd, subscriptionKey, sequence);
                this.metadata.lastUpdate = ackLocation;
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("on ack, no message sequence exists for id: " + command.getMessageId() + " and sub: " + command.getSubscriptionKey());
            }
        }
    }

    private void recordAckMessageReferenceLocation(Location ackLocation, Location messageLocation) {
        Set<Integer> referenceFileIds = this.metadata.ackMessageFileMap.get(ackLocation.getDataFileId());
        if (referenceFileIds == null) {
            referenceFileIds = new HashSet<Integer>();
            referenceFileIds.add(messageLocation.getDataFileId());
            this.metadata.ackMessageFileMap.put(ackLocation.getDataFileId(), referenceFileIds);
            this.metadata.ackMessageFileMapDirtyFlag.lazySet(true);
        } else {
            Integer id = messageLocation.getDataFileId();
            if (!referenceFileIds.contains(id)) {
                referenceFileIds.add(id);
            }
        }
    }

    void updateIndex(Transaction tx, KahaRemoveDestinationCommand command, Location location) throws IOException {
        StoredDestination sd = this.getStoredDestination(command.getDestination(), tx);
        sd.orderIndex.remove(tx);
        sd.locationIndex.clear(tx);
        sd.locationIndex.unload(tx);
        tx.free(sd.locationIndex.getPageId());
        sd.messageIdIndex.clear(tx);
        sd.messageIdIndex.unload(tx);
        tx.free(sd.messageIdIndex.getPageId());
        if (sd.subscriptions != null) {
            sd.subscriptions.clear(tx);
            sd.subscriptions.unload(tx);
            tx.free(sd.subscriptions.getPageId());
            sd.subscriptionAcks.clear(tx);
            sd.subscriptionAcks.unload(tx);
            tx.free(sd.subscriptionAcks.getPageId());
            sd.ackPositions.clear(tx);
            sd.ackPositions.unload(tx);
            tx.free(sd.ackPositions.getHeadPageId());
            sd.subLocations.clear(tx);
            sd.subLocations.unload(tx);
            tx.free(sd.subLocations.getHeadPageId());
        }
        String key = this.key(command.getDestination());
        this.storedDestinations.remove(key);
        this.metadata.destinations.remove(tx, key);
        this.clearStoreStats(command.getDestination());
        this.storeCache.remove(this.key(command.getDestination()));
    }

    void updateIndex(Transaction tx, KahaSubscriptionCommand command, Location location) throws IOException {
        StoredDestination sd = this.getStoredDestination(command.getDestination(), tx);
        String subscriptionKey = command.getSubscriptionKey();
        if (command.hasSubscriptionInfo()) {
            Location existing = sd.subLocations.get(tx, subscriptionKey);
            if (existing != null && existing.compareTo(location) == 0) {
                LOG.trace("ignoring journal replay of replay of sub from: " + location);
                return;
            }
            sd.subscriptions.put(tx, subscriptionKey, command);
            sd.subLocations.put(tx, subscriptionKey, location);
            long ackLocation = -1L;
            if (!command.getRetroactive()) {
                ackLocation = sd.orderIndex.nextMessageId - 1L;
            } else {
                this.addAckLocationForRetroactiveSub(tx, sd, subscriptionKey);
            }
            sd.subscriptionAcks.put(tx, subscriptionKey, new LastAck(ackLocation));
            sd.subscriptionCache.add(subscriptionKey);
        } else {
            sd.subscriptions.remove(tx, subscriptionKey);
            sd.subLocations.remove(tx, subscriptionKey);
            sd.subscriptionAcks.remove(tx, subscriptionKey);
            sd.subscriptionCache.remove(subscriptionKey);
            this.removeAckLocationsForSub(command, tx, sd, subscriptionKey);
            MessageStoreSubscriptionStatistics subStats = this.getSubStats(this.key(command.getDestination()));
            if (subStats != null) {
                subStats.removeSubscription(subscriptionKey);
            }
            if (sd.subscriptions.isEmpty(tx)) {
                KahaRemoveDestinationCommand removeDestinationCommand = new KahaRemoveDestinationCommand();
                removeDestinationCommand.setDestination(command.getDestination());
                this.updateIndex(tx, removeDestinationCommand, null);
                this.clearStoreStats(command.getDestination());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkpointUpdate(final boolean cleanup) throws IOException {
        this.checkpointLock.writeLock().lock();
        try {
            this.indexLock.writeLock().lock();
            try {
                Set<Integer> filesToGc = this.pageFile.tx().execute(new Transaction.CallableClosure<Set<Integer>, IOException>(){

                    @Override
                    public Set<Integer> execute(Transaction tx) throws IOException {
                        return MessageDatabase.this.checkpointUpdate(tx, cleanup);
                    }
                });
                this.pageFile.flush();
                this.journal.removeDataFiles(filesToGc);
            }
            finally {
                this.indexLock.writeLock().unlock();
            }
        }
        finally {
            this.checkpointLock.writeLock().unlock();
        }
    }

    Set<Integer> checkpointUpdate(Transaction tx, boolean cleanup) throws IOException {
        MDC.put((String)"activemq.persistenceDir", (String)this.getDirectory().getName());
        LOG.debug("Checkpoint started.");
        Location lastUpdate = this.metadata.lastUpdate;
        this.metadata.state = 2;
        this.metadata.producerSequenceIdTrackerLocation = this.checkpointProducerAudit();
        if (this.metadata.ackMessageFileMapDirtyFlag.get() || this.metadata.ackMessageFileMapLocation == null) {
            this.metadata.ackMessageFileMapLocation = this.checkpointAckMessageFileMap();
        }
        this.metadata.ackMessageFileMapDirtyFlag.lazySet(false);
        Location[] inProgressTxRange = this.getInProgressTxLocationRange();
        this.metadata.firstInProgressTransactionLocation = inProgressTxRange[0];
        tx.store(this.metadata.page, this.metadataMarshaller, true);
        final TreeSet<Integer> gcCandidateSet = new TreeSet<Integer>();
        if (cleanup) {
            int dataFileId;
            TreeSet<Integer> completeFileSet = new TreeSet<Integer>(this.journal.getFileMap().keySet());
            gcCandidateSet.addAll(completeFileSet);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Last update: " + lastUpdate + ", full gc candidates set: " + gcCandidateSet);
            }
            if (lastUpdate != null) {
                gcCandidateSet.removeAll(new TreeSet<Integer>(gcCandidateSet.tailSet(lastUpdate.getDataFileId())));
            }
            if (this.journalFilesBeingReplicated != null) {
                gcCandidateSet.removeAll(this.journalFilesBeingReplicated);
            }
            if (this.metadata.producerSequenceIdTrackerLocation != null) {
                dataFileId = this.metadata.producerSequenceIdTrackerLocation.getDataFileId();
                if (gcCandidateSet.contains(dataFileId) && gcCandidateSet.first() == dataFileId) {
                    this.metadata.producerSequenceIdTracker.setModified(true);
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("rewriting producerSequenceIdTracker:" + this.metadata.producerSequenceIdTrackerLocation);
                    }
                }
                gcCandidateSet.remove(dataFileId);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("gc candidates after producerSequenceIdTrackerLocation:" + this.metadata.producerSequenceIdTrackerLocation + ", " + gcCandidateSet);
                }
            }
            if (this.metadata.ackMessageFileMapLocation != null) {
                dataFileId = this.metadata.ackMessageFileMapLocation.getDataFileId();
                gcCandidateSet.remove(dataFileId);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("gc candidates after ackMessageFileMapLocation:" + this.metadata.ackMessageFileMapLocation + ", " + gcCandidateSet);
                }
            }
            if (inProgressTxRange[0] != null) {
                for (int pendingTx = inProgressTxRange[0].getDataFileId(); pendingTx <= inProgressTxRange[1].getDataFileId(); ++pendingTx) {
                    gcCandidateSet.remove(pendingTx);
                }
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("gc candidates after in progress tx range:" + Arrays.asList(inProgressTxRange) + ", " + gcCandidateSet);
            }
            for (Map.Entry<String, StoredDestination> entry : this.storedDestinations.entrySet()) {
                if (gcCandidateSet.isEmpty()) break;
                entry.getValue().locationIndex.visit(tx, new BTreeVisitor<Location, Long>(){
                    int last = -1;

                    @Override
                    public boolean isInterestedInKeysBetween(Location first, Location second) {
                        if (first == null) {
                            SortedSet<Integer> subset = gcCandidateSet.headSet(second.getDataFileId() + 1);
                            if (!subset.isEmpty() && subset.last().intValue() == second.getDataFileId()) {
                                subset.remove(second.getDataFileId());
                            }
                            return !subset.isEmpty();
                        }
                        if (second == null) {
                            SortedSet<Integer> subset = gcCandidateSet.tailSet(first.getDataFileId());
                            if (!subset.isEmpty() && subset.first().intValue() == first.getDataFileId()) {
                                subset.remove(first.getDataFileId());
                            }
                            return !subset.isEmpty();
                        }
                        SortedSet<Integer> subset = gcCandidateSet.subSet(first.getDataFileId(), second.getDataFileId() + 1);
                        if (!subset.isEmpty() && subset.first().intValue() == first.getDataFileId()) {
                            subset.remove(first.getDataFileId());
                        }
                        if (!subset.isEmpty() && subset.last().intValue() == second.getDataFileId()) {
                            subset.remove(second.getDataFileId());
                        }
                        return !subset.isEmpty();
                    }

                    @Override
                    public void visit(List<Location> keys, List<Long> values) {
                        for (Location l : keys) {
                            int fileId = l.getDataFileId();
                            if (this.last == fileId) continue;
                            gcCandidateSet.remove(fileId);
                            this.last = fileId;
                        }
                    }
                });
                if (entry.getValue().subLocations != null) {
                    Iterator<Map.Entry<String, Location>> iter = entry.getValue().subLocations.iterator(tx);
                    while (iter.hasNext()) {
                        Map.Entry<String, Location> subscription = iter.next();
                        int dataFileId2 = subscription.getValue().getDataFileId();
                        if (!gcCandidateSet.isEmpty() && gcCandidateSet.first() == dataFileId2) {
                            StoredDestination destination = entry.getValue();
                            String subscriptionKey = subscription.getKey();
                            SequenceSet pendingAcks = destination.ackPositions.get(tx, subscriptionKey);
                            if (pendingAcks == null || pendingAcks.isEmpty() || pendingAcks.size() == 1 && ((Sequence)pendingAcks.getTail()).range() == 1L) {
                                if (LOG.isTraceEnabled()) {
                                    LOG.trace("Found candidate for rewrite: {} from file {}", (Object)entry.getKey(), (Object)dataFileId2);
                                }
                                KahaSubscriptionCommand kahaSub = destination.subscriptions.get(tx, subscriptionKey);
                                destination.subLocations.put(tx, subscriptionKey, this.checkpointSubscriptionCommand(kahaSub));
                                continue;
                            }
                        }
                        gcCandidateSet.remove(dataFileId2);
                    }
                }
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace("gc candidates after dest:" + entry.getKey() + ", " + gcCandidateSet);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("gc candidates: " + gcCandidateSet);
                LOG.trace("ackMessageFileMap: " + this.metadata.ackMessageFileMap);
            }
            boolean ackMessageFileMapMod = false;
            Iterator<Integer> candidates = gcCandidateSet.iterator();
            while (candidates.hasNext()) {
                Integer candidate = candidates.next();
                Set<Integer> referencedFileIds = this.metadata.ackMessageFileMap.get(candidate);
                if (referencedFileIds == null) continue;
                for (Integer referencedFileId : referencedFileIds) {
                    if (!completeFileSet.contains(referencedFileId) || gcCandidateSet.contains(referencedFileId)) continue;
                    candidates.remove();
                    break;
                }
                if (gcCandidateSet.contains(candidate)) {
                    ackMessageFileMapMod |= this.metadata.ackMessageFileMap.remove(candidate) != null;
                    this.metadata.ackMessageFileMapDirtyFlag.lazySet(true);
                    continue;
                }
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace("not removing data file: " + candidate + " as contained ack(s) refer to referenced file: " + referencedFileIds);
            }
            if (!gcCandidateSet.isEmpty()) {
                LOG.debug("Cleanup removing the data files: {}", gcCandidateSet);
                for (Integer candidate : gcCandidateSet) {
                    for (Set<Integer> ackFiles : this.metadata.ackMessageFileMap.values()) {
                        ackMessageFileMapMod |= ackFiles.remove(candidate);
                        this.metadata.ackMessageFileMapDirtyFlag.lazySet(true);
                    }
                }
                if (ackMessageFileMapMod) {
                    this.checkpointUpdate(tx, false);
                }
            } else if (this.isEnableAckCompaction()) {
                if (++this.checkPointCyclesWithNoGC >= this.getCompactAcksAfterNoGC()) {
                    if (this.metadata.ackMessageFileMap.size() > 1 && (this.journalLogOnLastCompactionCheck == this.journal.getCurrentDataFileId() || this.isCompactAcksIgnoresStoreGrowth())) {
                        LOG.trace("No files GC'd checking if threshold to ACK compaction has been met.");
                        try {
                            this.scheduler.execute(new AckCompactionRunner());
                        }
                        catch (Exception ex) {
                            LOG.warn("Error on queueing the Ack Compactor", (Throwable)ex);
                        }
                    } else {
                        LOG.trace("Journal activity detected, no Ack compaction scheduled.");
                    }
                    this.checkPointCyclesWithNoGC = 0;
                } else {
                    LOG.trace("Not yet time to check for compaction: {} of {} cycles", (Object)this.checkPointCyclesWithNoGC, (Object)this.getCompactAcksAfterNoGC());
                }
                this.journalLogOnLastCompactionCheck = this.journal.getCurrentDataFileId();
            }
        }
        MDC.remove((String)"activemq.persistenceDir");
        LOG.debug("Checkpoint done.");
        return gcCandidateSet;
    }

    private void forwardAllAcks(Integer journalToRead, Set<Integer> journalLogsReferenced) throws IllegalStateException, IOException {
        LOG.trace("Attempting to move all acks in journal:{} to the front.", (Object)journalToRead);
        DataFile forwardsFile = this.journal.reserveDataFile();
        forwardsFile.setTypeCode(1);
        LOG.trace("Reserved file for forwarded acks: {}", (Object)forwardsFile);
        HashMap<Integer, Set<Integer>> updatedAckLocations = new HashMap<Integer, Set<Integer>>();
        try (TargetedDataFileAppender appender2 = new TargetedDataFileAppender(this.journal, forwardsFile);){
            KahaRewrittenDataFileCommand compactionMarker = new KahaRewrittenDataFileCommand();
            compactionMarker.setSourceDataFileId(journalToRead);
            compactionMarker.setRewriteType(forwardsFile.getTypeCode());
            ByteSequence payload = this.toByteSequence(compactionMarker);
            appender2.storeItem(payload, (byte)1, false);
            LOG.trace("Marked ack rewrites file as replacing file: {}", (Object)journalToRead);
            Location limit = new Location(journalToRead + 1, 0);
            Location nextLocation = this.getNextLocationForAckForward(new Location(journalToRead, 0), limit);
            while (nextLocation != null) {
                JournalCommand<?> command = null;
                try {
                    command = this.load(nextLocation);
                }
                catch (IOException ex) {
                    LOG.trace("Error loading command during ack forward: {}", (Object)nextLocation);
                }
                if (this.shouldForward(command)) {
                    payload = this.toByteSequence(command);
                    Location location = appender2.storeItem(payload, (byte)1, false);
                    updatedAckLocations.put(location.getDataFileId(), journalLogsReferenced);
                }
                nextLocation = this.getNextLocationForAckForward(nextLocation, limit);
            }
        }
        LOG.trace("ACKS forwarded, updates for ack locations: {}", updatedAckLocations);
        this.indexLock.writeLock().lock();
        for (Map.Entry entry : updatedAckLocations.entrySet()) {
            Set<Integer> referenceFileIds = this.metadata.ackMessageFileMap.get(entry.getKey());
            if (referenceFileIds == null) {
                referenceFileIds = new HashSet<Integer>();
                referenceFileIds.addAll((Collection)entry.getValue());
                this.metadata.ackMessageFileMap.put((Integer)entry.getKey(), referenceFileIds);
                this.metadata.ackMessageFileMapDirtyFlag.lazySet(true);
                continue;
            }
            referenceFileIds.addAll((Collection)entry.getValue());
        }
        this.metadata.ackMessageFileMap.remove(journalToRead);
        this.metadata.ackMessageFileMapDirtyFlag.lazySet(true);
        this.indexLock.writeLock().unlock();
        LOG.trace("ACK File Map following updates: {}", this.metadata.ackMessageFileMap);
    }

    private boolean shouldForward(JournalCommand<?> command) {
        boolean result = false;
        if (command != null) {
            KahaCommitCommand kahaCommitCommand;
            if (command instanceof KahaRemoveMessageCommand) {
                result = true;
            } else if (command instanceof KahaCommitCommand && (kahaCommitCommand = (KahaCommitCommand)command).hasTransactionInfo() && kahaCommitCommand.getTransactionInfo().hasXaTransactionId()) {
                result = true;
            }
        }
        return result;
    }

    private Location getNextLocationForAckForward(Location nextLocation, Location limit) {
        Location location;
        block2: {
            location = null;
            try {
                location = this.journal.getNextLocation(nextLocation, limit);
            }
            catch (IOException e) {
                LOG.warn("Failed to load next journal location after: {}, reason: {}", (Object)nextLocation, (Object)e);
                if (!LOG.isDebugEnabled()) break block2;
                LOG.debug("Failed to load next journal location after: {}", (Object)nextLocation, (Object)e);
            }
        }
        return location;
    }

    private Location checkpointProducerAudit() throws IOException {
        if (this.metadata.producerSequenceIdTracker == null || this.metadata.producerSequenceIdTracker.modified()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oout = new ObjectOutputStream(baos);
            oout.writeObject(this.metadata.producerSequenceIdTracker);
            oout.flush();
            oout.close();
            Location location = this.store((JournalCommand)new KahaProducerAuditCommand().setAudit(new Buffer(baos.toByteArray())), this.nullCompletionCallback);
            try {
                location.getLatch().await();
                if (location.getException().get() != null) {
                    throw location.getException().get();
                }
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException(e.toString());
            }
            return location;
        }
        return this.metadata.producerSequenceIdTrackerLocation;
    }

    private Location checkpointAckMessageFileMap() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oout = new ObjectOutputStream(baos);
        oout.writeObject(this.metadata.ackMessageFileMap);
        oout.flush();
        oout.close();
        Location location = this.store((JournalCommand)new KahaAckMessageFileMapCommand().setAckMessageFileMap(new Buffer(baos.toByteArray())), this.nullCompletionCallback);
        try {
            location.getLatch().await();
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException(e.toString());
        }
        return location;
    }

    private Location checkpointSubscriptionCommand(KahaSubscriptionCommand subscription) throws IOException {
        ByteSequence sequence = this.toByteSequence(subscription);
        Location location = this.journal.write(sequence, this.nullCompletionCallback);
        try {
            location.getLatch().await();
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException(e.toString());
        }
        return location;
    }

    public HashSet<Integer> getJournalFilesBeingReplicated() {
        return this.journalFilesBeingReplicated;
    }

    protected StoredDestination getStoredDestination(KahaDestination destination, Transaction tx) throws IOException {
        String key = this.key(destination);
        StoredDestination rc = this.storedDestinations.get(key);
        if (rc == null) {
            boolean topic = destination.getType() == KahaDestination.DestinationType.TOPIC || destination.getType() == KahaDestination.DestinationType.TEMP_TOPIC;
            rc = this.loadStoredDestination(tx, key, topic);
            this.storedDestinations.put(key, rc);
        }
        return rc;
    }

    protected StoredDestination getExistingStoredDestination(KahaDestination destination, Transaction tx) throws IOException {
        String key = this.key(destination);
        StoredDestination rc = this.storedDestinations.get(key);
        if (rc == null && this.metadata.destinations.containsKey(tx, key)) {
            rc = this.getStoredDestination(destination, tx);
        }
        return rc;
    }

    private StoredDestination loadStoredDestination(Transaction tx, String key, boolean topic) throws IOException {
        Map.Entry<Object, Object> entry;
        Iterator<Map.Entry<Object, Object>> iterator;
        StoredDestination rc = this.metadata.destinations.get(tx, key);
        if (rc == null) {
            rc = new StoredDestination();
            rc.orderIndex.allocate(tx);
            rc.locationIndex = new BTreeIndex(this.pageFile, tx.allocate());
            rc.messageIdIndex = new BTreeIndex(this.pageFile, tx.allocate());
            if (topic) {
                rc.subscriptions = new BTreeIndex(this.pageFile, tx.allocate());
                rc.subscriptionAcks = new BTreeIndex(this.pageFile, tx.allocate());
                rc.ackPositions = new ListIndex(this.pageFile, tx.allocate());
                rc.subLocations = new ListIndex(this.pageFile, tx.allocate());
            }
            this.metadata.destinations.put(tx, key, rc);
        }
        rc.orderIndex.load(tx);
        rc.orderIndex.configureLast(tx);
        rc.locationIndex.setKeyMarshaller(new LocationSizeMarshaller());
        rc.locationIndex.setValueMarshaller(LongMarshaller.INSTANCE);
        rc.locationIndex.load(tx);
        rc.messageIdIndex.setKeyMarshaller(StringMarshaller.INSTANCE);
        rc.messageIdIndex.setValueMarshaller(LongMarshaller.INSTANCE);
        rc.messageIdIndex.load(tx);
        if (this.metadata.version < 6) {
            iterator = rc.locationIndex.iterator(tx);
            while (iterator.hasNext()) {
                entry = iterator.next();
                rc.locationIndex.put(tx, entry.getKey(), entry.getValue());
            }
            iterator = rc.orderIndex.iterator(tx);
            while (iterator.hasNext()) {
                entry = iterator.next();
                rc.orderIndex.get(tx, (Long)entry.getKey());
                rc.orderIndex.put(tx, rc.orderIndex.lastGetPriority(), (Long)entry.getKey(), (MessageKeys)entry.getValue());
            }
        }
        if (topic) {
            rc.subscriptions.setKeyMarshaller(StringMarshaller.INSTANCE);
            rc.subscriptions.setValueMarshaller(KahaSubscriptionCommandMarshaller.INSTANCE);
            rc.subscriptions.load(tx);
            rc.subscriptionAcks.setKeyMarshaller(StringMarshaller.INSTANCE);
            rc.subscriptionAcks.setValueMarshaller(new LastAckMarshaller());
            rc.subscriptionAcks.load(tx);
            rc.ackPositions.setKeyMarshaller(StringMarshaller.INSTANCE);
            rc.ackPositions.setValueMarshaller(SequenceSet.Marshaller.INSTANCE);
            rc.ackPositions.load(tx);
            rc.subLocations.setKeyMarshaller(StringMarshaller.INSTANCE);
            rc.subLocations.setValueMarshaller(LocationMarshaller.INSTANCE);
            rc.subLocations.load(tx);
            rc.subscriptionCursors = new HashMap();
            if (this.metadata.version < 3) {
                iterator = rc.subscriptionAcks.iterator(tx);
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    Iterator<Map.Entry<Long, MessageKeys>> orderIterator = rc.orderIndex.iterator(tx, new MessageOrderCursor(((LastAck)entry.getValue()).lastAckedSequence));
                    while (orderIterator.hasNext()) {
                        Long sequence = orderIterator.next().getKey();
                        this.addAckLocation(tx, rc, sequence, (String)entry.getKey());
                    }
                    rc.subscriptionAcks.put(tx, (String)entry.getKey(), (LastAck)entry.getValue());
                }
            }
            iterator = rc.subscriptionAcks.iterator(tx);
            while (iterator.hasNext()) {
                entry = iterator.next();
                rc.subscriptionCache.add((String)entry.getKey());
            }
            if (rc.orderIndex.nextMessageId == 0L) {
                if (!rc.subscriptionAcks.isEmpty(tx)) {
                    iterator = rc.subscriptionAcks.iterator(tx);
                    while (iterator.hasNext()) {
                        entry = iterator.next();
                        rc.orderIndex.nextMessageId = Math.max(rc.orderIndex.nextMessageId, ((LastAck)entry.getValue()).lastAckedSequence + 1L);
                    }
                }
            } else {
                Iterator<Map.Entry<String, SequenceSet>> subscriptions = rc.ackPositions.iterator(tx);
                while (subscriptions.hasNext()) {
                    Map.Entry<String, SequenceSet> subscription = subscriptions.next();
                    SequenceSet pendingAcks = subscription.getValue();
                    if (pendingAcks == null || pendingAcks.isEmpty()) continue;
                    for (Long sequenceId : pendingAcks) {
                        rc.orderIndex.nextMessageId = Math.max(rc.orderIndex.nextMessageId, sequenceId);
                    }
                }
            }
        }
        if (this.metadata.version < 6) {
            this.metadata.destinations.put(tx, key, rc);
        }
        return rc;
    }

    protected void clearStoreStats(KahaDestination kahaDestination) {
        String key = this.key(kahaDestination);
        MessageStoreStatistics storeStats = this.getStoreStats(key);
        MessageStoreSubscriptionStatistics subStats = this.getSubStats(key);
        if (storeStats != null) {
            storeStats.reset();
        }
        if (subStats != null) {
            subStats.reset();
        }
    }

    protected void incrementAndAddSizeToStoreStat(KahaDestination kahaDestination, long size2) {
        this.incrementAndAddSizeToStoreStat(this.key(kahaDestination), size2);
    }

    protected void incrementAndAddSizeToStoreStat(String kahaDestKey, long size2) {
        MessageStoreStatistics storeStats = this.getStoreStats(kahaDestKey);
        if (storeStats != null) {
            storeStats.getMessageCount().increment();
            if (size2 > 0L) {
                storeStats.getMessageSize().addSize(size2);
            }
        }
    }

    protected void decrementAndSubSizeToStoreStat(KahaDestination kahaDestination, long size2) {
        this.decrementAndSubSizeToStoreStat(this.key(kahaDestination), size2);
    }

    protected void decrementAndSubSizeToStoreStat(String kahaDestKey, long size2) {
        MessageStoreStatistics storeStats = this.getStoreStats(kahaDestKey);
        if (storeStats != null) {
            storeStats.getMessageCount().decrement();
            if (size2 > 0L) {
                storeStats.getMessageSize().addSize(-size2);
            }
        }
    }

    protected void incrementAndAddSizeToStoreStat(KahaDestination kahaDestination, String subKey, long size2) {
        this.incrementAndAddSizeToStoreStat(this.key(kahaDestination), subKey, size2);
    }

    protected void incrementAndAddSizeToStoreStat(String kahaDestKey, String subKey, long size2) {
        MessageStoreSubscriptionStatistics subStats;
        if (this.enableSubscriptionStatistics && (subStats = this.getSubStats(kahaDestKey)) != null && subKey != null) {
            subStats.getMessageCount(subKey).increment();
            if (size2 > 0L) {
                subStats.getMessageSize(subKey).addSize(size2);
            }
        }
    }

    protected void decrementAndSubSizeToStoreStat(String kahaDestKey, String subKey, long size2) {
        MessageStoreSubscriptionStatistics subStats;
        if (this.enableSubscriptionStatistics && (subStats = this.getSubStats(kahaDestKey)) != null && subKey != null) {
            subStats.getMessageCount(subKey).decrement();
            if (size2 > 0L) {
                subStats.getMessageSize(subKey).addSize(-size2);
            }
        }
    }

    protected void decrementAndSubSizeToStoreStat(KahaDestination kahaDestination, String subKey, long size2) {
        this.decrementAndSubSizeToStoreStat(this.key(kahaDestination), subKey, size2);
    }

    protected MessageStoreStatistics getStoreStats(String kahaDestKey) {
        MessageStoreStatistics storeStats = null;
        try {
            MessageStore messageStore = (MessageStore)this.storeCache.get(kahaDestKey);
            if (messageStore != null) {
                storeStats = messageStore.getMessageStoreStatistics();
            }
        }
        catch (Exception e1) {
            LOG.error("Getting size counter of destination failed", (Throwable)e1);
        }
        return storeStats;
    }

    protected MessageStoreSubscriptionStatistics getSubStats(String kahaDestKey) {
        MessageStoreSubscriptionStatistics subStats = null;
        try {
            MessageStore messageStore = (MessageStore)this.storeCache.get(kahaDestKey);
            if (messageStore instanceof TopicMessageStore) {
                subStats = ((TopicMessageStore)messageStore).getMessageStoreSubStatistics();
            }
        }
        catch (Exception e1) {
            LOG.error("Getting size counter of destination failed", (Throwable)e1);
        }
        return subStats;
    }

    protected boolean matchType(Destination destination, KahaDestination.DestinationType type) {
        if (destination instanceof Topic && type.equals((Object)KahaDestination.DestinationType.TOPIC)) {
            return true;
        }
        return destination instanceof Queue && type.equals((Object)KahaDestination.DestinationType.QUEUE);
    }

    private void addAckLocation(Transaction tx, StoredDestination sd, Long messageSequence, String subscriptionKey) throws IOException {
        SequenceSet sequences = sd.ackPositions.get(tx, subscriptionKey);
        if (sequences == null) {
            sequences = new SequenceSet();
            sequences.add(messageSequence);
            sd.ackPositions.add(tx, subscriptionKey, sequences);
        } else {
            sequences.add(messageSequence);
            sd.ackPositions.put(tx, subscriptionKey, sequences);
        }
    }

    private void addAckLocationForRetroactiveSub(Transaction tx, StoredDestination sd, String subscriptionKey) throws IOException {
        SequenceSet allOutstanding = new SequenceSet();
        Iterator<Map.Entry<String, SequenceSet>> iterator = sd.ackPositions.iterator(tx);
        while (iterator.hasNext()) {
            SequenceSet set2 = iterator.next().getValue();
            for (Long entry : set2) {
                allOutstanding.add(entry);
            }
        }
        sd.ackPositions.put(tx, subscriptionKey, allOutstanding);
    }

    private void addAckLocationForNewMessage(Transaction tx, KahaDestination kahaDest, StoredDestination sd, Long messageSequence) throws IOException {
        for (String subscriptionKey : sd.subscriptionCache) {
            SequenceSet sequences = sd.ackPositions.get(tx, subscriptionKey);
            if (sequences == null) {
                sequences = new SequenceSet();
                sequences.add(new Sequence(messageSequence, messageSequence + 1L));
                sd.ackPositions.add(tx, subscriptionKey, sequences);
            } else {
                sequences.add(new Sequence(messageSequence, messageSequence + 1L));
                sd.ackPositions.put(tx, subscriptionKey, sequences);
            }
            MessageKeys key = sd.orderIndex.get(tx, messageSequence);
            this.incrementAndAddSizeToStoreStat(kahaDest, subscriptionKey, (long)key.location.getSize());
        }
    }

    private void removeAckLocationsForSub(KahaSubscriptionCommand command, Transaction tx, StoredDestination sd, String subscriptionKey) throws IOException {
        if (!sd.ackPositions.isEmpty(tx)) {
            SequenceSet sequences = sd.ackPositions.remove(tx, subscriptionKey);
            if (sequences == null || sequences.isEmpty()) {
                return;
            }
            ArrayList<Long> unreferenced = new ArrayList<Long>();
            for (Long sequenceId : sequences) {
                if (this.isSequenceReferenced(tx, sd, sequenceId)) continue;
                unreferenced.add(sequenceId);
            }
            for (Long sequenceId : unreferenced) {
                ArrayList<Map.Entry<Long, MessageKeys>> deletes = new ArrayList<Map.Entry<Long, MessageKeys>>();
                sd.orderIndex.getDeleteList(tx, deletes, sequenceId);
                for (Map.Entry<Long, MessageKeys> entry : deletes) {
                    sd.locationIndex.remove(tx, entry.getValue().location);
                    sd.messageIdIndex.remove(tx, entry.getValue().messageId);
                    sd.orderIndex.remove(tx, entry.getKey());
                    this.decrementAndSubSizeToStoreStat(command.getDestination(), (long)entry.getValue().location.getSize());
                }
            }
        }
    }

    private boolean isSequenceReferenced(Transaction tx, StoredDestination sd, Long sequenceId) throws IOException {
        for (String subscriptionKey : sd.subscriptionCache) {
            SequenceSet sequence = sd.ackPositions.get(tx, subscriptionKey);
            if (sequence == null || !sequence.contains(sequenceId)) continue;
            return true;
        }
        return false;
    }

    private void removeAckLocation(KahaRemoveMessageCommand command, Transaction tx, StoredDestination sd, String subscriptionKey, Long messageSequence) throws IOException {
        SequenceSet range;
        if (messageSequence != null && (range = sd.ackPositions.get(tx, subscriptionKey)) != null && !range.isEmpty()) {
            range.remove(messageSequence);
            if (!range.isEmpty()) {
                sd.ackPositions.put(tx, subscriptionKey, range);
            } else {
                sd.ackPositions.remove(tx, subscriptionKey);
            }
            MessageKeys key = sd.orderIndex.get(tx, messageSequence);
            this.decrementAndSubSizeToStoreStat(command.getDestination(), subscriptionKey, (long)key.location.getSize());
            if (this.isSequenceReferenced(tx, sd, messageSequence)) {
                return;
            }
            ArrayList<Map.Entry<Long, MessageKeys>> deletes = new ArrayList<Map.Entry<Long, MessageKeys>>();
            sd.orderIndex.getDeleteList(tx, deletes, messageSequence);
            for (Map.Entry<Long, MessageKeys> entry : deletes) {
                sd.locationIndex.remove(tx, entry.getValue().location);
                sd.messageIdIndex.remove(tx, entry.getValue().messageId);
                sd.orderIndex.remove(tx, entry.getKey());
                this.decrementAndSubSizeToStoreStat(command.getDestination(), (long)entry.getValue().location.getSize());
            }
        }
    }

    public LastAck getLastAck(Transaction tx, StoredDestination sd, String subscriptionKey) throws IOException {
        return sd.subscriptionAcks.get(tx, subscriptionKey);
    }

    protected SequenceSet getSequenceSet(Transaction tx, StoredDestination sd, String subscriptionKey) throws IOException {
        if (sd.ackPositions != null) {
            SequenceSet messageSequences = sd.ackPositions.get(tx, subscriptionKey);
            return messageSequences;
        }
        return null;
    }

    protected long getStoredMessageCount(Transaction tx, StoredDestination sd, String subscriptionKey) throws IOException {
        SequenceSet messageSequences;
        if (sd.ackPositions != null && (messageSequences = sd.ackPositions.get(tx, subscriptionKey)) != null) {
            long result = messageSequences.rangeSize();
            return result > 0L ? result - 1L : 0L;
        }
        return 0L;
    }

    protected Map<String, AtomicLong> getStoredMessageSize(Transaction tx, StoredDestination sd, List<String> subscriptionKeys) throws IOException {
        HashMap<String, AtomicLong> subPendingMessageSizes = new HashMap<String, AtomicLong>();
        HashMap<String, SequenceSet> messageSequencesMap = new HashMap<String, SequenceSet>();
        if (sd.ackPositions != null) {
            Long recoveryPosition = null;
            for (String subscriptionKey : subscriptionKeys) {
                subPendingMessageSizes.put(subscriptionKey, new AtomicLong());
                SequenceSet messageSequences = sd.ackPositions.get(tx, subscriptionKey);
                if (messageSequences == null || messageSequences.isEmpty()) continue;
                long head = ((Sequence)messageSequences.getHead()).getFirst();
                recoveryPosition = recoveryPosition != null ? Math.min(recoveryPosition, head) : head;
                messageSequencesMap.put(subscriptionKey, messageSequences);
            }
            recoveryPosition = recoveryPosition != null ? recoveryPosition : 0L;
            Iterator<Map.Entry<Long, MessageKeys>> iterator = sd.orderIndex.iterator(tx, new MessageOrderCursor(recoveryPosition));
            while (iterator.hasNext()) {
                Map.Entry<Long, MessageKeys> messageEntry = iterator.next();
                for (Map.Entry seqEntry : messageSequencesMap.entrySet()) {
                    String subscriptionKey = (String)seqEntry.getKey();
                    SequenceSet messageSequences = (SequenceSet)messageSequencesMap.get(subscriptionKey);
                    if (!messageSequences.contains(messageEntry.getKey())) continue;
                    ((AtomicLong)subPendingMessageSizes.get(subscriptionKey)).addAndGet(messageEntry.getValue().location.getSize());
                }
            }
        }
        return subPendingMessageSizes;
    }

    protected long getStoredMessageSize(Transaction tx, StoredDestination sd, String subscriptionKey) throws IOException {
        SequenceSet messageSequences;
        long locationSize = 0L;
        if (sd.ackPositions != null && (messageSequences = sd.ackPositions.get(tx, subscriptionKey)) != null && !messageSequences.isEmpty()) {
            boolean contiguousRange;
            Sequence head = (Sequence)messageSequences.getHead();
            Iterator<Map.Entry<Long, MessageKeys>> iterator = sd.orderIndex.iterator(tx, new MessageOrderCursor(head.getFirst()));
            boolean bl = contiguousRange = messageSequences.size() == 1;
            while (iterator.hasNext()) {
                Map.Entry<Long, MessageKeys> entry = iterator.next();
                if (!contiguousRange && !messageSequences.contains(entry.getKey())) continue;
                locationSize += (long)entry.getValue().location.getSize();
            }
        }
        return locationSize;
    }

    protected String key(KahaDestination destination) {
        return destination.getType().getNumber() + ":" + destination.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trackRecoveredAcks(ArrayList<MessageAck> acks) {
        this.indexLock.writeLock().lock();
        try {
            for (MessageAck ack : acks) {
                this.ackedAndPrepared.add(ack.getLastMessageId().toProducerKey());
            }
        }
        finally {
            this.indexLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forgetRecoveredAcks(ArrayList<MessageAck> acks, boolean rollback2) throws IOException {
        if (acks != null) {
            this.indexLock.writeLock().lock();
            try {
                for (MessageAck ack : acks) {
                    String id = ack.getLastMessageId().toProducerKey();
                    this.ackedAndPrepared.remove(id);
                    if (!rollback2) continue;
                    this.rolledBackAcks.add(id);
                }
            }
            finally {
                this.indexLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Operation> getInflightTx(KahaTransactionInfo info) {
        List<Operation<Object>> tx;
        TransactionId key = TransactionIdConversion.convert(info);
        LinkedHashMap<TransactionId, List<Operation>> linkedHashMap = this.inflightTransactions;
        synchronized (linkedHashMap) {
            tx = this.inflightTransactions.get(key);
            if (tx == null) {
                tx = Collections.synchronizedList(new ArrayList());
                this.inflightTransactions.put(key, tx);
            }
        }
        return tx;
    }

    private TransactionId key(KahaTransactionInfo transactionInfo) {
        return TransactionIdConversion.convert(transactionInfo);
    }

    private PageFile createPageFile() throws IOException {
        if (this.indexDirectory == null) {
            this.indexDirectory = this.directory;
        }
        IOHelper.mkdirs(this.indexDirectory);
        PageFile index = new PageFile(this.indexDirectory, "db");
        index.setEnableWriteThread(this.isEnableIndexWriteAsync());
        index.setWriteBatchSize(this.getIndexWriteBatchSize());
        index.setPageCacheSize(this.indexCacheSize);
        index.setUseLFRUEviction(this.isUseIndexLFRUEviction());
        index.setLFUEvictionFactor(this.getIndexLFUEvictionFactor());
        index.setEnableDiskSyncs(this.isEnableIndexDiskSyncs());
        index.setEnableRecoveryFile(this.isEnableIndexRecoveryFile());
        index.setEnablePageCaching(this.isEnableIndexPageCaching());
        return index;
    }

    protected Journal createJournal() throws IOException {
        Journal manager = new Journal();
        manager.setDirectory(this.directory);
        manager.setMaxFileLength(this.getJournalMaxFileLength());
        manager.setCheckForCorruptionOnStartup(this.checkForCorruptJournalFiles);
        manager.setChecksum(this.checksumJournalFiles || this.checkForCorruptJournalFiles);
        manager.setWriteBatchSize(this.getJournalMaxWriteBatchSize());
        manager.setArchiveDataLogs(this.isArchiveDataLogs());
        manager.setSizeAccumulator(this.journalSize);
        manager.setEnableAsyncDiskSync(this.isEnableJournalDiskSyncs());
        manager.setPreallocationScope(Journal.PreallocationScope.valueOf(this.preallocationScope.trim().toUpperCase()));
        manager.setPreallocationStrategy(Journal.PreallocationStrategy.valueOf(this.preallocationStrategy.trim().toUpperCase()));
        manager.setJournalDiskSyncStrategy(this.journalDiskSyncStrategy);
        if (this.getDirectoryArchive() != null) {
            IOHelper.mkdirs(this.getDirectoryArchive());
            manager.setDirectoryArchive(this.getDirectoryArchive());
        }
        return manager;
    }

    private Metadata createMetadata() {
        Metadata md = new Metadata();
        md.producerSequenceIdTracker.setAuditDepth(this.getFailoverProducersAuditDepth());
        md.producerSequenceIdTracker.setMaximumNumberOfProducersToTrack(this.getMaxFailoverProducersToTrack());
        return md;
    }

    protected abstract void configureMetadata();

    public int getJournalMaxWriteBatchSize() {
        return this.journalMaxWriteBatchSize;
    }

    public void setJournalMaxWriteBatchSize(int journalMaxWriteBatchSize) {
        this.journalMaxWriteBatchSize = journalMaxWriteBatchSize;
    }

    public File getDirectory() {
        return this.directory;
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }

    public boolean isDeleteAllMessages() {
        return this.deleteAllMessages;
    }

    public void setDeleteAllMessages(boolean deleteAllMessages2) {
        this.deleteAllMessages = deleteAllMessages2;
    }

    public void setIndexWriteBatchSize(int setIndexWriteBatchSize) {
        this.setIndexWriteBatchSize = setIndexWriteBatchSize;
    }

    public int getIndexWriteBatchSize() {
        return this.setIndexWriteBatchSize;
    }

    public void setEnableIndexWriteAsync(boolean enableIndexWriteAsync) {
        this.enableIndexWriteAsync = enableIndexWriteAsync;
    }

    boolean isEnableIndexWriteAsync() {
        return this.enableIndexWriteAsync;
    }

    @Deprecated
    public boolean isEnableJournalDiskSyncs() {
        return this.journalDiskSyncStrategy == Journal.JournalDiskSyncStrategy.ALWAYS;
    }

    @Deprecated
    public void setEnableJournalDiskSyncs(boolean syncWrites) {
        this.journalDiskSyncStrategy = syncWrites ? Journal.JournalDiskSyncStrategy.ALWAYS : Journal.JournalDiskSyncStrategy.NEVER;
    }

    public Journal.JournalDiskSyncStrategy getJournalDiskSyncStrategyEnum() {
        return this.journalDiskSyncStrategy;
    }

    public String getJournalDiskSyncStrategy() {
        return this.journalDiskSyncStrategy.name();
    }

    public void setJournalDiskSyncStrategy(String journalDiskSyncStrategy) {
        this.journalDiskSyncStrategy = Journal.JournalDiskSyncStrategy.valueOf(journalDiskSyncStrategy.trim().toUpperCase());
    }

    public long getJournalDiskSyncInterval() {
        return this.journalDiskSyncInterval;
    }

    public void setJournalDiskSyncInterval(long journalDiskSyncInterval) {
        this.journalDiskSyncInterval = journalDiskSyncInterval;
    }

    public long getCheckpointInterval() {
        return this.checkpointInterval;
    }

    public void setCheckpointInterval(long checkpointInterval) {
        this.checkpointInterval = checkpointInterval;
    }

    public long getCleanupInterval() {
        return this.cleanupInterval;
    }

    public void setCleanupInterval(long cleanupInterval) {
        this.cleanupInterval = cleanupInterval;
    }

    public void setJournalMaxFileLength(int journalMaxFileLength) {
        this.journalMaxFileLength = journalMaxFileLength;
    }

    public int getJournalMaxFileLength() {
        return this.journalMaxFileLength;
    }

    public void setMaxFailoverProducersToTrack(int maxFailoverProducersToTrack) {
        this.metadata.producerSequenceIdTracker.setMaximumNumberOfProducersToTrack(maxFailoverProducersToTrack);
    }

    public int getMaxFailoverProducersToTrack() {
        return this.metadata.producerSequenceIdTracker.getMaximumNumberOfProducersToTrack();
    }

    public void setFailoverProducersAuditDepth(int failoverProducersAuditDepth) {
        this.metadata.producerSequenceIdTracker.setAuditDepth(failoverProducersAuditDepth);
    }

    public int getFailoverProducersAuditDepth() {
        return this.metadata.producerSequenceIdTracker.getAuditDepth();
    }

    public PageFile getPageFile() throws IOException {
        if (this.pageFile == null) {
            this.pageFile = this.createPageFile();
        }
        return this.pageFile;
    }

    public Journal getJournal() throws IOException {
        if (this.journal == null) {
            this.journal = this.createJournal();
        }
        return this.journal;
    }

    protected Metadata getMetadata() {
        return this.metadata;
    }

    public boolean isFailIfDatabaseIsLocked() {
        return this.failIfDatabaseIsLocked;
    }

    public void setFailIfDatabaseIsLocked(boolean failIfDatabaseIsLocked) {
        this.failIfDatabaseIsLocked = failIfDatabaseIsLocked;
    }

    public boolean isIgnoreMissingJournalfiles() {
        return this.ignoreMissingJournalfiles;
    }

    public void setIgnoreMissingJournalfiles(boolean ignoreMissingJournalfiles) {
        this.ignoreMissingJournalfiles = ignoreMissingJournalfiles;
    }

    public int getIndexCacheSize() {
        return this.indexCacheSize;
    }

    public void setIndexCacheSize(int indexCacheSize) {
        this.indexCacheSize = indexCacheSize;
    }

    public boolean isCheckForCorruptJournalFiles() {
        return this.checkForCorruptJournalFiles;
    }

    public void setCheckForCorruptJournalFiles(boolean checkForCorruptJournalFiles) {
        this.checkForCorruptJournalFiles = checkForCorruptJournalFiles;
    }

    public PurgeRecoveredXATransactionStrategy getPurgeRecoveredXATransactionStrategyEnum() {
        return this.purgeRecoveredXATransactionStrategy;
    }

    public String getPurgeRecoveredXATransactionStrategy() {
        return this.purgeRecoveredXATransactionStrategy.name();
    }

    public void setPurgeRecoveredXATransactionStrategy(String purgeRecoveredXATransactionStrategy) {
        this.purgeRecoveredXATransactionStrategy = PurgeRecoveredXATransactionStrategy.valueOf(purgeRecoveredXATransactionStrategy.trim().toUpperCase());
    }

    public boolean isChecksumJournalFiles() {
        return this.checksumJournalFiles;
    }

    public void setChecksumJournalFiles(boolean checksumJournalFiles) {
        this.checksumJournalFiles = checksumJournalFiles;
    }

    @Override
    public void setBrokerService(BrokerService brokerService) {
        this.brokerService = brokerService;
    }

    public boolean isArchiveDataLogs() {
        return this.archiveDataLogs;
    }

    public void setArchiveDataLogs(boolean archiveDataLogs) {
        this.archiveDataLogs = archiveDataLogs;
    }

    public File getDirectoryArchive() {
        return this.directoryArchive;
    }

    public void setDirectoryArchive(File directoryArchive) {
        this.directoryArchive = directoryArchive;
    }

    public boolean isArchiveCorruptedIndex() {
        return this.archiveCorruptedIndex;
    }

    public void setArchiveCorruptedIndex(boolean archiveCorruptedIndex) {
        this.archiveCorruptedIndex = archiveCorruptedIndex;
    }

    public float getIndexLFUEvictionFactor() {
        return this.indexLFUEvictionFactor;
    }

    public void setIndexLFUEvictionFactor(float indexLFUEvictionFactor) {
        this.indexLFUEvictionFactor = indexLFUEvictionFactor;
    }

    public boolean isUseIndexLFRUEviction() {
        return this.useIndexLFRUEviction;
    }

    public void setUseIndexLFRUEviction(boolean useIndexLFRUEviction) {
        this.useIndexLFRUEviction = useIndexLFRUEviction;
    }

    public void setEnableIndexDiskSyncs(boolean enableIndexDiskSyncs) {
        this.enableIndexDiskSyncs = enableIndexDiskSyncs;
    }

    public void setEnableIndexRecoveryFile(boolean enableIndexRecoveryFile) {
        this.enableIndexRecoveryFile = enableIndexRecoveryFile;
    }

    public void setEnableIndexPageCaching(boolean enableIndexPageCaching) {
        this.enableIndexPageCaching = enableIndexPageCaching;
    }

    public boolean isEnableIndexDiskSyncs() {
        return this.enableIndexDiskSyncs;
    }

    public boolean isEnableIndexRecoveryFile() {
        return this.enableIndexRecoveryFile;
    }

    public boolean isEnableIndexPageCaching() {
        return this.enableIndexPageCaching;
    }

    public PersistenceAdapterStatistics getPersistenceAdapterStatistics() {
        return this.persistenceAdapterStatistics;
    }

    public File getIndexDirectory() {
        return this.indexDirectory;
    }

    public void setIndexDirectory(File indexDirectory) {
        this.indexDirectory = indexDirectory;
    }

    public String getPreallocationScope() {
        return this.preallocationScope;
    }

    public void setPreallocationScope(String preallocationScope) {
        this.preallocationScope = preallocationScope;
    }

    public String getPreallocationStrategy() {
        return this.preallocationStrategy;
    }

    public void setPreallocationStrategy(String preallocationStrategy) {
        this.preallocationStrategy = preallocationStrategy;
    }

    public int getCompactAcksAfterNoGC() {
        return this.compactAcksAfterNoGC;
    }

    public void setCompactAcksAfterNoGC(int compactAcksAfterNoGC) {
        this.compactAcksAfterNoGC = compactAcksAfterNoGC;
    }

    public boolean isCompactAcksIgnoresStoreGrowth() {
        return this.compactAcksIgnoresStoreGrowth;
    }

    public void setCompactAcksIgnoresStoreGrowth(boolean compactAcksIgnoresStoreGrowth) {
        this.compactAcksIgnoresStoreGrowth = compactAcksIgnoresStoreGrowth;
    }

    public boolean isEnableAckCompaction() {
        return this.enableAckCompaction;
    }

    public void setEnableAckCompaction(boolean enableAckCompaction) {
        this.enableAckCompaction = enableAckCompaction;
    }

    public boolean isEnableSubscriptionStatistics() {
        return this.enableSubscriptionStatistics;
    }

    public void setEnableSubscriptionStatistics(boolean enableSubscriptionStatistics) {
        this.enableSubscriptionStatistics = enableSubscriptionStatistics;
    }

    static interface IndexAware {
        public void sequenceAssignedWithIndexLocked(long var1);
    }

    private static class HashSetStringMarshaller
    extends VariableMarshaller<HashSet<String>> {
        static final HashSetStringMarshaller INSTANCE = new HashSetStringMarshaller();

        private HashSetStringMarshaller() {
        }

        @Override
        public void writePayload(HashSet<String> object, DataOutput dataOut) throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oout = new ObjectOutputStream(baos);
            oout.writeObject(object);
            oout.flush();
            oout.close();
            byte[] data = baos.toByteArray();
            dataOut.writeInt(data.length);
            dataOut.write(data);
        }

        @Override
        public HashSet<String> readPayload(DataInput dataIn) throws IOException {
            int dataLen = dataIn.readInt();
            byte[] data = new byte[dataLen];
            dataIn.readFully(data);
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            ObjectInputStream oin = new ObjectInputStream(bais);
            try {
                return (HashSet)oin.readObject();
            }
            catch (ClassNotFoundException cfe) {
                IOException ioe = new IOException("Failed to read HashSet<String>: " + cfe);
                ioe.initCause(cfe);
                throw ioe;
            }
        }
    }

    class MessageOrderIndex {
        static final byte HI = 9;
        static final byte LO = 0;
        static final byte DEF = 4;
        long nextMessageId;
        BTreeIndex<Long, MessageKeys> defaultPriorityIndex;
        BTreeIndex<Long, MessageKeys> lowPriorityIndex;
        BTreeIndex<Long, MessageKeys> highPriorityIndex;
        final MessageOrderCursor cursor;
        Long lastDefaultKey;
        Long lastHighKey;
        Long lastLowKey;
        byte lastGetPriority;
        final List<Long> pendingAdditions;
        final MessageKeysMarshaller messageKeysMarshaller;

        MessageOrderIndex() {
            this.cursor = new MessageOrderCursor();
            this.pendingAdditions = new LinkedList<Long>();
            this.messageKeysMarshaller = new MessageKeysMarshaller();
        }

        MessageKeys remove(Transaction tx, Long key) throws IOException {
            MessageKeys result = this.defaultPriorityIndex.remove(tx, key);
            if (result == null && this.highPriorityIndex != null && (result = this.highPriorityIndex.remove(tx, key)) == null && this.lowPriorityIndex != null) {
                result = this.lowPriorityIndex.remove(tx, key);
            }
            return result;
        }

        void load(Transaction tx) throws IOException {
            this.defaultPriorityIndex.setKeyMarshaller(LongMarshaller.INSTANCE);
            this.defaultPriorityIndex.setValueMarshaller(this.messageKeysMarshaller);
            this.defaultPriorityIndex.load(tx);
            this.lowPriorityIndex.setKeyMarshaller(LongMarshaller.INSTANCE);
            this.lowPriorityIndex.setValueMarshaller(this.messageKeysMarshaller);
            this.lowPriorityIndex.load(tx);
            this.highPriorityIndex.setKeyMarshaller(LongMarshaller.INSTANCE);
            this.highPriorityIndex.setValueMarshaller(this.messageKeysMarshaller);
            this.highPriorityIndex.load(tx);
        }

        void allocate(Transaction tx) throws IOException {
            this.defaultPriorityIndex = new BTreeIndex(MessageDatabase.this.pageFile, tx.allocate());
            if (MessageDatabase.this.metadata.version >= 2) {
                this.lowPriorityIndex = new BTreeIndex(MessageDatabase.this.pageFile, tx.allocate());
                this.highPriorityIndex = new BTreeIndex(MessageDatabase.this.pageFile, tx.allocate());
            }
        }

        void configureLast(Transaction tx) throws IOException {
            TreeSet<Long> orderedSet = new TreeSet<Long>();
            this.addLast(orderedSet, this.highPriorityIndex, tx);
            this.addLast(orderedSet, this.defaultPriorityIndex, tx);
            this.addLast(orderedSet, this.lowPriorityIndex, tx);
            if (!orderedSet.isEmpty()) {
                this.nextMessageId = orderedSet.last() + 1L;
            }
        }

        private void addLast(TreeSet<Long> orderedSet, BTreeIndex<Long, MessageKeys> index, Transaction tx) throws IOException {
            Map.Entry<Long, MessageKeys> lastEntry;
            if (index != null && (lastEntry = index.getLast(tx)) != null) {
                orderedSet.add(lastEntry.getKey());
            }
        }

        void clear(Transaction tx) throws IOException {
            this.remove(tx);
            this.resetCursorPosition();
            this.allocate(tx);
            this.load(tx);
            this.configureLast(tx);
        }

        void remove(Transaction tx) throws IOException {
            this.defaultPriorityIndex.clear(tx);
            this.defaultPriorityIndex.unload(tx);
            tx.free(this.defaultPriorityIndex.getPageId());
            if (this.lowPriorityIndex != null) {
                this.lowPriorityIndex.clear(tx);
                this.lowPriorityIndex.unload(tx);
                tx.free(this.lowPriorityIndex.getPageId());
            }
            if (this.highPriorityIndex != null) {
                this.highPriorityIndex.clear(tx);
                this.highPriorityIndex.unload(tx);
                tx.free(this.highPriorityIndex.getPageId());
            }
        }

        void resetCursorPosition() {
            this.cursor.reset();
            this.lastDefaultKey = null;
            this.lastHighKey = null;
            this.lastLowKey = null;
        }

        void setBatch(Transaction tx, Long sequence) throws IOException {
            if (sequence != null) {
                Long nextPosition = new Long(sequence + 1L);
                this.lastDefaultKey = sequence;
                this.cursor.defaultCursorPosition = nextPosition;
                this.lastHighKey = sequence;
                this.cursor.highPriorityCursorPosition = nextPosition;
                this.lastLowKey = sequence;
                this.cursor.lowPriorityCursorPosition = nextPosition;
            }
        }

        void setBatch(Transaction tx, LastAck last) throws IOException {
            this.setBatch(tx, last.lastAckedSequence);
            if (this.cursor.defaultCursorPosition == 0L && this.cursor.highPriorityCursorPosition == 0L && this.cursor.lowPriorityCursorPosition == 0L) {
                long next = last.lastAckedSequence + 1L;
                switch (last.priority) {
                    case 4: {
                        this.cursor.defaultCursorPosition = next;
                        this.cursor.highPriorityCursorPosition = next;
                        break;
                    }
                    case 9: {
                        this.cursor.highPriorityCursorPosition = next;
                        break;
                    }
                    case 0: {
                        this.cursor.lowPriorityCursorPosition = next;
                        this.cursor.defaultCursorPosition = next;
                        this.cursor.highPriorityCursorPosition = next;
                    }
                }
            }
        }

        void stoppedIterating() {
            if (this.lastDefaultKey != null) {
                this.cursor.defaultCursorPosition = this.lastDefaultKey + 1L;
            }
            if (this.lastHighKey != null) {
                this.cursor.highPriorityCursorPosition = this.lastHighKey + 1L;
            }
            if (this.lastLowKey != null) {
                this.cursor.lowPriorityCursorPosition = this.lastLowKey + 1L;
            }
            this.lastDefaultKey = null;
            this.lastHighKey = null;
            this.lastLowKey = null;
        }

        void getDeleteList(Transaction tx, ArrayList<Map.Entry<Long, MessageKeys>> deletes, Long sequenceId) throws IOException {
            if (this.defaultPriorityIndex.containsKey(tx, sequenceId)) {
                this.getDeleteList(tx, deletes, this.defaultPriorityIndex, sequenceId);
            } else if (this.highPriorityIndex != null && this.highPriorityIndex.containsKey(tx, sequenceId)) {
                this.getDeleteList(tx, deletes, this.highPriorityIndex, sequenceId);
            } else if (this.lowPriorityIndex != null && this.lowPriorityIndex.containsKey(tx, sequenceId)) {
                this.getDeleteList(tx, deletes, this.lowPriorityIndex, sequenceId);
            }
        }

        void getDeleteList(Transaction tx, ArrayList<Map.Entry<Long, MessageKeys>> deletes, BTreeIndex<Long, MessageKeys> index, Long sequenceId) throws IOException {
            Iterator<Map.Entry<Object, MessageKeys>> iterator = index.iterator(tx, sequenceId, null);
            deletes.add(iterator.next());
        }

        long getNextMessageId() {
            return this.nextMessageId++;
        }

        void revertNextMessageId() {
            --this.nextMessageId;
        }

        MessageKeys get(Transaction tx, Long key) throws IOException {
            MessageKeys result = this.defaultPriorityIndex.get(tx, key);
            if (result == null) {
                result = this.highPriorityIndex.get(tx, key);
                if (result == null) {
                    result = this.lowPriorityIndex.get(tx, key);
                    this.lastGetPriority = 0;
                } else {
                    this.lastGetPriority = (byte)9;
                }
            } else {
                this.lastGetPriority = (byte)4;
            }
            return result;
        }

        MessageKeys put(Transaction tx, int priority, Long key, MessageKeys value) throws IOException {
            if (priority == 4) {
                return this.defaultPriorityIndex.put(tx, key, value);
            }
            if (priority > 4) {
                return this.highPriorityIndex.put(tx, key, value);
            }
            return this.lowPriorityIndex.put(tx, key, value);
        }

        Iterator<Map.Entry<Long, MessageKeys>> iterator(Transaction tx) throws IOException {
            return new MessageOrderIterator(tx, this.cursor, this);
        }

        Iterator<Map.Entry<Long, MessageKeys>> iterator(Transaction tx, MessageOrderCursor m) throws IOException {
            return new MessageOrderIterator(tx, m, this);
        }

        public byte lastGetPriority() {
            return this.lastGetPriority;
        }

        public boolean alreadyDispatched(Long sequence) {
            return this.cursor.highPriorityCursorPosition > 0L && this.cursor.highPriorityCursorPosition >= sequence || this.cursor.defaultCursorPosition > 0L && this.cursor.defaultCursorPosition >= sequence || this.cursor.lowPriorityCursorPosition > 0L && this.cursor.lowPriorityCursorPosition >= sequence;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void trackPendingAdd(Long seq) {
            List<Long> list = this.pendingAdditions;
            synchronized (list) {
                this.pendingAdditions.add(seq);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void trackPendingAddComplete(Long seq) {
            List<Long> list = this.pendingAdditions;
            synchronized (list) {
                this.pendingAdditions.remove(seq);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Long minPendingAdd() {
            List<Long> list = this.pendingAdditions;
            synchronized (list) {
                if (!this.pendingAdditions.isEmpty()) {
                    return this.pendingAdditions.get(0);
                }
                return null;
            }
        }

        class MessageOrderIterator
        implements Iterator<Map.Entry<Long, MessageKeys>> {
            Iterator<Map.Entry<Long, MessageKeys>> currentIterator;
            final Iterator<Map.Entry<Long, MessageKeys>> highIterator;
            final Iterator<Map.Entry<Long, MessageKeys>> defaultIterator;
            final Iterator<Map.Entry<Long, MessageKeys>> lowIterator;

            MessageOrderIterator(Transaction tx, MessageOrderCursor m, MessageOrderIndex messageOrderIndex) throws IOException {
                Long pendingAddLimiter = messageOrderIndex.minPendingAdd();
                this.defaultIterator = MessageOrderIndex.this.defaultPriorityIndex.iterator(tx, m.defaultCursorPosition, pendingAddLimiter);
                this.highIterator = MessageOrderIndex.this.highPriorityIndex != null ? MessageOrderIndex.this.highPriorityIndex.iterator(tx, m.highPriorityCursorPosition, pendingAddLimiter) : null;
                this.lowIterator = MessageOrderIndex.this.lowPriorityIndex != null ? MessageOrderIndex.this.lowPriorityIndex.iterator(tx, m.lowPriorityCursorPosition, pendingAddLimiter) : null;
            }

            @Override
            public boolean hasNext() {
                if (this.currentIterator == null) {
                    if (this.highIterator != null) {
                        if (this.highIterator.hasNext()) {
                            this.currentIterator = this.highIterator;
                            return this.currentIterator.hasNext();
                        }
                        if (this.defaultIterator.hasNext()) {
                            this.currentIterator = this.defaultIterator;
                            return this.currentIterator.hasNext();
                        }
                        if (this.lowIterator.hasNext()) {
                            this.currentIterator = this.lowIterator;
                            return this.currentIterator.hasNext();
                        }
                        return false;
                    }
                    this.currentIterator = this.defaultIterator;
                    return this.currentIterator.hasNext();
                }
                if (this.highIterator != null) {
                    if (this.currentIterator.hasNext()) {
                        return true;
                    }
                    if (this.currentIterator == this.highIterator) {
                        if (this.defaultIterator.hasNext()) {
                            this.currentIterator = this.defaultIterator;
                            return this.currentIterator.hasNext();
                        }
                        if (this.lowIterator.hasNext()) {
                            this.currentIterator = this.lowIterator;
                            return this.currentIterator.hasNext();
                        }
                        return false;
                    }
                    if (this.currentIterator == this.defaultIterator) {
                        if (this.lowIterator.hasNext()) {
                            this.currentIterator = this.lowIterator;
                            return this.currentIterator.hasNext();
                        }
                        return false;
                    }
                }
                return this.currentIterator.hasNext();
            }

            @Override
            public Map.Entry<Long, MessageKeys> next() {
                Map.Entry<Long, MessageKeys> result = this.currentIterator.next();
                if (result != null) {
                    Long key = result.getKey();
                    if (this.highIterator != null) {
                        if (this.currentIterator == this.defaultIterator) {
                            MessageOrderIndex.this.lastDefaultKey = key;
                        } else if (this.currentIterator == this.highIterator) {
                            MessageOrderIndex.this.lastHighKey = key;
                        } else {
                            MessageOrderIndex.this.lastLowKey = key;
                        }
                    } else {
                        MessageOrderIndex.this.lastDefaultKey = key;
                    }
                }
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    class MessageOrderCursor {
        long defaultCursorPosition;
        long lowPriorityCursorPosition;
        long highPriorityCursorPosition;

        MessageOrderCursor() {
        }

        MessageOrderCursor(long position) {
            this.defaultCursorPosition = position;
            this.lowPriorityCursorPosition = position;
            this.highPriorityCursorPosition = position;
        }

        MessageOrderCursor(MessageOrderCursor other) {
            this.defaultCursorPosition = other.defaultCursorPosition;
            this.lowPriorityCursorPosition = other.lowPriorityCursorPosition;
            this.highPriorityCursorPosition = other.highPriorityCursorPosition;
        }

        MessageOrderCursor copy() {
            return new MessageOrderCursor(this);
        }

        void reset() {
            this.defaultCursorPosition = 0L;
            this.highPriorityCursorPosition = 0L;
            this.lowPriorityCursorPosition = 0L;
        }

        void increment() {
            if (this.defaultCursorPosition != 0L) {
                ++this.defaultCursorPosition;
            }
            if (this.highPriorityCursorPosition != 0L) {
                ++this.highPriorityCursorPosition;
            }
            if (this.lowPriorityCursorPosition != 0L) {
                ++this.lowPriorityCursorPosition;
            }
        }

        public String toString() {
            return "MessageOrderCursor:[def:" + this.defaultCursorPosition + ", low:" + this.lowPriorityCursorPosition + ", high:" + this.highPriorityCursorPosition + "]";
        }

        public void sync(MessageOrderCursor other) {
            this.defaultCursorPosition = other.defaultCursorPosition;
            this.lowPriorityCursorPosition = other.lowPriorityCursorPosition;
            this.highPriorityCursorPosition = other.highPriorityCursorPosition;
        }
    }

    class RemoveOperation
    extends Operation<KahaRemoveMessageCommand> {
        public RemoveOperation(KahaRemoveMessageCommand command, Location location) {
            super(MessageDatabase.this, (JournalCommand)command, location);
        }

        @Override
        public void execute(Transaction tx) throws IOException {
            MessageDatabase.this.updateIndex(tx, (KahaRemoveMessageCommand)this.command, this.location);
        }
    }

    class AddOperation
    extends Operation<KahaAddMessageCommand> {
        final IndexAware runWithIndexLock;

        public AddOperation(KahaAddMessageCommand command, Location location, IndexAware runWithIndexLock) {
            super(MessageDatabase.this, (JournalCommand)command, location);
            this.runWithIndexLock = runWithIndexLock;
        }

        @Override
        public void execute(Transaction tx) throws IOException {
            long seq = MessageDatabase.this.updateIndex(tx, (KahaAddMessageCommand)this.command, this.location);
            if (this.runWithIndexLock != null) {
                this.runWithIndexLock.sequenceAssignedWithIndexLocked(seq);
            }
        }
    }

    static abstract class Operation<T extends JournalCommand<T>> {
        final T command;
        final Location location;
        final /* synthetic */ MessageDatabase this$0;

        public Operation(T command, Location location) {
            this.this$0 = this$0;
            this.command = command;
            this.location = location;
        }

        public Location getLocation() {
            return this.location;
        }

        public T getCommand() {
            return this.command;
        }

        public abstract void execute(Transaction var1) throws IOException;
    }

    class LocationSizeMarshaller
    implements Marshaller<Location> {
        @Override
        public Location readPayload(DataInput dataIn) throws IOException {
            Location rc = new Location();
            rc.setDataFileId(dataIn.readInt());
            rc.setOffset(dataIn.readInt());
            if (MessageDatabase.this.metadata.version >= 6) {
                rc.setSize(dataIn.readInt());
            }
            return rc;
        }

        @Override
        public void writePayload(Location object, DataOutput dataOut) throws IOException {
            dataOut.writeInt(object.getDataFileId());
            dataOut.writeInt(object.getOffset());
            dataOut.writeInt(object.getSize());
        }

        @Override
        public int getFixedSize() {
            return 12;
        }

        @Override
        public Location deepCopy(Location source) {
            return new Location(source);
        }

        @Override
        public boolean isDeepCopySupported() {
            return true;
        }
    }

    static class KahaSubscriptionCommandMarshaller
    extends VariableMarshaller<KahaSubscriptionCommand> {
        static final KahaSubscriptionCommandMarshaller INSTANCE = new KahaSubscriptionCommandMarshaller();

        KahaSubscriptionCommandMarshaller() {
        }

        @Override
        public KahaSubscriptionCommand readPayload(DataInput dataIn) throws IOException {
            KahaSubscriptionCommand rc = new KahaSubscriptionCommand();
            rc.mergeFramed((InputStream)((Object)dataIn));
            return rc;
        }

        @Override
        public void writePayload(KahaSubscriptionCommand object, DataOutput dataOut) throws IOException {
            object.writeFramed((OutputStream)((Object)dataOut));
        }
    }

    protected class StoredDestinationMarshaller
    extends VariableMarshaller<StoredDestination> {
        final MessageKeysMarshaller messageKeysMarshaller;

        protected StoredDestinationMarshaller() {
            this.messageKeysMarshaller = new MessageKeysMarshaller();
        }

        @Override
        public StoredDestination readPayload(final DataInput dataIn) throws IOException {
            final StoredDestination value = new StoredDestination();
            value.orderIndex.defaultPriorityIndex = new BTreeIndex(MessageDatabase.this.pageFile, dataIn.readLong());
            value.locationIndex = new BTreeIndex(MessageDatabase.this.pageFile, dataIn.readLong());
            value.messageIdIndex = new BTreeIndex(MessageDatabase.this.pageFile, dataIn.readLong());
            if (dataIn.readBoolean()) {
                value.subscriptions = new BTreeIndex(MessageDatabase.this.pageFile, dataIn.readLong());
                value.subscriptionAcks = new BTreeIndex(MessageDatabase.this.pageFile, dataIn.readLong());
                if (MessageDatabase.this.metadata.version >= 4) {
                    value.ackPositions = new ListIndex(MessageDatabase.this.pageFile, dataIn.readLong());
                } else {
                    MessageDatabase.this.pageFile.tx().execute(new Transaction.Closure<IOException>(){

                        @Override
                        public void execute(Transaction tx) throws IOException {
                            LinkedHashMap<String, SequenceSet> temp = new LinkedHashMap<String, SequenceSet>();
                            if (MessageDatabase.this.metadata.version >= 3) {
                                BTreeIndex<Long, HashSet<String>> oldAckPositions = new BTreeIndex<Long, HashSet<String>>(MessageDatabase.this.pageFile, dataIn.readLong());
                                oldAckPositions.setKeyMarshaller(LongMarshaller.INSTANCE);
                                oldAckPositions.setValueMarshaller(HashSetStringMarshaller.INSTANCE);
                                oldAckPositions.load(tx);
                                Iterator iterator = oldAckPositions.iterator(tx);
                                while (iterator.hasNext()) {
                                    Map.Entry entry = iterator.next();
                                    for (String subKey : (HashSet)entry.getValue()) {
                                        SequenceSet pendingAcks = (SequenceSet)temp.get(subKey);
                                        if (pendingAcks == null) {
                                            pendingAcks = new SequenceSet();
                                            temp.put(subKey, pendingAcks);
                                        }
                                        pendingAcks.add((Long)entry.getKey());
                                    }
                                }
                            }
                            value.ackPositions = new ListIndex(MessageDatabase.this.pageFile, tx.allocate());
                            value.ackPositions.setKeyMarshaller(StringMarshaller.INSTANCE);
                            value.ackPositions.setValueMarshaller(SequenceSet.Marshaller.INSTANCE);
                            value.ackPositions.load(tx);
                            for (String subscriptionKey : temp.keySet()) {
                                value.ackPositions.put(tx, subscriptionKey, (SequenceSet)temp.get(subscriptionKey));
                            }
                        }
                    });
                }
                if (MessageDatabase.this.metadata.version >= 5) {
                    value.subLocations = new ListIndex(MessageDatabase.this.pageFile, dataIn.readLong());
                } else {
                    MessageDatabase.this.pageFile.tx().execute(new Transaction.Closure<IOException>(){

                        @Override
                        public void execute(Transaction tx) throws IOException {
                            value.subLocations = new ListIndex(MessageDatabase.this.pageFile, tx.allocate());
                            value.subLocations.setKeyMarshaller(StringMarshaller.INSTANCE);
                            value.subLocations.setValueMarshaller(LocationMarshaller.INSTANCE);
                            value.subLocations.load(tx);
                        }
                    });
                }
            }
            if (MessageDatabase.this.metadata.version >= 2) {
                value.orderIndex.lowPriorityIndex = new BTreeIndex(MessageDatabase.this.pageFile, dataIn.readLong());
                value.orderIndex.highPriorityIndex = new BTreeIndex(MessageDatabase.this.pageFile, dataIn.readLong());
            } else {
                MessageDatabase.this.pageFile.tx().execute(new Transaction.Closure<IOException>(){

                    @Override
                    public void execute(Transaction tx) throws IOException {
                        value.orderIndex.lowPriorityIndex = new BTreeIndex(MessageDatabase.this.pageFile, tx.allocate());
                        value.orderIndex.lowPriorityIndex.setKeyMarshaller(LongMarshaller.INSTANCE);
                        value.orderIndex.lowPriorityIndex.setValueMarshaller(StoredDestinationMarshaller.this.messageKeysMarshaller);
                        value.orderIndex.lowPriorityIndex.load(tx);
                        value.orderIndex.highPriorityIndex = new BTreeIndex(MessageDatabase.this.pageFile, tx.allocate());
                        value.orderIndex.highPriorityIndex.setKeyMarshaller(LongMarshaller.INSTANCE);
                        value.orderIndex.highPriorityIndex.setValueMarshaller(StoredDestinationMarshaller.this.messageKeysMarshaller);
                        value.orderIndex.highPriorityIndex.load(tx);
                    }
                });
            }
            return value;
        }

        @Override
        public void writePayload(StoredDestination value, DataOutput dataOut) throws IOException {
            dataOut.writeLong(value.orderIndex.defaultPriorityIndex.getPageId());
            dataOut.writeLong(value.locationIndex.getPageId());
            dataOut.writeLong(value.messageIdIndex.getPageId());
            if (value.subscriptions != null) {
                dataOut.writeBoolean(true);
                dataOut.writeLong(value.subscriptions.getPageId());
                dataOut.writeLong(value.subscriptionAcks.getPageId());
                dataOut.writeLong(value.ackPositions.getHeadPageId());
                dataOut.writeLong(value.subLocations.getHeadPageId());
            } else {
                dataOut.writeBoolean(false);
            }
            dataOut.writeLong(value.orderIndex.lowPriorityIndex.getPageId());
            dataOut.writeLong(value.orderIndex.highPriorityIndex.getPageId());
        }
    }

    class StoredDestination {
        MessageOrderIndex orderIndex;
        BTreeIndex<Location, Long> locationIndex;
        BTreeIndex<String, Long> messageIdIndex;
        BTreeIndex<String, KahaSubscriptionCommand> subscriptions;
        BTreeIndex<String, LastAck> subscriptionAcks;
        HashMap<String, MessageOrderCursor> subscriptionCursors;
        ListIndex<String, SequenceSet> ackPositions;
        ListIndex<String, Location> subLocations;
        final HashSet<String> subscriptionCache;

        StoredDestination() {
            this.orderIndex = new MessageOrderIndex();
            this.subscriptionCache = new LinkedHashSet<String>();
        }

        public void trackPendingAdd(Long seq) {
            this.orderIndex.trackPendingAdd(seq);
        }

        public void trackPendingAddComplete(Long seq) {
            this.orderIndex.trackPendingAddComplete(seq);
        }

        public String toString() {
            return "nextSeq:" + this.orderIndex.nextMessageId + ",lastRet:" + this.orderIndex.cursor + ",pending:" + this.orderIndex.pendingAdditions.size();
        }
    }

    protected class LastAckMarshaller
    implements Marshaller<LastAck> {
        protected LastAckMarshaller() {
        }

        @Override
        public void writePayload(LastAck object, DataOutput dataOut) throws IOException {
            dataOut.writeLong(object.lastAckedSequence);
            dataOut.writeByte(object.priority);
        }

        @Override
        public LastAck readPayload(DataInput dataIn) throws IOException {
            LastAck lastAcked = new LastAck();
            lastAcked.lastAckedSequence = dataIn.readLong();
            if (MessageDatabase.this.metadata.version >= 3) {
                lastAcked.priority = dataIn.readByte();
            }
            return lastAcked;
        }

        @Override
        public int getFixedSize() {
            return 9;
        }

        @Override
        public LastAck deepCopy(LastAck source) {
            return new LastAck(source);
        }

        @Override
        public boolean isDeepCopySupported() {
            return true;
        }
    }

    class LastAck {
        long lastAckedSequence;
        byte priority;

        public LastAck(LastAck source) {
            this.lastAckedSequence = source.lastAckedSequence;
            this.priority = source.priority;
        }

        public LastAck() {
            this.priority = (byte)9;
        }

        public LastAck(long ackLocation) {
            this.lastAckedSequence = ackLocation;
            this.priority = 0;
        }

        public LastAck(long ackLocation, byte priority) {
            this.lastAckedSequence = ackLocation;
            this.priority = priority;
        }

        public String toString() {
            return "[" + this.lastAckedSequence + ":" + this.priority + "]";
        }
    }

    protected class MessageKeysMarshaller
    extends VariableMarshaller<MessageKeys> {
        final LocationSizeMarshaller locationSizeMarshaller;

        protected MessageKeysMarshaller() {
            this.locationSizeMarshaller = new LocationSizeMarshaller();
        }

        @Override
        public MessageKeys readPayload(DataInput dataIn) throws IOException {
            return new MessageKeys(dataIn.readUTF(), this.locationSizeMarshaller.readPayload(dataIn));
        }

        @Override
        public void writePayload(MessageKeys object, DataOutput dataOut) throws IOException {
            dataOut.writeUTF(object.messageId);
            this.locationSizeMarshaller.writePayload(object.location, dataOut);
        }
    }

    static class MessageKeys {
        final String messageId;
        final Location location;

        public MessageKeys(String messageId, Location location) {
            this.messageId = messageId;
            this.location = location;
        }

        public String toString() {
            return "[" + this.messageId + "," + this.location + "]";
        }
    }

    private final class AckCompactionRunner
    implements Runnable {
        private AckCompactionRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int journalToAdvance = -1;
            HashSet journalLogsReferenced = new HashSet();
            boolean forwarded = false;
            try {
                MessageDatabase.this.checkpointLock.readLock().lock();
                try {
                    MessageDatabase.this.indexLock.writeLock().lock();
                    ArrayList<Integer> journalFileIds = new ArrayList<Integer>(MessageDatabase.this.metadata.ackMessageFileMap.keySet());
                    Collections.sort(journalFileIds);
                    for (Integer journalFileId : journalFileIds) {
                        DataFile current = MessageDatabase.this.journal.getDataFileById(journalFileId);
                        if (current == null || current.getTypeCode() == 1) continue;
                        journalToAdvance = journalFileId;
                        break;
                    }
                    if (journalToAdvance == -1 || journalToAdvance == MessageDatabase.this.journal.getCurrentDataFileId()) {
                        return;
                    }
                    journalLogsReferenced.addAll(MessageDatabase.this.metadata.ackMessageFileMap.get(journalToAdvance));
                }
                finally {
                    MessageDatabase.this.indexLock.writeLock().unlock();
                }
                try {
                    MessageDatabase.this.forwardAllAcks(journalToAdvance, journalLogsReferenced);
                    forwarded = true;
                }
                catch (IOException ioe) {
                    LOG.error("Forwarding of acks failed", (Throwable)ioe);
                    MessageDatabase.this.brokerService.handleIOException(ioe);
                }
                catch (Throwable e) {
                    LOG.error("Forwarding of acks failed", e);
                    MessageDatabase.this.brokerService.handleIOException(IOExceptionSupport.create(e));
                }
            }
            finally {
                MessageDatabase.this.checkpointLock.readLock().unlock();
            }
            try {
                if (forwarded) {
                    MessageDatabase.this.checkpointUpdate(false);
                }
            }
            catch (IOException ioe) {
                LOG.error("Checkpoint failed", (Throwable)ioe);
                MessageDatabase.this.brokerService.handleIOException(ioe);
            }
            catch (Throwable e) {
                LOG.error("Checkpoint failed", e);
                MessageDatabase.this.brokerService.handleIOException(IOExceptionSupport.create(e));
            }
        }
    }

    class TranInfo {
        TransactionId id;
        Location location;
        HashMap<KahaDestination, opCount> destinationOpCount = new HashMap();

        TranInfo() {
        }

        public void track(Operation operation) {
            KahaDestination destination;
            if (this.location == null) {
                this.location = operation.getLocation();
            }
            boolean isAdd = false;
            if (operation instanceof AddOperation) {
                AddOperation add = (AddOperation)operation;
                destination = ((KahaAddMessageCommand)add.getCommand()).getDestination();
                isAdd = true;
            } else {
                RemoveOperation removeOpperation = (RemoveOperation)operation;
                destination = ((KahaRemoveMessageCommand)removeOpperation.getCommand()).getDestination();
            }
            opCount opCount2 = this.destinationOpCount.get(destination);
            if (opCount2 == null) {
                opCount2 = new opCount();
                this.destinationOpCount.put(destination, opCount2);
            }
            if (isAdd) {
                ++opCount2.add;
            } else {
                ++opCount2.remove;
            }
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.location).append(";").append(this.id).append(";\n");
            for (Map.Entry<KahaDestination, opCount> op : this.destinationOpCount.entrySet()) {
                buffer.append(op.getKey()).append('+').append(op.getValue().add).append(',').append('-').append(op.getValue().remove).append(';');
            }
            return buffer.toString();
        }

        class opCount {
            int add;
            int remove;

            opCount() {
            }
        }
    }

    private final class CheckpointRunner
    implements Runnable {
        private long lastCheckpoint = System.currentTimeMillis();
        private long lastCleanup = System.currentTimeMillis();
        private long lastSync = System.currentTimeMillis();
        private Location lastAsyncUpdate = null;

        private CheckpointRunner() {
        }

        @Override
        public void run() {
            try {
                if (MessageDatabase.this.opened.get()) {
                    long now = System.currentTimeMillis();
                    if (MessageDatabase.this.journal.isJournalDiskSyncPeriodic() && MessageDatabase.this.journalDiskSyncInterval > 0L && now - this.lastSync >= MessageDatabase.this.journalDiskSyncInterval) {
                        Location currentUpdate = MessageDatabase.this.lastAsyncJournalUpdate.get();
                        if (currentUpdate != null && !currentUpdate.equals(this.lastAsyncUpdate)) {
                            this.lastAsyncUpdate = currentUpdate;
                            if (LOG.isTraceEnabled()) {
                                LOG.trace("Writing trace command to trigger journal sync");
                            }
                            MessageDatabase.this.store(new KahaTraceCommand(), true, null, null);
                        }
                        this.lastSync = now;
                    }
                    if (MessageDatabase.this.cleanupInterval > 0L && now - this.lastCleanup >= MessageDatabase.this.cleanupInterval) {
                        MessageDatabase.this.checkpointCleanup(true);
                        this.lastCleanup = now;
                        this.lastCheckpoint = now;
                    } else if (MessageDatabase.this.checkpointInterval > 0L && now - this.lastCheckpoint >= MessageDatabase.this.checkpointInterval) {
                        MessageDatabase.this.checkpointCleanup(false);
                        this.lastCheckpoint = now;
                    }
                }
            }
            catch (IOException ioe) {
                LOG.error("Checkpoint failed", (Throwable)ioe);
                MessageDatabase.this.brokerService.handleIOException(ioe);
            }
            catch (Throwable e) {
                LOG.error("Checkpoint failed", e);
                MessageDatabase.this.brokerService.handleIOException(IOExceptionSupport.create(e));
            }
        }
    }

    public static enum PurgeRecoveredXATransactionStrategy {
        NEVER,
        COMMIT,
        ROLLBACK;

    }

    class MetadataMarshaller
    extends VariableMarshaller<Metadata> {
        MetadataMarshaller() {
        }

        @Override
        public Metadata readPayload(DataInput dataIn) throws IOException {
            Metadata rc = MessageDatabase.this.createMetadata();
            rc.read(dataIn);
            return rc;
        }

        @Override
        public void writePayload(Metadata object, DataOutput dataOut) throws IOException {
            object.write(dataOut);
        }
    }

    protected class Metadata {
        protected Page<Metadata> page;
        protected int state;
        protected BTreeIndex<String, StoredDestination> destinations;
        protected Location lastUpdate;
        protected Location firstInProgressTransactionLocation;
        protected Location producerSequenceIdTrackerLocation = null;
        protected Location ackMessageFileMapLocation = null;
        protected transient ActiveMQMessageAuditNoSync producerSequenceIdTracker = new ActiveMQMessageAuditNoSync();
        protected transient Map<Integer, Set<Integer>> ackMessageFileMap = new HashMap<Integer, Set<Integer>>();
        protected transient AtomicBoolean ackMessageFileMapDirtyFlag = new AtomicBoolean(false);
        protected int version = 6;
        protected int openwireVersion = 11;

        protected Metadata() {
        }

        public void read(DataInput is) throws IOException {
            this.state = is.readInt();
            this.destinations = new BTreeIndex(MessageDatabase.this.pageFile, is.readLong());
            this.lastUpdate = is.readBoolean() ? LocationMarshaller.INSTANCE.readPayload(is) : null;
            this.firstInProgressTransactionLocation = is.readBoolean() ? LocationMarshaller.INSTANCE.readPayload(is) : null;
            try {
                this.producerSequenceIdTrackerLocation = is.readBoolean() ? LocationMarshaller.INSTANCE.readPayload(is) : null;
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
            try {
                this.version = is.readInt();
            }
            catch (EOFException expectedOnUpgrade) {
                this.version = 1;
            }
            this.ackMessageFileMapLocation = this.version >= 5 && is.readBoolean() ? LocationMarshaller.INSTANCE.readPayload(is) : null;
            try {
                this.openwireVersion = is.readInt();
            }
            catch (EOFException expectedOnUpgrade) {
                this.openwireVersion = 6;
            }
            LOG.info("KahaDB is version " + this.version);
        }

        public void write(DataOutput os) throws IOException {
            os.writeInt(this.state);
            os.writeLong(this.destinations.getPageId());
            if (this.lastUpdate != null) {
                os.writeBoolean(true);
                LocationMarshaller.INSTANCE.writePayload(this.lastUpdate, os);
            } else {
                os.writeBoolean(false);
            }
            if (this.firstInProgressTransactionLocation != null) {
                os.writeBoolean(true);
                LocationMarshaller.INSTANCE.writePayload(this.firstInProgressTransactionLocation, os);
            } else {
                os.writeBoolean(false);
            }
            if (this.producerSequenceIdTrackerLocation != null) {
                os.writeBoolean(true);
                LocationMarshaller.INSTANCE.writePayload(this.producerSequenceIdTrackerLocation, os);
            } else {
                os.writeBoolean(false);
            }
            os.writeInt(6);
            if (this.ackMessageFileMapLocation != null) {
                os.writeBoolean(true);
                LocationMarshaller.INSTANCE.writePayload(this.ackMessageFileMapLocation, os);
            } else {
                os.writeBoolean(false);
            }
            os.writeInt(this.openwireVersion);
        }
    }
}

