/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.engine.impl;

import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.transport.EmptyFrame;
import org.apache.qpid.proton.amqp.transport.FrameBody;
import org.apache.qpid.proton.codec.ByteBufferDecoder;
import org.apache.qpid.proton.codec.DecodeException;
import org.apache.qpid.proton.engine.TransportException;
import org.apache.qpid.proton.engine.impl.AmqpHeader;
import org.apache.qpid.proton.engine.impl.ByteBufferUtils;
import org.apache.qpid.proton.engine.impl.FrameHandler;
import org.apache.qpid.proton.engine.impl.ProtocolTracer;
import org.apache.qpid.proton.engine.impl.TransportImpl;
import org.apache.qpid.proton.engine.impl.TransportInput;
import org.apache.qpid.proton.framing.TransportFrame;

class FrameParser
implements TransportInput {
    private static final Logger TRACE_LOGGER = Logger.getLogger("proton.trace");
    private static final String HEADER_DESCRIPTION = "AMQP";
    private static final ByteBuffer _emptyInputBuffer = ByteBufferUtils.newWriteableBuffer(0);
    private final FrameHandler _frameHandler;
    private final ByteBufferDecoder _decoder;
    private final int _inputBufferSize;
    private final int _localMaxFrameSize;
    private final TransportImpl _transport;
    private ByteBuffer _inputBuffer = null;
    private boolean _tail_closed = false;
    private State _state = State.HEADER0;
    private long _framesInput = 0L;
    private int _size;
    private ByteBuffer _frameBuffer;
    private TransportFrame _heldFrame;
    private TransportException _parsingError;

    FrameParser(FrameHandler frameHandler, ByteBufferDecoder decoder, int localMaxFrameSize, TransportImpl transport) {
        this._frameHandler = frameHandler;
        this._decoder = decoder;
        this._localMaxFrameSize = localMaxFrameSize;
        this._inputBufferSize = this._localMaxFrameSize > 0 ? this._localMaxFrameSize : 16384;
        this._transport = transport;
    }

    private void input(ByteBuffer in) throws TransportException {
        this.flushHeldFrame();
        if (this._heldFrame != null) {
            return;
        }
        TransportException frameParsingError = null;
        int size2 = this._size;
        State state = this._state;
        ByteBuffer oldIn = null;
        boolean transportAccepting = true;
        while (in.hasRemaining() && state != State.ERROR && transportAccepting) {
            switch (state) {
                case HEADER0: {
                    if (!in.hasRemaining()) break;
                    byte c = in.get();
                    if (c != AmqpHeader.HEADER[0]) {
                        frameParsingError = new TransportException("AMQP header mismatch value %x, expecting %x. In state: %s", new Object[]{c, AmqpHeader.HEADER[0], state});
                        state = State.ERROR;
                        break;
                    }
                    state = State.HEADER1;
                }
                case HEADER1: {
                    if (!in.hasRemaining()) break;
                    byte c = in.get();
                    if (c != AmqpHeader.HEADER[1]) {
                        frameParsingError = new TransportException("AMQP header mismatch value %x, expecting %x. In state: %s", new Object[]{c, AmqpHeader.HEADER[1], state});
                        state = State.ERROR;
                        break;
                    }
                    state = State.HEADER2;
                }
                case HEADER2: {
                    if (!in.hasRemaining()) break;
                    byte c = in.get();
                    if (c != AmqpHeader.HEADER[2]) {
                        frameParsingError = new TransportException("AMQP header mismatch value %x, expecting %x. In state: %s", new Object[]{c, AmqpHeader.HEADER[2], state});
                        state = State.ERROR;
                        break;
                    }
                    state = State.HEADER3;
                }
                case HEADER3: {
                    if (!in.hasRemaining()) break;
                    byte c = in.get();
                    if (c != AmqpHeader.HEADER[3]) {
                        frameParsingError = new TransportException("AMQP header mismatch value %x, expecting %x. In state: %s", new Object[]{c, AmqpHeader.HEADER[3], state});
                        state = State.ERROR;
                        break;
                    }
                    state = State.HEADER4;
                }
                case HEADER4: {
                    if (!in.hasRemaining()) break;
                    byte c = in.get();
                    if (c != AmqpHeader.HEADER[4]) {
                        frameParsingError = new TransportException("AMQP header mismatch value %x, expecting %x. In state: %s", new Object[]{c, AmqpHeader.HEADER[4], state});
                        state = State.ERROR;
                        break;
                    }
                    state = State.HEADER5;
                }
                case HEADER5: {
                    if (!in.hasRemaining()) break;
                    byte c = in.get();
                    if (c != AmqpHeader.HEADER[5]) {
                        frameParsingError = new TransportException("AMQP header mismatch value %x, expecting %x. In state: %s", new Object[]{c, AmqpHeader.HEADER[5], state});
                        state = State.ERROR;
                        break;
                    }
                    state = State.HEADER6;
                }
                case HEADER6: {
                    if (!in.hasRemaining()) break;
                    byte c = in.get();
                    if (c != AmqpHeader.HEADER[6]) {
                        frameParsingError = new TransportException("AMQP header mismatch value %x, expecting %x. In state: %s", new Object[]{c, AmqpHeader.HEADER[6], state});
                        state = State.ERROR;
                        break;
                    }
                    state = State.HEADER7;
                }
                case HEADER7: {
                    if (!in.hasRemaining()) break;
                    byte c = in.get();
                    if (c != AmqpHeader.HEADER[7]) {
                        frameParsingError = new TransportException("AMQP header mismatch value %x, expecting %x. In state: %s", new Object[]{c, AmqpHeader.HEADER[7], state});
                        state = State.ERROR;
                        break;
                    }
                    this.logHeader();
                    state = State.SIZE_0;
                }
                case SIZE_0: {
                    if (!in.hasRemaining()) break;
                    if (in.remaining() >= 4) {
                        size2 = in.getInt();
                        state = State.PRE_PARSE;
                        break;
                    }
                    size2 = in.get() << 24 & 0xFF000000;
                    if (!in.hasRemaining()) {
                        state = State.SIZE_1;
                        break;
                    }
                }
                case SIZE_1: {
                    size2 |= in.get() << 16 & 0xFF0000;
                    if (!in.hasRemaining()) {
                        state = State.SIZE_2;
                        break;
                    }
                }
                case SIZE_2: {
                    size2 |= in.get() << 8 & 0xFF00;
                    if (!in.hasRemaining()) {
                        state = State.SIZE_3;
                        break;
                    }
                }
                case SIZE_3: {
                    size2 |= in.get() & 0xFF;
                    state = State.PRE_PARSE;
                }
                case PRE_PARSE: {
                    if (size2 < 8) {
                        frameParsingError = new TransportException("specified frame size %d smaller than minimum frame header size %d", size2, 8);
                        state = State.ERROR;
                        break;
                    }
                    if (this._localMaxFrameSize > 0 && size2 > this._localMaxFrameSize) {
                        frameParsingError = new TransportException("specified frame size %d greater than maximum valid frame size %d", size2, this._localMaxFrameSize);
                        state = State.ERROR;
                        break;
                    }
                    if (in.remaining() < size2 - 4) {
                        this._frameBuffer = ByteBuffer.allocate(size2 - 4);
                        this._frameBuffer.put(in);
                        state = State.BUFFERING;
                        break;
                    }
                }
                case BUFFERING: {
                    if (this._frameBuffer != null) {
                        if (in.remaining() < this._frameBuffer.remaining()) {
                            this._frameBuffer.put(in);
                            break;
                        }
                        ByteBuffer dup = in.duplicate();
                        dup.limit(dup.position() + this._frameBuffer.remaining());
                        in.position(in.position() + this._frameBuffer.remaining());
                        this._frameBuffer.put(dup);
                        oldIn = in;
                        this._frameBuffer.flip();
                        in = this._frameBuffer;
                        state = State.PARSING;
                    }
                }
                case PARSING: {
                    int dataOffset = in.get() << 2 & 0x3FF;
                    if (dataOffset < 8) {
                        frameParsingError = new TransportException("specified frame data offset %d smaller than minimum frame header size %d", dataOffset, 8);
                        state = State.ERROR;
                        break;
                    }
                    if (dataOffset > size2) {
                        frameParsingError = new TransportException("specified frame data offset %d larger than the frame size %d", dataOffset, size2);
                        state = State.ERROR;
                        break;
                    }
                    int type = in.get() & 0xFF;
                    int channel = in.getShort() & 0xFFFF;
                    if (type != 0) {
                        frameParsingError = new TransportException("unknown frame type: %d", type);
                        state = State.ERROR;
                        break;
                    }
                    if (dataOffset != 8) {
                        in.position(in.position() + dataOffset - 8);
                    }
                    int frameBodySize = size2 - dataOffset;
                    if (oldIn == null) {
                        oldIn = in;
                        in = in.duplicate();
                        int endPos = in.position() + frameBodySize;
                        in.limit(endPos);
                        oldIn.position(endPos);
                    }
                    try {
                        ++this._framesInput;
                        Binary payload = null;
                        Object val = null;
                        if (frameBodySize > 0) {
                            this._decoder.setByteBuffer(in);
                            val = this._decoder.readObject();
                            this._decoder.setByteBuffer(null);
                            if (in.hasRemaining()) {
                                byte[] payloadBytes = new byte[in.remaining()];
                                in.get(payloadBytes);
                                payload = new Binary(payloadBytes);
                            } else {
                                payload = null;
                            }
                        } else {
                            val = EmptyFrame.INSTANCE;
                        }
                        if (val instanceof FrameBody) {
                            FrameBody frameBody = (FrameBody)val;
                            if (TRACE_LOGGER.isLoggable(Level.FINE)) {
                                TRACE_LOGGER.log(Level.FINE, "IN: CH[" + channel + "] : " + frameBody + (payload == null ? "" : "[" + payload + "]"));
                            }
                            TransportFrame frame = new TransportFrame(channel, frameBody, payload);
                            if (this._frameHandler.isHandlingFrames()) {
                                this._tail_closed = this._frameHandler.handleFrame(frame);
                            } else {
                                transportAccepting = false;
                                this._heldFrame = frame;
                            }
                        } else {
                            throw new TransportException("Frameparser encountered a " + (val == null ? "null" : val.getClass()) + " which is not a " + FrameBody.class);
                        }
                        this.reset();
                        in = oldIn;
                        oldIn = null;
                        this._frameBuffer = null;
                        state = State.SIZE_0;
                    }
                    catch (DecodeException ex) {
                        state = State.ERROR;
                        frameParsingError = new TransportException(ex);
                    }
                    break;
                }
            }
        }
        if (this._tail_closed) {
            if (in.hasRemaining()) {
                state = State.ERROR;
                frameParsingError = new TransportException("framing error");
            } else if (state != State.SIZE_0) {
                state = State.ERROR;
                frameParsingError = new TransportException("connection aborted");
            } else {
                this._frameHandler.closed(null);
            }
        }
        this._state = state;
        this._size = size2;
        if (this._state == State.ERROR) {
            this._tail_closed = true;
            if (frameParsingError != null) {
                this._parsingError = frameParsingError;
                this._frameHandler.closed(frameParsingError);
            } else {
                throw new TransportException("Unable to parse, probably because of a previous error");
            }
        }
    }

    @Override
    public int capacity() {
        if (this._tail_closed) {
            return -1;
        }
        if (this._inputBuffer != null) {
            return this._inputBuffer.remaining();
        }
        return this._inputBufferSize;
    }

    @Override
    public int position() {
        if (this._tail_closed) {
            return -1;
        }
        return this._inputBuffer == null ? 0 : this._inputBuffer.position();
    }

    @Override
    public ByteBuffer tail() {
        if (this._tail_closed) {
            throw new TransportException("tail closed");
        }
        if (this._inputBuffer == null) {
            this._inputBuffer = ByteBufferUtils.newWriteableBuffer(this._inputBufferSize);
        }
        return this._inputBuffer;
    }

    @Override
    public void process() throws TransportException {
        if (this._inputBuffer != null) {
            this._inputBuffer.flip();
            try {
                this.input(this._inputBuffer);
            }
            finally {
                if (this._inputBuffer.hasRemaining()) {
                    this._inputBuffer.compact();
                } else if (this._inputBuffer.capacity() > TransportImpl.BUFFER_RELEASE_THRESHOLD) {
                    this._inputBuffer = null;
                } else {
                    this._inputBuffer.clear();
                }
            }
        } else {
            this.input(_emptyInputBuffer);
        }
    }

    @Override
    public void close_tail() {
        this._tail_closed = true;
        this.process();
    }

    public void flush() {
        this.flushHeldFrame();
        if (this._heldFrame == null) {
            this.process();
        }
    }

    private void flushHeldFrame() {
        if (this._heldFrame != null && this._frameHandler.isHandlingFrames()) {
            this._tail_closed = this._frameHandler.handleFrame(this._heldFrame);
            this._heldFrame = null;
        }
    }

    private void reset() {
        this._size = 0;
        this._state = State.SIZE_0;
    }

    long getFramesInput() {
        return this._framesInput;
    }

    private void logHeader() {
        if (this._transport.isFrameTracingEnabled()) {
            this._transport.log(TransportImpl.INCOMING, HEADER_DESCRIPTION);
            ProtocolTracer tracer = this._transport.getProtocolTracer();
            if (tracer != null) {
                tracer.receivedHeader(HEADER_DESCRIPTION);
            }
        }
    }

    private static enum State {
        HEADER0,
        HEADER1,
        HEADER2,
        HEADER3,
        HEADER4,
        HEADER5,
        HEADER6,
        HEADER7,
        SIZE_0,
        SIZE_1,
        SIZE_2,
        SIZE_3,
        PRE_PARSE,
        BUFFERING,
        PARSING,
        ERROR;

    }
}

