/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.util;

import java.nio.ByteBuffer;
import org.iq80.leveldb.util.SliceInput;
import org.iq80.leveldb.util.SliceOutput;

public final class VariableLengthQuantity {
    private VariableLengthQuantity() {
    }

    public static int variableLengthSize(int value) {
        int size2 = 1;
        while ((value & 0xFFFFFF80) != 0) {
            value >>>= 7;
            ++size2;
        }
        return size2;
    }

    public static int variableLengthSize(long value) {
        int size2 = 1;
        while ((value & 0xFFFFFFFFFFFFFF80L) != 0L) {
            value >>>= 7;
            ++size2;
        }
        return size2;
    }

    public static void writeVariableLengthInt(int value, SliceOutput sliceOutput) {
        int highBitMask = 128;
        if (value < 128 && value >= 0) {
            sliceOutput.writeByte(value);
        } else if (value < 16384 && value > 0) {
            sliceOutput.writeByte(value | highBitMask);
            sliceOutput.writeByte(value >>> 7);
        } else if (value < 0x200000 && value > 0) {
            sliceOutput.writeByte(value | highBitMask);
            sliceOutput.writeByte(value >>> 7 | highBitMask);
            sliceOutput.writeByte(value >>> 14);
        } else if (value < 0x10000000 && value > 0) {
            sliceOutput.writeByte(value | highBitMask);
            sliceOutput.writeByte(value >>> 7 | highBitMask);
            sliceOutput.writeByte(value >>> 14 | highBitMask);
            sliceOutput.writeByte(value >>> 21);
        } else {
            sliceOutput.writeByte(value | highBitMask);
            sliceOutput.writeByte(value >>> 7 | highBitMask);
            sliceOutput.writeByte(value >>> 14 | highBitMask);
            sliceOutput.writeByte(value >>> 21 | highBitMask);
            sliceOutput.writeByte(value >>> 28);
        }
    }

    public static void writeVariableLengthLong(long value, SliceOutput sliceOutput) {
        while ((value & 0xFFFFFFFFFFFFFF80L) != 0L) {
            sliceOutput.writeByte((int)(value & 0x7FL | 0x80L));
            value >>>= 7;
        }
        sliceOutput.writeByte((int)value);
    }

    public static int readVariableLengthInt(SliceInput sliceInput) {
        int result = 0;
        for (int shift = 0; shift <= 28; shift += 7) {
            int b = sliceInput.readUnsignedByte();
            result |= (b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw new NumberFormatException("last byte of variable length int has high bit set");
    }

    public static int readVariableLengthInt(ByteBuffer sliceInput) {
        int result = 0;
        for (int shift = 0; shift <= 28; shift += 7) {
            byte b = sliceInput.get();
            result |= (b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw new NumberFormatException("last byte of variable length int has high bit set");
    }

    public static long readVariableLengthLong(SliceInput sliceInput) {
        long result = 0L;
        for (int shift = 0; shift <= 63; shift += 7) {
            long b = sliceInput.readUnsignedByte();
            result |= (b & 0x7FL) << shift;
            if ((b & 0x80L) != 0L) continue;
            return result;
        }
        throw new NumberFormatException("last byte of variable length int has high bit set");
    }
}

