/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.helpers.MessageFormatter;

public class SimpleLogger
extends MarkerIgnoringBase {
    private static final long serialVersionUID = 1L;
    public static final int ERROR = 0;
    public static final int WARN = 1;
    public static final int INFO = 2;
    public static final int DEBUG = 3;
    public static final int TRACE = 4;
    private static int level = 0;
    private static long startTime = System.currentTimeMillis();
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private String name;

    public static int getLevel() {
        return level;
    }

    public static void setLevel(int level) {
        SimpleLogger.level = level;
    }

    SimpleLogger(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isTraceEnabled() {
        return this.isLogEnabled(4);
    }

    public void trace(String msg) {
        this.log(4, msg);
    }

    public void trace(String format, Object arg) {
        this.log(4, format, arg);
    }

    public void trace(String format, Object arg1, Object arg2) {
        this.log(4, format, arg1, arg2);
    }

    public void trace(String format, Object[] argArray) {
        this.log(4, format, argArray);
    }

    public void trace(String msg, Throwable t) {
        this.log(4, msg, t);
    }

    public boolean isDebugEnabled() {
        return this.isLogEnabled(3);
    }

    public void debug(String msg) {
        this.log(3, msg);
    }

    public void debug(String format, Object arg) {
        this.log(3, format, arg);
    }

    public void debug(String format, Object arg1, Object arg2) {
        this.log(3, format, arg1, arg2);
    }

    public void debug(String format, Object[] argArray) {
        this.log(3, format, argArray, null);
    }

    public void debug(String msg, Throwable t) {
        this.log(3, msg, t);
    }

    public boolean isInfoEnabled() {
        return this.isLogEnabled(2);
    }

    public void info(String msg) {
        this.log(2, msg);
    }

    public void info(String format, Object arg) {
        this.log(2, format, arg);
    }

    public void info(String format, Object arg1, Object arg2) {
        this.log(2, format, arg1, arg2);
    }

    public void info(String format, Object[] argArray) {
        this.log(2, format, argArray);
    }

    public void info(String msg, Throwable t) {
        this.log(2, msg, t);
    }

    public boolean isWarnEnabled() {
        return this.isLogEnabled(1);
    }

    public void warn(String msg) {
        this.log(1, msg);
    }

    public void warn(String format, Object arg) {
        this.log(1, format, arg);
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.log(1, format, arg1, arg2);
    }

    public void warn(String format, Object[] argArray) {
        this.log(1, format, argArray);
    }

    public void warn(String msg, Throwable t) {
        this.log(1, msg, t);
    }

    public boolean isErrorEnabled() {
        return this.isLogEnabled(0);
    }

    public void error(String msg) {
        this.log(0, msg);
    }

    public void error(String format, Object arg) {
        this.log(0, format, arg);
    }

    public void error(String format, Object arg1, Object arg2) {
        this.log(0, format, arg1, arg2);
    }

    public void error(String format, Object[] argArray) {
        this.log(0, format, argArray);
    }

    public void error(String msg, Throwable t) {
        this.log(0, msg, t);
    }

    protected boolean isLogEnabled(int level) {
        return SimpleLogger.level >= level;
    }

    protected void log(int level, String msg) {
        if (this.isLogEnabled(level)) {
            this.doLog(level, msg, null);
        }
    }

    protected void log(int level, String format, Object arg) {
        if (this.isLogEnabled(level)) {
            String msg = MessageFormatter.format((String)format, (Object)arg).getMessage();
            this.doLog(level, msg, null);
        }
    }

    protected void log(int level, String format, Object arg1, Object arg2) {
        if (this.isLogEnabled(level)) {
            String msg = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2).getMessage();
            this.doLog(level, msg, null);
        }
    }

    protected void log(int level, String format, Object[] args) {
        if (this.isLogEnabled(level)) {
            String msg = MessageFormatter.arrayFormat((String)format, (Object[])args).getMessage();
            this.doLog(level, msg, null);
        }
    }

    protected void log(int level, String msg, Throwable t) {
        if (this.isLogEnabled(level)) {
            this.doLog(level, msg, t);
        }
    }

    protected void doLog(int level, String msg, Throwable t) {
        StringBuilder buf = new StringBuilder();
        long millis = System.currentTimeMillis();
        buf.append(millis - startTime);
        buf.append(" [");
        buf.append(Thread.currentThread().getName());
        buf.append("] ");
        switch (level) {
            case 4: {
                buf.append("TRACE");
                break;
            }
            case 3: {
                buf.append("DEBUG");
                break;
            }
            case 2: {
                buf.append("INFO");
                break;
            }
            case 1: {
                buf.append("WARN");
                break;
            }
            case 0: {
                buf.append("ERROR");
            }
        }
        buf.append(" ");
        buf.append(this.name);
        buf.append(" - ");
        buf.append(msg);
        buf.append(LINE_SEPARATOR);
        System.err.print(buf.toString());
        if (t != null) {
            t.printStackTrace(System.err);
        }
        System.err.flush();
    }
}

