/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.annotation.HandlesTypes;
import org.apache.xbean.finder.BundleAnnotationFinder;
import org.apache.xbean.finder.BundleAssignableClassFinder;
import org.ops4j.pax.web.utils.ClassPathUtil;
import org.osgi.framework.Bundle;
import org.osgi.service.packageadmin.PackageAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletContainerInitializerScanner {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Bundle bundle;
    private Bundle serverBundle;
    private PackageAdmin packageAdminService;

    public ServletContainerInitializerScanner(Bundle bundle, Bundle serverBundle, PackageAdmin packageAdminService) {
        this.bundle = bundle;
        this.serverBundle = serverBundle;
        this.packageAdminService = packageAdminService;
    }

    public void scanBundles(Map<ServletContainerInitializer, Set<Class<?>>> containerInitializers) {
        Set<Bundle> bundlesInClassSpace = ClassPathUtil.getBundlesInClassSpace(this.bundle, new HashSet<Bundle>());
        if (this.serverBundle != null) {
            ClassPathUtil.getBundlesInClassSpace(this.serverBundle, bundlesInClassSpace);
        }
        for (URL u : ClassPathUtil.findResources(bundlesInClassSpace, "/META-INF/services", "javax.servlet.ServletContainerInitializer", true)) {
            try {
                Class initializerClass;
                InputStream is = u.openStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                String className = this.parseServiceConfig(reader);
                this.log.info("will add {} to ServletContainerInitializers", (Object)className);
                if (className.endsWith("JasperInitializer")) {
                    this.log.info("Skipt {}, because specialized handler will be present", (Object)className);
                    continue;
                }
                try {
                    initializerClass = this.bundle.loadClass(className);
                }
                catch (ClassNotFoundException ignore) {
                    if (this.serverBundle != null) {
                        initializerClass = this.serverBundle.loadClass(className);
                    }
                    this.log.warn("couldn't find Class for {}", (Object)className);
                    continue;
                }
                ServletContainerInitializer initializer = (ServletContainerInitializer)initializerClass.newInstance();
                HashSet<Class> setOfClasses = new HashSet<Class>();
                HandlesTypes handlesTypes = initializerClass.getAnnotation(HandlesTypes.class);
                if (handlesTypes != null) {
                    Class[] classes;
                    for (Class klass : classes = handlesTypes.value()) {
                        BundleAssignableClassFinder basf;
                        boolean isAnnotation = klass.isAnnotation();
                        boolean isInteraface = klass.isInterface();
                        if (isAnnotation) {
                            try {
                                BundleAnnotationFinder baf = new BundleAnnotationFinder(this.packageAdminService, this.bundle);
                                List annotatedClasses = baf.findAnnotatedClasses(klass);
                                setOfClasses.addAll(annotatedClasses);
                            }
                            catch (Exception e) {
                                this.log.warn("Failed to find annotated classes for ServletContainerInitializer");
                            }
                            continue;
                        }
                        if (isInteraface) {
                            basf = new BundleAssignableClassFinder(this.packageAdminService, new Class[]{klass}, this.bundle);
                            Set interfaces = basf.find();
                            for (String interfaceName : interfaces) {
                                setOfClasses.add(this.bundle.loadClass(interfaceName));
                            }
                            continue;
                        }
                        basf = new BundleAssignableClassFinder(this.packageAdminService, new Class[]{klass}, this.bundle);
                        Set classNames = basf.find();
                        for (String klassName : classNames) {
                            setOfClasses.add(this.bundle.loadClass(klassName));
                        }
                    }
                }
                containerInitializers.put(initializer, setOfClasses);
                this.log.info("added ServletContainerInitializer: {}", (Object)className);
            }
            catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                this.log.warn("failed to parse and instantiate of javax.servlet.ServletContainerInitializer in classpath");
            }
        }
    }

    private String parseServiceConfig(BufferedReader r) throws IOException {
        String ln;
        do {
            if ((ln = r.readLine()) == null) {
                return null;
            }
            int ci = ln.indexOf(35);
            if (ci < 0) continue;
            ln = ln.substring(0, ci);
        } while ((ln = ln.trim()).isEmpty());
        return ln;
    }
}

