/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.transaction.parsing;

import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.transaction.TransactionManager;
import org.apache.aries.blueprint.ComponentDefinitionRegistry;
import org.apache.aries.blueprint.NamespaceHandler;
import org.apache.aries.blueprint.ParserContext;
import org.apache.aries.blueprint.mutable.MutableBeanMetadata;
import org.apache.aries.blueprint.mutable.MutablePassThroughMetadata;
import org.apache.aries.transaction.parsing.AnnotationProcessor;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.blueprint.reflect.Metadata;
import org.osgi.service.coordinator.Coordinator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TxNamespaceHandler
implements NamespaceHandler {
    public static final String TX_NAMESPACE_URI = "http://aries.apache.org/xmlns/transactions/v2.0.0";
    public static final String ANNOTATION_PARSER_BEAN_NAME = ".org_apache_aries_transaction_annotations";
    private static final Logger LOGGER = LoggerFactory.getLogger(TxNamespaceHandler.class);
    private TransactionManager tm;
    private Coordinator coordinator;
    private final Map<String, String> schemaMap = new HashMap<String, String>();

    public TxNamespaceHandler() {
        this.schemaMap.put(TX_NAMESPACE_URI, "transactionv20.xsd");
    }

    private void parseElement(Element elt, ParserContext pc) {
        Node n;
        LOGGER.debug("parser asked to parse element {} ", (Object)elt.getNodeName());
        ComponentDefinitionRegistry cdr = pc.getComponentDefinitionRegistry();
        if ("enable".equals(elt.getLocalName()) && ((n = elt.getChildNodes().item(0)) == null || Boolean.parseBoolean(n.getNodeValue())) && !cdr.containsComponentDefinition(ANNOTATION_PARSER_BEAN_NAME)) {
            LOGGER.debug("Enabling annotation based transactions");
            MutableBeanMetadata meta = this.createAnnotationParserBean(pc, cdr);
            cdr.registerComponentDefinition((ComponentMetadata)meta);
        }
    }

    private MutableBeanMetadata createAnnotationParserBean(ParserContext pc, ComponentDefinitionRegistry cdr) {
        MutableBeanMetadata meta = (MutableBeanMetadata)pc.createMetadata(MutableBeanMetadata.class);
        meta.setId(ANNOTATION_PARSER_BEAN_NAME);
        meta.setRuntimeClass(AnnotationProcessor.class);
        meta.setProcessor(true);
        meta.addArgument((Metadata)this.passThrough(pc, cdr), ComponentDefinitionRegistry.class.getName(), 0);
        meta.addArgument((Metadata)this.passThrough(pc, this.tm), TransactionManager.class.getName(), 1);
        meta.addArgument((Metadata)this.passThrough(pc, this.coordinator), Coordinator.class.getName(), 1);
        return meta;
    }

    private MutablePassThroughMetadata passThrough(ParserContext pc, Object o) {
        MutablePassThroughMetadata meta = (MutablePassThroughMetadata)pc.createMetadata(MutablePassThroughMetadata.class);
        meta.setObject(o);
        return meta;
    }

    public ComponentMetadata decorate(Node node, ComponentMetadata cm, ParserContext pc) {
        if (node instanceof Element) {
            this.parseElement((Element)node, pc);
        }
        return cm;
    }

    public Metadata parse(Element elt, ParserContext pc) {
        this.parseElement(elt, pc);
        return null;
    }

    public URL getSchemaLocation(String namespaceUri) {
        String xsdPath = this.schemaMap.get(namespaceUri);
        return xsdPath != null ? this.getClass().getResource(xsdPath) : null;
    }

    public void setTm(TransactionManager tm) {
        this.tm = tm;
    }

    public void setCoordinator(Coordinator coordinator) {
        this.coordinator = coordinator;
    }

    public Set<Class> getManagedClasses() {
        return Collections.emptySet();
    }
}

