/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier.errorhandler;

import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.camel.CamelContext;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.LoggingLevel;
import org.apache.camel.NamedNode;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RedeliveryPolicyDefinition;
import org.apache.camel.model.errorhandler.DeadLetterChannelProperties;
import org.apache.camel.model.errorhandler.DefaultErrorHandlerProperties;
import org.apache.camel.model.errorhandler.ErrorHandlerRefProperties;
import org.apache.camel.model.errorhandler.NoErrorHandlerProperties;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.processor.errorhandler.ErrorHandlerSupport;
import org.apache.camel.processor.errorhandler.ExceptionPolicy;
import org.apache.camel.processor.errorhandler.ExceptionPolicyKey;
import org.apache.camel.processor.errorhandler.RedeliveryErrorHandler;
import org.apache.camel.processor.errorhandler.RedeliveryPolicy;
import org.apache.camel.reifier.AbstractReifier;
import org.apache.camel.reifier.errorhandler.DeadLetterChannelReifier;
import org.apache.camel.reifier.errorhandler.DefaultErrorHandlerReifier;
import org.apache.camel.reifier.errorhandler.ErrorHandlerRefReifier;
import org.apache.camel.reifier.errorhandler.NoErrorHandlerReifier;
import org.apache.camel.spi.ErrorHandler;
import org.apache.camel.spi.Language;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.util.ObjectHelper;

public abstract class ErrorHandlerReifier<T extends ErrorHandlerFactory>
extends AbstractReifier {
    private static final Map<Class<?>, BiFunction<Route, ErrorHandlerFactory, ErrorHandlerReifier<? extends ErrorHandlerFactory>>> ERROR_HANDLERS = new HashMap(0);
    protected T definition;

    protected ErrorHandlerReifier(Route route, T definition) {
        super(route);
        this.definition = definition;
    }

    public static void registerReifier(Class<?> errorHandlerClass, BiFunction<Route, ErrorHandlerFactory, ErrorHandlerReifier<? extends ErrorHandlerFactory>> creator) {
        ERROR_HANDLERS.put(errorHandlerClass, creator);
    }

    public static ErrorHandlerReifier<? extends ErrorHandlerFactory> reifier(Route route, ErrorHandlerFactory definition) {
        BiFunction<Route, ErrorHandlerFactory, ErrorHandlerReifier<? extends ErrorHandlerFactory>> reifier;
        ErrorHandlerReifier<ErrorHandlerFactory> answer = null;
        if (!ERROR_HANDLERS.isEmpty() && (reifier = ERROR_HANDLERS.get(definition.getClass())) != null) {
            answer = reifier.apply(route, definition);
        }
        if (answer == null) {
            answer = ErrorHandlerReifier.coreReifier(route, definition);
        }
        if (answer == null) {
            throw new IllegalStateException("Unsupported definition: " + definition);
        }
        return answer;
    }

    private static ErrorHandlerReifier<? extends ErrorHandlerFactory> coreReifier(Route route, ErrorHandlerFactory definition) {
        if (definition instanceof DeadLetterChannelProperties) {
            return new DeadLetterChannelReifier(route, definition);
        }
        if (definition instanceof DefaultErrorHandlerProperties) {
            return new DefaultErrorHandlerReifier(route, definition);
        }
        if (definition instanceof ErrorHandlerRefProperties) {
            return new ErrorHandlerRefReifier(route, definition);
        }
        if (definition instanceof NoErrorHandlerProperties) {
            return new NoErrorHandlerReifier(route, definition);
        }
        return null;
    }

    public ExceptionPolicy createExceptionPolicy(OnExceptionDefinition def) {
        Predicate retryWhile;
        Predicate continued;
        Predicate handled = def.getHandledPolicy();
        if (handled == null && def.getHandled() != null) {
            handled = this.createPredicate(def.getHandled());
        }
        if ((continued = def.getContinuedPolicy()) == null && def.getContinued() != null) {
            continued = this.createPredicate(def.getContinued());
        }
        if ((retryWhile = def.getRetryWhilePolicy()) == null && def.getRetryWhile() != null) {
            retryWhile = this.createPredicate(def.getRetryWhile());
        }
        Processor onRedelivery = this.getProcessor(def.getOnRedelivery(), def.getOnRedeliveryRef());
        Processor onExceptionOccurred = this.getProcessor(def.getOnExceptionOccurred(), def.getOnExceptionOccurredRef());
        return new ExceptionPolicy(def.getId(), CamelContextHelper.getRouteId((NamedNode)def), this.parseBoolean(def.getUseOriginalMessage(), false), this.parseBoolean(def.getUseOriginalBody(), false), ObjectHelper.isNotEmpty((Object)def.getOutputs()), handled, continued, retryWhile, onRedelivery, onExceptionOccurred, def.getRedeliveryPolicyRef(), ErrorHandlerReifier.getRedeliveryPolicy(def.getRedeliveryPolicyType()), def.getExceptions());
    }

    private static Map<ExceptionPolicy.RedeliveryOption, String> getRedeliveryPolicy(RedeliveryPolicyDefinition definition) {
        if (definition == null) {
            return null;
        }
        HashMap<ExceptionPolicy.RedeliveryOption, String> policy = new HashMap<ExceptionPolicy.RedeliveryOption, String>();
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.maximumRedeliveries, definition.getMaximumRedeliveries());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.redeliveryDelay, definition.getRedeliveryDelay());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.asyncDelayedRedelivery, definition.getAsyncDelayedRedelivery());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.backOffMultiplier, definition.getBackOffMultiplier());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.useExponentialBackOff, definition.getUseExponentialBackOff());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.collisionAvoidanceFactor, definition.getCollisionAvoidanceFactor());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.useCollisionAvoidance, definition.getUseCollisionAvoidance());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.maximumRedeliveryDelay, definition.getMaximumRedeliveryDelay());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.retriesExhaustedLogLevel, definition.getRetriesExhaustedLogLevel());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.retryAttemptedLogLevel, definition.getRetryAttemptedLogLevel());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.retryAttemptedLogInterval, definition.getRetryAttemptedLogInterval());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.logRetryAttempted, definition.getLogRetryAttempted());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.logStackTrace, definition.getLogStackTrace());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.logRetryStackTrace, definition.getLogRetryStackTrace());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.logHandled, definition.getLogHandled());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.logNewException, definition.getLogNewException());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.logContinued, definition.getLogContinued());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.logExhausted, definition.getLogExhausted());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.logExhaustedMessageHistory, definition.getLogExhaustedMessageHistory());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.logExhaustedMessageBody, definition.getLogExhaustedMessageBody());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.disableRedelivery, definition.getDisableRedelivery());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.delayPattern, definition.getDelayPattern());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.allowRedeliveryWhileStopping, definition.getAllowRedeliveryWhileStopping());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.exchangeFormatterRef, definition.getExchangeFormatterRef());
        return policy;
    }

    private static void setOption(Map<ExceptionPolicy.RedeliveryOption, String> policy, ExceptionPolicy.RedeliveryOption option, Object value) {
        if (value != null) {
            policy.put(option, value.toString());
        }
    }

    public void addExceptionPolicy(ErrorHandlerSupport handlerSupport, OnExceptionDefinition exceptionType) {
        Processor errorHandler = this.route.getOnException(exceptionType.getId());
        handlerSupport.addErrorHandler(errorHandler);
        if (ObjectHelper.isNotEmpty((Object)exceptionType.getExceptions())) {
            List<Class<Throwable>> list = this.createExceptionClasses(exceptionType);
            for (Class<Throwable> clazz : list) {
                String routeId = null;
                if (exceptionType.isRouteScoped()) {
                    routeId = this.route.getRouteId();
                }
                ExpressionDefinition when = exceptionType.getOnWhen() != null ? exceptionType.getOnWhen().getExpression() : null;
                ExceptionPolicyKey key = new ExceptionPolicyKey(routeId, clazz, (Predicate)when);
                ExceptionPolicy policy = this.createExceptionPolicy(exceptionType);
                handlerSupport.addExceptionPolicy(key, policy);
            }
        }
    }

    protected List<Class<? extends Throwable>> createExceptionClasses(OnExceptionDefinition exceptionType) {
        List list = exceptionType.getExceptions();
        ArrayList<Class<? extends Throwable>> answer = new ArrayList<Class<? extends Throwable>>(list.size());
        for (String name : list) {
            try {
                Class type = this.camelContext.getClassResolver().resolveMandatoryClass(name, Throwable.class);
                answer.add(type);
            }
            catch (ClassNotFoundException e) {
                throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
            }
        }
        return answer;
    }

    public abstract Processor createErrorHandler(Processor var1) throws Exception;

    public void configure(ErrorHandler handler) {
        if (handler instanceof ErrorHandlerSupport) {
            ErrorHandlerSupport handlerSupport = (ErrorHandlerSupport)handler;
            for (NamedNode exception : this.route.getErrorHandlers(this.definition)) {
                this.addExceptionPolicy(handlerSupport, (OnExceptionDefinition)exception);
            }
        }
        if (handler instanceof RedeliveryErrorHandler) {
            boolean original;
            boolean bl = original = ((RedeliveryErrorHandler)handler).isUseOriginalMessagePolicy() || ((RedeliveryErrorHandler)handler).isUseOriginalBodyPolicy();
            if (original) {
                this.route.setAllowUseOriginalMessage(Boolean.valueOf(true));
            }
        }
    }

    public static RedeliveryPolicy createRedeliveryPolicy(RedeliveryPolicyDefinition definition, CamelContext context, RedeliveryPolicy parentPolicy) {
        RedeliveryPolicy answer = parentPolicy != null ? parentPolicy.copy() : new RedeliveryPolicy();
        try {
            Duration duration;
            if (definition.getMaximumRedeliveries() != null) {
                answer.setMaximumRedeliveries(CamelContextHelper.parseInteger((CamelContext)context, (String)definition.getMaximumRedeliveries()).intValue());
            }
            if (definition.getRedeliveryDelay() != null) {
                duration = CamelContextHelper.parseDuration((CamelContext)context, (String)definition.getRedeliveryDelay());
                answer.setRedeliveryDelay(duration.toMillis());
            }
            if (definition.getAsyncDelayedRedelivery() != null) {
                answer.setAsyncDelayedRedelivery(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.getAsyncDelayedRedelivery()).booleanValue());
            }
            if (definition.getRetriesExhaustedLogLevel() != null) {
                answer.setRetriesExhaustedLogLevel((LoggingLevel)CamelContextHelper.parse((CamelContext)context, LoggingLevel.class, (String)definition.getRetriesExhaustedLogLevel()));
            }
            if (definition.getRetryAttemptedLogLevel() != null) {
                answer.setRetryAttemptedLogLevel((LoggingLevel)CamelContextHelper.parse((CamelContext)context, LoggingLevel.class, (String)definition.getRetryAttemptedLogLevel()));
            }
            if (definition.getRetryAttemptedLogInterval() != null) {
                answer.setRetryAttemptedLogInterval(CamelContextHelper.parseInteger((CamelContext)context, (String)definition.getRetryAttemptedLogInterval()).intValue());
            }
            if (definition.getBackOffMultiplier() != null) {
                answer.setBackOffMultiplier(CamelContextHelper.parseDouble((CamelContext)context, (String)definition.getBackOffMultiplier()).doubleValue());
            }
            if (definition.getUseExponentialBackOff() != null) {
                answer.setUseExponentialBackOff(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.getUseExponentialBackOff()).booleanValue());
            }
            if (definition.getCollisionAvoidanceFactor() != null) {
                answer.setCollisionAvoidanceFactor(CamelContextHelper.parseDouble((CamelContext)context, (String)definition.getCollisionAvoidanceFactor()).doubleValue());
            }
            if (definition.getUseCollisionAvoidance() != null) {
                answer.setUseCollisionAvoidance(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.getUseCollisionAvoidance()).booleanValue());
            }
            if (definition.getMaximumRedeliveryDelay() != null) {
                duration = CamelContextHelper.parseDuration((CamelContext)context, (String)definition.getMaximumRedeliveryDelay());
                answer.setMaximumRedeliveryDelay(duration.toMillis());
            }
            if (definition.getLogStackTrace() != null) {
                answer.setLogStackTrace(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.getLogStackTrace()).booleanValue());
            }
            if (definition.getLogRetryStackTrace() != null) {
                answer.setLogRetryStackTrace(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.getLogRetryStackTrace()).booleanValue());
            }
            if (definition.getLogHandled() != null) {
                answer.setLogHandled(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.getLogHandled()).booleanValue());
            }
            if (definition.getLogNewException() != null) {
                answer.setLogNewException(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.getLogNewException()).booleanValue());
            }
            if (definition.getLogContinued() != null) {
                answer.setLogContinued(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.getLogContinued()).booleanValue());
            }
            if (definition.getLogRetryAttempted() != null) {
                answer.setLogRetryAttempted(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.getLogRetryAttempted()).booleanValue());
            }
            if (definition.getLogExhausted() != null) {
                answer.setLogExhausted(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.getLogExhausted()).booleanValue());
            }
            if (definition.getLogExhaustedMessageHistory() != null) {
                answer.setLogExhaustedMessageHistory(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.getLogExhaustedMessageHistory()).booleanValue());
            }
            if (definition.getLogExhaustedMessageBody() != null) {
                answer.setLogExhaustedMessageBody(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.getLogExhaustedMessageBody()));
            }
            if (definition.getDisableRedelivery() != null && CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.getDisableRedelivery()).booleanValue()) {
                answer.setMaximumRedeliveries(0);
            }
            if (definition.getDelayPattern() != null) {
                answer.setDelayPattern(CamelContextHelper.parseText((CamelContext)context, (String)definition.getDelayPattern()));
            }
            if (definition.getAllowRedeliveryWhileStopping() != null) {
                answer.setAllowRedeliveryWhileStopping(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.getAllowRedeliveryWhileStopping()).booleanValue());
            }
            if (definition.getExchangeFormatterRef() != null) {
                answer.setExchangeFormatterRef(CamelContextHelper.parseText((CamelContext)context, (String)definition.getExchangeFormatterRef()));
            }
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
        return answer;
    }

    protected Predicate getPredicate(Predicate pred, String ref) {
        if (pred == null && ref != null) {
            Language bean = this.camelContext.resolveLanguage("bean");
            pred = bean.createPredicate(ref);
        }
        return pred;
    }

    protected <T> T getBean(Class<T> clazz, T bean, String ref) {
        if (bean == null && ref != null) {
            bean = this.lookup(ref, clazz);
        }
        return bean;
    }

    protected Processor getProcessor(Processor processor, String ref) {
        if (processor == null) {
            processor = this.getBean(Processor.class, null, ref);
        }
        if (processor != null) {
            processor = ((ExtendedCamelContext)this.camelContext.adapt(ExtendedCamelContext.class)).getInternalProcessorFactory().addUnitOfWorkProcessorAdvice(this.camelContext, processor, this.route);
        }
        return processor;
    }
}

