/*
 * Decompiled with CFR 0.152.
 */
package io.iden3.circomwitnesscalc;

import io.iden3.circomwitnesscalc.WitnesscalcError;
import io.iden3.circomwitnesscalc.WitnesscalcJniBridge;
import io.iden3.circomwitnesscalc.WitnesscalcUnknownStatusError;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\b\b\u0002\u0010\u000b\u001a\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"DEFAULT_ERROR_BUFFER_SIZE", "", "WITNESSCALC_OK", "WITNESSCALC_ERROR", "witnesscalcJNI", "Lio/iden3/circomwitnesscalc/WitnesscalcJniBridge;", "calculateWitness", "", "inputs", "", "graphData", "errorBufferSize", "circomwitnesscalc_release"})
public final class WitnessCalcKt {
    public static final int DEFAULT_ERROR_BUFFER_SIZE = 256;
    private static final int WITNESSCALC_OK = 0;
    private static final int WITNESSCALC_ERROR = 1;
    @NotNull
    private static final WitnesscalcJniBridge witnesscalcJNI = new WitnesscalcJniBridge();

    @NotNull
    public static final byte[] calculateWitness(@NotNull String inputs, @NotNull byte[] graphData, int errorBufferSize) throws WitnesscalcError {
        Intrinsics.checkNotNullParameter((Object)inputs, (String)"inputs");
        Intrinsics.checkNotNullParameter((Object)graphData, (String)"graphData");
        byte[][] witnessArray = new byte[1][];
        long[] witnessSizeArray = new long[1];
        byte[] errorBuffer = new byte[errorBufferSize];
        int statusCode = witnesscalcJNI.calculateWitness(inputs, graphData, graphData.length, witnessArray, witnessSizeArray, errorBuffer, errorBuffer.length);
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        Object object = charset;
        String string = new String(errorBuffer, (Charset)object);
        object = new char[1];
        object[0] = false;
        String error = StringsKt.trim((String)string, (char[])object);
        byte[] witness = (byte[])ArraysKt.first((Object[])((Object[])witnessArray));
        if (statusCode == 0 && witness != null) {
            return witness;
        }
        if (statusCode == 1) {
            throw new WitnesscalcError(error, null, statusCode, 2, null);
        }
        if (witness == null) {
            throw new WitnesscalcError(error, null, 0, 6, null);
        }
        throw new WitnesscalcUnknownStatusError(statusCode);
    }

    public static /* synthetic */ byte[] calculateWitness$default(String string, byte[] byArray, int n, int n2, Object object) throws WitnesscalcError {
        if ((n2 & 4) != 0) {
            n = 256;
        }
        return WitnessCalcKt.calculateWitness(string, byArray, n);
    }
}

