/*
 * Decompiled with CFR 0.152.
 */
package io.idml.jackson.serder;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.idml.IdmlNull$;
import io.idml.IdmlValue;
import io.idml.datanodes.IArray;
import io.idml.datanodes.IDouble;
import io.idml.datanodes.IFalse$;
import io.idml.datanodes.IInt;
import io.idml.datanodes.IObject;
import io.idml.datanodes.IString;
import io.idml.datanodes.ITrue$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005\ra\u0001B\u0001\u0003\u0001-\u0011!\u0003\u0015,bYV,G)Z:fe&\fG.\u001b>fe*\u00111\u0001B\u0001\u0007g\u0016\u0014H-\u001a:\u000b\u0005\u00151\u0011a\u00026bG.\u001cxN\u001c\u0006\u0003\u000f!\tA!\u001b3nY*\t\u0011\"\u0001\u0002j_\u000e\u00011C\u0001\u0001\r!\riQcF\u0007\u0002\u001d)\u0011q\u0002E\u0001\tI\u0006$\u0018MY5oI*\u0011Q!\u0005\u0006\u0003%M\t\u0011BZ1ti\u0016\u0014\b0\u001c7\u000b\u0003Q\t1aY8n\u0013\t1bB\u0001\tKg>tG)Z:fe&\fG.\u001b>feB\u0011\u0001$H\u0007\u00023)\u0011!dG\u0001\u0005Y\u0006twMC\u0001\u001d\u0003\u0011Q\u0017M^1\n\u0005yI\"AB(cU\u0016\u001cG\u000f\u0003\u0005!\u0001\t\u0005\t\u0015!\u0003\"\u0003\u001d1\u0017m\u0019;pef\u0004\"AI\u0013\u000e\u0003\rR!\u0001\n\b\u0002\tQL\b/Z\u0005\u0003M\r\u00121\u0002V=qK\u001a\u000b7\r^8ss\"A\u0001\u0006\u0001B\u0001B\u0003%\u0011&A\u0003lY\u0006\u001c8\u000f\r\u0002+sA\u00191\u0006N\u001c\u000f\u00051\u0012\u0004CA\u00171\u001b\u0005q#BA\u0018\u000b\u0003\u0019a$o\\8u})\t\u0011'A\u0003tG\u0006d\u0017-\u0003\u00024a\u00051\u0001K]3eK\u001aL!!\u000e\u001c\u0003\u000b\rc\u0017m]:\u000b\u0005M\u0002\u0004C\u0001\u001d:\u0019\u0001!\u0011BO\u0014\u0002\u0002\u0003\u0005)\u0011A\u001e\u0003\u0007}#\u0013'\u0005\u0002=\u0001B\u0011QHP\u0007\u0002a%\u0011q\b\r\u0002\b\u001d>$\b.\u001b8h!\ti\u0014)\u0003\u0002Ca\t\u0019\u0011I\\=\t\u000b\u0011\u0003A\u0011A#\u0002\rqJg.\u001b;?)\r1\u0005*\u0013\t\u0003\u000f\u0002i\u0011A\u0001\u0005\u0006A\r\u0003\r!\t\u0005\u0006Q\r\u0003\rA\u0013\u0019\u0003\u00176\u00032a\u000b\u001bM!\tAT\nB\u0005;\u0013\u0006\u0005\t\u0011!B\u0001w!)q\n\u0001C\u0001!\u0006YA-Z:fe&\fG.\u001b>f)\r9\u0012+\u0017\u0005\u0006%:\u0003\raU\u0001\u0003UB\u0004\"\u0001V,\u000e\u0003US!A\u0016\t\u0002\t\r|'/Z\u0005\u00031V\u0013!BS:p]B\u000b'o]3s\u0011\u0015Qf\n1\u0001\\\u0003\u0011\u0019G\u000f\u001f;\u0011\u00055a\u0016BA/\u000f\u0005Y!Um]3sS\u0006d\u0017N_1uS>t7i\u001c8uKb$\b\"B0\u0001\t\u0003\u0001\u0017aC:uCJ$xJ\u00196fGR$2aF1c\u0011\u0015\u0011f\f1\u0001T\u0011\u0015Qf\f1\u0001\\\u0011\u0015!\u0007\u0001\"\u0001f\u0003)\u0019H/\u0019:u\u0003J\u0014\u0018-\u001f\u000b\u0004M2l\u0007CA4k\u001b\u0005A'BA5\u0007\u0003%!\u0017\r^1o_\u0012,7/\u0003\u0002lQ\n1\u0011*\u0011:sCfDQAU2A\u0002MCQAW2A\u0002mCQa\u001c\u0001\u0005\u0002A\fACZ5fY\u0012t\u0015-\\3Pe\u0016sGm\u00142kK\u000e$HcA9ukB\u0011qM]\u0005\u0003g\"\u0014q!S(cU\u0016\u001cG\u000fC\u0003S]\u0002\u00071\u000bC\u0003[]\u0002\u00071\fC\u0003x\u0001\u0011\u0005\u00030\u0001\u0006jg\u000e\u000b7\r[1cY\u0016$\u0012!\u001f\t\u0003{iL!a\u001f\u0019\u0003\u000f\t{w\u000e\\3b]\")Q\u0010\u0001C!}\u0006aq-\u001a;Ok2dg+\u00197vKR\tq\u0003\u0003\u0004\u0002\u0002\u0001!\tE`\u0001\u000eO\u0016$X)\u001c9usZ\u000bG.^3")
public class PValueDeserializer
extends JsonDeserializer<Object> {
    private final Class<?> klass;

    public Object deserialize(JsonParser jp, DeserializationContext ctxt) {
        Object object;
        Object object2 = jp.getCurrentToken() == null ? jp.nextToken() : BoxedUnit.UNIT;
        JsonToken jsonToken = jp.getCurrentToken();
        if (JsonToken.VALUE_NULL.equals(jsonToken)) {
            object = IdmlNull$.MODULE$;
        } else if (JsonToken.VALUE_NUMBER_INT.equals(jsonToken)) {
            object = new IInt(jp.getLongValue());
        } else if (JsonToken.VALUE_NUMBER_FLOAT.equals(jsonToken)) {
            object = new IDouble(jp.getValueAsDouble());
        } else if (JsonToken.VALUE_STRING.equals(jsonToken)) {
            object = new IString(jp.getText());
        } else if (JsonToken.VALUE_TRUE.equals(jsonToken)) {
            object = ITrue$.MODULE$;
        } else if (JsonToken.VALUE_FALSE.equals(jsonToken)) {
            object = IFalse$.MODULE$;
        } else if (JsonToken.START_ARRAY.equals(jsonToken)) {
            object = this.startArray(jp, ctxt);
        } else if (JsonToken.START_OBJECT.equals(jsonToken)) {
            object = this.startObject(jp, ctxt);
        } else {
            boolean bl = JsonToken.FIELD_NAME.equals(jsonToken) ? true : JsonToken.END_OBJECT.equals(jsonToken);
            if (bl) {
                object = this.fieldNameOrEndObject(jp, ctxt);
            } else {
                throw ctxt.mappingException(IdmlValue.class);
            }
        }
        IdmlNull$ value = object;
        if (!this.klass.isAssignableFrom(value.getClass())) {
            throw ctxt.mappingException(this.klass);
        }
        return value;
    }

    public Object startObject(JsonParser jp, DeserializationContext ctxt) {
        jp.nextToken();
        return this.deserialize(jp, ctxt);
    }

    public IArray startArray(JsonParser jp, DeserializationContext ctxt) {
        Buffer values = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        jp.nextToken();
        while (true) {
            JsonToken jsonToken = jp.getCurrentToken();
            JsonToken jsonToken2 = JsonToken.END_ARRAY;
            if (!(jsonToken == null ? jsonToken2 != null : !jsonToken.equals(jsonToken2))) break;
            values.$plus$eq((Object)((IdmlValue)this.deserialize(jp, ctxt)));
            jp.nextToken();
        }
        return new IArray(values);
    }

    public IObject fieldNameOrEndObject(JsonParser jp, DeserializationContext ctxt) {
        Map fields = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        while (true) {
            JsonToken jsonToken = jp.getCurrentToken();
            JsonToken jsonToken2 = JsonToken.END_OBJECT;
            if (!(jsonToken == null ? jsonToken2 != null : !jsonToken.equals(jsonToken2))) break;
            String name = jp.getCurrentName();
            jp.nextToken();
            fields.put((Object)name, (Object)((IdmlValue)this.deserialize(jp, ctxt)));
            jp.nextToken();
        }
        return new IObject(fields);
    }

    public boolean isCachable() {
        return true;
    }

    public Object getNullValue() {
        return IdmlNull$.MODULE$;
    }

    public Object getEmptyValue() {
        return IdmlNull$.MODULE$;
    }

    public PValueDeserializer(TypeFactory factory, Class<?> klass) {
        this.klass = klass;
    }
}

