/*
 * Decompiled with CFR 0.152.
 */
package io.immutables.common;

import java.util.Arrays;

public final class Capacity {
    private Capacity() {
    }

    public static int[] ensure(int[] elements, int limit, int increment) {
        int newCapacity;
        int oldCapacity = elements.length;
        if (oldCapacity - limit >= increment) {
            return elements;
        }
        int requiredCapacity = oldCapacity + increment;
        if (requiredCapacity < oldCapacity) {
            newCapacity = Integer.MAX_VALUE;
        } else {
            newCapacity = oldCapacity << 1;
            if (newCapacity < requiredCapacity) {
                newCapacity = Integer.highestOneBit(requiredCapacity - 1) << 1;
            }
            if (newCapacity == 0) {
                newCapacity = requiredCapacity;
            } else if (newCapacity < 0) {
                newCapacity = Integer.MAX_VALUE;
            }
        }
        return Arrays.copyOf(elements, newCapacity);
    }

    public static char[] ensure(char[] elements, int limit, int increment) {
        int newCapacity;
        int oldCapacity = elements.length;
        if (oldCapacity - limit >= increment) {
            return elements;
        }
        int requiredCapacity = oldCapacity + increment;
        if (requiredCapacity < oldCapacity) {
            newCapacity = Integer.MAX_VALUE;
        } else {
            newCapacity = oldCapacity << 1;
            if (newCapacity < requiredCapacity) {
                newCapacity = Integer.highestOneBit(requiredCapacity - 1) << 1;
            }
            if (newCapacity == 0) {
                newCapacity = requiredCapacity;
            } else if (newCapacity < 0) {
                newCapacity = Integer.MAX_VALUE;
            }
        }
        return Arrays.copyOf(elements, newCapacity);
    }

    public static long[] ensure(long[] elements, int limit, int increment) {
        int newCapacity;
        int oldCapacity = elements.length;
        if (oldCapacity - limit >= increment) {
            return elements;
        }
        int requiredCapacity = oldCapacity + increment;
        if (requiredCapacity < oldCapacity) {
            newCapacity = Integer.MAX_VALUE;
        } else {
            newCapacity = oldCapacity << 1;
            if (newCapacity < requiredCapacity) {
                newCapacity = Integer.highestOneBit(requiredCapacity - 1) << 1;
            }
            if (newCapacity == 0) {
                newCapacity = requiredCapacity;
            } else if (newCapacity < 0) {
                newCapacity = Integer.MAX_VALUE;
            }
        }
        return Arrays.copyOf(elements, newCapacity);
    }

    public static <T> T[] ensure(T[] elements, int limit, int increment) {
        int newCapacity;
        int oldCapacity = elements.length;
        if (oldCapacity - limit >= increment) {
            return elements;
        }
        int requiredCapacity = oldCapacity + increment;
        if (requiredCapacity < oldCapacity) {
            newCapacity = Integer.MAX_VALUE;
        } else {
            newCapacity = oldCapacity << 1;
            if (newCapacity < requiredCapacity) {
                newCapacity = Integer.highestOneBit(requiredCapacity - 1) << 1;
            }
            if (newCapacity == 0) {
                newCapacity = requiredCapacity;
            } else if (newCapacity < 0) {
                newCapacity = Integer.MAX_VALUE;
            }
        }
        return Arrays.copyOf(elements, newCapacity);
    }
}

