/*
 * Decompiled with CFR 0.152.
 */
package io.immutables.common;

import java.util.Objects;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum CaseFormat {
    LowerKebob(c -> c == '-', "-"){

        @Override
        String normalizeWord(String word) {
            return word.toLowerCase();
        }

        @Override
        String convert(CaseFormat format, String s) {
            return switch (format) {
                case LowerSnake -> s.replace('-', '_');
                case UpperSnake -> s.replace('-', '_').toUpperCase();
                default -> super.convert(format, s);
            };
        }
    }
    ,
    LowerSnake(c -> c == '_', "_"){

        @Override
        String normalizeWord(String word) {
            return word.toLowerCase();
        }

        @Override
        String convert(CaseFormat format, String s) {
            return switch (format) {
                case LowerKebob -> s.replace('_', '-');
                case UpperSnake -> s.toUpperCase();
                default -> super.convert(format, s);
            };
        }
    }
    ,
    LowerCamel(Character::isUpperCase, ""){

        @Override
        String normalizeWord(String word) {
            return CaseFormat.firstCharOnlyToUpper(word);
        }

        @Override
        String normalizeFirstWord(String word) {
            return word.toLowerCase();
        }
    }
    ,
    UpperCamel(Character::isUpperCase, ""){

        @Override
        String normalizeWord(String word) {
            return CaseFormat.firstCharOnlyToUpper(word);
        }
    }
    ,
    UpperSnake(c -> c == '_', "_"){

        @Override
        String normalizeWord(String word) {
            return word.toUpperCase();
        }

        @Override
        String convert(CaseFormat format, String s) {
            return switch (format) {
                case LowerKebob -> s.replace('_', '-').toLowerCase();
                case LowerSnake -> s.toLowerCase();
                default -> super.convert(format, s);
            };
        }
    };

    private final CharMatcher boundary;
    private final String separator;

    private CaseFormat(CharMatcher boundary, String separator) {
        this.boundary = boundary;
        this.separator = separator;
    }

    abstract String normalizeWord(String var1);

    String normalizeFirstWord(String word) {
        return this.normalizeWord(word);
    }

    public final String to(CaseFormat format, String s) {
        Objects.requireNonNull(format);
        Objects.requireNonNull(s);
        return format == this ? s : this.convert(format, s);
    }

    String convert(CaseFormat format, String s) {
        StringBuilder out = null;
        int i = 0;
        int j = -1;
        while (true) {
            ++j;
            if ((j = this.indexNextBoundary(s, j)) == -1) break;
            if (i == 0) {
                out = new StringBuilder(s.length() + 4 * format.separator.length());
                out.append(format.normalizeFirstWord(s.substring(i, j)));
            } else {
                ((StringBuilder)Objects.requireNonNull(out)).append(format.normalizeWord(s.substring(i, j)));
            }
            out.append(format.separator);
            i = j + this.separator.length();
        }
        return i == 0 ? format.normalizeFirstWord(s) : ((StringBuilder)Objects.requireNonNull(out)).append(format.normalizeWord(s.substring(i))).toString();
    }

    private int indexNextBoundary(String s, int startIndex) {
        for (int i = startIndex; i < s.length(); ++i) {
            if (!this.boundary.matches(s.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    private static String firstCharOnlyToUpper(String word) {
        return word.isEmpty() ? word : Character.toUpperCase(word.charAt(0)) + word.substring(1).toLowerCase();
    }

    @FunctionalInterface
    private static interface CharMatcher {
        public boolean matches(char var1);
    }
}

