/*
 * Decompiled with CFR 0.152.
 */
package io.immutables.common;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class Glob {
    private static final String ANY_DIRS = "**";
    private static final int NOPE = -1;

    private Glob() {
    }

    public static Glob of(String pattern) {
        pattern = pattern.trim();
        int atAnyDirs = pattern.indexOf(ANY_DIRS);
        int afterAnyDirs = atAnyDirs + ANY_DIRS.length();
        if (atAnyDirs > -1) {
            int atNextAnyDirs = pattern.indexOf(ANY_DIRS, afterAnyDirs);
            if (atNextAnyDirs > -1) {
                if (pattern.startsWith(ANY_DIRS) && pattern.endsWith(ANY_DIRS)) {
                    Glob.checkSlashes(pattern, atNextAnyDirs, afterAnyDirs);
                    String middle = pattern.substring(afterAnyDirs + 1, atNextAnyDirs - 1);
                    if (!middle.contains(ANY_DIRS)) {
                        return Glob.middlePattern(middle);
                    }
                }
                throw new IllegalArgumentException("Unsupported glob syntax, can occur only as a (prefix) or a (suffix)or (suffix and prefix) or in the (middle) but was: " + pattern);
            }
            Glob.checkSlashes(pattern, atAnyDirs, afterAnyDirs);
            return Glob.prefixSuffixPattern(pattern, atAnyDirs, afterAnyDirs);
        }
        return Glob.wholePattern(Glob.toRegex("^", pattern, "$"));
    }

    private static Glob middlePattern(String pattern) {
        final Pattern asMiddle = Glob.toRegex("/", pattern, "/");
        final Pattern asPrefix = Glob.toRegex("^", pattern, "/");
        final Pattern asSuffix = Glob.toRegex("/", pattern, "$");
        final Pattern asWhole = Glob.toRegex("^", pattern, "$");
        return new Glob(){

            @Override
            public boolean matches(String path) {
                return asMiddle.matcher(path).find() || asPrefix.matcher(path).find() || asSuffix.matcher(path).find() || asWhole.matcher(path).find();
            }
        };
    }

    private static Glob wholePattern(final Pattern full) {
        return new Glob(){

            @Override
            public boolean matches(String path) {
                return full.matcher(path).matches();
            }
        };
    }

    private static Glob prefixSuffixPattern(String pattern, int before, int after) {
        boolean noSuffix;
        boolean noPrefix = before == 0;
        boolean bl = noSuffix = after == pattern.length();
        if (noPrefix && noSuffix) {
            return new Glob(){

                @Override
                public boolean matches(String path) {
                    return true;
                }
            };
        }
        if (noPrefix) {
            final Pattern suffix = Glob.toRegex("", pattern.substring(after + 1), "$");
            return new Glob(){

                @Override
                public boolean matches(String path) {
                    return Glob.suffixMatches(suffix, path);
                }
            };
        }
        final String prefixPart = pattern.substring(0, before);
        final Pattern prefix = Glob.toRegex("^", prefixPart, "");
        if (noSuffix) {
            return new Glob(){

                @Override
                public boolean matches(String path) {
                    return Glob.prefixMatches(prefix, Glob.maybeIgnoringFrontSlash(prefixPart, path));
                }
            };
        }
        final Pattern suffix = Glob.toRegex("", pattern.substring(after + 1), "$");
        return new Glob(){

            @Override
            public boolean matches(String path) {
                return Glob.prefixMatches(prefix, Glob.maybeIgnoringFrontSlash(prefixPart, path)) && Glob.suffixMatches(suffix, path);
            }
        };
    }

    private static void checkSlashes(String pattern, int before, int after) {
        if (!Glob.hasSlashOrNothingInFront(pattern, before) || !Glob.hasSlashOrNothingAtEnd(pattern, after)) {
            throw new IllegalArgumentException("Unsupported glob syntax, ** signifies many dirs, not part of the name, need to have a slash separating it from other parts: " + pattern);
        }
    }

    private static boolean hasSlashOrNothingAtEnd(String string, int after) {
        return after == string.length() || string.charAt(after) == '/';
    }

    private static boolean hasSlashOrNothingInFront(String string, int before) {
        return before == 0 || string.charAt(before - 1) == '/';
    }

    private static String maybeIgnoringFrontSlash(String patternPrefix, String path) {
        if (!path.isEmpty() && path.charAt(0) == '/' && patternPrefix.charAt(0) != '/') {
            return path.substring(1);
        }
        return path;
    }

    private static boolean prefixMatches(Pattern prefix, String path) {
        return prefix.matcher(path).find();
    }

    private static boolean suffixMatches(Pattern suffix, String path) {
        Matcher matcher = suffix.matcher(path);
        if (matcher.find()) {
            int start = matcher.start();
            return start == 0 || path.charAt(start - 1) == '/';
        }
        return false;
    }

    private static boolean middleMatches(Pattern suffix, String path) {
        Matcher matcher = suffix.matcher(path);
        if (matcher.find()) {
            int start = matcher.start();
            return start == 0 || path.charAt(start - 1) == '/';
        }
        return false;
    }

    public abstract boolean matches(String var1);

    private static Pattern toRegex(String prefix, String pattern, String suffix) {
        StringBuilder regex = new StringBuilder(prefix);
        int i = 0;
        while (true) {
            int atMany = pattern.indexOf("*", i);
            int atOne = pattern.indexOf("?", i);
            int min = -1;
            if (atMany > -1 && atOne > -1) {
                min = Math.min(atMany, atOne);
            } else if (atMany > -1) {
                min = atMany;
            } else if (atOne > -1) {
                min = atOne;
            }
            if (min == -1) break;
            if (min != i) {
                regex.append(Pattern.quote(pattern.substring(i, min)));
            }
            if (min == atMany) {
                regex.append("[^/]*");
            } else {
                regex.append("[^/]");
            }
            i = min + 1;
        }
        if (i != pattern.length()) {
            regex.append(Pattern.quote(pattern.substring(i)));
        }
        regex.append(suffix);
        return Pattern.compile(regex.toString());
    }
}

