/*
 * Decompiled with CFR 0.152.
 */
package io.immutables.common;

import io.immutables.meta.Null;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Arrays;

public abstract class ProxyHandler
implements InvocationHandler {
    private static final Object[] NO_ARGS = new Object[0];

    @Null
    protected abstract Object handleInterfaceMethod(Object var1, Method var2, Object[] var3) throws Throwable;

    @Override
    @Null
    public final Object invoke(Object proxy, Method method, @Null Object[] arguments) throws Throwable {
        if (arguments == null) {
            arguments = NO_ARGS;
        }
        if (ProxyHandler.isHashCode(method)) {
            return System.identityHashCode(proxy);
        }
        if (ProxyHandler.isEquals(method)) {
            return proxy == arguments[0];
        }
        if (ProxyHandler.isToString(method)) {
            return this.toString(proxy);
        }
        return this.handleInterfaceMethod(proxy, method, arguments);
    }

    @Null
    protected final Object delegate(Object target, Method method, Object ... arguments) throws Throwable {
        assert (method.getDeclaringClass().isInstance(target));
        try {
            return method.invoke(target, arguments);
        }
        catch (InvocationTargetException e) {
            Exception maybeDeclared;
            Throwable cause = e.getCause();
            if (cause instanceof Error) {
                Error error = (Error)cause;
                throw error;
            }
            if (cause instanceof RuntimeException) {
                RuntimeException exception = (RuntimeException)cause;
                throw exception;
            }
            if (cause instanceof Exception && ProxyHandler.declaredInThrows(method, maybeDeclared = (Exception)cause)) {
                throw maybeDeclared;
            }
            throw new UndeclaredThrowableException(cause);
        }
    }

    private static boolean declaredInThrows(Method method, Exception exception) {
        return Arrays.stream(method.getExceptionTypes()).anyMatch(thrown -> thrown.isInstance(exception));
    }

    protected Object toString(Object proxy) {
        return "proxy" + Arrays.stream(proxy.getClass().getInterfaces()).map(c -> {
            String name = c.getCanonicalName();
            return name != null ? name : c.getName();
        }).toList();
    }

    public final boolean equals(@Null Object obj) {
        return super.equals(obj);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public static boolean isToString(Method method) {
        return method.getParameterCount() == 0 && method.getName().equals("toString");
    }

    public static boolean isEquals(Method method) {
        return method.getParameterCount() == 1 && method.getName().equals("equals") && method.getParameterTypes()[0] == Object.class;
    }

    public static boolean isHashCode(Method method) {
        return method.getParameterCount() == 0 && method.getName().equals("hashCode");
    }
}

