/*
 * Decompiled with CFR 0.152.
 */
package io.immutables.common;

import io.immutables.common.Capacity;
import io.immutables.meta.Null;
import java.io.Writer;
import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.Objects;

public interface Source {
    public static CharSequence wrap(char[] input) {
        return new SourceWrapper(input);
    }

    public static final class SourceWrapper
    implements CharSequence {
        private final char[] data;
        private final int begin;
        private final int end;

        SourceWrapper(char[] data) {
            this(data, 0, data.length);
        }

        SourceWrapper(char[] data, int begin, int end) {
            this.data = data;
            this.begin = begin;
            this.end = end;
        }

        @Override
        public CharSequence subSequence(int begin, int end) {
            Objects.checkFromToIndex(begin, end, this.length());
            return new SourceWrapper(this.data, this.begin + begin, this.begin + end);
        }

        @Override
        public int length() {
            return this.end - this.begin;
        }

        @Override
        public char charAt(int index) {
            Objects.checkIndex(index, this.end - this.begin);
            return this.data[this.begin + index];
        }

        @Override
        public String toString() {
            return String.valueOf(this.data, this.begin, this.end - this.begin);
        }
    }

    public static final class Buffer
    extends Writer
    implements CharSequence {
        private static final int MIN_CAPACITY = 128;
        private char[] data = new char[0];
        private int limit = 0;

        public Buffer() {
            this(128);
        }

        public Buffer(int initialCapacity) {
            this.data = Capacity.ensure(this.data, this.limit, initialCapacity);
        }

        @Override
        public int length() {
            return this.limit;
        }

        @Override
        public char charAt(int index) {
            Objects.checkIndex(index, this.limit);
            return this.data[index];
        }

        @Override
        public CharSequence subSequence(int begin, int end) {
            Objects.checkFromToIndex(begin, end, this.limit);
            return new SourceWrapper(this.data, begin, end);
        }

        @Override
        public String toString() {
            return String.valueOf(this.data, 0, this.limit);
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }

        @Override
        public Buffer append(CharSequence cs) {
            if (cs instanceof CharBuffer) {
                int increment = cs.length();
                this.data = Capacity.ensure(this.data, this.limit, increment);
                ((CharBuffer)cs).get(this.data, this.limit, increment);
                this.limit += increment;
                return this;
            }
            return this.append(cs, 0, cs.length());
        }

        @Override
        public Buffer append(CharSequence cs, int start, int end) {
            int increment = end - start;
            this.data = Capacity.ensure(this.data, this.limit, increment);
            if (cs instanceof String) {
                ((String)cs).getChars(start, end, this.data, this.limit);
            } else if (cs instanceof StringBuilder) {
                ((StringBuilder)cs).getChars(start, end, this.data, this.limit);
            } else {
                for (int i = 0; i < increment; ++i) {
                    this.data[this.limit + i] = cs.charAt(start + i);
                }
            }
            this.limit += increment;
            return this;
        }

        @Override
        public void write(String string) {
            this.write(string, 0, string.length());
        }

        @Override
        public void write(String string, int offset, int length) {
            this.data = Capacity.ensure(this.data, this.limit, length);
            string.getChars(offset, offset + length, this.data, this.limit);
            this.limit += length;
        }

        @Override
        public void write(char[] buffer) {
            this.write(buffer, 0, buffer.length);
        }

        @Override
        public void write(char[] buffer, int offset, int length) {
            this.data = Capacity.ensure(this.data, this.limit, length);
            System.arraycopy(buffer, offset, this.data, this.limit, length);
            this.limit += length;
        }

        @Override
        public void write(int c) {
            this.append((char)c);
        }

        @Override
        public Buffer append(char c) {
            this.data = Capacity.ensure(this.data, this.limit, 128);
            this.data[this.limit++] = c;
            return this;
        }

        public void getChars(int srcStart, int srcEnd, char[] dest, int destStart) {
            Objects.checkFromToIndex(srcStart, srcEnd, this.limit);
            System.arraycopy(this.data, srcStart, dest, destStart, srcEnd - srcStart);
        }

        public char[] getUnsafeArray() {
            return this.data;
        }

        public void reset() {
            this.limit = 0;
        }

        public char[] toCharArray() {
            return Arrays.copyOf(this.data, this.limit);
        }
    }

    public static final class Lines {
        private final int[] lines;
        private final int count;

        private Lines(int[] lines, int count) {
            this.lines = lines;
            this.count = count;
        }

        public int count() {
            return this.count;
        }

        public Range getLineRange(int lineNumber) {
            Objects.checkIndex(lineNumber - 1, this.count);
            int before = this.lines[lineNumber - 1];
            int after = this.lines[lineNumber];
            return Range.of(Position.of(before + 1, lineNumber, 1), Position.of(after, lineNumber, after - before));
        }

        public Position get(int position) {
            if (position < 0) {
                throw new IndexOutOfBoundsException("position is not >= 0: " + position);
            }
            int lineIndex = Arrays.binarySearch(this.lines, 0, this.count, position);
            if (lineIndex < 0) {
                lineIndex = -lineIndex - 2;
            }
            int lineNumber = lineIndex + 1;
            int columnNumber = position - this.lines[lineIndex];
            if (columnNumber == 0) {
                columnNumber = position - this.lines[lineIndex - 1];
                --lineNumber;
            }
            return Position.of(position, lineNumber, columnNumber);
        }

        public static Lines from(char[] input) {
            return Lines.from(Source.wrap(input));
        }

        public static Lines from(CharSequence input) {
            Tracker tracker = new Tracker();
            int length = input.length();
            for (int i = 0; i < length; ++i) {
                if (input.charAt(i) != '\n') continue;
                tracker.addNewlineAt(i);
            }
            return tracker.lines(length);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this.count + "]";
        }

        public static final class Tracker {
            private int[] lines = new int[128];
            private int count;

            public Tracker() {
                this.lines[0] = -1;
                this.count = 1;
            }

            public int addNewlineAt(int position) {
                this.lines = Capacity.ensure(this.lines, this.count, 1);
                this.lines[this.count++] = position;
                return this.count;
            }

            public Lines lines(int length) {
                this.lines[this.count] = length;
                return new Lines(this.lines, this.count);
            }
        }
    }

    public static final class Problem {
        public final String filename;
        public final CharSequence source;
        public final Range range;
        public final String message;
        public final String hint;
        public final Lines lines;

        public Problem(String filename, CharSequence source, Lines lines, Range range, String message, String hint) {
            this.filename = filename;
            this.source = source;
            this.lines = lines;
            this.range = range;
            this.message = message;
            this.hint = hint;
        }

        public String toString() {
            return this.filename + ":" + this.range.begin + " " + this.message + "\n\t" + Excerpt.from(this.source, this.lines).get(this.range).toString().replace("\n", "\n\t") + this.hint + "\n";
        }
    }

    public static final class Excerpt {
        private final int gutterWidth;
        private final CharSequence source;
        private final Lines lines;
        private static final String ELLIPSIS = "\u2026";
        private static final String GUTTER_SEPARATOR = " |";
        private static final int TAB_WIDTH = Integer.getInteger("io.immutables.source.tab-width", 2);

        private Excerpt(CharSequence source, Lines lines) {
            this.source = source;
            this.lines = lines;
            this.gutterWidth = Math.max(1, Excerpt.computeLineNumberMagnitude(lines.count()));
        }

        public static Excerpt from(CharSequence source) {
            return new Excerpt(source, Lines.from(source));
        }

        public static Excerpt from(CharSequence source, Lines lines) {
            return new Excerpt(source, lines);
        }

        private static int computeLineNumberMagnitude(int size) {
            int m = 10;
            int i = 1;
            while (m >= 10) {
                if (size / m == 0) {
                    return i;
                }
                m *= 10;
                ++i;
            }
            throw new AssertionError();
        }

        private CharSequence getLine(int lineNumber) {
            return this.lines.getLineRange(lineNumber).get(this.source);
        }

        public StringBuilder get(Range range) {
            int lineNumber = range.begin.line;
            int columnStart = range.begin.column;
            int columnEnd = range.end.line == lineNumber && range.end.column != columnStart ? range.end.column : columnStart + 1;
            StringBuilder sb = new StringBuilder();
            this.appendLinesAbove(sb, lineNumber);
            this.appendLine(sb, lineNumber);
            this.appendSquiggles(sb, lineNumber, columnStart, columnEnd);
            this.appendLinesBelow(sb, lineNumber);
            return sb;
        }

        private void appendSquiggles(StringBuilder sb, int lineNumber, int columnStart, int columnEnd) {
            int i;
            this.gutterFill(sb, '^');
            CharSequence line = this.getLine(lineNumber);
            int squiggleStart = columnStart - 1;
            int squiggleWidth = Math.max(columnEnd - columnStart, 1);
            for (i = 0; i < squiggleStart; ++i) {
                if (line.charAt(i) == '\t') {
                    this.appendRepeat(sb, ' ', TAB_WIDTH);
                    continue;
                }
                sb.append(' ');
            }
            for (i = squiggleStart; i < squiggleStart + squiggleWidth; ++i) {
                if (i < line.length() && line.charAt(i) == '\t') {
                    this.appendRepeat(sb, '^', TAB_WIDTH);
                    continue;
                }
                sb.append('^');
            }
            sb.append('\n');
        }

        private void appendLinesAbove(StringBuilder sb, int lineNumber) {
            if (lineNumber > 1) {
                if (lineNumber == 3) {
                    this.appendLine(sb, lineNumber - 2);
                } else if (lineNumber > 3) {
                    this.appendLine(sb, lineNumber - 2, ELLIPSIS);
                }
                this.appendLine(sb, lineNumber - 1);
            }
        }

        private void appendLinesBelow(StringBuilder sb, int lineNumber) {
            if (lineNumber + 1 <= this.lines.count()) {
                this.appendLine(sb, lineNumber + 1);
                if (lineNumber + 2 == this.lines.count()) {
                    this.appendLine(sb, lineNumber + 2);
                } else if (lineNumber + 2 < this.lines.count()) {
                    this.appendLine(sb, lineNumber + 2, ELLIPSIS);
                }
            }
        }

        private void appendLine(StringBuilder sb, int lineNumber) {
            this.appendLine(sb, lineNumber, this.getLine(lineNumber));
        }

        private void appendLine(StringBuilder sb, int lineNumber, CharSequence content) {
            this.gutter(sb, String.valueOf(lineNumber));
            for (int i = 0; i < content.length(); ++i) {
                char c = content.charAt(i);
                if (c == '\t') {
                    this.appendRepeat(sb, ' ', TAB_WIDTH);
                    continue;
                }
                sb.append(c);
            }
            sb.append('\n');
        }

        private void gutter(StringBuilder sb, String gutter) {
            for (int i = gutter.length(); i < this.gutterWidth; ++i) {
                sb.append(' ');
            }
            sb.append(gutter).append(GUTTER_SEPARATOR);
        }

        private void gutterFill(StringBuilder sb, char c) {
            this.appendRepeat(sb, c, this.gutterWidth);
            sb.append(GUTTER_SEPARATOR);
        }

        private void appendRepeat(StringBuilder sb, char c, int times) {
            for (int i = 0; i < times; ++i) {
                sb.append(c);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (int l = 1; l <= this.lines.count(); ++l) {
                this.appendLine(sb, l);
            }
            return sb.toString();
        }
    }

    public static final class Range {
        public final Position begin;
        public final Position end;

        private Range(Position begin, Position end) {
            this.begin = begin;
            this.end = end;
        }

        public static Range of(Position begin, Position end) {
            if (begin.position > end.position) {
                throw new IllegalArgumentException("end position cannot be before begin position");
            }
            return new Range(begin, end);
        }

        public static Range of(Position begin) {
            return Range.of(begin, begin);
        }

        public CharSequence get(CharSequence source) {
            return source.subSequence(this.begin.position, this.end.position);
        }

        public Range withinLine() {
            if (this.begin.line == this.end.line) {
                return this;
            }
            return new Range(this.begin, this.begin);
        }

        public Range span(Range to) {
            return Range.of(this.begin, to.end);
        }

        public String toString() {
            return this.begin.equals(this.end) ? "[" + this.begin + ")" : "[" + this.begin + "\u2025" + this.end + ")";
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (!(obj instanceof Range)) return false;
            Range r = (Range)obj;
            if (!this.begin.equals(r.begin)) return false;
            if (!this.end.equals(r.end)) return false;
            return true;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.begin.hashCode();
            h += (h << 5) + this.end.hashCode();
            return h;
        }
    }

    public static final class Position {
        public final int position;
        public final int line;
        public final int column;

        private Position(int position, int line, int column) {
            this.position = position;
            this.line = line;
            this.column = column;
        }

        public static Position of(int position, int line, int column) {
            if (position < 0) {
                throw new IllegalArgumentException("position is not [0..): " + position);
            }
            if (line < 1) {
                throw new IllegalArgumentException("line is not [1..): " + line);
            }
            if (column < 1) {
                throw new IllegalArgumentException("column is not [1..) " + column);
            }
            return new Position(position, line, column);
        }

        public String toString() {
            return this.line + ":" + this.column;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.position;
            h += (h << 5) + this.line;
            h += (h << 5) + this.column;
            return h;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(@Null Object another) {
            if (!(another instanceof Position)) return false;
            Position p = (Position)another;
            if (this.position != p.position) return false;
            if (this.line != p.line) return false;
            if (this.column != p.column) return false;
            return true;
        }
    }
}

