/*
 * Decompiled with CFR 0.152.
 */
package io.immutables.common;

import io.immutables.common.Capacity;
import io.immutables.common.Foldable;
import io.immutables.meta.Null;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class Vect<E>
implements Iterable<E>,
Foldable<E> {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private static final Vect<?> EMPTY = new Vect(EMPTY_ARRAY);
    final Object[] elements;

    Vect(Object[] elements) {
        this.elements = elements;
    }

    Vect(boolean checkNonnullElements, Object[] elements) {
        if (checkNonnullElements) {
            for (int i = 0; i < elements.length; ++i) {
                if (elements[i] != null) continue;
                throw new NullPointerException("Vect element[" + i + "] is null");
            }
        }
        this.elements = elements;
    }

    public Iterator iterator() {
        return new Iterator();
    }

    public <R> Vect<R> mapIndex(BiFunction<Integer, ? super E, ? extends R> to) {
        if (this == EMPTY) {
            return Vect.of();
        }
        Object[] newElements = new Object[this.elements.length];
        for (int i = 0; i < this.elements.length; ++i) {
            newElements[i] = Objects.requireNonNull(to.apply(i, this.elements[i]));
        }
        return new Vect<E>(newElements);
    }

    public <R> Vect<R> map(Function<? super E, ? extends R> to) {
        if (this == EMPTY) {
            return Vect.of();
        }
        Object[] newElements = new Object[this.elements.length];
        for (int i = 0; i < this.elements.length; ++i) {
            newElements[i] = Objects.requireNonNull(to.apply(this.elements[i]));
        }
        return new Vect<E>(newElements);
    }

    public <R> Vect<R> flatMap(Function<? super E, ? extends Iterable<R>> to) {
        Builder<R> builder = new Builder<R>(this.elements.length);
        for (Object e : this.elements) {
            for (R r : to.apply(e)) {
                builder.add(r);
            }
        }
        return builder.build();
    }

    public Optional<E> findFirst(Predicate<? super E> is) {
        for (Object o : this.elements) {
            Object e = o;
            if (!is.test(e)) continue;
            return Optional.of(e);
        }
        return Optional.empty();
    }

    public boolean some(Predicate<? super E> is) {
        for (Object e : this.elements) {
            if (!is.test(e)) continue;
            return true;
        }
        return false;
    }

    public boolean all(Predicate<? super E> is) {
        for (Object e : this.elements) {
            if (is.test(e)) continue;
            return false;
        }
        return true;
    }

    public boolean contains(E element) {
        for (Object e : this.elements) {
            if (!e.equals(element)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void forEach(Consumer<? super E> consumer) {
        for (Object e : this.elements) {
            consumer.accept(e);
        }
    }

    public <T> Vect<T> only(Class<T> type) {
        return this.filter(type::isInstance);
    }

    public Vect<E> takeWhile(Predicate<? super E> predicate) {
        int taken;
        for (taken = 0; taken < this.elements.length && predicate.test(this.elements[taken]); ++taken) {
        }
        if (taken == 0) {
            return EMPTY;
        }
        if (taken == this.elements.length) {
            return this;
        }
        return this.range(0, taken);
    }

    public Vect<E> dropWhile(Predicate<? super E> predicate) {
        int dropped;
        for (dropped = 0; dropped < this.elements.length && predicate.test(this.elements[dropped]); ++dropped) {
        }
        if (dropped == 0) {
            return this;
        }
        if (dropped == this.elements.length) {
            return EMPTY;
        }
        return this.rangeFrom(dropped);
    }

    public <R> R bipartition(Predicate<? super E> predicate, BiFunction<Vect<E>, Vect<E>, R> receiver) {
        Builder yes = new Builder(this.elements.length);
        Builder no = new Builder(this.elements.length);
        for (Object e : this) {
            (predicate.test(e) ? yes : no).add(e);
        }
        return receiver.apply(yes.build(), no.build());
    }

    public Vect<E> filter(Predicate<? super E> is) {
        if (this == EMPTY) {
            return this;
        }
        Object[] newElements = (Object[])this.elements.clone();
        int size = 0;
        for (Object e : this.elements) {
            if (!is.test(e)) continue;
            newElements[size++] = e;
        }
        return size == 0 ? Vect.of() : new Vect<E>(Arrays.copyOf(newElements, size));
    }

    @Override
    public <A> A fold(A left, BiFunction<A, E, A> folder) {
        A a = Objects.requireNonNull(left);
        for (Object e : this.elements) {
            a = Objects.requireNonNull(folder.apply(a, e));
        }
        return a;
    }

    @Override
    public <A> A fold(BiFunction<E, A, A> reducer, A right) {
        A a = Objects.requireNonNull(right);
        for (int i = this.elements.length - 1; i >= 0; --i) {
            a = Objects.requireNonNull(reducer.apply(this.elements[i], a));
        }
        return a;
    }

    public Vect<E> prepend(E element) {
        if (this == EMPTY) {
            return Vect.of(element);
        }
        return new Builder<E>(this.elements.length + 1).add(element).addAll(this.elements).build();
    }

    public Vect<E> append(E element) {
        if (this == EMPTY) {
            return Vect.of(element);
        }
        return new Builder<Object>(this.elements.length + 1).addAll(this.elements).add(element).build();
    }

    public Vect<E> sort() {
        if (this.elements.length <= 1) {
            return this;
        }
        Object[] sorted = (Object[])this.elements.clone();
        Arrays.sort(sorted);
        return new Vect<E>(sorted);
    }

    public Vect<E> sort(Comparator<? super E> comparator) {
        if (this.elements.length <= 1) {
            return this;
        }
        Object[] sorted = (Object[])this.elements.clone();
        Arrays.sort(sorted, comparator);
        return new Vect<E>(sorted);
    }

    public Vect<E> reverse() {
        if (this.elements.length <= 1) {
            return this;
        }
        Object[] reversed = (Object[])this.elements.clone();
        int i = 0;
        int j = reversed.length - 1;
        int mid = reversed.length / 2;
        while (i < mid) {
            Object t = reversed[i];
            reversed[i] = reversed[j];
            reversed[j] = t;
            ++i;
            --j;
        }
        return new Vect<E>(reversed);
    }

    @Override
    public E reduce(BiFunction<E, E, E> reducer) {
        if (this.elements.length == 0) {
            throw new NoSuchElementException();
        }
        Object a = this.elements[0];
        for (int i = 1; i < this.elements.length; ++i) {
            a = Objects.requireNonNull(reducer.apply(a, this.elements[i]));
        }
        return (E)a;
    }

    public Vect<E> range(int from, int to) {
        Objects.checkFromToIndex(from, to, this.elements.length);
        if (from == to) {
            return EMPTY;
        }
        return new Vect<E>(Arrays.copyOfRange(this.elements, from, to));
    }

    public Vect<E> rangeFrom(int from) {
        Objects.checkFromToIndex(from, this.elements.length, this.elements.length);
        if (this == EMPTY) {
            return this;
        }
        return new Vect<E>(Arrays.copyOfRange(this.elements, from, this.elements.length));
    }

    public E first() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("first()");
        }
        return (E)this.elements[0];
    }

    public E last() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("last()");
        }
        return (E)this.elements[this.elements.length - 1];
    }

    public E get(int index) {
        return (E)this.elements[index];
    }

    public int size() {
        return this.elements.length;
    }

    public boolean isEmpty() {
        return this.elements.length == 0;
    }

    public int hashCode() {
        return Arrays.hashCode(this.elements);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof Vect && Arrays.equals(this.elements, ((Vect)obj).elements);
    }

    @Override
    public Spliterator<E> spliterator() {
        return Spliterators.spliterator(this.elements, 1024);
    }

    public Stream<E> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public String toString() {
        return this.join(", ", "[", "]");
    }

    public String join(String separator) {
        return this.join(separator, "", "");
    }

    public String join(String separator, String prefix, String suffix) {
        return this.stream().map(Object::toString).collect(Collectors.joining(separator, prefix, suffix));
    }

    public Vect<E> concat(Vect<? extends E> v) {
        return new Builder(this.size() + v.size()).addAll(this).addAll(v).build();
    }

    public Object[] toArray() {
        return (Object[])this.elements.clone();
    }

    public E[] toArray(E[] a) {
        if (a.length < this.elements.length) {
            return Arrays.copyOf(this.elements, this.elements.length, a.getClass());
        }
        System.arraycopy(this.elements, 0, a, 0, this.elements.length);
        if (a.length > this.elements.length) {
            a[this.elements.length] = null;
        }
        return a;
    }

    public E[] toArray(IntFunction<E[]> factory) {
        return this.toArray(factory.apply(this.elements.length));
    }

    public static <E> Vect<E> of(E single) {
        return new Vect<E>(true, new Object[]{single});
    }

    public static <E> Vect<E> of(E first, E second) {
        return new Vect<E>(true, new Object[]{first, second});
    }

    public static <E> Vect<E> of(E first, E second, E third) {
        return new Vect<E>(true, new Object[]{first, second, third});
    }

    public static <E> Vect<E> of(E first, E second, E third, E fourth) {
        return new Vect<E>(true, new Object[]{first, second, third, fourth});
    }

    public static <E> Vect<E> of(E first, E second, E third, E fourth, E fifth) {
        return new Vect<E>(true, new Object[]{first, second, third, fourth, fifth});
    }

    @SafeVarargs
    public static <E> Vect<E> of(E ... elements) {
        if (elements.length == 0) {
            return Vect.of();
        }
        Object[] array = (Object[])elements.clone();
        if (array.length == 0) {
            return Vect.of();
        }
        return new Vect<E>(true, array);
    }

    public static <E> Vect<E> of() {
        return EMPTY;
    }

    @Deprecated
    public static <E> Vect<E> from(Vect<? extends E> vector) {
        return vector;
    }

    public static <E> Vect<E> from(Iterable<? extends E> iterable) {
        if (iterable instanceof Vect) {
            return (Vect)iterable;
        }
        if (iterable instanceof Collection) {
            Object[] array = ((Collection)iterable).toArray();
            if (array.length == 0) {
                return Vect.of();
            }
            return new Vect<E>(true, array);
        }
        return Vect.builder().addAll(iterable).build();
    }

    public static <E> Builder<E> builder() {
        return new Builder(10);
    }

    public static <E> Builder<E> builderWithExpectedSize(int size) {
        return new Builder(size);
    }

    public <R> When<R> when() {
        return new When();
    }

    public static <E> Collector<E, Builder<E>, Vect<E>> to() {
        return Collector.of(Vect::builder, Builder::add, Builder::combine, Builder::build, new Collector.Characteristics[0]);
    }

    public final class Iterator
    implements java.util.Iterator<E> {
        int index = 0;

        @Override
        public boolean hasNext() {
            return this.index < Vect.this.elements.length;
        }

        @Override
        public E next() {
            return Vect.this.elements[this.index++];
        }

        public boolean wasLast() {
            return this.index == Vect.this.elements.length;
        }

        public boolean wasFirst() {
            return this.index == 1;
        }

        public String toString() {
            return Vect.class.getSimpleName() + ".Iterator(at " + this.index + ")";
        }
    }

    public static class Builder<E> {
        private Object[] elements = EMPTY_ARRAY;
        private int size;

        Builder(int expectedSize) {
            this.ensureCapacityFor(expectedSize);
        }

        Builder<E> combine(Builder<E> builder) {
            this.ensureCapacityFor(builder.size);
            System.arraycopy(builder.elements, 0, this.elements, this.size, builder.size);
            this.size += builder.size;
            return this;
        }

        public Builder<E> add(E element) {
            Objects.requireNonNull(element);
            this.ensureCapacityFor(1);
            this.elements[this.size++] = element;
            return this;
        }

        public Builder<E> addAll(E[] elements) {
            this.ensureCapacityFor(elements.length);
            for (E e : elements) {
                this.elements[this.size++] = Objects.requireNonNull(e);
            }
            return this;
        }

        public Builder<E> addAll(Iterable<? extends E> iterable) {
            Objects.requireNonNull(iterable);
            if (iterable instanceof Collection) {
                Object[] array = ((Collection)iterable).toArray();
                this.ensureCapacityFor(array.length);
                for (Object e : array) {
                    this.elements[this.size++] = Objects.requireNonNull(e);
                }
            } else if (iterable instanceof Vect) {
                Object[] array = ((Vect)iterable).elements;
                this.ensureCapacityFor(array.length);
                for (Object e : array) {
                    this.elements[this.size++] = Objects.requireNonNull(e);
                }
            } else {
                for (E e : iterable) {
                    this.ensureCapacityFor(1);
                    this.elements[this.size++] = Objects.requireNonNull(e);
                }
            }
            return this;
        }

        private void ensureCapacityFor(int increment) {
            this.elements = Capacity.ensure(this.elements, this.size, increment);
        }

        public Vect<E> build() {
            return this.size == 0 ? Vect.of() : new Vect(Arrays.copyOf(this.elements, this.size));
        }
    }

    public final class When<R>
    implements Supplier<R> {
        @Null
        private R result;

        public When<R> empty(Supplier<R> onEmpty) {
            if (this.result == null && Vect.this.elements.length == 0) {
                this.result = Objects.requireNonNull(onEmpty.get());
            }
            return this;
        }

        public When<R> single(Function<E, R> onSingle) {
            if (this.result == null && Vect.this.elements.length == 1) {
                this.result = Objects.requireNonNull(onSingle.apply(Vect.this.elements[0]));
            }
            return this;
        }

        public When<R> pair(BiFunction<E, E, R> onPair) {
            if (this.result == null && Vect.this.elements.length == 2) {
                this.result = Objects.requireNonNull(onPair.apply(Vect.this.elements[0], Vect.this.elements[1]));
            }
            return this;
        }

        public When<R> head(BiFunction<E, Vect<E>, R> onHead) {
            if (this.result == null && Vect.this.elements.length >= 1) {
                Object head = Vect.this.elements[0];
                Object[] tail = Arrays.copyOfRange(Vect.this.elements, 1, Vect.this.elements.length);
                this.result = Objects.requireNonNull(onHead.apply(head, new Vect(tail)));
            }
            return this;
        }

        public R otherwise(Function<Vect<E>, R> onElse) {
            if (this.result == null) {
                this.result = Objects.requireNonNull(onElse.apply(Vect.this));
            }
            return this.result;
        }

        public R otherwise(R r) {
            if (this.result == null) {
                this.result = Objects.requireNonNull(r);
            }
            return this.result;
        }

        @Override
        public R get() {
            if (this.result == null) {
                throw new IllegalStateException("Non exhaustive match, use 'otherwise' case");
            }
            return this.result;
        }
    }
}

