package io.imqa;

import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.dsl.DependencyHandler; 
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.DependencyResolutionListener;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.JavaVersion;
import org.gradle.internal.jvm.Jvm;

import io.imqa.injector.util.Logger;
import io.imqa.injector.JavacAction;
import io.imqa.injector.DependencyInjector;

import java.io.IOException;
import java.io.InputStream;
import java.io.File;
import java.util.Set;
import java.util.HashSet;
import java.lang.Iterable;
import java.util.Iterator;
import java.util.Properties;

public class IMQAPlugin implements Plugin<Project> {

	public IMQAPlugin() {
	}

	@Override
	public void apply(Project project) {
		Set<Project> allProject = project.getAllprojects();
		Logger.d("All Project: "+allProject.toString());
		Logger.d("All Project: "+project.getName());


		// project.beforeEvaluate(new JavacAction(project.getName()));
		project.afterEvaluate(new JavacAction(project.getName()));
		Logger.d("IMQAPlugin Applied");

		DependencyInjector depInjector = new DependencyInjector();
		depInjector.doInject(project);
	}

	private void checkRuntimeJvmVersoin() {
		Logger.d("JDK Version", System.getProperty("java.version"));
		Logger.d("JDK Version2", System.getProperty("java.runtime.version"));
		Logger.d("JDK Version3", System.getProperty("java.specification.version"));
		Logger.d("Java Version", JavaVersion.current().getMajorVersion());
		Logger.d("Java Version2", Jvm.current().toString());
	}
}