package io.imqa.asm;

import org.objectweb.asm.*; 

import java.util.HashMap;
import java.util.Set;

import io.imqa.injector.util.Logger;

public class ActivityClassVisitor extends ClassVisitor {
	HashMap<String, Boolean> lifeCycle = new HashMap<>(); // onCreate, onStart, onResume
	String superClass = "";

	public ActivityClassVisitor(ClassVisitor cv) {
		super(Opcodes.ASM5, cv);
		lifeCycle.put("onCreate", false);
		lifeCycle.put("onStart", false);
		lifeCycle.put("onResume", false);
	}

	@Override
	public void visit(int version, int access, String name,
		String signature, String superName, String[] interfaces) {
		cv.visit(version, access, name, signature, superName, interfaces);
		superClass = superName;
		Logger.d("Lifecycle Super Name", superClass);
	}

	@Override 
	public MethodVisitor visitMethod(int access, String name, 
			String desc, String signature, String[] exceptions) { 
		MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
//		Logger.d("Lifecycle VISIT", name+", "+desc + ", "+signature+", "+access);
		switch (name) {
			case "onCreate":
				Logger.d("Lifecycle Name", name+", "+desc + ", "+signature+", "+access);
				lifeCycle.replace("onCreate", true);
				return new LifecycleVisitor(access, name, desc, mv); 
			case "onStart":
				Logger.d("Lifecycle Name", name+", "+desc + ", "+signature+", "+access);
				lifeCycle.replace("onStart", true);
				return new LifecycleVisitor(access, name, desc, mv); 
			case "onResume":
				lifeCycle.replace("onResume", true);
				Logger.d("Lifecycle Name", name+", "+desc + ", "+signature+", "+access);
				return new LifecycleVisitor(access, name, desc, mv); 
			default:
				return mv;
		}
	}
	
	@Override
	public void visitEnd() {
		// 액티비티 클래스에 Life cycle 구현 안된 곳이 있다면 새로 작성
		Set<String> cycleNames = lifeCycle.keySet();
		for(String cycleName : cycleNames) {
			if (!lifeCycle.get(cycleName)) {
				// Adapter 새로 달아서 하고 싶은데..
				//ClassVisitor customCv = new OverrideAdapter(cv);
				//customCv.visitMethod(Opcodes.ACC_PROTECTED, cycleName,"()V", null, null).visitEnd();
				// TODO visitMethod 해서 나온 mv 를 어댑터를 달아서 visitCode를 변경


				//MethodVisitor mv = cv.visitMethod(Opcodes.ACC_PROTECTED, cycleName,"()V", null, null);
				//MethodVisitor mv = new TransformerAdapter();

				MethodVisitor mv = cv.visitMethod(Opcodes.ACC_PROTECTED, cycleName,"()V", null, null);
				LifecycleMakerVisitor lifecyclemv = new LifecycleMakerVisitor(
					Opcodes.ACC_PROTECTED, 
					cycleName, 
					superClass,
					"()V", 
					mv);

				lifecyclemv.visitCode();

				lifecyclemv.visitInsn(Opcodes.RETURN);
				/*onMethodTop(mv, fieldName);
				onMethodMiddle(mv, cycleName);
				onMethodBottom(mv, fieldName);
				mv.visitMaxs(1+4,1);
				mv.visitEnd();
				*/
			}
		}

		cv.visitEnd();
	}



}