package io.imqa.asm;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.IOException;

import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;

import io.imqa.injector.util.Logger;

public class ActivityTransformer {

	public static void doTransform(File classFile) {
		Logger.d("Lifecycle Class Name", classFile.getName());
		InputStream inputStream = null;
		try {
			inputStream = new FileInputStream(classFile);
			if (!transformCheck(inputStream)) {

				InputStream visitorInputStream = new FileInputStream(classFile);
				ClassWriter cw = new ClassWriter(ClassWriter.COMPUTE_MAXS);
				ClassReader cr = new ClassReader(visitorInputStream);
				ClassVisitor cv = new ActivityClassVisitor(cw);
				cr.accept(cv, ClassReader.EXPAND_FRAMES);

				FileOutputStream stream = new FileOutputStream(classFile);
				stream.write(cw.toByteArray());

				stream.close();
				visitorInputStream.close();
			}
			inputStream.close();
		} catch (FileNotFoundException e) {
			Logger.e("Activity Inject", "Not Project Activity");
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	private static boolean transformCheck(InputStream inputStream) {
		ClassVisitChecker cv = new ClassVisitChecker();
		try {
			ClassReader cr = new ClassReader(inputStream);

			cv.addCheckList(Opcodes.GETSTATIC,
					"io/imqa/core/dump/ActivityRenderData",
					"CREATED",
					"Ljava/lang/String;");
			cv.addCheckList(Opcodes.GETSTATIC,
					"io/imqa/core/dump/ActivityRenderData",
					"STARTED",
					"Ljava/lang/String;");
			cv.addCheckList(Opcodes.GETSTATIC,
					"io/imqa/core/dump/ActivityRenderData",
					"RESUMED",
					"Ljava/lang/String;");


			cr.accept(cv, 0);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		return cv.isOverrided();
	}
}