package io.imqa.asm;

import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

import io.imqa.injector.util.Logger;

public class ClassVisitChecker extends ClassVisitor {
    private ArrayList<CheckList> checkList = new ArrayList<>();
    private boolean overrided = false;

    public ClassVisitChecker() {
        super(Opcodes.ASM5);
    }

    public void addCheckList(int opcode, String owner, String name, String desc) {
        checkList.add(new CheckList(opcode, owner, name, desc));
    }

    public boolean isOverrided() {
        return overrided;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name,
                                     String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        return new MethodVisitChecker(Opcodes.ASM5, mv);
    }

    class MethodVisitChecker extends MethodVisitor {
        public MethodVisitChecker(int api) {
            super(api);
        }

        public MethodVisitChecker(int api, MethodVisitor mv) {
            super(api, mv);
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            if (check(opcode, owner, name, desc))
                overrided = true;

            super.visitMethodInsn(opcode, owner, name, desc, itf);
        }

        @Override
        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            if (check(opcode, owner, name, desc))
                overrided = true;

            super.visitFieldInsn(opcode, owner, name, desc);
        }

        public boolean check(int opcode, String owner, String name, String desc) {
            boolean isExist = false;
            for (CheckList item : checkList) {
                if (item.opcode == opcode
                        && item.owner.equals(owner)
                        && item.name.equals(name)
                        && item.desc.equals(desc))
                    isExist = true;
            }

            return isExist;
        }
    }
}
