package io.imqa.asm;

import org.objectweb.asm.*; 

import io.imqa.injector.util.Logger;
import java.util.ArrayList;
import java.util.List;

public class EventFinder implements Finder {
	
	public void init() {

	}

	public boolean find(String name) {

		switch(name) {
			case "android/view/View$OnClickListener":
			case "android/view/View$OnLongClickListener":
			case "android/view/View$OnFocusChangeListener":
			case "android/view/View$OnKeyListener":
			case "android/view/View$OnTouchListener":
				//Logger.d("SuperClass name", name);
				return true;
		}

		return false;
	}

	private boolean checkMethod(String name, String[] allowedNameList) {
		for(String allowedName : allowedNameList) {
			if (name.equals(allowedName))
				return true;
		}

		return false;
	}

	private String[] getEventMethod(String eventName) {
		List<String> methodList = new ArrayList<String>();

		switch(eventName) {
			case "android/view/View$OnClickListener":
				methodList.add("onClick");
				break;
			case "android/view/View$OnLongClickListener":
				methodList.add("onLongClick");
				break;
			case "android/view/View$OnFocusChangeListener":
				methodList.add("onFocusChange");
				break;
			case "android/view/View$OnKeyListener":
				methodList.add("onKey");
				break;
			case "android/view/View$OnTouchListener":
				methodList.add("onTouch");
				break;
		}
		String[] methodArray = new String[methodList.size()];
		methodList.toArray(methodArray);
		return methodArray;
	}

	public MethodVisitor getVisitor(String[] interfaceList, String className, String superName, 
		int access, String name, String desc, MethodVisitor mv) {
		
		if (find(superName)
			&& checkMethod(name, getEventMethod(superName))) {
			return new EventVisitor(className, access, name, desc, mv); 
		}

		for (String interfaceName : interfaceList) {
			if (find(interfaceName)
				&& checkMethod(name, getEventMethod(interfaceName))) {
				//Logger.d("Interface name", interfaceName);
				Logger.d("Event Inject", className + ", Method : "+name);
				return new EventVisitor(className, access, name, desc, mv); 
			}
		}

		return mv;
	}

	@Override
	public void visitEnd(ClassVisitor cv, String className, String superClass, String[] interfaceList) {
	}
}