package io.imqa.asm;

import org.objectweb.asm.*; 

import io.imqa.injector.util.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class FragmentMakerFinder implements Finder {

	HashMap<String, Boolean> lifeCycle = new HashMap<>(); // onCreateView, onStart, onResume

	public void init() {
		lifeCycle.clear();
		lifeCycle.put("onCreate", false);
		lifeCycle.put("onCreateView", false);
		lifeCycle.put("onStart", false);
		lifeCycle.put("onResume", false);
	}

	public boolean find(String name) {

		switch(name) {
			case "android/support/v4/app/Fragment":
			case "android/support/v4/app/DialogFragment":
			case "android/support/v4/app/ListFragment":
			case "android/support/v4/app/PreferenceFragment":
			case "android/app/Fragment":
			
				Logger.d("SuperClass name", name);
				return true;
		}

		return false;
	}

	private boolean checkMethod(String name, String[] allowedNameList) {
		for(String allowedName : allowedNameList) {
			if (name.equals(allowedName))
				return true;
		}

		return false;
	}

	private String[] getFragmentMethod() {
		List<String> methodList = new ArrayList<String>();

		//methodList.add("onAttach");
		methodList.add("onCreate");
		methodList.add("onCreateView");
		methodList.add("onActivityCreated");
		methodList.add("onViewStateRestored");
		methodList.add("onStart");
		methodList.add("onResume");

		/*
		methodList.add("onPause");
		methodList.add("onStop");
		methodList.add("onDestroyView");
		methodList.add("onDestroy");
		methodList.add("onDetach");
		*/

		String[] methodArray = new String[methodList.size()];
		methodList.toArray(methodArray);
		return methodArray;
	}

	public MethodVisitor getVisitor(String[] interfaceList, String className, String superName, 
		int access, String name, String desc, MethodVisitor mv) {

		if (find(superName)
			&& checkMethod(name, getFragmentMethod())) {
			Logger.d("Fragment Inject", className + ", Method : "+name);

			setVisited(name);
			return new FragmentVisitor(className, access, name, desc, mv); 
		}

		for (String interfaceName : interfaceList) {
			if (find(interfaceName)
				&& checkMethod(name, getFragmentMethod())) {
				Logger.d("Fragment Inject", className + ", Method : "+name);
				setVisited(name);
				return new FragmentVisitor(className, access, name, desc, mv); 
			}
		}

		return mv;
	}

	@Override
	public void visitEnd(ClassVisitor cv, String className, String superClass, String[] interfaceList) {
		if (find(superClass)) {
			makeVisit(cv, className, superClass);
		}

		for (String interfaceName : interfaceList) {
			if (find(interfaceName)) {
				makeVisit(cv, className, superClass);
			}
		}
	}

	protected void setVisited(String name) {
		switch (name) {
			case "onCreate":
			case "onCreateView":
			case "onStart":
			case "onResume":
				lifeCycle.replace(name, true);
				break;
		}
	}

	protected void makeVisit(ClassVisitor cv, String className, String superClass) {
		// 프래그먼트 클래스에 Life cycle 구현 안된 곳이 있다면 새로 작성
		Set<String> cycleNames = lifeCycle.keySet();
		for(String cycleName : cycleNames) {
			if (!lifeCycle.get(cycleName)) {
				String desc = "()V";
				switch (cycleName) {
					case "onCreate": 
						desc = "(Landroid/os/Bundle;)V";
						break;
					case "onCreateView":
						desc = "(Landroid/view/LayoutInflater;Landroid/view/ViewGroup;Landroid/os/Bundle;)Landroid/view/View;";
						break;
				}

				MethodVisitor mv = cv.visitMethod(Opcodes.ACC_PUBLIC, cycleName, desc, null, null);
				FragmentMakerVisitor lifecyclemv = new FragmentMakerVisitor(
					className,
					Opcodes.ACC_PUBLIC, 
					cycleName, 
					superClass,
					desc, 
					mv);

				lifecyclemv.visitCode();

				lifecyclemv.visitInsn(Opcodes.RETURN);
			}
		}
	}
}