package io.imqa.asm;

import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;

public class FragmentMakerVisitor extends FragmentVisitor {

	String superClass = "";
	String desc = "";

	protected FragmentMakerVisitor(String className, int access, String name, String superClass, String desc, MethodVisitor mv) { 
		super(className, access, name, desc, mv);
		this.superClass = superClass;
		this.desc = desc;
	} 

	@Override 
	protected void onMethodEnter() {
		super.onMethodEnter();
		onMethodMiddle(mv, superClass);
	}


	protected void onMethodMiddle(MethodVisitor mv, String name) {
		mv.visitVarInsn(Opcodes.ALOAD, 0);
		switch (fieldName) {
			case "onCreate":
				mv.visitVarInsn(Opcodes.ALOAD, 1);
				break;
			case "onCreateView":
				mv.visitVarInsn(Opcodes.ALOAD, 1);
				mv.visitVarInsn(Opcodes.ALOAD, 2);
				mv.visitVarInsn(Opcodes.ALOAD, 3);
				break;
		}

		mv.visitMethodInsn(
				Opcodes.INVOKESPECIAL, 
				superClass,
				fieldName, 
				desc);

	}

	protected void onMethodExit(int opcode) {
		super.onMethodExit(opcode);
	}
}
