package io.imqa.asm;

import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.commons.AdviceAdapter;

public class FragmentVisitor extends AdviceAdapter { 
	protected String className;
	protected String fieldName;
	protected String renderName;

	protected FragmentVisitor(String className, int access, String name, String desc, MethodVisitor mv) { 
		super(Opcodes.ASM5, mv, access, name, desc);
		this.className = className;
		this.fieldName = name;
		this.renderName = checkCycle(name);
	} 
	
	@Override 
	protected void onMethodEnter() {
		mv.visitMethodInsn(
				Opcodes.INVOKESTATIC, 
				"io/imqa/mpm/IMQAMpmAgent", 
				"getInstance", 
				"()Lio/imqa/mpm/IMQAMpmAgent;"); 
		mv.visitVarInsn(Opcodes.ALOAD, 0);
		mv.visitMethodInsn(
				Opcodes.INVOKEVIRTUAL, 
				className, 
				"getContext", 
				"()Landroid/content/Context;"); 
		mv.visitMethodInsn(
				Opcodes.INVOKEVIRTUAL, 
				"io/imqa/mpm/IMQAMpmAgent", 
				"setActivityContext", 
				"(Landroid/content/Context;)Lio/imqa/mpm/IMQAMpmAgent;"); 
		mv.visitLdcInsn(className);
		mv.visitFieldInsn(
				Opcodes.GETSTATIC, 
				"io/imqa/mpm/dump/FragmentRenderData", 
				renderName, 
				"Ljava/lang/String;");
		mv.visitMethodInsn(
				Opcodes.INVOKEVIRTUAL, 
				"io/imqa/mpm/IMQAMpmAgent", 
				"startFragmentRender", 
				"(Ljava/lang/String;Ljava/lang/String;)V"); 
	}
	@Override
	protected void onMethodExit(int opcode) {
		mv.visitMethodInsn(
				Opcodes.INVOKESTATIC, 
				"io/imqa/mpm/IMQAMpmAgent", 
				"getInstance", 
				"()Lio/imqa/mpm/IMQAMpmAgent;"); 
		mv.visitVarInsn(Opcodes.ALOAD, 0);
		mv.visitMethodInsn(
				Opcodes.INVOKEVIRTUAL, 
				className, 
				"getContext", 
				"()Landroid/content/Context;"); 
		mv.visitMethodInsn(
				Opcodes.INVOKEVIRTUAL, 
				"io/imqa/mpm/IMQAMpmAgent", 
				"setActivityContext", 
				"(Landroid/content/Context;)Lio/imqa/mpm/IMQAMpmAgent;"); 
		mv.visitLdcInsn(className);
		mv.visitFieldInsn(
				Opcodes.GETSTATIC, 
				"io/imqa/mpm/dump/FragmentRenderData", 
				renderName, 
				"Ljava/lang/String;");
		mv.visitMethodInsn(
				Opcodes.INVOKEVIRTUAL, 
				"io/imqa/mpm/IMQAMpmAgent", 
				"endFragmentRender", 
				"(Ljava/lang/String;Ljava/lang/String;)V"); 
	}

	
	@Override 
	public void visitMaxs(int maxStack, int maxLocals) { 
		super.visitMaxs(maxStack, maxLocals); 
	} 

	protected String checkCycle(String cycleName) {
		switch (cycleName) {
			case "onCreate":
				cycleName = "CREATED";
				break;
			case "onCreateView":
				cycleName = "VIEW_CREATED";
				break;
			case "onActivityCreated":
				cycleName = "ACTIVITY_CREATED";
				break;
			case "onStart":
				cycleName = "STARTED";
				break;
			case "onResume":
				cycleName = "RESUMED";
				break;
			/*
			 * Not neccecery to collect rendering time
			case "onPause":
				cycleName = "PAUSED";
				break;
			case "onStop":
				cycleName = "STOPED";
				break;
			case "onDestroyView":
				cycleName = "VIEW_DESTROYED";
				break;
			case "onDestroy":
				cycleName = "DESTROYED";
				break;
			case "onDetach":
				cycleName = "DETACHED";
				break;
			*/

		}

		return cycleName;
	}


}
