package io.imqa.asm;

import org.objectweb.asm.*; 

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

import io.imqa.injector.util.Logger;
import io.imqa.injector.util.BuildOption;

public class GlobalClassVisitor extends ClassVisitor {
	String superClass = "";
	String className = "";
	boolean eventClass = false;
	boolean webviewClass = false;
	String[] interfaces;


	List<Finder> finderList = new ArrayList<Finder>();

	public GlobalClassVisitor(ClassVisitor cv) {
		super(Opcodes.ASM5, cv);
		if (BuildOption.eventListenerInject)
			finderList.add(new EventFinder());
		if (BuildOption.webViewInject)
			finderList.add(new WebviewFinder());
		if (BuildOption.fragmentInject) {
			finderList.add(new FragmentMakerFinder());
		}
	}

	@Override
	public void visit(int version, int access, String name,
		String signature, String superName, String[] interfaces) {
		cv.visit(version, access, name, signature, superName, interfaces);
		this.className = name;
		this.superClass = superName;
		this.interfaces = interfaces;

		//Logger.d("Extended", superName);
		for(Finder finder : finderList) {
			// TODO 만약 event를 커스텀 하여 새로 만들었을 경우 이 클래스를 또 다시 extends 한 클래스를 찾아야 한다.
			if (finder.find(superName)) {
				finder.init();
			}
		}
	}

	@Override 
	public MethodVisitor visitMethod(int access, String name, 
			String desc, String signature, String[] exceptions) { 
		//Logger.d("Name: "+name+", "+desc + ", "+signature+", "+access);
		MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions); 

		for(Finder finder : finderList) {
			mv = finder.getVisitor(interfaces, className, superClass, access, name, desc, mv);
		}

		return mv;
	}
	
	@Override
	public void visitEnd() {
		// TODO 라이프사이클 관련은 프래그먼트로 넣을 것
		for(Finder finder : finderList) {
			finder.visitEnd(cv, className, superClass, interfaces);
		}

		cv.visitEnd();
	}



}