package io.imqa.asm;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.IOException;

import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;

import io.imqa.injector.util.Logger;

public class GlobalTransformer {

	public static void doTransform(File classFile) {
		InputStream inputStream = null;
		try {
			inputStream = new FileInputStream(classFile);
			if (!transformCheck(inputStream)) {

				InputStream visitInputStream = new FileInputStream(classFile);
				ClassWriter cw = new ClassWriter(ClassWriter.COMPUTE_MAXS);
				ClassReader cr = new ClassReader(visitInputStream);
				ClassVisitor cv = new GlobalClassVisitor(cw);
				cr.accept(cv, ClassReader.EXPAND_FRAMES);

				FileOutputStream stream = new FileOutputStream(classFile);
				stream.write(cw.toByteArray());

				stream.close();
				visitInputStream.close();
			}
			inputStream.close();
		} catch (FileNotFoundException e) {
			Logger.e("Global Inject", "Not Found class");
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}


	private static boolean transformCheck(InputStream inputStream) {
		ClassVisitChecker cv = new ClassVisitChecker();
		try {
			ClassReader cr = new ClassReader(inputStream);

			cv.addCheckList(Opcodes.INVOKEVIRTUAL,
					"io/imqa/mpm/IMQAMpmAgent",
					"startEvent",
					"(Ljava/lang/String;Ljava/lang/String;)V");
			cv.addCheckList(Opcodes.INVOKEVIRTUAL,
					"io/imqa/mpm/IMQAMpmAgent",
					"startFragmentRender",
					"(Ljava/lang/String;Ljava/lang/String;)V");
			cv.addCheckList(Opcodes.INVOKESTATIC,
					"io/imqa/mpm/network/MPMWebviewInterface",
					"requestHttp",
					"(Landroid/webkit/WebView;Ljava/lang/String;)V");


			cr.accept(cv, 0);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		return cv.isOverrided();
	}
}