package io.imqa.asm;

import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;

public class LifecycleMakerVisitor extends LifecycleVisitor {

	String superClass = "";
	protected LifecycleMakerVisitor(int access, String name, String superClass, String desc, MethodVisitor mv) { 
		super(access, name, desc, mv);
		this.superClass = superClass;
	} 

	@Override 
	protected void onMethodEnter() {
		super.onMethodEnter();
		onMethodMiddle(mv, superClass);
	}


	protected void onMethodMiddle(MethodVisitor mv, String name) {
		// super.onLife();
		mv.visitVarInsn(Opcodes.ALOAD, 0);
		mv.visitMethodInsn(
				Opcodes.INVOKESPECIAL, 
				superClass,
				//"android/support/v7/app/AppCompatActivity", 
				fieldName, 
				"()V");

//		onMethodExit(0);
	}

	protected void onMethodExit(int opcode) {
		super.onMethodExit(opcode);
	}
}
