package io.imqa.asm;

import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.commons.AdviceAdapter;

import java.util.ArrayList;

import io.imqa.injector.util.Logger;

public class LifecycleVisitor extends AdviceAdapter { 
	protected String fieldName;
	protected String renderName;

	protected LifecycleVisitor(int access, String name, String desc, MethodVisitor mv) { 
		super(Opcodes.ASM5, mv, access, name, desc);
		this.fieldName = name;
		this.renderName = checkCycle(name);
	}

	@Override 
	protected void onMethodEnter() {
		mv.visitMethodInsn(
				Opcodes.INVOKESTATIC, 
				"io/imqa/mpm/IMQAMpmAgent", 
				"getInstance", 
				"()Lio/imqa/mpm/IMQAMpmAgent;"); 
		mv.visitVarInsn(Opcodes.ALOAD, 0);
		mv.visitMethodInsn(
				Opcodes.INVOKEVIRTUAL, 
				"io/imqa/mpm/IMQAMpmAgent", 
				"setActivityContext", 
				"(Landroid/content/Context;)Lio/imqa/mpm/IMQAMpmAgent;"); 
		mv.visitFieldInsn(
				Opcodes.GETSTATIC, 
				"io/imqa/mpm/dump/ActivityRenderData", 
				renderName, 
				"Ljava/lang/String;");
		mv.visitMethodInsn(
				Opcodes.INVOKEVIRTUAL, 
				"io/imqa/mpm/IMQAMpmAgent", 
				"startRender", 
				"(Ljava/lang/String;)V"); 
	}
	@Override
	protected void onMethodExit(int opcode) {
		mv.visitMethodInsn(
				Opcodes.INVOKESTATIC, 
				"io/imqa/mpm/IMQAMpmAgent", 
				"getInstance", 
				"()Lio/imqa/mpm/IMQAMpmAgent;"); 
		mv.visitVarInsn(Opcodes.ALOAD, 0);
		mv.visitMethodInsn(
				Opcodes.INVOKEVIRTUAL, 
				"io/imqa/mpm/IMQAMpmAgent", 
				"setActivityContext", 
				"(Landroid/content/Context;)Lio/imqa/mpm/IMQAMpmAgent;"); 
		mv.visitFieldInsn(
				Opcodes.GETSTATIC, 
				"io/imqa/mpm/dump/ActivityRenderData", 
				renderName, 
				"Ljava/lang/String;");
		mv.visitMethodInsn(
				Opcodes.INVOKEVIRTUAL, 
				"io/imqa/mpm/IMQAMpmAgent", 
				"endRender", 
				"(Ljava/lang/String;)V");
	}

	
	@Override 
	public void visitMaxs(int maxStack, int maxLocals) { 
		super.visitMaxs(maxStack, maxLocals); 
	}

	protected String checkCycle(String cycleName) {
		switch (cycleName) {
			case "onCreate":
				cycleName = "CREATED";
				break;
			case "onStart":
				cycleName = "STARTED";
				break;
			case "onResume":
				cycleName = "RESUMED";
				break;
		}

		return cycleName;
	}


}
