package io.imqa.asm;

import org.objectweb.asm.*; 
import io.imqa.injector.util.Logger;

public class OverrideAdapter extends ClassVisitor {

	public OverrideAdapter(ClassVisitor cv) {
		super(Opcodes.ASM5, cv);
	}

	@Override
	public void visit(int version, int access, String name,
		String signature, String superName, String[] interfaces) {
		cv.visit(version, access, name, signature, superName, interfaces);
	}

	@Override 
	public MethodVisitor visitMethod(int access, String name, 
			String desc, String signature, String[] exceptions) { 
		Logger.d("Name: "+name+", "+desc + ", "+signature+", "+access);
		MethodVisitor mv = cv.visitMethod(access, name, desc, signature, exceptions); 

		String fieldName = "";
		switch (name) {
			case "onCreate":
				fieldName = "CREATED";
				break;
			case "onStart":
				fieldName = "STARTED";
				break;
			case "onResume":
				fieldName = "RESUMED";
				break;
		}
		
		mv.visitCode();
		
		// TOP
		mv.visitMethodInsn(
				Opcodes.INVOKESTATIC, 
				"io/imqa/mpm/IMQAMpmAgent", 
				"getInstance", 
				"()Lio/imqa/mpm/IMQAMpmAgent;"); 
		mv.visitVarInsn(Opcodes.ALOAD, 0);
		mv.visitMethodInsn(
				Opcodes.INVOKEVIRTUAL, 
				"io/imqa/mpm/IMQAMpmAgent", 
				"setActivityContext", 
				"(Landroid/content/Context;)Lio/imqa/mpm/IMQAMpmAgent;"); 
		mv.visitFieldInsn(
				Opcodes.GETSTATIC, 
				"io/imqa/mpm/dump/ActivityRenderData", 
				fieldName, 
				"Ljava/lang/String;"); 
		//mv.visitLdcInsn(this.name);
		mv.visitMethodInsn(
				Opcodes.INVOKEVIRTUAL, 
				"io/imqa/mpm/IMQAMpmAgent", 
				"startRender", 
				"(Ljava/lang/String;)V"); 

		// MIDDLE
		mv.visitVarInsn(Opcodes.ALOAD, 0);
		mv.visitMethodInsn(
				Opcodes.INVOKESPECIAL, 
				"android/support/v7/app/AppCompatActivity", 
				name, 
				"()V");

		// BOTTOM
		mv.visitMethodInsn(
				Opcodes.INVOKESTATIC, 
				"io/imqa/mpm/IMQAMpmAgent", 
				"getInstance", 
				"()Lio/imqa/mpm/IMQAMpmAgent;"); 
		mv.visitVarInsn(Opcodes.ALOAD, 0);
		mv.visitMethodInsn(
				Opcodes.INVOKEVIRTUAL, 
				"io/imqa/mpm/IMQAMpmAgent", 
				"setActivityContext", 
				"(Landroid/content/Context;)Lio/imqa/mpm/IMQAMpmAgent;"); 
		mv.visitFieldInsn(
				Opcodes.GETSTATIC, 
				"io/imqa/mpm/dump/ActivityRenderData", 
				fieldName, 
				"Ljava/lang/String;"); 
		//mv.visitLdcInsn(this.name);
		mv.visitMethodInsn(
				Opcodes.INVOKEVIRTUAL, 
				"io/imqa/mpm/IMQAMpmAgent", 
				"endRender", 
				"(Ljava/lang/String;)V"); 
		return mv;
	}

	@Override
	public void visitEnd() {
	}
}