package io.imqa.asm;

import org.objectweb.asm.*; 

import io.imqa.injector.util.Logger;

public class WebviewFinder implements Finder {
	public void init() {

	}
	
	public boolean find(String name) {

		switch(name) {
			case "android/webkit/WebViewClient":
			case "android/webkit/WebChromeClient":
			
				Logger.d("SuperClass name", name);
				return true;
		}

		return false;
	}

	public MethodVisitor getVisitor(String[] interfaceList, String className, String superName, 
		int access, String name, String desc, MethodVisitor mv) {
		
		if (find(superName)) {
			/*switch (name) {
				case "shouldOverrideUrlLoading":
					return 
			}*/
			return new WebviewLoadVisitor(className, access, name, desc, mv); 
		} else {
			for (String interfaceName : interfaceList) {
				switch(interfaceName) {
					case "android/webkit/WebViewClient":
						Logger.d("Interface name", interfaceName);
						//return true;
						return new WebviewLoadVisitor(className, access, name, desc, mv); 
				}
			}
		}

		return mv;
	}

	@Override
	public void visitEnd(ClassVisitor cv, String className, String superClass, String[] interfaceList) {
	}
}