package io.imqa.asm;

import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.commons.AdviceAdapter;

import io.imqa.injector.util.Logger;

public class WebviewLoadVisitor extends AdviceAdapter { 
	protected String methodName;
	protected String className;
	protected String desc;

	protected WebviewLoadVisitor(String className, int access, String methodName, String desc, MethodVisitor mv) { 
		super(Opcodes.ASM5, mv, access, methodName, desc);
		this.className = className;
		this.methodName = methodName;
		this.desc = desc;


	} 
	
	@Override 
	protected void onMethodEnter() {
		Logger.d("Webview Method name", methodName);
		Logger.d("Webview Method desc", desc);

		switch (this.methodName) {
			
			case "shouldOverrideUrlLoading":
				if (this.desc.equals("(Landroid/webkit/WebView;Ljava/lang/String;)Z")) {
					mv.visitVarInsn(Opcodes.ALOAD, 1);
					mv.visitVarInsn(Opcodes.ALOAD, 2);
					mv.visitMethodInsn(
						Opcodes.INVOKESTATIC, 
						"io/imqa/mpm/network/MPMWebviewInterface", 
						"requestHttp", 
						"(Landroid/webkit/WebView;Ljava/lang/String;)V");
				}
				break;
			case "shouldInterceptRequest" :
				if (this.desc.equals("(Landroid/webkit/WebView;Landroid/webkit/WebResourceRequest;)Landroid/webkit/WebResourceResponse;")) {
					mv.visitVarInsn(Opcodes.ALOAD, 0); 
					mv.visitVarInsn(Opcodes.ALOAD, 2); 
					mv.visitMethodInsn(
						Opcodes.INVOKESTATIC, 
						"io/imqa/mpm/network/MPMWebviewInterface", 
						"urlStart", 
						"(Landroid/webkit/WebViewClient;Landroid/webkit/WebResourceRequest;)V");
				} else if (this.desc.equals("(Landroid/webkit/WebView;Ljava/lang/String;)Landroid/webkit/WebResourceResponse;")) {
					mv.visitVarInsn(Opcodes.ALOAD, 0); 
					mv.visitVarInsn(Opcodes.ALOAD, 2); 
					mv.visitLdcInsn("GET");
					mv.visitMethodInsn(
						Opcodes.INVOKESTATIC, 
						"io/imqa/mpm/network/MPMWebviewInterface", 
						"urlStart", 
						"(Landroid/webkit/WebViewClient;Ljava/lang/String;Ljava/lang/String;)V");
				}
				break;
			case "onPageStarted":
				if (this.desc.equals("(Landroid/webkit/WebView;Ljava/lang/String;Landroid/graphics/Bitmap;)V")) {
					mv.visitVarInsn(Opcodes.ALOAD, 0); 
					mv.visitMethodInsn(
						Opcodes.INVOKESTATIC, 
						"io/imqa/mpm/network/MPMWebviewInterface", 
						"onPageStarted", 
						"(Landroid/webkit/WebViewClient;)V");
				}
				break;
			case "onPageFinished":
				if (this.desc.equals("(Landroid/webkit/WebView;Ljava/lang/String;)V")) {
					mv.visitVarInsn(Opcodes.ALOAD, 0); 
					mv.visitVarInsn(Opcodes.ALOAD, 1); 
					mv.visitVarInsn(Opcodes.ALOAD, 2); 
					mv.visitMethodInsn(
						Opcodes.INVOKESTATIC, 
						"io/imqa/mpm/network/MPMWebviewInterface", 
						"loadEndJavascript", 
						"(Landroid/webkit/WebViewClient;Landroid/webkit/WebView;Ljava/lang/String;)Ljava/lang/String;");
				}
				break;
			case "onReceivedHttpError":
				if (this.desc.equals("(Landroid/webkit/WebView;Landroid/webkit/WebResourceRequest;Landroid/webkit/WebResourceResponse;)V")) {
					mv.visitVarInsn(Opcodes.ALOAD, 0); 
					mv.visitVarInsn(Opcodes.ALOAD, 2); 
					mv.visitVarInsn(Opcodes.ALOAD, 3); 
					mv.visitMethodInsn(
						Opcodes.INVOKESTATIC, 
						"io/imqa/mpm/network/MPMWebviewInterface", 
						"receivedError", 
						"(Landroid/webkit/WebViewClient;Landroid/webkit/WebResourceRequest;Landroid/webkit/WebResourceResponse;)V");
				}
				break;
				
			case "onReceivedError":
				if (this.desc.equals("(Landroid/webkit/WebView;ILjava/lang/String;Ljava/lang/String;)V")) {
					mv.visitVarInsn(Opcodes.ALOAD, 0); 
					mv.visitVarInsn(Opcodes.ALOAD, 4); 
					mv.visitVarInsn(Opcodes.ALOAD, 2); 
					mv.visitVarInsn(Opcodes.ALOAD, 3); 
					mv.visitMethodInsn(
						Opcodes.INVOKESTATIC, 
						"io/imqa/mpm/network/MPMWebviewInterface", 
						"receivedError", 
						"(Landroid/webkit/WebViewClient;Ljava/lang/String;ILjava/lang/String;)V");
				}
				break;

		}
	}
	@Override
	protected void onMethodExit(int opcode) {
	}

	
	@Override 
	public void visitMaxs(int maxStack, int maxLocals) { 
		super.visitMaxs(maxStack, maxLocals); 
	} 

}
