package io.imqa.asm;

import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.commons.AdviceAdapter;

public class WebviewUrlInjector extends AdviceAdapter { 
	protected String eventName;
	protected String className;

	protected WebviewUrlInjector(String className, int access, String methodName, String desc, MethodVisitor mv) { 
		super(Opcodes.ASM5, mv, access, methodName, desc);
		this.className = className;
		this.eventName = methodName;
	} 
	
	@Override 
	protected void onMethodEnter() {
		//mv.visitVarInsn(Opcodes.ALOAD, 0);
		mv.visitMethodInsn(
				Opcodes.INVOKESTATIC, 
				"io/imqa/mpm/IMQAMpmAgent", 
				"getInstance", 
				"()Lio/imqa/mpm/IMQAMpmAgent;"); 
		mv.visitLdcInsn(this.className);
		mv.visitLdcInsn(this.eventName);
		mv.visitMethodInsn(
				Opcodes.INVOKEVIRTUAL, 
				"io/imqa/mpm/IMQAMpmAgent", 
				"startEvent", 
				"(Ljava/lang/String;Ljava/lang/String;)V"); 
	}
	@Override
	protected void onMethodExit(int opcode) {
		//mv.visitVarInsn(Opcodes.ALOAD, 0);
		mv.visitMethodInsn(
				Opcodes.INVOKESTATIC, 
				"io/imqa/mpm/IMQAMpmAgent", 
				"getInstance", 
				"()Lio/imqa/mpm/IMQAMpmAgent;"); 
		mv.visitLdcInsn(this.className);
		mv.visitLdcInsn(this.eventName);
		mv.visitMethodInsn(
				Opcodes.INVOKEVIRTUAL, 
				"io/imqa/mpm/IMQAMpmAgent", 
				"endEvent", 
				"(Ljava/lang/String;Ljava/lang/String;)V"); 
	}

	
	@Override 
	public void visitMaxs(int maxStack, int maxLocals) { 
		super.visitMaxs(maxStack, maxLocals); 
	} 

}
