package io.imqa.injector;

import io.imqa.injector.util.Logger;

public class ActivityInjectorFactory {

    public static Injector checkActivityPackage(String projectName, String packageName, String activityName, String buildLocation) {
        Logger.d("Check Activity : P - " + packageName + ", A - "+ activityName);

        // 앱의 액티비티인지 프로젝트 명으로 검사
        boolean isProjectActivity = true;
        String[] pathList = packageName.split("/");
        String[] activityPathList = activityName.split("/");
        for (int i=0; i<pathList.length; i++) {
            if (!pathList[i].equals(activityPathList[i])) {
                isProjectActivity = false;
            }
        }

        if (isProjectActivity) {
            Logger.d("For This Package : true");
            return new ProjectActivityInjector(projectName, packageName, activityName, buildLocation);
        } else {
            Logger.d("For This Package : false");
            return null;
            // TODO Library Catch
            //return new LibraryActivityInjector(projectName, packageName, activityName, buildLocation);
        }
    }
}