package io.imqa.injector;

import java.io.File;
import java.lang.reflect.Field;

import io.imqa.injector.util.Logger;

public class AndroidBuildConfig {

	private String projectName = "";
	private String flavor = "";
	private String buildType = "";
	private String packageName = "";
	private String applicationId = "";

	public AndroidBuildConfig(String projectName, String flavor, String buildType) {
		this.projectName = projectName;
		this.buildType = buildType;
		this.flavor = flavor;

		init();
	}

	private void init() {
		String buildConfigLocation = projectName+"/build/generated/source/buildConfig/";
		if (!flavor.equals("")) {
			buildConfigLocation += flavor+"/";
		}

		buildConfigLocation += buildType+"/";
		
		//String packageName = "";
		File configDir = new File(buildConfigLocation);
		
		this.packageName = findBuildConfig(configDir);
		this.packageName = this.packageName.substring(0, this.packageName.indexOf(".BuildConfig.java"));
		
		// TODO Build Config 파일을 파싱하도록
		/*
        try {
            Class buildConfigClass = Class.forName(this.packageName+".BuildConfig");;
            Class appid = buildConfigClass.getDeclaredField("APPLICATION_ID").getDeclaringClass();
            Logger.d("IMQA TEST", appid.toString());
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        } catch (NoSuchFieldException e) {
            e.printStackTrace();
        }*/
	}

	private String findBuildConfig(File target) {
		String packageName = "";
		for (File item : target.listFiles()) {
			packageName += item.getName();
			if (item.isDirectory())
				return packageName += "." + findBuildConfig(item);
		}
		return packageName;
	}

	public String getPackageName() {
		return this.packageName;
	}
}