package io.imqa.injector;


import io.imqa.injector.util.Logger;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

public class AndroidManifestParser {

	private String manifestLocation;
	private ArrayList<String> activityList = new ArrayList<>();
	private String projectName = "";
	private String flavor = "";
	private String buildType = "";
	private String packageName = "";
	private String sourceSet = "";

	public AndroidManifestParser(String projectName, String flavor, String buildType, String packageName) {
		this.projectName = projectName;
		this.buildType = buildType;
		this.flavor = flavor;
		this.packageName = packageName;
		this.manifestLocation = findManifestLocation(projectName+"/build/intermediates/manifests/full/");
		this.activityList = findActivityList(this.manifestLocation);
	}

	public ArrayList<String> getActivityList() {
		return activityList;
	}

	public String getPackageName() {
		return this.packageName;
	}

	public String getSourceSet() {
		return this.sourceSet;
	}

    private String findManifestLocation(String fileName) {
		if (!flavor.equals("")) {
			fileName += flavor+"/";
		}
		fileName += buildType+"/AndroidManifest.xml";
		Logger.d("Manifest Location", fileName);

    	return fileName;
    }

	private ArrayList<String> findActivityList(String fileName) {
		// Get Activity List on Manifest.xml
		//String fileName = "app/build/intermediates/manifests/full/debug/AndroidManifest.xml";

		ArrayList<String> activityList = new ArrayList<>();
		NodeList nodeList = null;
		try {
			File fXmlFile = new File(fileName);
			DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
			DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
			Document doc = dBuilder.parse(fXmlFile);
			doc.getDocumentElement().normalize();
			String beforePackageName = doc.getDocumentElement().getAttribute("package");
			beforePackageName = beforePackageName.replace(".", "/");
			
			/*
			beforePackageName.indexOf(packageName);
            if (!flavor.equals("")) {
            	Logger.d("PACKAGE beforePackageName",beforePackageName);
            	Logger.d("PACKAGE FLAVOR",flavor);
                int i = beforePackageName.indexOf(flavor);
                Logger.d("PACKAGE FLAVOR LENGTH",i+"");
                beforePackageName = beforePackageName.substring(0,i-1);
            }
            */

            sourceSet = beforePackageName;

			// Search Element name that have 'activity' in 'application' 
			Logger.d("Root element",  doc.getDocumentElement().getNodeName());
			NodeList applicationList = doc.getElementsByTagName("application");
			nodeList = applicationList.item(0).getChildNodes();

			Logger.d("-----------------------");



	        // This find 'activity'
	        for (int index = 0; index < nodeList.getLength(); index++) {
	            Node nNode = nodeList.item(index);

		        if (nNode.getNodeType() == Node.ELEMENT_NODE
		            && nNode.getNodeName().equals("activity")) {

		        	// If found activity node do change .class file
		            Element eElement = (Element) nNode;
		        	
		            String activityName = findActivityName(eElement);
		            if (activityName != null) {
		            	activityName = activityName.replace(".", "/");
		                Logger.d("Activity name", activityName);

		                activityList.add(activityName);
		            }
		        }
	        }
		} catch (Exception e) {
			e.printStackTrace();
		}


		return activityList;
	}

    private String findActivityName(Element eElement) {
        //Logger.d(eElement.getAttributes());
        String sTag = "android:name";
        String enabled = "android:enabled";
        if (eElement.getAttribute(enabled).equals("false"))
        	return null;
        else 
        	return eElement.getAttribute(sTag);
    }


    public static boolean checkActivityManifest(String fileName, String targetPackageName) {
        try {
            File fXmlFile = new File(fileName);
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(fXmlFile);
            doc.getDocumentElement().normalize();
            String libPackageName = doc.getDocumentElement().getAttribute("package");
            libPackageName = libPackageName.replace(".", "/");

            Logger.d("Check library manifest", targetPackageName + " / " + libPackageName);
            return targetPackageName.equals(libPackageName);

        } catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }
}