package io.imqa.injector;


import org.gradle.api.Project;
import org.gradle.api.artifacts.dsl.DependencyHandler; 
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.DependencyResolutionListener;
import org.gradle.api.artifacts.ResolvableDependencies;

import io.imqa.injector.util.Logger;
import io.imqa.injector.util.BuildOption;

import java.util.Set;
import java.util.HashSet;
import java.lang.Iterable;
import java.util.Iterator;

public class DependencyInjector {

	public static final String CONF_IMQA_SDK = "imqa";
	DependencySet compileDeps;
	private static final String IMQA_GROUP_NAME = "io.imqa";
	private static final String MPM_SDK_NAME = "imqa-mpm-client";
	private static final String CRASH_SDK_NAME = "imqa-crash-client";
	private String MPM_SDK_INFO_FOR_DEPENDENCY = "";
	private String CRASH_SDK_INFO_FOR_DEPENDENCY = "";

	public DependencyInjector() {

		// TODO local.properties 에서 가져올 것
		MPM_SDK_INFO_FOR_DEPENDENCY += IMQA_GROUP_NAME +":"+ MPM_SDK_NAME +":"+ "1.2.7";
		CRASH_SDK_INFO_FOR_DEPENDENCY += IMQA_GROUP_NAME +":"+ CRASH_SDK_NAME +":"+ "1.2.2";
	}

	public void doInject(Project project) {
		
		Logger.d("Version Ready", MPM_SDK_INFO_FOR_DEPENDENCY);
		Logger.d("Version Ready", CRASH_SDK_INFO_FOR_DEPENDENCY);

		Set<String> dependencyTypeSet = new HashSet<String>();
		dependencyTypeSet.add("compile");
		Iterator<Configuration> projIt = project.getRootProject().getBuildscript().getConfigurations().iterator();
		
		while(projIt.hasNext()) {
			Configuration conf = projIt.next();
			
			Iterable<Dependency> depIts = conf.getAllDependencies();
			Iterator<Dependency> depIt = depIts.iterator();
			while(depIt.hasNext()) {
				Dependency dep = depIt.next();

				if (dep.getGroup().equals("com.android.tools.build")
					&& dep.getName().equals("gradle")) {
					String version = new String(dep.getVersion());

					Logger.d("Version", version);

					try {
						String[] splitedVersion = version.split("\\.");
						int majorVersion = Integer.parseInt(splitedVersion[0]);
						int minorVersion = Integer.parseInt(splitedVersion[1]);
						int microVersion = Integer.parseInt(splitedVersion[2]);

						if (majorVersion == 3) {
							if (minorVersion >= 1) {
								dependencyTypeSet.clear();
							}

							dependencyTypeSet.add("implementation");
						}

					} catch(Exception e) {
						Logger.d("IMQA ERROR", e.getMessage());
					}
				}
			}
		}

		String dependencyType = "";
		boolean hasMpmDependency = false;
		boolean hasCrashDependency = false;

		for(Iterator depIter = dependencyTypeSet.iterator(); depIter.hasNext();) {
			dependencyType = String.valueOf(depIter.next());
			Logger.d("Dependency Type", dependencyType);
			compileDeps = project.getConfigurations().getByName(dependencyType).getDependencies();

			if (hasDependency(compileDeps, MPM_SDK_NAME)) {
				hasMpmDependency = true;
			}
			if (hasDependency(compileDeps, CRASH_SDK_NAME)) {
				hasCrashDependency = true;
			}
		}

		if (!hasMpmDependency && BuildOption.imqaMpm) {
			dynamicDependencyInject(project, dependencyType, MPM_SDK_INFO_FOR_DEPENDENCY);
		}

		if (!hasCrashDependency && BuildOption.imqaCrash) {
			dynamicDependencyInject(project, dependencyType, CRASH_SDK_INFO_FOR_DEPENDENCY);
		}
	}


	private static boolean hasDependency(DependencySet compileDeps, String imqaDependency) {
		// 의존성 확인
		boolean hasDependency = false;
		Iterator<Dependency> it = compileDeps.iterator();

		while (it.hasNext()) {
			Dependency dep = it.next();

			if (dep.getGroup() != null
				&& dep.getGroup().equals(IMQA_GROUP_NAME) 
				&& dep.getName().equals(imqaDependency)) {
				hasDependency = true;
			}
		}

		return hasDependency;
	}

	private static void dynamicDependencyInject(Project project, String dependencyType, String name) {
		// 실시간 의존성 추가
		project.getConfigurations()
			.getByName(dependencyType)
			.getDependencies()
			.add(project.getDependencies().create(name));

		Logger.d("SDK Imported", name);
	}
}