package io.imqa.injector;

import io.imqa.injector.util.Logger;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.IOException;

import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;

public class JarUtil {
	private Manifest jarManifest;

	public String jarExtracting(String source) throws IOException, FileNotFoundException {
		String destDir = source.substring(0,source.lastIndexOf("/")) + "/temp";
		File tempDir = new File(destDir);
		if (!tempDir.exists())
				tempDir.mkdir();

		JarFile jar = new JarFile(source);
		jarManifest = jar.getManifest();
		Enumeration enumEntries = jar.entries();
		while (enumEntries.hasMoreElements()) {
			JarEntry file = (JarEntry) enumEntries.nextElement();

			//if(file.getName().toUpperCase().indexOf("META-INF") != -1) continue;

			java.io.File f = new java.io.File(destDir+"/"+file.getName());
			// if its a directory, create it
			if (file.isDirectory()) { 
				f.mkdir();
				continue;
			}
			InputStream is = jar.getInputStream(file); 
			FileOutputStream fos = new FileOutputStream(f);
			// write contents of 'is' to 'fos'
			while (is.available() > 0) {  
				fos.write(is.read());
			}
			fos.close();
			is.close();
		}
		jar.close();

		//File originJar = new File(source);
		//originJar.delete();

		return destDir+"/";
	}

	public void jarReCompressing(String source, String target) throws IOException, FileNotFoundException {
		JarOutputStream jos = null;
		Logger.d(source);
		try {
			jos = new JarOutputStream(new FileOutputStream(target), jarManifest);

		} finally {
			if (jos != null)
				jos.close();
		}
	}

	public void jarAdd(File source, JarOutputStream target) throws IOException, FileNotFoundException {
		BufferedInputStream in = null;
		try {
			if (source.isDirectory()) {
				String name = source.getCanonicalPath().replace("\\", "/");
			if (!name.isEmpty()) {
				if (!name.endsWith("/"))
					name += "/";
				JarEntry entry = new JarEntry(cutDirectoryPath(name));
				entry.setTime(source.lastModified());
				target.putNextEntry(entry);
				target.closeEntry();
			}
			for (File nestedFile: source.listFiles())
				jarAdd(nestedFile, target);
				return;
			}

			// TODO
			if (source.getName().equals("classes.jar")) {
				return;
			}
			if (source.getName().equals("MANIFEST.MF")) {
				return;
			}

			JarEntry entry = new JarEntry(cutDirectoryPath(source.getCanonicalPath().replace("\\", "/")));
			//entry.setTime(source.lastModified());
			target.putNextEntry(entry);
			in = new BufferedInputStream(new FileInputStream(source));

			byte[] buffer = new byte[1024];
			while (true) {
				int count = in.read(buffer);
				if (count == -1)
				break;
				target.write(buffer, 0, count);
			}
			target.closeEntry();

		} finally {
			if (in != null)
			in.close();
		}
	}

	public String cutDirectoryPath(String origin) {
		String result = "";
		if (origin.length() > 0) {
			Logger.d("Cut Detecting", "Origin: " + origin);
			String sourceDirName = "/temp";
			Logger.d("Cut Detecting", "origin Length: " + origin.length());
			Logger.d("Cut Detecting", "sourceDirName Length: " + sourceDirName.length());

			int startIndex = origin.indexOf(sourceDirName)+sourceDirName.length();
			int length = origin.length() - startIndex;
			Logger.d("Cut Detecting", "Data: " + startIndex + ", "+ length);

			if (length > 0) 
				result = origin.substring(startIndex+1);
			else 
				result = origin.substring(startIndex);
			Logger.d("Cut Detecting", "After: " + result);
		}
		return result;
	}

	public void deleteFolder(String parentPath) {
		File file = new File(parentPath);
		String[] fnameList = file.list();
		int fCnt = fnameList.length;
		String childPath = "";

		for(int i = 0; i < fCnt; i++) {
			childPath = parentPath+"/"+fnameList[i];
			File f = new File(childPath);
			if( ! f.isDirectory()) {
				f.delete();
			} else {
				deleteFolder(childPath);
			}
		}

		File f = new File(parentPath);
		f.delete();  
	}
}