package io.imqa.injector;

import io.imqa.injector.util.Logger;
import io.imqa.injector.util.BuildOption;

import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.internal.plugins.DefaultExtraPropertiesExtension;
import org.gradle.api.NamedDomainObjectContainer;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;

import java.lang.reflect.Method;

public class JavacAction implements Action<Project>{

	//private static String javaCompileTask = ":app:compile(\\w*)(Release|Debug)JavaWithJavac";

	private static String projectName = "";
	private static ArrayList<String> buildTypeList = new ArrayList<String>();

	public JavacAction(String projectName) {
		this.projectName = projectName;
		//this.javaCompileTask = ":"+projectName+":compile(\\w*)(Release|Debug)JavaWithJavac";
	}

	@Override
	public void execute(Project project) {
		Logger.d("After Evaluate!!!");

		try {
			Object androidProps = (Object) project.property("android");
			Class androidPropsClazz = Class.forName(androidProps.getClass().getName());
	            
			Logger.d("TEST 1", androidProps.getClass().getName());

			Method androidPropsMethod = androidPropsClazz.getMethod("getBuildTypes");
			androidPropsMethod.setAccessible(true);

			NamedDomainObjectContainer<Object> buildTypeContainer 
				= (NamedDomainObjectContainer<Object>) androidPropsMethod.invoke(androidProps);
			// Collection<BuildType> buildTypeContainer = android.getBuildTypes();
			Iterator<Object> buildIt = buildTypeContainer.iterator();

			while(buildIt.hasNext()) {
				// Processing when Release Task existing in compile tasks
				// BuildType buildType = buildIt.next();
				Object buildType = buildIt.next();
				Class buildTypeClazz = Class.forName(buildType.getClass().getName());
		            
				Logger.d("TEST 2", buildType.getClass().getName());

				Method buildTypeMethod = buildTypeClazz.getMethod("getName");
				buildTypeMethod.setAccessible(true);
				buildTypeList.add((String) buildTypeMethod.invoke(buildType));

				Logger.d("All BuildTypes", (String) buildTypeMethod.invoke(buildType));
			}
            
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        } catch (RuntimeException e) {
            throw e;
        } catch (Exception e) {
            throw new RuntimeException(e);
        }

		DefaultExtraPropertiesExtension property = (DefaultExtraPropertiesExtension) project.property("ext");
		Map<String, Object> properties = property.getProperties();
		if (!properties.isEmpty()) {
			Set<String> keys = properties.keySet();
			for(String key : keys) {
				// Logger.d("TEST", key + ":"+properties.get(key).toString());
			}
		}

		if (property.has("IMQALifecycle")) {
			BuildOption.lifecycleInject = (boolean) property.getProperty("IMQALifecycle");
		}

		if (property.has("IMQAEventListener")) {
			BuildOption.eventListenerInject = (boolean) property.getProperty("IMQAEventListener");
		}

		if (property.has("IMQALibraryActivity")) {
			BuildOption.libraryActivityInject = (boolean) property.getProperty("IMQALibraryActivity");
		}

		if (property.has("IMQAFragment")) {
			BuildOption.fragmentInject = (boolean) property.getProperty("IMQAFragment");
		}

		if (property.has("IMQAWebview")) {
			BuildOption.webViewInject = (boolean) property.getProperty("IMQAWebview");
		}

		if (property.has("IMQAMPM")) {
			BuildOption.imqaMpm = (boolean) property.getProperty("IMQAMPM");
		}

		if (property.has("IMQACrash")) {
			BuildOption.imqaCrash = (boolean) property.getProperty("IMQACrash");
		}

		DependencyInjector depInjector = new DependencyInjector();
		depInjector.doInject(project);

		TaskContainer tc = project.getTasks();
		Logger.d("Task Container", tc.toString());
		Iterator<Task> taskIter = tc.iterator();

		while(taskIter.hasNext()) {
			// Processing when Release Task existing in compile tasks
			Task compileTask = taskIter.next();

			// Find Javac Task
			Pattern javacPattern = Pattern.compile(":"+projectName+":compile(\\w*)(Release|Debug)JavaWithJavac");
			String nonFalvorPatter = ":"+projectName+":compile(Release|Debug)JavaWithJavac";
			
			if (buildTypeList.size() > 0) {
				for (String buildTypeStr : buildTypeList) {
					javacPattern = Pattern.compile(":"+projectName+":compile(\\w+)"+
						toCapitalize(buildTypeStr) +
						"JavaWithJavac");
					Matcher javacMatcher = javacPattern.matcher( compileTask.toString() );

					javacPattern = Pattern.compile(":"+projectName+":compile"+
						toCapitalize(buildTypeStr) +
						"JavaWithJavac");
					Matcher nonFlavorJavacMatcher = javacPattern.matcher( compileTask.toString() );
					if( javacMatcher.find() ) {
						//if (compileTask.getPath().equals(":app:compileDebugJavaWithJavac")) {
						//Task complieTask = tc.getByPath(":app:lint");
						findBuildType(compileTask, buildTypeStr);
						Logger.d("Pattern", javacPattern.toString());
					} else if ( nonFlavorJavacMatcher.find() ){
						findBuildType(compileTask, buildTypeStr);
						Logger.d("Pattern", javacPattern.toString());
					}
				}
			} else {
				Matcher javacMatcher = javacPattern.matcher( compileTask.toString() );
				javacPattern = Pattern.compile(":"+projectName+":compile(Release|Debug)JavaWithJavac");
				Matcher nonFlavorJavacMatcher = javacPattern.matcher( compileTask.toString() );
				if( javacMatcher.find() ) {
					//if (compileTask.getPath().equals(":app:compileDebugJavaWithJavac")) {
					//Task complieTask = tc.getByPath(":app:lint");
					findBuildType(compileTask, javacMatcher.group(1).toLowerCase());
					Logger.d("Pattern", javacPattern.toString());
				} else if (nonFlavorJavacMatcher.find()) {
					findBuildType(compileTask, javacMatcher.group(1).toLowerCase());
					Logger.d("Pattern", javacPattern.toString());
				}
			}
		}
	}


	private void findBuildType(Task compileTask, final String buildType) {
		Logger.d("Task Name: "+compileTask.getName() + ", Task Desc: "+compileTask.getDescription());
		compileTask.doLast(new Action<Task>() {
			@Override
			public void execute(Task task) {
				Logger.d("Task Name: "+task.getName() + ", Task Desc: "+task.getDescription());

				// Find Flavor and Build type
				String flavor = "";
				Pattern flavorPattern = Pattern.compile(":"+projectName+":compile(\\w+)("+
						toCapitalize(buildType) +
						")JavaWithJavac");

				Matcher flavorMatcher = flavorPattern.matcher( task.toString() );

				if( flavorMatcher.find() ) {
					flavor = flavorMatcher.group(1).toLowerCase();
				}

				// String buildType = "";
				/*
				if (buildTypeList.size() == 0) {
					Pattern flavorPattern = Pattern.compile(":"+projectName+":compile(\\w+)(Release|Debug)JavaWithJavac");
					Matcher flavorMatcher = flavorPattern.matcher( task.toString() );

					if( flavorMatcher.find() ) {
						// If exist flavor 
						flavor = flavorMatcher.group(1).toLowerCase();
						Pattern bulidTypePattern = Pattern.compile(":"+projectName+":compile"+flavorMatcher.group(1)+"(\\w+)JavaWithJavac");
						Matcher buildTypeMatcher = bulidTypePattern.matcher(task.toString());
						if (buildTypeMatcher.find())
							buildType = buildTypeMatcher.group(1).toLowerCase();
					} else {
						// no flavor
						Pattern bulidTypePattern = Pattern.compile(":"+projectName+":compile(\\w+)JavaWithJavac");
						Matcher buildTypeMatcher = bulidTypePattern.matcher(task.toString());
						if (buildTypeMatcher.find())
							buildType = buildTypeMatcher.group(1).toLowerCase();
					}
				} else {
					Pattern flavorPattern = Pattern.compile(":"+projectName+":compile(\\w+)("+
						toCapitalize(buildType) +
						")JavaWithJavac");

					Matcher flavorMatcher = flavorPattern.matcher( task.toString() );

					if( flavorMatcher.find() ) {
						flavor = flavorMatcher.group(1).toLowerCase();
					}
				//}
				*/

				// File location it
				String buildLocation = projectName+"/build/intermediates/classes/";
				if (!flavor.equals("")) {
					buildLocation += flavor+"/";
				}
				buildLocation += buildType+"/";

				AndroidBuildConfig buildConfig = new AndroidBuildConfig(projectName, flavor, buildType);

				AndroidManifestParser androidManifestParser = new AndroidManifestParser(projectName, flavor, buildType, buildConfig.getPackageName());

				// Get Activity List on Manifest.xml
				ArrayList<String> activityList = androidManifestParser.getActivityList();

				// This find 'activity'
				Logger.d("LifeCycle Search", "Start");
				int injectedFileCount = 0;
				for (String activityName : activityList) {
					injectedFileCount++;
					callLifeCycleInject(buildConfig.getPackageName().replace(".", "/"), activityName, buildLocation);
				}
				Logger.d("LifeCycle Search", "LifeCycle Searched of "+injectedFileCount+" Files");

				// Get All Class List
				ArrayList<String> fileList = getAllFileList(new File(buildLocation));
				Logger.d("Global Search", "Start");
				injectedFileCount = 0;
				for (String fileAbsolteName : fileList) {
					injectedFileCount++;
					callGlobalInject(fileAbsolteName);
				}

				Logger.d("Global Search", "Global Searched of "+injectedFileCount+" Files");
			}
		});
	}

	private ArrayList<String> getAllFileList(File root) {
		ArrayList<String> list = new ArrayList<String>();
		File[] files = root.listFiles();
		for (File file : files) {
			if (file.isFile()) {
				//Logger.d("FILE NAME", file.getName());
				String[] names = file.getName().split("\\.");
				//Logger.d("Splited size", names.toString());
				if (names.length > 0 && names[names.length-1].equals("class")) {
					//Logger.d("FILES TEST", file.getAbsolutePath());
					list.add(file.getAbsolutePath());
					//doSome();
				}
			} else {
				list.addAll(getAllFileList(file));
			}
		}
		return list;
	}

	private void callLifeCycleInject(String packageName, String activityName, String buildLocation) {
		if (BuildOption.lifecycleInject) {
			try {

				Injector activityInjector = 
					//ActivityInjectorFactory.checkActivityPackage(projectName, packageName, activityName, buildLocation);
					new ProjectActivityInjector(projectName, packageName, activityName, buildLocation);

				if (activityInjector == null)
					throw new InjectorException();

				activityInjector.doInject();

			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

	private void callGlobalInject(String fileAbsolteName) {
		String[] filePath = fileAbsolteName.split("/");
		StringBuilder sb = new StringBuilder();
		for (int i=0; i<filePath.length - 1; i++) {
			if (filePath[i].length() > 0) {
				sb.append("/");
				sb.append(filePath[i]);
			}
		}
		GlobalInjector globalInjector = new GlobalInjector(filePath[filePath.length-1], sb.toString());
		globalInjector.doInject();
	}

	private String toCapitalize(String input) {
		return Character.toUpperCase(input.charAt(0)) + input.substring(1);
	}
}