package io.imqa.injector;

import io.imqa.asm.ActivityTransformer;
/*
import io.imqa.injector.BaseActivityInjector;
import io.imqa.injector.AndroidManifestParser;
*/
import io.imqa.injector.util.Logger;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class LibraryActivityInjector extends BaseActivityInjector {

	private String jarLocation;
	private JarUtil jarUtil = new JarUtil();

	public LibraryActivityInjector(String projectName, String packageName, String activityName, String buildLocation) {
		super(projectName, packageName, activityName, buildLocation);
	}

	@Override
	protected void beforeInject() {
		// 라이브러리로 가져온 액티비티인 경우
		String targetPackageName = targetClass.substring(0,targetClass.lastIndexOf("/"));
		// expoloded-aar 위치에서 가져온다
		String jarDir = projectName + "/build/intermediates/exploded-aar";

		int dirStep = 0; // 0: lib, 1: group, 2: libName, 3: version
		String manifestLocation = findLibManifest(jarDir, dirStep, targetPackageName);
		Logger.d("Manifest Location", manifestLocation);
		manifestLocation = manifestLocation.substring(0,manifestLocation.lastIndexOf("/"));
		Logger.d("Library Location : " + manifestLocation);
		buildLocation = manifestLocation + "/jars/";
		
		try {
			jarLocation = jarUtil.jarExtracting(buildLocation+"classes.jar");
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}

		this.targetClass = jarLocation + targetClass+".class";
	}

	@Override
	protected void inject() {
		Logger.d("Bulid Location : " + this.targetClass);
		File classFile = new File(buildLocation+"/"+this.targetClass);

		ActivityTransformer.doTransform(classFile);
	}

	@Override
	protected void afterInject() {
		try {
			// Extracting 된 Jar파일 재압축
			jarUtil.jarReCompressing(jarLocation, buildLocation+"classes.jar");
			jarUtil.deleteFolder(jarLocation);
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}

	}


	private String findLibManifest(String source, int dirStep, String targetPackageName){
		File dir = new File(source); 
		Logger.d("Is Directory : " + dir.isDirectory());
		File[] fileList = dir.listFiles(); 
		boolean isFileFound = false;
		String libManifest = "";

		Logger.d("FindLibManifest : " + source + "/"+dirStep);

		if (dirStep < 4 && fileList != null) {
			try{
				for(File file : fileList){
					Logger.d("FileName : " + file.getName());
					if(file.isFile()){
						// 파일이 있다면 파일 이름 출력
						if (file.getName().equals("AndroidManifest.xml")) {
							Logger.d("파일 이름 = " + file.getName());
							isFileFound = AndroidManifestParser.checkActivityManifest(file.getCanonicalPath(), targetPackageName);
							if (isFileFound)
								return file.getCanonicalPath();
						}
					} else if (file.isDirectory()) {
						libManifest = findLibManifest(file.getCanonicalPath(), dirStep+1, targetPackageName);
						if (!libManifest.equals("")) {
							return libManifest;
						} 
					}
				}
			}catch(IOException e){
				e.printStackTrace();
			}
			return libManifest;
		} else {
		   return libManifest;
		}
	}

}