package io.imqa.injector;

import io.imqa.asm.ActivityTransformer;
import io.imqa.injector.util.Logger;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;

public class ProjectActivityInjector extends BaseActivityInjector {

	public ProjectActivityInjector(String projectName, String packageName, String activityName, String buildLocation) {
		super(projectName, packageName, activityName+".class", buildLocation);
	}

	@Override
	protected void beforeInject() {
	}

	@Override
	protected void inject() {
		Logger.d("Activity Inject", "P - " + packageName + ", C - "+ buildLocation+"/"+targetClass);

		File classFile = new File(buildLocation+"/"+this.targetClass);
		ActivityTransformer.doTransform(classFile);
	}

	@Override
	protected void afterInject() {

	}
}