package io.imqa.injector.util;

import java.util.logging.*;


public class Logger {
    private static boolean PRINT_LOG = true;
    private static final String IMQA_TAG = "IMQA";
    private static final java.util.logging.Logger logger = java.util.logging.Logger.getLogger(io.imqa.injector.util.Logger.class.getName());

    public Logger() {
    }

    public static void setPrintLog(boolean mode) {
        PRINT_LOG = mode;
    }

    public static void d(String msg) {
        d("", msg);

    }

    public static void d(String tag, String msg) {
        if (PRINT_LOG) {
            logger.log(Level.WARNING, IMQA_TAG + "["+tag+"]" + msg);
        }
    }

    public static void d(String tag, String msg, Throwable tr) {
        if (PRINT_LOG) {
            logger.log(Level.WARNING, IMQA_TAG + "["+tag+"]" + msg);
        }
    }

    public static void i(String msg) {
        i("", msg);
    }

    public static void i(String tag, String msg) {
        if (PRINT_LOG) {
            logger.log(Level.INFO, IMQA_TAG + "["+tag+"]" + msg);
        }
    }

    public static void i(String tag, String msg, Throwable tr) {
        if (PRINT_LOG) {
            logger.log(Level.INFO, IMQA_TAG + "["+tag+"]" + msg);
        }
    }

    public static void e(String msg) {
        e("", msg);
    }

    public static void e(String tag, String msg) {
        if (PRINT_LOG) {
            logger.log(Level.WARNING, IMQA_TAG + "["+tag+"]" + msg);
        }
    }

    public static void e(String tag, String msg, Throwable tr) {
        if (PRINT_LOG) {
            logger.log(Level.WARNING, IMQA_TAG + "["+tag+"]" + msg);
        }
    }
}
