/*
 * Decompiled with CFR 0.152.
 */
package io.imqa.asm;

import io.imqa.asm.LifecycleMakerVisitor;
import io.imqa.asm.LifecycleVisitor;
import io.imqa.injector.util.Logger;
import java.util.HashMap;
import java.util.Set;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public class ActivityClassVisitor
extends ClassVisitor {
    HashMap<String, Boolean> lifeCycle = new HashMap();
    String superClass = "";

    public ActivityClassVisitor(ClassVisitor cv) {
        super(327680, cv);
        this.lifeCycle.put("onCreate", false);
        this.lifeCycle.put("onStart", false);
        this.lifeCycle.put("onResume", false);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.cv.visit(version, access, name, signature, superName, interfaces);
        this.superClass = superName;
        Logger.d("Lifecycle Super Name", this.superClass);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        switch (name) {
            case "onCreate": {
                Logger.d("Lifecycle Name", name + ", " + desc + ", " + signature + ", " + access);
                this.lifeCycle.replace("onCreate", true);
                return new LifecycleVisitor(access, name, desc, mv);
            }
            case "onStart": {
                Logger.d("Lifecycle Name", name + ", " + desc + ", " + signature + ", " + access);
                this.lifeCycle.replace("onStart", true);
                return new LifecycleVisitor(access, name, desc, mv);
            }
            case "onResume": {
                this.lifeCycle.replace("onResume", true);
                Logger.d("Lifecycle Name", name + ", " + desc + ", " + signature + ", " + access);
                return new LifecycleVisitor(access, name, desc, mv);
            }
        }
        return mv;
    }

    public void visitEnd() {
        Set<String> cycleNames = this.lifeCycle.keySet();
        for (String cycleName : cycleNames) {
            if (this.lifeCycle.get(cycleName).booleanValue()) continue;
            MethodVisitor mv = this.cv.visitMethod(4, cycleName, "()V", null, null);
            LifecycleMakerVisitor lifecyclemv = new LifecycleMakerVisitor(4, cycleName, this.superClass, "()V", mv);
            lifecyclemv.visitCode();
            lifecyclemv.visitInsn(177);
        }
        this.cv.visitEnd();
    }
}

