/*
 * Decompiled with CFR 0.152.
 */
package io.imqa.asm;

import io.imqa.asm.ActivityClassVisitor;
import io.imqa.asm.ClassVisitChecker;
import io.imqa.injector.util.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class ActivityTransformer {
    public static void doTransform(File classFile) {
        Logger.d("Lifecycle Class Name", classFile.getName());
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(classFile);
            if (!ActivityTransformer.transformCheck(inputStream)) {
                FileInputStream visitorInputStream = new FileInputStream(classFile);
                ClassWriter cw = new ClassWriter(1);
                ClassReader cr = new ClassReader((InputStream)visitorInputStream);
                ActivityClassVisitor cv = new ActivityClassVisitor((ClassVisitor)cw);
                cr.accept((ClassVisitor)cv, 8);
                FileOutputStream stream = new FileOutputStream(classFile);
                stream.write(cw.toByteArray());
                stream.close();
                ((InputStream)visitorInputStream).close();
            }
            ((InputStream)inputStream).close();
        }
        catch (FileNotFoundException e) {
            Logger.e("Activity Inject", "Not Project Activity");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static boolean transformCheck(InputStream inputStream) {
        ClassVisitChecker cv = new ClassVisitChecker();
        try {
            ClassReader cr = new ClassReader(inputStream);
            cv.addCheckList(178, "io/imqa/core/dump/ActivityRenderData", "CREATED", "Ljava/lang/String;");
            cv.addCheckList(178, "io/imqa/core/dump/ActivityRenderData", "STARTED", "Ljava/lang/String;");
            cv.addCheckList(178, "io/imqa/core/dump/ActivityRenderData", "RESUMED", "Ljava/lang/String;");
            cr.accept((ClassVisitor)cv, 0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return cv.isOverrided();
    }
}

