/*
 * Decompiled with CFR 0.152.
 */
package io.imqa.asm;

import io.imqa.asm.CheckList;
import java.util.ArrayList;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public class ClassVisitChecker
extends ClassVisitor {
    private ArrayList<CheckList> checkList = new ArrayList();
    private boolean overrided = false;

    public ClassVisitChecker() {
        super(327680);
    }

    public void addCheckList(int opcode, String owner, String name, String desc) {
        this.checkList.add(new CheckList(opcode, owner, name, desc));
    }

    public boolean isOverrided() {
        return this.overrided;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        return new MethodVisitChecker(327680, mv);
    }

    class MethodVisitChecker
    extends MethodVisitor {
        public MethodVisitChecker(int api) {
            super(api);
        }

        public MethodVisitChecker(int api, MethodVisitor mv) {
            super(api, mv);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            if (this.check(opcode, owner, name, desc)) {
                ClassVisitChecker.this.overrided = true;
            }
            super.visitMethodInsn(opcode, owner, name, desc, itf);
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            if (this.check(opcode, owner, name, desc)) {
                ClassVisitChecker.this.overrided = true;
            }
            super.visitFieldInsn(opcode, owner, name, desc);
        }

        public boolean check(int opcode, String owner, String name, String desc) {
            boolean isExist = false;
            for (CheckList item : ClassVisitChecker.this.checkList) {
                if (item.opcode != opcode || !item.owner.equals(owner) || !item.name.equals(name) || !item.desc.equals(desc)) continue;
                isExist = true;
            }
            return isExist;
        }
    }
}

